/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideosignaling.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetIceServerConfigRequest extends KinesisVideoSignalingRequest implements
        ToCopyableBuilder<GetIceServerConfigRequest.Builder, GetIceServerConfigRequest> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetIceServerConfigRequest::channelARN)).setter(setter(Builder::channelARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelARN").build()).build();

    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetIceServerConfigRequest::clientId)).setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()).build();

    private static final SdkField<String> SERVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetIceServerConfigRequest::serviceAsString)).setter(setter(Builder::service))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Service").build()).build();

    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetIceServerConfigRequest::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD,
            CLIENT_ID_FIELD, SERVICE_FIELD, USERNAME_FIELD));

    private final String channelARN;

    private final String clientId;

    private final String service;

    private final String username;

    private GetIceServerConfigRequest(BuilderImpl builder) {
        super(builder);
        this.channelARN = builder.channelARN;
        this.clientId = builder.clientId;
        this.service = builder.service;
        this.username = builder.username;
    }

    /**
     * <p>
     * The ARN of the signaling channel to be used for the peer-to-peer connection between configured peers.
     * </p>
     * 
     * @return The ARN of the signaling channel to be used for the peer-to-peer connection between configured peers.
     */
    public String channelARN() {
        return channelARN;
    }

    /**
     * <p>
     * Unique identifier for the viewer. Must be unique within the signaling channel.
     * </p>
     * 
     * @return Unique identifier for the viewer. Must be unique within the signaling channel.
     */
    public String clientId() {
        return clientId;
    }

    /**
     * <p>
     * Specifies the desired service. Currently, <code>TURN</code> is the only valid value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #service} will
     * return {@link Service#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serviceAsString}.
     * </p>
     * 
     * @return Specifies the desired service. Currently, <code>TURN</code> is the only valid value.
     * @see Service
     */
    public Service service() {
        return Service.fromValue(service);
    }

    /**
     * <p>
     * Specifies the desired service. Currently, <code>TURN</code> is the only valid value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #service} will
     * return {@link Service#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serviceAsString}.
     * </p>
     * 
     * @return Specifies the desired service. Currently, <code>TURN</code> is the only valid value.
     * @see Service
     */
    public String serviceAsString() {
        return service;
    }

    /**
     * <p>
     * An optional user ID to be associated with the credentials.
     * </p>
     * 
     * @return An optional user ID to be associated with the credentials.
     */
    public String username() {
        return username;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelARN());
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(serviceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(username());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIceServerConfigRequest)) {
            return false;
        }
        GetIceServerConfigRequest other = (GetIceServerConfigRequest) obj;
        return Objects.equals(channelARN(), other.channelARN()) && Objects.equals(clientId(), other.clientId())
                && Objects.equals(serviceAsString(), other.serviceAsString()) && Objects.equals(username(), other.username());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetIceServerConfigRequest").add("ChannelARN", channelARN()).add("ClientId", clientId())
                .add("Service", serviceAsString()).add("Username", username()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelARN":
            return Optional.ofNullable(clazz.cast(channelARN()));
        case "ClientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        case "Service":
            return Optional.ofNullable(clazz.cast(serviceAsString()));
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetIceServerConfigRequest, T> g) {
        return obj -> g.apply((GetIceServerConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisVideoSignalingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetIceServerConfigRequest> {
        /**
         * <p>
         * The ARN of the signaling channel to be used for the peer-to-peer connection between configured peers.
         * </p>
         * 
         * @param channelARN
         *        The ARN of the signaling channel to be used for the peer-to-peer connection between configured peers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelARN(String channelARN);

        /**
         * <p>
         * Unique identifier for the viewer. Must be unique within the signaling channel.
         * </p>
         * 
         * @param clientId
         *        Unique identifier for the viewer. Must be unique within the signaling channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * Specifies the desired service. Currently, <code>TURN</code> is the only valid value.
         * </p>
         * 
         * @param service
         *        Specifies the desired service. Currently, <code>TURN</code> is the only valid value.
         * @see Service
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Service
         */
        Builder service(String service);

        /**
         * <p>
         * Specifies the desired service. Currently, <code>TURN</code> is the only valid value.
         * </p>
         * 
         * @param service
         *        Specifies the desired service. Currently, <code>TURN</code> is the only valid value.
         * @see Service
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Service
         */
        Builder service(Service service);

        /**
         * <p>
         * An optional user ID to be associated with the credentials.
         * </p>
         * 
         * @param username
         *        An optional user ID to be associated with the credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisVideoSignalingRequest.BuilderImpl implements Builder {
        private String channelARN;

        private String clientId;

        private String service;

        private String username;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIceServerConfigRequest model) {
            super(model);
            channelARN(model.channelARN);
            clientId(model.clientId);
            service(model.service);
            username(model.username);
        }

        public final String getChannelARN() {
            return channelARN;
        }

        @Override
        public final Builder channelARN(String channelARN) {
            this.channelARN = channelARN;
            return this;
        }

        public final void setChannelARN(String channelARN) {
            this.channelARN = channelARN;
        }

        public final String getClientId() {
            return clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final String getService() {
            return service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        @Override
        public final Builder service(Service service) {
            this.service(service == null ? null : service.toString());
            return this;
        }

        public final void setService(String service) {
            this.service = service;
        }

        public final String getUsername() {
            return username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetIceServerConfigRequest build() {
            return new GetIceServerConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
