/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideosignaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kinesisvideosignaling.model.UrisCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IceServer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IceServer> {
    private static final SdkField<List<String>> URIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(IceServer.getter(IceServer::uris)).setter(IceServer.setter(Builder::uris)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Uris").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(IceServer.getter(IceServer::username)).setter(IceServer.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()}).build();
    private static final SdkField<String> PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(IceServer.getter(IceServer::password)).setter(IceServer.setter(Builder::password)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()}).build();
    private static final SdkField<Integer> TTL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(IceServer.getter(IceServer::ttl)).setter(IceServer.setter(Builder::ttl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ttl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URIS_FIELD, USERNAME_FIELD, PASSWORD_FIELD, TTL_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> uris;
    private final String username;
    private final String password;
    private final Integer ttl;

    private IceServer(BuilderImpl builder) {
        this.uris = builder.uris;
        this.username = builder.username;
        this.password = builder.password;
        this.ttl = builder.ttl;
    }

    public boolean hasUris() {
        return this.uris != null && !(this.uris instanceof SdkAutoConstructList);
    }

    public List<String> uris() {
        return this.uris;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public Integer ttl() {
        return this.ttl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.uris());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.password());
        hashCode = 31 * hashCode + Objects.hashCode(this.ttl());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IceServer)) {
            return false;
        }
        IceServer other = (IceServer)obj;
        return Objects.equals(this.uris(), other.uris()) && Objects.equals(this.username(), other.username()) && Objects.equals(this.password(), other.password()) && Objects.equals(this.ttl(), other.ttl());
    }

    public String toString() {
        return ToString.builder((String)"IceServer").add("Uris", this.uris()).add("Username", (Object)this.username()).add("Password", (Object)this.password()).add("Ttl", (Object)this.ttl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Uris": {
                return Optional.ofNullable(clazz.cast(this.uris()));
            }
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "Password": {
                return Optional.ofNullable(clazz.cast(this.password()));
            }
            case "Ttl": {
                return Optional.ofNullable(clazz.cast(this.ttl()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IceServer, T> g) {
        return obj -> g.apply((IceServer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> uris = DefaultSdkAutoConstructList.getInstance();
        private String username;
        private String password;
        private Integer ttl;

        private BuilderImpl() {
        }

        private BuilderImpl(IceServer model) {
            this.uris(model.uris);
            this.username(model.username);
            this.password(model.password);
            this.ttl(model.ttl);
        }

        public final Collection<String> getUris() {
            return this.uris;
        }

        @Override
        public final Builder uris(Collection<String> uris) {
            this.uris = UrisCopier.copy(uris);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder uris(String ... uris) {
            this.uris(Arrays.asList(uris));
            return this;
        }

        public final void setUris(Collection<String> uris) {
            this.uris = UrisCopier.copy(uris);
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final String getPassword() {
            return this.password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        public final Integer getTtl() {
            return this.ttl;
        }

        @Override
        public final Builder ttl(Integer ttl) {
            this.ttl = ttl;
            return this;
        }

        public final void setTtl(Integer ttl) {
            this.ttl = ttl;
        }

        public IceServer build() {
            return new IceServer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IceServer> {
        public Builder uris(Collection<String> var1);

        public Builder uris(String ... var1);

        public Builder username(String var1);

        public Builder password(String var1);

        public Builder ttl(Integer var1);
    }
}

