/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideosignaling.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendAlexaOfferToMasterRequest extends KinesisVideoSignalingRequest implements
        ToCopyableBuilder<SendAlexaOfferToMasterRequest.Builder, SendAlexaOfferToMasterRequest> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelARN").getter(getter(SendAlexaOfferToMasterRequest::channelARN))
            .setter(setter(Builder::channelARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelARN").build()).build();

    private static final SdkField<String> SENDER_CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SenderClientId").getter(getter(SendAlexaOfferToMasterRequest::senderClientId))
            .setter(setter(Builder::senderClientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SenderClientId").build()).build();

    private static final SdkField<String> MESSAGE_PAYLOAD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MessagePayload").getter(getter(SendAlexaOfferToMasterRequest::messagePayload))
            .setter(setter(Builder::messagePayload))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessagePayload").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD,
            SENDER_CLIENT_ID_FIELD, MESSAGE_PAYLOAD_FIELD));

    private final String channelARN;

    private final String senderClientId;

    private final String messagePayload;

    private SendAlexaOfferToMasterRequest(BuilderImpl builder) {
        super(builder);
        this.channelARN = builder.channelARN;
        this.senderClientId = builder.senderClientId;
        this.messagePayload = builder.messagePayload;
    }

    /**
     * <p>
     * The ARN of the signaling channel by which Alexa and the master peer communicate.
     * </p>
     * 
     * @return The ARN of the signaling channel by which Alexa and the master peer communicate.
     */
    public final String channelARN() {
        return channelARN;
    }

    /**
     * <p>
     * The unique identifier for the sender client.
     * </p>
     * 
     * @return The unique identifier for the sender client.
     */
    public final String senderClientId() {
        return senderClientId;
    }

    /**
     * <p>
     * The base64-encoded SDP offer content.
     * </p>
     * 
     * @return The base64-encoded SDP offer content.
     */
    public final String messagePayload() {
        return messagePayload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelARN());
        hashCode = 31 * hashCode + Objects.hashCode(senderClientId());
        hashCode = 31 * hashCode + Objects.hashCode(messagePayload());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendAlexaOfferToMasterRequest)) {
            return false;
        }
        SendAlexaOfferToMasterRequest other = (SendAlexaOfferToMasterRequest) obj;
        return Objects.equals(channelARN(), other.channelARN()) && Objects.equals(senderClientId(), other.senderClientId())
                && Objects.equals(messagePayload(), other.messagePayload());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SendAlexaOfferToMasterRequest").add("ChannelARN", channelARN())
                .add("SenderClientId", senderClientId()).add("MessagePayload", messagePayload()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelARN":
            return Optional.ofNullable(clazz.cast(channelARN()));
        case "SenderClientId":
            return Optional.ofNullable(clazz.cast(senderClientId()));
        case "MessagePayload":
            return Optional.ofNullable(clazz.cast(messagePayload()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendAlexaOfferToMasterRequest, T> g) {
        return obj -> g.apply((SendAlexaOfferToMasterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisVideoSignalingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, SendAlexaOfferToMasterRequest> {
        /**
         * <p>
         * The ARN of the signaling channel by which Alexa and the master peer communicate.
         * </p>
         * 
         * @param channelARN
         *        The ARN of the signaling channel by which Alexa and the master peer communicate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelARN(String channelARN);

        /**
         * <p>
         * The unique identifier for the sender client.
         * </p>
         * 
         * @param senderClientId
         *        The unique identifier for the sender client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder senderClientId(String senderClientId);

        /**
         * <p>
         * The base64-encoded SDP offer content.
         * </p>
         * 
         * @param messagePayload
         *        The base64-encoded SDP offer content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messagePayload(String messagePayload);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisVideoSignalingRequest.BuilderImpl implements Builder {
        private String channelARN;

        private String senderClientId;

        private String messagePayload;

        private BuilderImpl() {
        }

        private BuilderImpl(SendAlexaOfferToMasterRequest model) {
            super(model);
            channelARN(model.channelARN);
            senderClientId(model.senderClientId);
            messagePayload(model.messagePayload);
        }

        public final String getChannelARN() {
            return channelARN;
        }

        public final void setChannelARN(String channelARN) {
            this.channelARN = channelARN;
        }

        @Override
        @Transient
        public final Builder channelARN(String channelARN) {
            this.channelARN = channelARN;
            return this;
        }

        public final String getSenderClientId() {
            return senderClientId;
        }

        public final void setSenderClientId(String senderClientId) {
            this.senderClientId = senderClientId;
        }

        @Override
        @Transient
        public final Builder senderClientId(String senderClientId) {
            this.senderClientId = senderClientId;
            return this;
        }

        public final String getMessagePayload() {
            return messagePayload;
        }

        public final void setMessagePayload(String messagePayload) {
            this.messagePayload = messagePayload;
        }

        @Override
        @Transient
        public final Builder messagePayload(String messagePayload) {
            this.messagePayload = messagePayload;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendAlexaOfferToMasterRequest build() {
            return new SendAlexaOfferToMasterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
