/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideosignaling;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.kinesisvideosignaling.DefaultKinesisVideoSignalingAsyncClient;
import software.amazon.awssdk.services.kinesisvideosignaling.DefaultKinesisVideoSignalingBaseClientBuilder;
import software.amazon.awssdk.services.kinesisvideosignaling.KinesisVideoSignalingAsyncClient;
import software.amazon.awssdk.services.kinesisvideosignaling.KinesisVideoSignalingAsyncClientBuilder;
import software.amazon.awssdk.services.kinesisvideosignaling.KinesisVideoSignalingServiceClientConfiguration;
import software.amazon.awssdk.services.kinesisvideosignaling.endpoints.KinesisVideoSignalingEndpointProvider;

@SdkInternalApi
final class DefaultKinesisVideoSignalingAsyncClientBuilder
extends DefaultKinesisVideoSignalingBaseClientBuilder<KinesisVideoSignalingAsyncClientBuilder, KinesisVideoSignalingAsyncClient>
implements KinesisVideoSignalingAsyncClientBuilder {
    DefaultKinesisVideoSignalingAsyncClientBuilder() {
    }

    @Override
    public DefaultKinesisVideoSignalingAsyncClientBuilder endpointProvider(KinesisVideoSignalingEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final KinesisVideoSignalingAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultKinesisVideoSignalingAsyncClientBuilder.validateClientOptions(clientConfiguration);
        KinesisVideoSignalingServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultKinesisVideoSignalingAsyncClient client = new DefaultKinesisVideoSignalingAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private KinesisVideoSignalingServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return KinesisVideoSignalingServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

