/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideosignaling;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.kinesisvideosignaling.model.GetIceServerConfigRequest;
import software.amazon.awssdk.services.kinesisvideosignaling.model.GetIceServerConfigResponse;
import software.amazon.awssdk.services.kinesisvideosignaling.model.SendAlexaOfferToMasterRequest;
import software.amazon.awssdk.services.kinesisvideosignaling.model.SendAlexaOfferToMasterResponse;

/**
 * Service client for accessing Amazon Kinesis Video Signaling Channels asynchronously. This can be created using the
 * static {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@link SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * Kinesis Video Streams Signaling Service is a intermediate service that establishes a communication channel for
 * discovering peers, transmitting offers and answers in order to establish peer-to-peer connection in webRTC
 * technology.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface KinesisVideoSignalingAsyncClient extends AwsClient {
    String SERVICE_NAME = "kinesisvideo";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "kinesisvideo";

    /**
     * <p>
     * Gets the Interactive Connectivity Establishment (ICE) server configuration information, including URIs, username,
     * and password which can be used to configure the WebRTC connection. The ICE component uses this configuration
     * information to setup the WebRTC connection, including authenticating with the Traversal Using Relays around NAT
     * (TURN) relay server.
     * </p>
     * <p>
     * TURN is a protocol that is used to improve the connectivity of peer-to-peer applications. By providing a
     * cloud-based relay service, TURN ensures that a connection can be established even when one or more peers are
     * incapable of a direct peer-to-peer connection. For more information, see <a
     * href="https://tools.ietf.org/html/draft-uberti-rtcweb-turn-rest-00">A REST API For Access To TURN Services</a>.
     * </p>
     * <p>
     * You can invoke this API to establish a fallback mechanism in case either of the peers is unable to establish a
     * direct peer-to-peer connection over a signaling channel. You must specify either a signaling channel ARN or the
     * client ID in order to invoke this API.
     * </p>
     *
     * @param getIceServerConfigRequest
     * @return A Java Future containing the result of the GetIceServerConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidClientException The specified client is invalid.</li>
     *         <li>SessionExpiredException If the client session is expired. Once the client is connected, the session
     *         is valid for 45 minutes. Client should reconnect to the channel to continue sending/receiving messages.</li>
     *         <li>ClientLimitExceededException Your request was throttled because you have exceeded the limit of
     *         allowed client calls. Try making the call later.</li>
     *         <li>ResourceNotFoundException The specified resource is not found.</li>
     *         <li>InvalidArgumentException The value for this input parameter is invalid.</li>
     *         <li>NotAuthorizedException The caller is not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisVideoSignalingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample KinesisVideoSignalingAsyncClient.GetIceServerConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-video-signaling-2019-12-04/GetIceServerConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetIceServerConfigResponse> getIceServerConfig(GetIceServerConfigRequest getIceServerConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the Interactive Connectivity Establishment (ICE) server configuration information, including URIs, username,
     * and password which can be used to configure the WebRTC connection. The ICE component uses this configuration
     * information to setup the WebRTC connection, including authenticating with the Traversal Using Relays around NAT
     * (TURN) relay server.
     * </p>
     * <p>
     * TURN is a protocol that is used to improve the connectivity of peer-to-peer applications. By providing a
     * cloud-based relay service, TURN ensures that a connection can be established even when one or more peers are
     * incapable of a direct peer-to-peer connection. For more information, see <a
     * href="https://tools.ietf.org/html/draft-uberti-rtcweb-turn-rest-00">A REST API For Access To TURN Services</a>.
     * </p>
     * <p>
     * You can invoke this API to establish a fallback mechanism in case either of the peers is unable to establish a
     * direct peer-to-peer connection over a signaling channel. You must specify either a signaling channel ARN or the
     * client ID in order to invoke this API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIceServerConfigRequest.Builder} avoiding the
     * need to create one manually via {@link GetIceServerConfigRequest#builder()}
     * </p>
     *
     * @param getIceServerConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kinesisvideosignaling.model.GetIceServerConfigRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetIceServerConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidClientException The specified client is invalid.</li>
     *         <li>SessionExpiredException If the client session is expired. Once the client is connected, the session
     *         is valid for 45 minutes. Client should reconnect to the channel to continue sending/receiving messages.</li>
     *         <li>ClientLimitExceededException Your request was throttled because you have exceeded the limit of
     *         allowed client calls. Try making the call later.</li>
     *         <li>ResourceNotFoundException The specified resource is not found.</li>
     *         <li>InvalidArgumentException The value for this input parameter is invalid.</li>
     *         <li>NotAuthorizedException The caller is not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisVideoSignalingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample KinesisVideoSignalingAsyncClient.GetIceServerConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-video-signaling-2019-12-04/GetIceServerConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetIceServerConfigResponse> getIceServerConfig(
            Consumer<GetIceServerConfigRequest.Builder> getIceServerConfigRequest) {
        return getIceServerConfig(GetIceServerConfigRequest.builder().applyMutation(getIceServerConfigRequest).build());
    }

    /**
     * <p>
     * This API allows you to connect WebRTC-enabled devices with Alexa display devices. When invoked, it sends the
     * Alexa Session Description Protocol (SDP) offer to the master peer. The offer is delivered as soon as the master
     * is connected to the specified signaling channel. This API returns the SDP answer from the connected master. If
     * the master is not connected to the signaling channel, redelivery requests are made until the message expires.
     * </p>
     *
     * @param sendAlexaOfferToMasterRequest
     * @return A Java Future containing the result of the SendAlexaOfferToMaster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClientLimitExceededException Your request was throttled because you have exceeded the limit of
     *         allowed client calls. Try making the call later.</li>
     *         <li>ResourceNotFoundException The specified resource is not found.</li>
     *         <li>InvalidArgumentException The value for this input parameter is invalid.</li>
     *         <li>NotAuthorizedException The caller is not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisVideoSignalingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample KinesisVideoSignalingAsyncClient.SendAlexaOfferToMaster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-video-signaling-2019-12-04/SendAlexaOfferToMaster"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SendAlexaOfferToMasterResponse> sendAlexaOfferToMaster(
            SendAlexaOfferToMasterRequest sendAlexaOfferToMasterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API allows you to connect WebRTC-enabled devices with Alexa display devices. When invoked, it sends the
     * Alexa Session Description Protocol (SDP) offer to the master peer. The offer is delivered as soon as the master
     * is connected to the specified signaling channel. This API returns the SDP answer from the connected master. If
     * the master is not connected to the signaling channel, redelivery requests are made until the message expires.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendAlexaOfferToMasterRequest.Builder} avoiding the
     * need to create one manually via {@link SendAlexaOfferToMasterRequest#builder()}
     * </p>
     *
     * @param sendAlexaOfferToMasterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kinesisvideosignaling.model.SendAlexaOfferToMasterRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the SendAlexaOfferToMaster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClientLimitExceededException Your request was throttled because you have exceeded the limit of
     *         allowed client calls. Try making the call later.</li>
     *         <li>ResourceNotFoundException The specified resource is not found.</li>
     *         <li>InvalidArgumentException The value for this input parameter is invalid.</li>
     *         <li>NotAuthorizedException The caller is not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KinesisVideoSignalingException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample KinesisVideoSignalingAsyncClient.SendAlexaOfferToMaster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-video-signaling-2019-12-04/SendAlexaOfferToMaster"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SendAlexaOfferToMasterResponse> sendAlexaOfferToMaster(
            Consumer<SendAlexaOfferToMasterRequest.Builder> sendAlexaOfferToMasterRequest) {
        return sendAlexaOfferToMaster(SendAlexaOfferToMasterRequest.builder().applyMutation(sendAlexaOfferToMasterRequest)
                .build());
    }

    @Override
    default KinesisVideoSignalingServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link KinesisVideoSignalingAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static KinesisVideoSignalingAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link KinesisVideoSignalingAsyncClient}.
     */
    static KinesisVideoSignalingAsyncClientBuilder builder() {
        return new DefaultKinesisVideoSignalingAsyncClientBuilder();
    }
}
