/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.nio.ByteBuffer;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DecryptResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DecryptResponse> {
    private final String keyId;
    private final ByteBuffer plaintext;

    private DecryptResponse(BuilderImpl builder) {
        this.keyId = builder.keyId;
        this.plaintext = builder.plaintext;
    }

    public String keyId() {
        return this.keyId;
    }

    public ByteBuffer plaintext() {
        return this.plaintext;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.keyId() == null ? 0 : this.keyId().hashCode());
        hashCode = 31 * hashCode + (this.plaintext() == null ? 0 : this.plaintext().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DecryptResponse)) {
            return false;
        }
        DecryptResponse other = (DecryptResponse)((Object)obj);
        if (other.keyId() == null ^ this.keyId() == null) {
            return false;
        }
        if (other.keyId() != null && !other.keyId().equals(this.keyId())) {
            return false;
        }
        if (other.plaintext() == null ^ this.plaintext() == null) {
            return false;
        }
        return other.plaintext() == null || other.plaintext().equals(this.plaintext());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.keyId() != null) {
            sb.append("KeyId: ").append(this.keyId()).append(",");
        }
        if (this.plaintext() != null) {
            sb.append("Plaintext: ").append(this.plaintext()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String keyId;
        private ByteBuffer plaintext;

        private BuilderImpl() {
        }

        private BuilderImpl(DecryptResponse model) {
            this.setKeyId(model.keyId);
            this.setPlaintext(model.plaintext);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final ByteBuffer getPlaintext() {
            return this.plaintext;
        }

        @Override
        public final Builder plaintext(ByteBuffer plaintext) {
            this.plaintext = StandardMemberCopier.copy((ByteBuffer)plaintext);
            return this;
        }

        public final void setPlaintext(ByteBuffer plaintext) {
            this.plaintext = StandardMemberCopier.copy((ByteBuffer)plaintext);
        }

        public DecryptResponse build() {
            return new DecryptResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DecryptResponse> {
        public Builder keyId(String var1);

        public Builder plaintext(ByteBuffer var1);
    }
}

