/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.kms.model.AlgorithmSpec;
import software.amazon.awssdk.services.kms.model.WrappingKeySpec;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetParametersForImportRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetParametersForImportRequest> {
    private final String keyId;
    private final String wrappingAlgorithm;
    private final String wrappingKeySpec;

    private GetParametersForImportRequest(BuilderImpl builder) {
        this.keyId = builder.keyId;
        this.wrappingAlgorithm = builder.wrappingAlgorithm;
        this.wrappingKeySpec = builder.wrappingKeySpec;
    }

    public String keyId() {
        return this.keyId;
    }

    public String wrappingAlgorithm() {
        return this.wrappingAlgorithm;
    }

    public String wrappingKeySpec() {
        return this.wrappingKeySpec;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.keyId() == null ? 0 : this.keyId().hashCode());
        hashCode = 31 * hashCode + (this.wrappingAlgorithm() == null ? 0 : this.wrappingAlgorithm().hashCode());
        hashCode = 31 * hashCode + (this.wrappingKeySpec() == null ? 0 : this.wrappingKeySpec().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetParametersForImportRequest)) {
            return false;
        }
        GetParametersForImportRequest other = (GetParametersForImportRequest)((Object)obj);
        if (other.keyId() == null ^ this.keyId() == null) {
            return false;
        }
        if (other.keyId() != null && !other.keyId().equals(this.keyId())) {
            return false;
        }
        if (other.wrappingAlgorithm() == null ^ this.wrappingAlgorithm() == null) {
            return false;
        }
        if (other.wrappingAlgorithm() != null && !other.wrappingAlgorithm().equals(this.wrappingAlgorithm())) {
            return false;
        }
        if (other.wrappingKeySpec() == null ^ this.wrappingKeySpec() == null) {
            return false;
        }
        return other.wrappingKeySpec() == null || other.wrappingKeySpec().equals(this.wrappingKeySpec());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.keyId() != null) {
            sb.append("KeyId: ").append(this.keyId()).append(",");
        }
        if (this.wrappingAlgorithm() != null) {
            sb.append("WrappingAlgorithm: ").append(this.wrappingAlgorithm()).append(",");
        }
        if (this.wrappingKeySpec() != null) {
            sb.append("WrappingKeySpec: ").append(this.wrappingKeySpec()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String keyId;
        private String wrappingAlgorithm;
        private String wrappingKeySpec;

        private BuilderImpl() {
        }

        private BuilderImpl(GetParametersForImportRequest model) {
            this.setKeyId(model.keyId);
            this.setWrappingAlgorithm(model.wrappingAlgorithm);
            this.setWrappingKeySpec(model.wrappingKeySpec);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final String getWrappingAlgorithm() {
            return this.wrappingAlgorithm;
        }

        @Override
        public final Builder wrappingAlgorithm(String wrappingAlgorithm) {
            this.wrappingAlgorithm = wrappingAlgorithm;
            return this;
        }

        @Override
        public final Builder wrappingAlgorithm(AlgorithmSpec wrappingAlgorithm) {
            this.wrappingAlgorithm(wrappingAlgorithm.toString());
            return this;
        }

        public final void setWrappingAlgorithm(String wrappingAlgorithm) {
            this.wrappingAlgorithm = wrappingAlgorithm;
        }

        public final void setWrappingAlgorithm(AlgorithmSpec wrappingAlgorithm) {
            this.wrappingAlgorithm(wrappingAlgorithm.toString());
        }

        public final String getWrappingKeySpec() {
            return this.wrappingKeySpec;
        }

        @Override
        public final Builder wrappingKeySpec(String wrappingKeySpec) {
            this.wrappingKeySpec = wrappingKeySpec;
            return this;
        }

        @Override
        public final Builder wrappingKeySpec(WrappingKeySpec wrappingKeySpec) {
            this.wrappingKeySpec(wrappingKeySpec.toString());
            return this;
        }

        public final void setWrappingKeySpec(String wrappingKeySpec) {
            this.wrappingKeySpec = wrappingKeySpec;
        }

        public final void setWrappingKeySpec(WrappingKeySpec wrappingKeySpec) {
            this.wrappingKeySpec(wrappingKeySpec.toString());
        }

        public GetParametersForImportRequest build() {
            return new GetParametersForImportRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetParametersForImportRequest> {
        public Builder keyId(String var1);

        public Builder wrappingAlgorithm(String var1);

        public Builder wrappingAlgorithm(AlgorithmSpec var1);

        public Builder wrappingKeySpec(String var1);

        public Builder wrappingKeySpec(WrappingKeySpec var1);
    }
}

