/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCustomKeyStoreRequest extends KmsRequest implements
        ToCopyableBuilder<CreateCustomKeyStoreRequest.Builder, CreateCustomKeyStoreRequest> {
    private static final SdkField<String> CUSTOM_KEY_STORE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomKeyStoreName").getter(getter(CreateCustomKeyStoreRequest::customKeyStoreName))
            .setter(setter(Builder::customKeyStoreName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomKeyStoreName").build())
            .build();

    private static final SdkField<String> CLOUD_HSM_CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CloudHsmClusterId").getter(getter(CreateCustomKeyStoreRequest::cloudHsmClusterId))
            .setter(setter(Builder::cloudHsmClusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudHsmClusterId").build()).build();

    private static final SdkField<String> TRUST_ANCHOR_CERTIFICATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrustAnchorCertificate").getter(getter(CreateCustomKeyStoreRequest::trustAnchorCertificate))
            .setter(setter(Builder::trustAnchorCertificate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustAnchorCertificate").build())
            .build();

    private static final SdkField<String> KEY_STORE_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyStorePassword").getter(getter(CreateCustomKeyStoreRequest::keyStorePassword))
            .setter(setter(Builder::keyStorePassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyStorePassword").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_KEY_STORE_NAME_FIELD,
            CLOUD_HSM_CLUSTER_ID_FIELD, TRUST_ANCHOR_CERTIFICATE_FIELD, KEY_STORE_PASSWORD_FIELD));

    private final String customKeyStoreName;

    private final String cloudHsmClusterId;

    private final String trustAnchorCertificate;

    private final String keyStorePassword;

    private CreateCustomKeyStoreRequest(BuilderImpl builder) {
        super(builder);
        this.customKeyStoreName = builder.customKeyStoreName;
        this.cloudHsmClusterId = builder.cloudHsmClusterId;
        this.trustAnchorCertificate = builder.trustAnchorCertificate;
        this.keyStorePassword = builder.keyStorePassword;
    }

    /**
     * <p>
     * Specifies a friendly name for the custom key store. The name must be unique in your AWS account.
     * </p>
     * 
     * @return Specifies a friendly name for the custom key store. The name must be unique in your AWS account.
     */
    public final String customKeyStoreName() {
        return customKeyStoreName;
    }

    /**
     * <p>
     * Identifies the AWS CloudHSM cluster for the custom key store. Enter the cluster ID of any active AWS CloudHSM
     * cluster that is not already associated with a custom key store. To find the cluster ID, use the <a
     * href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html">DescribeClusters</a>
     * operation.
     * </p>
     * 
     * @return Identifies the AWS CloudHSM cluster for the custom key store. Enter the cluster ID of any active AWS
     *         CloudHSM cluster that is not already associated with a custom key store. To find the cluster ID, use the
     *         <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html">
     *         DescribeClusters</a> operation.
     */
    public final String cloudHsmClusterId() {
        return cloudHsmClusterId;
    }

    /**
     * <p>
     * Enter the content of the trust anchor certificate for the cluster. This is the content of the
     * <code>customerCA.crt</code> file that you created when you <a
     * href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/initialize-cluster.html">initialized the cluster</a>.
     * </p>
     * 
     * @return Enter the content of the trust anchor certificate for the cluster. This is the content of the
     *         <code>customerCA.crt</code> file that you created when you <a
     *         href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/initialize-cluster.html">initialized the
     *         cluster</a>.
     */
    public final String trustAnchorCertificate() {
        return trustAnchorCertificate;
    }

    /**
     * <p>
     * Enter the password of the <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/key-store-concepts.html#concept-kmsuser">
     * <code>kmsuser</code> crypto user (CU) account</a> in the specified AWS CloudHSM cluster. AWS KMS logs into the
     * cluster as this user to manage key material on your behalf.
     * </p>
     * <p>
     * The password must be a string of 7 to 32 characters. Its value is case sensitive.
     * </p>
     * <p>
     * This parameter tells AWS KMS the <code>kmsuser</code> account password; it does not change the password in the
     * AWS CloudHSM cluster.
     * </p>
     * 
     * @return Enter the password of the <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/key-store-concepts.html#concept-kmsuser">
     *         <code>kmsuser</code> crypto user (CU) account</a> in the specified AWS CloudHSM cluster. AWS KMS logs
     *         into the cluster as this user to manage key material on your behalf.</p>
     *         <p>
     *         The password must be a string of 7 to 32 characters. Its value is case sensitive.
     *         </p>
     *         <p>
     *         This parameter tells AWS KMS the <code>kmsuser</code> account password; it does not change the password
     *         in the AWS CloudHSM cluster.
     */
    public final String keyStorePassword() {
        return keyStorePassword;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(customKeyStoreName());
        hashCode = 31 * hashCode + Objects.hashCode(cloudHsmClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(trustAnchorCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(keyStorePassword());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomKeyStoreRequest)) {
            return false;
        }
        CreateCustomKeyStoreRequest other = (CreateCustomKeyStoreRequest) obj;
        return Objects.equals(customKeyStoreName(), other.customKeyStoreName())
                && Objects.equals(cloudHsmClusterId(), other.cloudHsmClusterId())
                && Objects.equals(trustAnchorCertificate(), other.trustAnchorCertificate())
                && Objects.equals(keyStorePassword(), other.keyStorePassword());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCustomKeyStoreRequest").add("CustomKeyStoreName", customKeyStoreName())
                .add("CloudHsmClusterId", cloudHsmClusterId()).add("TrustAnchorCertificate", trustAnchorCertificate())
                .add("KeyStorePassword", keyStorePassword() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomKeyStoreName":
            return Optional.ofNullable(clazz.cast(customKeyStoreName()));
        case "CloudHsmClusterId":
            return Optional.ofNullable(clazz.cast(cloudHsmClusterId()));
        case "TrustAnchorCertificate":
            return Optional.ofNullable(clazz.cast(trustAnchorCertificate()));
        case "KeyStorePassword":
            return Optional.ofNullable(clazz.cast(keyStorePassword()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCustomKeyStoreRequest, T> g) {
        return obj -> g.apply((CreateCustomKeyStoreRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KmsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateCustomKeyStoreRequest> {
        /**
         * <p>
         * Specifies a friendly name for the custom key store. The name must be unique in your AWS account.
         * </p>
         * 
         * @param customKeyStoreName
         *        Specifies a friendly name for the custom key store. The name must be unique in your AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customKeyStoreName(String customKeyStoreName);

        /**
         * <p>
         * Identifies the AWS CloudHSM cluster for the custom key store. Enter the cluster ID of any active AWS CloudHSM
         * cluster that is not already associated with a custom key store. To find the cluster ID, use the <a
         * href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html"
         * >DescribeClusters</a> operation.
         * </p>
         * 
         * @param cloudHsmClusterId
         *        Identifies the AWS CloudHSM cluster for the custom key store. Enter the cluster ID of any active AWS
         *        CloudHSM cluster that is not already associated with a custom key store. To find the cluster ID, use
         *        the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html">
         *        DescribeClusters</a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudHsmClusterId(String cloudHsmClusterId);

        /**
         * <p>
         * Enter the content of the trust anchor certificate for the cluster. This is the content of the
         * <code>customerCA.crt</code> file that you created when you <a
         * href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/initialize-cluster.html">initialized the
         * cluster</a>.
         * </p>
         * 
         * @param trustAnchorCertificate
         *        Enter the content of the trust anchor certificate for the cluster. This is the content of the
         *        <code>customerCA.crt</code> file that you created when you <a
         *        href="https://docs.aws.amazon.com/cloudhsm/latest/userguide/initialize-cluster.html">initialized the
         *        cluster</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustAnchorCertificate(String trustAnchorCertificate);

        /**
         * <p>
         * Enter the password of the <a
         * href="https://docs.aws.amazon.com/kms/latest/developerguide/key-store-concepts.html#concept-kmsuser">
         * <code>kmsuser</code> crypto user (CU) account</a> in the specified AWS CloudHSM cluster. AWS KMS logs into
         * the cluster as this user to manage key material on your behalf.
         * </p>
         * <p>
         * The password must be a string of 7 to 32 characters. Its value is case sensitive.
         * </p>
         * <p>
         * This parameter tells AWS KMS the <code>kmsuser</code> account password; it does not change the password in
         * the AWS CloudHSM cluster.
         * </p>
         * 
         * @param keyStorePassword
         *        Enter the password of the <a
         *        href="https://docs.aws.amazon.com/kms/latest/developerguide/key-store-concepts.html#concept-kmsuser">
         *        <code>kmsuser</code> crypto user (CU) account</a> in the specified AWS CloudHSM cluster. AWS KMS logs
         *        into the cluster as this user to manage key material on your behalf.</p>
         *        <p>
         *        The password must be a string of 7 to 32 characters. Its value is case sensitive.
         *        </p>
         *        <p>
         *        This parameter tells AWS KMS the <code>kmsuser</code> account password; it does not change the
         *        password in the AWS CloudHSM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyStorePassword(String keyStorePassword);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KmsRequest.BuilderImpl implements Builder {
        private String customKeyStoreName;

        private String cloudHsmClusterId;

        private String trustAnchorCertificate;

        private String keyStorePassword;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCustomKeyStoreRequest model) {
            super(model);
            customKeyStoreName(model.customKeyStoreName);
            cloudHsmClusterId(model.cloudHsmClusterId);
            trustAnchorCertificate(model.trustAnchorCertificate);
            keyStorePassword(model.keyStorePassword);
        }

        public final String getCustomKeyStoreName() {
            return customKeyStoreName;
        }

        @Override
        public final Builder customKeyStoreName(String customKeyStoreName) {
            this.customKeyStoreName = customKeyStoreName;
            return this;
        }

        public final void setCustomKeyStoreName(String customKeyStoreName) {
            this.customKeyStoreName = customKeyStoreName;
        }

        public final String getCloudHsmClusterId() {
            return cloudHsmClusterId;
        }

        @Override
        public final Builder cloudHsmClusterId(String cloudHsmClusterId) {
            this.cloudHsmClusterId = cloudHsmClusterId;
            return this;
        }

        public final void setCloudHsmClusterId(String cloudHsmClusterId) {
            this.cloudHsmClusterId = cloudHsmClusterId;
        }

        public final String getTrustAnchorCertificate() {
            return trustAnchorCertificate;
        }

        @Override
        public final Builder trustAnchorCertificate(String trustAnchorCertificate) {
            this.trustAnchorCertificate = trustAnchorCertificate;
            return this;
        }

        public final void setTrustAnchorCertificate(String trustAnchorCertificate) {
            this.trustAnchorCertificate = trustAnchorCertificate;
        }

        public final String getKeyStorePassword() {
            return keyStorePassword;
        }

        @Override
        public final Builder keyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
            return this;
        }

        public final void setKeyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCustomKeyStoreRequest build() {
            return new CreateCustomKeyStoreRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
