/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kms.model.KmsResponse;
import software.amazon.awssdk.services.kms.model.SigningAlgorithmSpec;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VerifyResponse
extends KmsResponse
implements ToCopyableBuilder<Builder, VerifyResponse> {
    private static final SdkField<String> KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyId").getter(VerifyResponse.getter(VerifyResponse::keyId)).setter(VerifyResponse.setter(Builder::keyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()}).build();
    private static final SdkField<Boolean> SIGNATURE_VALID_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SignatureValid").getter(VerifyResponse.getter(VerifyResponse::signatureValid)).setter(VerifyResponse.setter(Builder::signatureValid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SignatureValid").build()}).build();
    private static final SdkField<String> SIGNING_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SigningAlgorithm").getter(VerifyResponse.getter(VerifyResponse::signingAlgorithmAsString)).setter(VerifyResponse.setter(Builder::signingAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningAlgorithm").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ID_FIELD, SIGNATURE_VALID_FIELD, SIGNING_ALGORITHM_FIELD));
    private final String keyId;
    private final Boolean signatureValid;
    private final String signingAlgorithm;

    private VerifyResponse(BuilderImpl builder) {
        super(builder);
        this.keyId = builder.keyId;
        this.signatureValid = builder.signatureValid;
        this.signingAlgorithm = builder.signingAlgorithm;
    }

    public final String keyId() {
        return this.keyId;
    }

    public final Boolean signatureValid() {
        return this.signatureValid;
    }

    public final SigningAlgorithmSpec signingAlgorithm() {
        return SigningAlgorithmSpec.fromValue(this.signingAlgorithm);
    }

    public final String signingAlgorithmAsString() {
        return this.signingAlgorithm;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.signatureValid());
        hashCode = 31 * hashCode + Objects.hashCode(this.signingAlgorithmAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifyResponse)) {
            return false;
        }
        VerifyResponse other = (VerifyResponse)((Object)obj);
        return Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.signatureValid(), other.signatureValid()) && Objects.equals(this.signingAlgorithmAsString(), other.signingAlgorithmAsString());
    }

    public final String toString() {
        return ToString.builder((String)"VerifyResponse").add("KeyId", (Object)this.keyId()).add("SignatureValid", (Object)this.signatureValid()).add("SigningAlgorithm", (Object)this.signingAlgorithmAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyId": {
                return Optional.ofNullable(clazz.cast(this.keyId()));
            }
            case "SignatureValid": {
                return Optional.ofNullable(clazz.cast(this.signatureValid()));
            }
            case "SigningAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.signingAlgorithmAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VerifyResponse, T> g) {
        return obj -> g.apply((VerifyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KmsResponse.BuilderImpl
    implements Builder {
        private String keyId;
        private Boolean signatureValid;
        private String signingAlgorithm;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifyResponse model) {
            super(model);
            this.keyId(model.keyId);
            this.signatureValid(model.signatureValid);
            this.signingAlgorithm(model.signingAlgorithm);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        @Override
        @Transient
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final Boolean getSignatureValid() {
            return this.signatureValid;
        }

        public final void setSignatureValid(Boolean signatureValid) {
            this.signatureValid = signatureValid;
        }

        @Override
        @Transient
        public final Builder signatureValid(Boolean signatureValid) {
            this.signatureValid = signatureValid;
            return this;
        }

        public final String getSigningAlgorithm() {
            return this.signingAlgorithm;
        }

        public final void setSigningAlgorithm(String signingAlgorithm) {
            this.signingAlgorithm = signingAlgorithm;
        }

        @Override
        @Transient
        public final Builder signingAlgorithm(String signingAlgorithm) {
            this.signingAlgorithm = signingAlgorithm;
            return this;
        }

        @Override
        @Transient
        public final Builder signingAlgorithm(SigningAlgorithmSpec signingAlgorithm) {
            this.signingAlgorithm(signingAlgorithm == null ? null : signingAlgorithm.toString());
            return this;
        }

        @Override
        public VerifyResponse build() {
            return new VerifyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KmsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, VerifyResponse> {
        public Builder keyId(String var1);

        public Builder signatureValid(Boolean var1);

        public Builder signingAlgorithm(String var1);

        public Builder signingAlgorithm(SigningAlgorithmSpec var1);
    }
}

