/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GenerateRandomRequest extends KmsRequest implements
        ToCopyableBuilder<GenerateRandomRequest.Builder, GenerateRandomRequest> {
    private static final SdkField<Integer> NUMBER_OF_BYTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfBytes").getter(getter(GenerateRandomRequest::numberOfBytes))
            .setter(setter(Builder::numberOfBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfBytes").build()).build();

    private static final SdkField<String> CUSTOM_KEY_STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomKeyStoreId").getter(getter(GenerateRandomRequest::customKeyStoreId))
            .setter(setter(Builder::customKeyStoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomKeyStoreId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMBER_OF_BYTES_FIELD,
            CUSTOM_KEY_STORE_ID_FIELD));

    private final Integer numberOfBytes;

    private final String customKeyStoreId;

    private GenerateRandomRequest(BuilderImpl builder) {
        super(builder);
        this.numberOfBytes = builder.numberOfBytes;
        this.customKeyStoreId = builder.customKeyStoreId;
    }

    /**
     * <p>
     * The length of the random byte string. This parameter is required.
     * </p>
     * 
     * @return The length of the random byte string. This parameter is required.
     */
    public final Integer numberOfBytes() {
        return numberOfBytes;
    }

    /**
     * <p>
     * Generates the random byte string in the CloudHSM cluster that is associated with the specified CloudHSM key
     * store. To find the ID of a custom key store, use the <a>DescribeCustomKeyStores</a> operation.
     * </p>
     * <p>
     * External key store IDs are not valid for this parameter. If you specify the ID of an external key store,
     * <code>GenerateRandom</code> throws an <code>UnsupportedOperationException</code>.
     * </p>
     * 
     * @return Generates the random byte string in the CloudHSM cluster that is associated with the specified CloudHSM
     *         key store. To find the ID of a custom key store, use the <a>DescribeCustomKeyStores</a> operation.</p>
     *         <p>
     *         External key store IDs are not valid for this parameter. If you specify the ID of an external key store,
     *         <code>GenerateRandom</code> throws an <code>UnsupportedOperationException</code>.
     */
    public final String customKeyStoreId() {
        return customKeyStoreId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(numberOfBytes());
        hashCode = 31 * hashCode + Objects.hashCode(customKeyStoreId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateRandomRequest)) {
            return false;
        }
        GenerateRandomRequest other = (GenerateRandomRequest) obj;
        return Objects.equals(numberOfBytes(), other.numberOfBytes())
                && Objects.equals(customKeyStoreId(), other.customKeyStoreId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GenerateRandomRequest").add("NumberOfBytes", numberOfBytes())
                .add("CustomKeyStoreId", customKeyStoreId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NumberOfBytes":
            return Optional.ofNullable(clazz.cast(numberOfBytes()));
        case "CustomKeyStoreId":
            return Optional.ofNullable(clazz.cast(customKeyStoreId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GenerateRandomRequest, T> g) {
        return obj -> g.apply((GenerateRandomRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KmsRequest.Builder, SdkPojo, CopyableBuilder<Builder, GenerateRandomRequest> {
        /**
         * <p>
         * The length of the random byte string. This parameter is required.
         * </p>
         * 
         * @param numberOfBytes
         *        The length of the random byte string. This parameter is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfBytes(Integer numberOfBytes);

        /**
         * <p>
         * Generates the random byte string in the CloudHSM cluster that is associated with the specified CloudHSM key
         * store. To find the ID of a custom key store, use the <a>DescribeCustomKeyStores</a> operation.
         * </p>
         * <p>
         * External key store IDs are not valid for this parameter. If you specify the ID of an external key store,
         * <code>GenerateRandom</code> throws an <code>UnsupportedOperationException</code>.
         * </p>
         * 
         * @param customKeyStoreId
         *        Generates the random byte string in the CloudHSM cluster that is associated with the specified
         *        CloudHSM key store. To find the ID of a custom key store, use the <a>DescribeCustomKeyStores</a>
         *        operation.</p>
         *        <p>
         *        External key store IDs are not valid for this parameter. If you specify the ID of an external key
         *        store, <code>GenerateRandom</code> throws an <code>UnsupportedOperationException</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customKeyStoreId(String customKeyStoreId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KmsRequest.BuilderImpl implements Builder {
        private Integer numberOfBytes;

        private String customKeyStoreId;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateRandomRequest model) {
            super(model);
            numberOfBytes(model.numberOfBytes);
            customKeyStoreId(model.customKeyStoreId);
        }

        public final Integer getNumberOfBytes() {
            return numberOfBytes;
        }

        public final void setNumberOfBytes(Integer numberOfBytes) {
            this.numberOfBytes = numberOfBytes;
        }

        @Override
        public final Builder numberOfBytes(Integer numberOfBytes) {
            this.numberOfBytes = numberOfBytes;
            return this;
        }

        public final String getCustomKeyStoreId() {
            return customKeyStoreId;
        }

        public final void setCustomKeyStoreId(String customKeyStoreId) {
            this.customKeyStoreId = customKeyStoreId;
        }

        @Override
        public final Builder customKeyStoreId(String customKeyStoreId) {
            this.customKeyStoreId = customKeyStoreId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GenerateRandomRequest build() {
            return new GenerateRandomRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
