/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.kms.DefaultKmsAsyncClient;
import software.amazon.awssdk.services.kms.DefaultKmsBaseClientBuilder;
import software.amazon.awssdk.services.kms.KmsAsyncClient;
import software.amazon.awssdk.services.kms.KmsAsyncClientBuilder;
import software.amazon.awssdk.services.kms.KmsServiceClientConfiguration;
import software.amazon.awssdk.services.kms.endpoints.KmsEndpointProvider;

@SdkInternalApi
final class DefaultKmsAsyncClientBuilder
extends DefaultKmsBaseClientBuilder<KmsAsyncClientBuilder, KmsAsyncClient>
implements KmsAsyncClientBuilder {
    DefaultKmsAsyncClientBuilder() {
    }

    @Override
    public DefaultKmsAsyncClientBuilder endpointProvider(KmsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final KmsAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultKmsAsyncClientBuilder.validateClientOptions(clientConfiguration);
        KmsServiceClientConfiguration serviceClientConfiguration = KmsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultKmsAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

