/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.internal.UserAgentUtils;
import software.amazon.awssdk.services.kms.model.CustomKeyStoresListEntry;
import software.amazon.awssdk.services.kms.model.DescribeCustomKeyStoresRequest;
import software.amazon.awssdk.services.kms.model.DescribeCustomKeyStoresResponse;

public class DescribeCustomKeyStoresIterable
implements SdkIterable<DescribeCustomKeyStoresResponse> {
    private final KmsClient client;
    private final DescribeCustomKeyStoresRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeCustomKeyStoresIterable(KmsClient client, DescribeCustomKeyStoresRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeCustomKeyStoresResponseFetcher();
    }

    public Iterator<DescribeCustomKeyStoresResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CustomKeyStoresListEntry> customKeyStores() {
        Function<DescribeCustomKeyStoresResponse, Iterator> getIterator = response -> {
            if (response != null && response.customKeyStores() != null) {
                return response.customKeyStores().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeCustomKeyStoresResponseFetcher
    implements SyncPageFetcher<DescribeCustomKeyStoresResponse> {
        private DescribeCustomKeyStoresResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCustomKeyStoresResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public DescribeCustomKeyStoresResponse nextPage(DescribeCustomKeyStoresResponse previousPage) {
            if (previousPage == null) {
                return DescribeCustomKeyStoresIterable.this.client.describeCustomKeyStores(DescribeCustomKeyStoresIterable.this.firstRequest);
            }
            return DescribeCustomKeyStoresIterable.this.client.describeCustomKeyStores((DescribeCustomKeyStoresRequest)((Object)DescribeCustomKeyStoresIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

