/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kms.model.KmsRequest;
import software.amazon.awssdk.services.kms.model.RecipientInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GenerateRandomRequest
extends KmsRequest
implements ToCopyableBuilder<Builder, GenerateRandomRequest> {
    private static final SdkField<Integer> NUMBER_OF_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfBytes").getter(GenerateRandomRequest.getter(GenerateRandomRequest::numberOfBytes)).setter(GenerateRandomRequest.setter(Builder::numberOfBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfBytes").build()}).build();
    private static final SdkField<String> CUSTOM_KEY_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomKeyStoreId").getter(GenerateRandomRequest.getter(GenerateRandomRequest::customKeyStoreId)).setter(GenerateRandomRequest.setter(Builder::customKeyStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomKeyStoreId").build()}).build();
    private static final SdkField<RecipientInfo> RECIPIENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Recipient").getter(GenerateRandomRequest.getter(GenerateRandomRequest::recipient)).setter(GenerateRandomRequest.setter(Builder::recipient)).constructor(RecipientInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recipient").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMBER_OF_BYTES_FIELD, CUSTOM_KEY_STORE_ID_FIELD, RECIPIENT_FIELD));
    private final Integer numberOfBytes;
    private final String customKeyStoreId;
    private final RecipientInfo recipient;

    private GenerateRandomRequest(BuilderImpl builder) {
        super(builder);
        this.numberOfBytes = builder.numberOfBytes;
        this.customKeyStoreId = builder.customKeyStoreId;
        this.recipient = builder.recipient;
    }

    public final Integer numberOfBytes() {
        return this.numberOfBytes;
    }

    public final String customKeyStoreId() {
        return this.customKeyStoreId;
    }

    public final RecipientInfo recipient() {
        return this.recipient;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.customKeyStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.recipient());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateRandomRequest)) {
            return false;
        }
        GenerateRandomRequest other = (GenerateRandomRequest)((Object)obj);
        return Objects.equals(this.numberOfBytes(), other.numberOfBytes()) && Objects.equals(this.customKeyStoreId(), other.customKeyStoreId()) && Objects.equals(this.recipient(), other.recipient());
    }

    public final String toString() {
        return ToString.builder((String)"GenerateRandomRequest").add("NumberOfBytes", (Object)this.numberOfBytes()).add("CustomKeyStoreId", (Object)this.customKeyStoreId()).add("Recipient", (Object)this.recipient()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NumberOfBytes": {
                return Optional.ofNullable(clazz.cast(this.numberOfBytes()));
            }
            case "CustomKeyStoreId": {
                return Optional.ofNullable(clazz.cast(this.customKeyStoreId()));
            }
            case "Recipient": {
                return Optional.ofNullable(clazz.cast(this.recipient()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GenerateRandomRequest, T> g) {
        return obj -> g.apply((GenerateRandomRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KmsRequest.BuilderImpl
    implements Builder {
        private Integer numberOfBytes;
        private String customKeyStoreId;
        private RecipientInfo recipient;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateRandomRequest model) {
            super(model);
            this.numberOfBytes(model.numberOfBytes);
            this.customKeyStoreId(model.customKeyStoreId);
            this.recipient(model.recipient);
        }

        public final Integer getNumberOfBytes() {
            return this.numberOfBytes;
        }

        public final void setNumberOfBytes(Integer numberOfBytes) {
            this.numberOfBytes = numberOfBytes;
        }

        @Override
        public final Builder numberOfBytes(Integer numberOfBytes) {
            this.numberOfBytes = numberOfBytes;
            return this;
        }

        public final String getCustomKeyStoreId() {
            return this.customKeyStoreId;
        }

        public final void setCustomKeyStoreId(String customKeyStoreId) {
            this.customKeyStoreId = customKeyStoreId;
        }

        @Override
        public final Builder customKeyStoreId(String customKeyStoreId) {
            this.customKeyStoreId = customKeyStoreId;
            return this;
        }

        public final RecipientInfo.Builder getRecipient() {
            return this.recipient != null ? this.recipient.toBuilder() : null;
        }

        public final void setRecipient(RecipientInfo.BuilderImpl recipient) {
            this.recipient = recipient != null ? recipient.build() : null;
        }

        @Override
        public final Builder recipient(RecipientInfo recipient) {
            this.recipient = recipient;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GenerateRandomRequest build() {
            return new GenerateRandomRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KmsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GenerateRandomRequest> {
        public Builder numberOfBytes(Integer var1);

        public Builder customKeyStoreId(String var1);

        public Builder recipient(RecipientInfo var1);

        default public Builder recipient(Consumer<RecipientInfo.Builder> recipient) {
            return this.recipient((RecipientInfo)((RecipientInfo.Builder)RecipientInfo.builder().applyMutation(recipient)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

