/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kms.model.KmsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetKeyRotationStatusResponse
extends KmsResponse
implements ToCopyableBuilder<Builder, GetKeyRotationStatusResponse> {
    private static final SdkField<Boolean> KEY_ROTATION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("KeyRotationEnabled").getter(GetKeyRotationStatusResponse.getter(GetKeyRotationStatusResponse::keyRotationEnabled)).setter(GetKeyRotationStatusResponse.setter(Builder::keyRotationEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyRotationEnabled").build()}).build();
    private static final SdkField<String> KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyId").getter(GetKeyRotationStatusResponse.getter(GetKeyRotationStatusResponse::keyId)).setter(GetKeyRotationStatusResponse.setter(Builder::keyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()}).build();
    private static final SdkField<Integer> ROTATION_PERIOD_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RotationPeriodInDays").getter(GetKeyRotationStatusResponse.getter(GetKeyRotationStatusResponse::rotationPeriodInDays)).setter(GetKeyRotationStatusResponse.setter(Builder::rotationPeriodInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RotationPeriodInDays").build()}).build();
    private static final SdkField<Instant> NEXT_ROTATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("NextRotationDate").getter(GetKeyRotationStatusResponse.getter(GetKeyRotationStatusResponse::nextRotationDate)).setter(GetKeyRotationStatusResponse.setter(Builder::nextRotationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextRotationDate").build()}).build();
    private static final SdkField<Instant> ON_DEMAND_ROTATION_START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("OnDemandRotationStartDate").getter(GetKeyRotationStatusResponse.getter(GetKeyRotationStatusResponse::onDemandRotationStartDate)).setter(GetKeyRotationStatusResponse.setter(Builder::onDemandRotationStartDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandRotationStartDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ROTATION_ENABLED_FIELD, KEY_ID_FIELD, ROTATION_PERIOD_IN_DAYS_FIELD, NEXT_ROTATION_DATE_FIELD, ON_DEMAND_ROTATION_START_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("KeyRotationEnabled", KEY_ROTATION_ENABLED_FIELD);
            this.put("KeyId", KEY_ID_FIELD);
            this.put("RotationPeriodInDays", ROTATION_PERIOD_IN_DAYS_FIELD);
            this.put("NextRotationDate", NEXT_ROTATION_DATE_FIELD);
            this.put("OnDemandRotationStartDate", ON_DEMAND_ROTATION_START_DATE_FIELD);
        }
    });
    private final Boolean keyRotationEnabled;
    private final String keyId;
    private final Integer rotationPeriodInDays;
    private final Instant nextRotationDate;
    private final Instant onDemandRotationStartDate;

    private GetKeyRotationStatusResponse(BuilderImpl builder) {
        super(builder);
        this.keyRotationEnabled = builder.keyRotationEnabled;
        this.keyId = builder.keyId;
        this.rotationPeriodInDays = builder.rotationPeriodInDays;
        this.nextRotationDate = builder.nextRotationDate;
        this.onDemandRotationStartDate = builder.onDemandRotationStartDate;
    }

    public final Boolean keyRotationEnabled() {
        return this.keyRotationEnabled;
    }

    public final String keyId() {
        return this.keyId;
    }

    public final Integer rotationPeriodInDays() {
        return this.rotationPeriodInDays;
    }

    public final Instant nextRotationDate() {
        return this.nextRotationDate;
    }

    public final Instant onDemandRotationStartDate() {
        return this.onDemandRotationStartDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyRotationEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.rotationPeriodInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextRotationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.onDemandRotationStartDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetKeyRotationStatusResponse)) {
            return false;
        }
        GetKeyRotationStatusResponse other = (GetKeyRotationStatusResponse)((Object)obj);
        return Objects.equals(this.keyRotationEnabled(), other.keyRotationEnabled()) && Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.rotationPeriodInDays(), other.rotationPeriodInDays()) && Objects.equals(this.nextRotationDate(), other.nextRotationDate()) && Objects.equals(this.onDemandRotationStartDate(), other.onDemandRotationStartDate());
    }

    public final String toString() {
        return ToString.builder((String)"GetKeyRotationStatusResponse").add("KeyRotationEnabled", (Object)this.keyRotationEnabled()).add("KeyId", (Object)this.keyId()).add("RotationPeriodInDays", (Object)this.rotationPeriodInDays()).add("NextRotationDate", (Object)this.nextRotationDate()).add("OnDemandRotationStartDate", (Object)this.onDemandRotationStartDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyRotationEnabled": {
                return Optional.ofNullable(clazz.cast(this.keyRotationEnabled()));
            }
            case "KeyId": {
                return Optional.ofNullable(clazz.cast(this.keyId()));
            }
            case "RotationPeriodInDays": {
                return Optional.ofNullable(clazz.cast(this.rotationPeriodInDays()));
            }
            case "NextRotationDate": {
                return Optional.ofNullable(clazz.cast(this.nextRotationDate()));
            }
            case "OnDemandRotationStartDate": {
                return Optional.ofNullable(clazz.cast(this.onDemandRotationStartDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetKeyRotationStatusResponse, T> g) {
        return obj -> g.apply((GetKeyRotationStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KmsResponse.BuilderImpl
    implements Builder {
        private Boolean keyRotationEnabled;
        private String keyId;
        private Integer rotationPeriodInDays;
        private Instant nextRotationDate;
        private Instant onDemandRotationStartDate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetKeyRotationStatusResponse model) {
            super(model);
            this.keyRotationEnabled(model.keyRotationEnabled);
            this.keyId(model.keyId);
            this.rotationPeriodInDays(model.rotationPeriodInDays);
            this.nextRotationDate(model.nextRotationDate);
            this.onDemandRotationStartDate(model.onDemandRotationStartDate);
        }

        public final Boolean getKeyRotationEnabled() {
            return this.keyRotationEnabled;
        }

        public final void setKeyRotationEnabled(Boolean keyRotationEnabled) {
            this.keyRotationEnabled = keyRotationEnabled;
        }

        @Override
        public final Builder keyRotationEnabled(Boolean keyRotationEnabled) {
            this.keyRotationEnabled = keyRotationEnabled;
            return this;
        }

        public final String getKeyId() {
            return this.keyId;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final Integer getRotationPeriodInDays() {
            return this.rotationPeriodInDays;
        }

        public final void setRotationPeriodInDays(Integer rotationPeriodInDays) {
            this.rotationPeriodInDays = rotationPeriodInDays;
        }

        @Override
        public final Builder rotationPeriodInDays(Integer rotationPeriodInDays) {
            this.rotationPeriodInDays = rotationPeriodInDays;
            return this;
        }

        public final Instant getNextRotationDate() {
            return this.nextRotationDate;
        }

        public final void setNextRotationDate(Instant nextRotationDate) {
            this.nextRotationDate = nextRotationDate;
        }

        @Override
        public final Builder nextRotationDate(Instant nextRotationDate) {
            this.nextRotationDate = nextRotationDate;
            return this;
        }

        public final Instant getOnDemandRotationStartDate() {
            return this.onDemandRotationStartDate;
        }

        public final void setOnDemandRotationStartDate(Instant onDemandRotationStartDate) {
            this.onDemandRotationStartDate = onDemandRotationStartDate;
        }

        @Override
        public final Builder onDemandRotationStartDate(Instant onDemandRotationStartDate) {
            this.onDemandRotationStartDate = onDemandRotationStartDate;
            return this;
        }

        @Override
        public GetKeyRotationStatusResponse build() {
            return new GetKeyRotationStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KmsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetKeyRotationStatusResponse> {
        public Builder keyRotationEnabled(Boolean var1);

        public Builder keyId(String var1);

        public Builder rotationPeriodInDays(Integer var1);

        public Builder nextRotationDate(Instant var1);

        public Builder onDemandRotationStartDate(Instant var1);
    }
}

