/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.KmsServiceClientConfiguration;
import software.amazon.awssdk.services.kms.internal.KmsServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.kms.model.AlreadyExistsException;
import software.amazon.awssdk.services.kms.model.CancelKeyDeletionRequest;
import software.amazon.awssdk.services.kms.model.CancelKeyDeletionResponse;
import software.amazon.awssdk.services.kms.model.CloudHsmClusterInUseException;
import software.amazon.awssdk.services.kms.model.CloudHsmClusterInvalidConfigurationException;
import software.amazon.awssdk.services.kms.model.CloudHsmClusterNotActiveException;
import software.amazon.awssdk.services.kms.model.CloudHsmClusterNotFoundException;
import software.amazon.awssdk.services.kms.model.CloudHsmClusterNotRelatedException;
import software.amazon.awssdk.services.kms.model.ConflictException;
import software.amazon.awssdk.services.kms.model.ConnectCustomKeyStoreRequest;
import software.amazon.awssdk.services.kms.model.ConnectCustomKeyStoreResponse;
import software.amazon.awssdk.services.kms.model.CreateAliasRequest;
import software.amazon.awssdk.services.kms.model.CreateAliasResponse;
import software.amazon.awssdk.services.kms.model.CreateCustomKeyStoreRequest;
import software.amazon.awssdk.services.kms.model.CreateCustomKeyStoreResponse;
import software.amazon.awssdk.services.kms.model.CreateGrantRequest;
import software.amazon.awssdk.services.kms.model.CreateGrantResponse;
import software.amazon.awssdk.services.kms.model.CreateKeyRequest;
import software.amazon.awssdk.services.kms.model.CreateKeyResponse;
import software.amazon.awssdk.services.kms.model.CustomKeyStoreHasCmKsException;
import software.amazon.awssdk.services.kms.model.CustomKeyStoreInvalidStateException;
import software.amazon.awssdk.services.kms.model.CustomKeyStoreNameInUseException;
import software.amazon.awssdk.services.kms.model.CustomKeyStoreNotFoundException;
import software.amazon.awssdk.services.kms.model.DecryptRequest;
import software.amazon.awssdk.services.kms.model.DecryptResponse;
import software.amazon.awssdk.services.kms.model.DeleteAliasRequest;
import software.amazon.awssdk.services.kms.model.DeleteAliasResponse;
import software.amazon.awssdk.services.kms.model.DeleteCustomKeyStoreRequest;
import software.amazon.awssdk.services.kms.model.DeleteCustomKeyStoreResponse;
import software.amazon.awssdk.services.kms.model.DeleteImportedKeyMaterialRequest;
import software.amazon.awssdk.services.kms.model.DeleteImportedKeyMaterialResponse;
import software.amazon.awssdk.services.kms.model.DependencyTimeoutException;
import software.amazon.awssdk.services.kms.model.DeriveSharedSecretRequest;
import software.amazon.awssdk.services.kms.model.DeriveSharedSecretResponse;
import software.amazon.awssdk.services.kms.model.DescribeCustomKeyStoresRequest;
import software.amazon.awssdk.services.kms.model.DescribeCustomKeyStoresResponse;
import software.amazon.awssdk.services.kms.model.DescribeKeyRequest;
import software.amazon.awssdk.services.kms.model.DescribeKeyResponse;
import software.amazon.awssdk.services.kms.model.DisableKeyRequest;
import software.amazon.awssdk.services.kms.model.DisableKeyResponse;
import software.amazon.awssdk.services.kms.model.DisableKeyRotationRequest;
import software.amazon.awssdk.services.kms.model.DisableKeyRotationResponse;
import software.amazon.awssdk.services.kms.model.DisabledException;
import software.amazon.awssdk.services.kms.model.DisconnectCustomKeyStoreRequest;
import software.amazon.awssdk.services.kms.model.DisconnectCustomKeyStoreResponse;
import software.amazon.awssdk.services.kms.model.DryRunOperationException;
import software.amazon.awssdk.services.kms.model.EnableKeyRequest;
import software.amazon.awssdk.services.kms.model.EnableKeyResponse;
import software.amazon.awssdk.services.kms.model.EnableKeyRotationRequest;
import software.amazon.awssdk.services.kms.model.EnableKeyRotationResponse;
import software.amazon.awssdk.services.kms.model.EncryptRequest;
import software.amazon.awssdk.services.kms.model.EncryptResponse;
import software.amazon.awssdk.services.kms.model.ExpiredImportTokenException;
import software.amazon.awssdk.services.kms.model.GenerateDataKeyPairRequest;
import software.amazon.awssdk.services.kms.model.GenerateDataKeyPairResponse;
import software.amazon.awssdk.services.kms.model.GenerateDataKeyPairWithoutPlaintextRequest;
import software.amazon.awssdk.services.kms.model.GenerateDataKeyPairWithoutPlaintextResponse;
import software.amazon.awssdk.services.kms.model.GenerateDataKeyRequest;
import software.amazon.awssdk.services.kms.model.GenerateDataKeyResponse;
import software.amazon.awssdk.services.kms.model.GenerateDataKeyWithoutPlaintextRequest;
import software.amazon.awssdk.services.kms.model.GenerateDataKeyWithoutPlaintextResponse;
import software.amazon.awssdk.services.kms.model.GenerateMacRequest;
import software.amazon.awssdk.services.kms.model.GenerateMacResponse;
import software.amazon.awssdk.services.kms.model.GenerateRandomRequest;
import software.amazon.awssdk.services.kms.model.GenerateRandomResponse;
import software.amazon.awssdk.services.kms.model.GetKeyPolicyRequest;
import software.amazon.awssdk.services.kms.model.GetKeyPolicyResponse;
import software.amazon.awssdk.services.kms.model.GetKeyRotationStatusRequest;
import software.amazon.awssdk.services.kms.model.GetKeyRotationStatusResponse;
import software.amazon.awssdk.services.kms.model.GetParametersForImportRequest;
import software.amazon.awssdk.services.kms.model.GetParametersForImportResponse;
import software.amazon.awssdk.services.kms.model.GetPublicKeyRequest;
import software.amazon.awssdk.services.kms.model.GetPublicKeyResponse;
import software.amazon.awssdk.services.kms.model.ImportKeyMaterialRequest;
import software.amazon.awssdk.services.kms.model.ImportKeyMaterialResponse;
import software.amazon.awssdk.services.kms.model.IncorrectKeyException;
import software.amazon.awssdk.services.kms.model.IncorrectKeyMaterialException;
import software.amazon.awssdk.services.kms.model.IncorrectTrustAnchorException;
import software.amazon.awssdk.services.kms.model.InvalidAliasNameException;
import software.amazon.awssdk.services.kms.model.InvalidArnException;
import software.amazon.awssdk.services.kms.model.InvalidCiphertextException;
import software.amazon.awssdk.services.kms.model.InvalidGrantIdException;
import software.amazon.awssdk.services.kms.model.InvalidGrantTokenException;
import software.amazon.awssdk.services.kms.model.InvalidImportTokenException;
import software.amazon.awssdk.services.kms.model.InvalidKeyUsageException;
import software.amazon.awssdk.services.kms.model.InvalidMarkerException;
import software.amazon.awssdk.services.kms.model.KeyUnavailableException;
import software.amazon.awssdk.services.kms.model.KmsException;
import software.amazon.awssdk.services.kms.model.KmsInternalException;
import software.amazon.awssdk.services.kms.model.KmsInvalidMacException;
import software.amazon.awssdk.services.kms.model.KmsInvalidSignatureException;
import software.amazon.awssdk.services.kms.model.KmsInvalidStateException;
import software.amazon.awssdk.services.kms.model.LimitExceededException;
import software.amazon.awssdk.services.kms.model.ListAliasesRequest;
import software.amazon.awssdk.services.kms.model.ListAliasesResponse;
import software.amazon.awssdk.services.kms.model.ListGrantsRequest;
import software.amazon.awssdk.services.kms.model.ListGrantsResponse;
import software.amazon.awssdk.services.kms.model.ListKeyPoliciesRequest;
import software.amazon.awssdk.services.kms.model.ListKeyPoliciesResponse;
import software.amazon.awssdk.services.kms.model.ListKeyRotationsRequest;
import software.amazon.awssdk.services.kms.model.ListKeyRotationsResponse;
import software.amazon.awssdk.services.kms.model.ListKeysRequest;
import software.amazon.awssdk.services.kms.model.ListKeysResponse;
import software.amazon.awssdk.services.kms.model.ListResourceTagsRequest;
import software.amazon.awssdk.services.kms.model.ListResourceTagsResponse;
import software.amazon.awssdk.services.kms.model.ListRetirableGrantsRequest;
import software.amazon.awssdk.services.kms.model.ListRetirableGrantsResponse;
import software.amazon.awssdk.services.kms.model.MalformedPolicyDocumentException;
import software.amazon.awssdk.services.kms.model.NotFoundException;
import software.amazon.awssdk.services.kms.model.PutKeyPolicyRequest;
import software.amazon.awssdk.services.kms.model.PutKeyPolicyResponse;
import software.amazon.awssdk.services.kms.model.ReEncryptRequest;
import software.amazon.awssdk.services.kms.model.ReEncryptResponse;
import software.amazon.awssdk.services.kms.model.ReplicateKeyRequest;
import software.amazon.awssdk.services.kms.model.ReplicateKeyResponse;
import software.amazon.awssdk.services.kms.model.RetireGrantRequest;
import software.amazon.awssdk.services.kms.model.RetireGrantResponse;
import software.amazon.awssdk.services.kms.model.RevokeGrantRequest;
import software.amazon.awssdk.services.kms.model.RevokeGrantResponse;
import software.amazon.awssdk.services.kms.model.RotateKeyOnDemandRequest;
import software.amazon.awssdk.services.kms.model.RotateKeyOnDemandResponse;
import software.amazon.awssdk.services.kms.model.ScheduleKeyDeletionRequest;
import software.amazon.awssdk.services.kms.model.ScheduleKeyDeletionResponse;
import software.amazon.awssdk.services.kms.model.SignRequest;
import software.amazon.awssdk.services.kms.model.SignResponse;
import software.amazon.awssdk.services.kms.model.TagException;
import software.amazon.awssdk.services.kms.model.TagResourceRequest;
import software.amazon.awssdk.services.kms.model.TagResourceResponse;
import software.amazon.awssdk.services.kms.model.UnsupportedOperationException;
import software.amazon.awssdk.services.kms.model.UntagResourceRequest;
import software.amazon.awssdk.services.kms.model.UntagResourceResponse;
import software.amazon.awssdk.services.kms.model.UpdateAliasRequest;
import software.amazon.awssdk.services.kms.model.UpdateAliasResponse;
import software.amazon.awssdk.services.kms.model.UpdateCustomKeyStoreRequest;
import software.amazon.awssdk.services.kms.model.UpdateCustomKeyStoreResponse;
import software.amazon.awssdk.services.kms.model.UpdateKeyDescriptionRequest;
import software.amazon.awssdk.services.kms.model.UpdateKeyDescriptionResponse;
import software.amazon.awssdk.services.kms.model.UpdatePrimaryRegionRequest;
import software.amazon.awssdk.services.kms.model.UpdatePrimaryRegionResponse;
import software.amazon.awssdk.services.kms.model.VerifyMacRequest;
import software.amazon.awssdk.services.kms.model.VerifyMacResponse;
import software.amazon.awssdk.services.kms.model.VerifyRequest;
import software.amazon.awssdk.services.kms.model.VerifyResponse;
import software.amazon.awssdk.services.kms.model.XksKeyAlreadyInUseException;
import software.amazon.awssdk.services.kms.model.XksKeyInvalidConfigurationException;
import software.amazon.awssdk.services.kms.model.XksKeyNotFoundException;
import software.amazon.awssdk.services.kms.model.XksProxyIncorrectAuthenticationCredentialException;
import software.amazon.awssdk.services.kms.model.XksProxyInvalidConfigurationException;
import software.amazon.awssdk.services.kms.model.XksProxyInvalidResponseException;
import software.amazon.awssdk.services.kms.model.XksProxyUriEndpointInUseException;
import software.amazon.awssdk.services.kms.model.XksProxyUriInUseException;
import software.amazon.awssdk.services.kms.model.XksProxyUriUnreachableException;
import software.amazon.awssdk.services.kms.model.XksProxyVpcEndpointServiceInUseException;
import software.amazon.awssdk.services.kms.model.XksProxyVpcEndpointServiceInvalidConfigurationException;
import software.amazon.awssdk.services.kms.model.XksProxyVpcEndpointServiceNotFoundException;
import software.amazon.awssdk.services.kms.transform.CancelKeyDeletionRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ConnectCustomKeyStoreRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.CreateAliasRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.CreateCustomKeyStoreRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.CreateGrantRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.CreateKeyRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.DecryptRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.DeleteAliasRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.DeleteCustomKeyStoreRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.DeleteImportedKeyMaterialRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.DeriveSharedSecretRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.DescribeCustomKeyStoresRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.DescribeKeyRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.DisableKeyRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.DisableKeyRotationRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.DisconnectCustomKeyStoreRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.EnableKeyRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.EnableKeyRotationRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.EncryptRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.GenerateDataKeyPairRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.GenerateDataKeyPairWithoutPlaintextRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.GenerateDataKeyRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.GenerateDataKeyWithoutPlaintextRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.GenerateMacRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.GenerateRandomRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.GetKeyPolicyRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.GetKeyRotationStatusRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.GetParametersForImportRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.GetPublicKeyRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ImportKeyMaterialRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ListAliasesRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ListGrantsRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ListKeyPoliciesRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ListKeyRotationsRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ListKeysRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ListResourceTagsRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ListRetirableGrantsRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.PutKeyPolicyRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ReEncryptRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ReplicateKeyRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.RetireGrantRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.RevokeGrantRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.RotateKeyOnDemandRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ScheduleKeyDeletionRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.SignRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.UpdateAliasRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.UpdateCustomKeyStoreRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.UpdateKeyDescriptionRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.UpdatePrimaryRegionRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.VerifyMacRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.VerifyRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultKmsClient
implements KmsClient {
    private static final Logger log = Logger.loggerFor(DefaultKmsClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultKmsClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"KMS#2.31.77").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelKeyDeletionResponse cancelKeyDeletion(CancelKeyDeletionRequest cancelKeyDeletionRequest) throws NotFoundException, InvalidArnException, DependencyTimeoutException, KmsInternalException, KmsInvalidStateException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelKeyDeletionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)cancelKeyDeletionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, cancelKeyDeletionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelKeyDeletion");
            CancelKeyDeletionResponse cancelKeyDeletionResponse = (CancelKeyDeletionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelKeyDeletion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)cancelKeyDeletionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelKeyDeletionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelKeyDeletionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$cancelKeyDeletion$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectCustomKeyStoreResponse connectCustomKeyStore(ConnectCustomKeyStoreRequest connectCustomKeyStoreRequest) throws CloudHsmClusterNotActiveException, CustomKeyStoreInvalidStateException, CustomKeyStoreNotFoundException, KmsInternalException, CloudHsmClusterInvalidConfigurationException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ConnectCustomKeyStoreResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)connectCustomKeyStoreRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, connectCustomKeyStoreRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ConnectCustomKeyStore");
            ConnectCustomKeyStoreResponse connectCustomKeyStoreResponse = (ConnectCustomKeyStoreResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ConnectCustomKeyStore").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)connectCustomKeyStoreRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ConnectCustomKeyStoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return connectCustomKeyStoreResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$connectCustomKeyStore$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAliasResponse createAlias(CreateAliasRequest createAliasRequest) throws DependencyTimeoutException, AlreadyExistsException, NotFoundException, InvalidAliasNameException, KmsInternalException, LimitExceededException, KmsInvalidStateException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAliasResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createAliasRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, createAliasRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAlias");
            CreateAliasResponse createAliasResponse = (CreateAliasResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAlias").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createAliasRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateAliasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAliasResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$createAlias$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateCustomKeyStoreResponse createCustomKeyStore(CreateCustomKeyStoreRequest createCustomKeyStoreRequest) throws CloudHsmClusterInUseException, CustomKeyStoreNameInUseException, CloudHsmClusterNotFoundException, KmsInternalException, CloudHsmClusterNotActiveException, IncorrectTrustAnchorException, CloudHsmClusterInvalidConfigurationException, LimitExceededException, XksProxyUriInUseException, XksProxyUriEndpointInUseException, XksProxyUriUnreachableException, XksProxyIncorrectAuthenticationCredentialException, XksProxyVpcEndpointServiceInUseException, XksProxyVpcEndpointServiceNotFoundException, XksProxyVpcEndpointServiceInvalidConfigurationException, XksProxyInvalidResponseException, XksProxyInvalidConfigurationException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCustomKeyStoreResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createCustomKeyStoreRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, createCustomKeyStoreRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCustomKeyStore");
            CreateCustomKeyStoreResponse createCustomKeyStoreResponse = (CreateCustomKeyStoreResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCustomKeyStore").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createCustomKeyStoreRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateCustomKeyStoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createCustomKeyStoreResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$createCustomKeyStore$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateGrantResponse createGrant(CreateGrantRequest createGrantRequest) throws NotFoundException, DisabledException, DependencyTimeoutException, InvalidArnException, KmsInternalException, InvalidGrantTokenException, LimitExceededException, KmsInvalidStateException, DryRunOperationException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateGrantResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createGrantRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, createGrantRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateGrant");
            CreateGrantResponse createGrantResponse = (CreateGrantResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateGrant").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createGrantRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateGrantRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createGrantResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$createGrant$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateKeyResponse createKey(CreateKeyRequest createKeyRequest) throws MalformedPolicyDocumentException, DependencyTimeoutException, InvalidArnException, UnsupportedOperationException, KmsInternalException, LimitExceededException, TagException, CustomKeyStoreNotFoundException, CustomKeyStoreInvalidStateException, CloudHsmClusterInvalidConfigurationException, XksKeyInvalidConfigurationException, XksKeyAlreadyInUseException, XksKeyNotFoundException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateKeyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createKeyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, createKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateKey");
            CreateKeyResponse createKeyResponse = (CreateKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateKey").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createKeyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createKeyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$createKey$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DecryptResponse decrypt(DecryptRequest decryptRequest) throws NotFoundException, DisabledException, InvalidCiphertextException, KeyUnavailableException, IncorrectKeyException, InvalidKeyUsageException, DependencyTimeoutException, InvalidGrantTokenException, KmsInternalException, KmsInvalidStateException, DryRunOperationException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DecryptResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)decryptRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, decryptRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"Decrypt");
            DecryptResponse decryptResponse = (DecryptResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("Decrypt").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)decryptRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DecryptRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return decryptResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$decrypt$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAliasResponse deleteAlias(DeleteAliasRequest deleteAliasRequest) throws DependencyTimeoutException, NotFoundException, KmsInternalException, KmsInvalidStateException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAliasResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAliasRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, deleteAliasRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAlias");
            DeleteAliasResponse deleteAliasResponse = (DeleteAliasResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAlias").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteAliasRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAliasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAliasResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$deleteAlias$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteCustomKeyStoreResponse deleteCustomKeyStore(DeleteCustomKeyStoreRequest deleteCustomKeyStoreRequest) throws CustomKeyStoreHasCmKsException, CustomKeyStoreInvalidStateException, CustomKeyStoreNotFoundException, KmsInternalException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCustomKeyStoreResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteCustomKeyStoreRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, deleteCustomKeyStoreRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCustomKeyStore");
            DeleteCustomKeyStoreResponse deleteCustomKeyStoreResponse = (DeleteCustomKeyStoreResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCustomKeyStore").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteCustomKeyStoreRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteCustomKeyStoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteCustomKeyStoreResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$deleteCustomKeyStore$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteImportedKeyMaterialResponse deleteImportedKeyMaterial(DeleteImportedKeyMaterialRequest deleteImportedKeyMaterialRequest) throws InvalidArnException, UnsupportedOperationException, DependencyTimeoutException, NotFoundException, KmsInternalException, KmsInvalidStateException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteImportedKeyMaterialResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteImportedKeyMaterialRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, deleteImportedKeyMaterialRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteImportedKeyMaterial");
            DeleteImportedKeyMaterialResponse deleteImportedKeyMaterialResponse = (DeleteImportedKeyMaterialResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteImportedKeyMaterial").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteImportedKeyMaterialRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteImportedKeyMaterialRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteImportedKeyMaterialResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$deleteImportedKeyMaterial$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeriveSharedSecretResponse deriveSharedSecret(DeriveSharedSecretRequest deriveSharedSecretRequest) throws NotFoundException, DisabledException, KeyUnavailableException, DependencyTimeoutException, InvalidGrantTokenException, InvalidKeyUsageException, KmsInternalException, KmsInvalidStateException, DryRunOperationException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeriveSharedSecretResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deriveSharedSecretRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, deriveSharedSecretRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeriveSharedSecret");
            DeriveSharedSecretResponse deriveSharedSecretResponse = (DeriveSharedSecretResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeriveSharedSecret").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deriveSharedSecretRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeriveSharedSecretRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deriveSharedSecretResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$deriveSharedSecret$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeCustomKeyStoresResponse describeCustomKeyStores(DescribeCustomKeyStoresRequest describeCustomKeyStoresRequest) throws CustomKeyStoreNotFoundException, InvalidMarkerException, KmsInternalException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCustomKeyStoresResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeCustomKeyStoresRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, describeCustomKeyStoresRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCustomKeyStores");
            DescribeCustomKeyStoresResponse describeCustomKeyStoresResponse = (DescribeCustomKeyStoresResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCustomKeyStores").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeCustomKeyStoresRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeCustomKeyStoresRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeCustomKeyStoresResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$describeCustomKeyStores$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeKeyResponse describeKey(DescribeKeyRequest describeKeyRequest) throws NotFoundException, InvalidArnException, DependencyTimeoutException, KmsInternalException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeKeyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeKeyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, describeKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeKey");
            DescribeKeyResponse describeKeyResponse = (DescribeKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeKey").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeKeyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeKeyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$describeKey$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableKeyResponse disableKey(DisableKeyRequest disableKeyRequest) throws NotFoundException, InvalidArnException, DependencyTimeoutException, KmsInternalException, KmsInvalidStateException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableKeyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disableKeyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, disableKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableKey");
            DisableKeyResponse disableKeyResponse = (DisableKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableKey").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)disableKeyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisableKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disableKeyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$disableKey$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableKeyRotationResponse disableKeyRotation(DisableKeyRotationRequest disableKeyRotationRequest) throws NotFoundException, DisabledException, InvalidArnException, DependencyTimeoutException, KmsInternalException, KmsInvalidStateException, UnsupportedOperationException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableKeyRotationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disableKeyRotationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, disableKeyRotationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableKeyRotation");
            DisableKeyRotationResponse disableKeyRotationResponse = (DisableKeyRotationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableKeyRotation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)disableKeyRotationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisableKeyRotationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disableKeyRotationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$disableKeyRotation$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisconnectCustomKeyStoreResponse disconnectCustomKeyStore(DisconnectCustomKeyStoreRequest disconnectCustomKeyStoreRequest) throws CustomKeyStoreInvalidStateException, CustomKeyStoreNotFoundException, KmsInternalException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisconnectCustomKeyStoreResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disconnectCustomKeyStoreRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, disconnectCustomKeyStoreRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisconnectCustomKeyStore");
            DisconnectCustomKeyStoreResponse disconnectCustomKeyStoreResponse = (DisconnectCustomKeyStoreResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisconnectCustomKeyStore").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)disconnectCustomKeyStoreRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisconnectCustomKeyStoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disconnectCustomKeyStoreResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$disconnectCustomKeyStore$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableKeyResponse enableKey(EnableKeyRequest enableKeyRequest) throws NotFoundException, InvalidArnException, DependencyTimeoutException, KmsInternalException, LimitExceededException, KmsInvalidStateException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableKeyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)enableKeyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, enableKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableKey");
            EnableKeyResponse enableKeyResponse = (EnableKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableKey").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)enableKeyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new EnableKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return enableKeyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$enableKey$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableKeyRotationResponse enableKeyRotation(EnableKeyRotationRequest enableKeyRotationRequest) throws NotFoundException, DisabledException, InvalidArnException, DependencyTimeoutException, KmsInternalException, KmsInvalidStateException, UnsupportedOperationException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableKeyRotationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)enableKeyRotationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, enableKeyRotationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableKeyRotation");
            EnableKeyRotationResponse enableKeyRotationResponse = (EnableKeyRotationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableKeyRotation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)enableKeyRotationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new EnableKeyRotationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return enableKeyRotationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$enableKeyRotation$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EncryptResponse encrypt(EncryptRequest encryptRequest) throws NotFoundException, DisabledException, KeyUnavailableException, DependencyTimeoutException, InvalidKeyUsageException, InvalidGrantTokenException, KmsInternalException, KmsInvalidStateException, DryRunOperationException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EncryptResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)encryptRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, encryptRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"Encrypt");
            EncryptResponse encryptResponse = (EncryptResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("Encrypt").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)encryptRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new EncryptRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return encryptResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$encrypt$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenerateDataKeyResponse generateDataKey(GenerateDataKeyRequest generateDataKeyRequest) throws NotFoundException, DisabledException, KeyUnavailableException, DependencyTimeoutException, InvalidKeyUsageException, InvalidGrantTokenException, KmsInternalException, KmsInvalidStateException, DryRunOperationException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GenerateDataKeyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)generateDataKeyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, generateDataKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GenerateDataKey");
            GenerateDataKeyResponse generateDataKeyResponse = (GenerateDataKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GenerateDataKey").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)generateDataKeyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GenerateDataKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return generateDataKeyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$generateDataKey$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenerateDataKeyPairResponse generateDataKeyPair(GenerateDataKeyPairRequest generateDataKeyPairRequest) throws NotFoundException, DisabledException, KeyUnavailableException, DependencyTimeoutException, InvalidKeyUsageException, InvalidGrantTokenException, KmsInternalException, KmsInvalidStateException, UnsupportedOperationException, DryRunOperationException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GenerateDataKeyPairResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)generateDataKeyPairRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, generateDataKeyPairRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GenerateDataKeyPair");
            GenerateDataKeyPairResponse generateDataKeyPairResponse = (GenerateDataKeyPairResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GenerateDataKeyPair").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)generateDataKeyPairRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GenerateDataKeyPairRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return generateDataKeyPairResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$generateDataKeyPair$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenerateDataKeyPairWithoutPlaintextResponse generateDataKeyPairWithoutPlaintext(GenerateDataKeyPairWithoutPlaintextRequest generateDataKeyPairWithoutPlaintextRequest) throws NotFoundException, DisabledException, KeyUnavailableException, DependencyTimeoutException, InvalidKeyUsageException, InvalidGrantTokenException, KmsInternalException, KmsInvalidStateException, UnsupportedOperationException, DryRunOperationException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GenerateDataKeyPairWithoutPlaintextResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)generateDataKeyPairWithoutPlaintextRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, generateDataKeyPairWithoutPlaintextRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GenerateDataKeyPairWithoutPlaintext");
            GenerateDataKeyPairWithoutPlaintextResponse generateDataKeyPairWithoutPlaintextResponse = (GenerateDataKeyPairWithoutPlaintextResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GenerateDataKeyPairWithoutPlaintext").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)generateDataKeyPairWithoutPlaintextRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GenerateDataKeyPairWithoutPlaintextRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return generateDataKeyPairWithoutPlaintextResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$generateDataKeyPairWithoutPlaintext$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenerateDataKeyWithoutPlaintextResponse generateDataKeyWithoutPlaintext(GenerateDataKeyWithoutPlaintextRequest generateDataKeyWithoutPlaintextRequest) throws NotFoundException, DisabledException, KeyUnavailableException, DependencyTimeoutException, InvalidKeyUsageException, InvalidGrantTokenException, KmsInternalException, KmsInvalidStateException, DryRunOperationException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GenerateDataKeyWithoutPlaintextResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)generateDataKeyWithoutPlaintextRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, generateDataKeyWithoutPlaintextRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GenerateDataKeyWithoutPlaintext");
            GenerateDataKeyWithoutPlaintextResponse generateDataKeyWithoutPlaintextResponse = (GenerateDataKeyWithoutPlaintextResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GenerateDataKeyWithoutPlaintext").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)generateDataKeyWithoutPlaintextRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GenerateDataKeyWithoutPlaintextRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return generateDataKeyWithoutPlaintextResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$generateDataKeyWithoutPlaintext$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenerateMacResponse generateMac(GenerateMacRequest generateMacRequest) throws NotFoundException, DisabledException, KeyUnavailableException, InvalidKeyUsageException, InvalidGrantTokenException, KmsInternalException, KmsInvalidStateException, DryRunOperationException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GenerateMacResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)generateMacRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, generateMacRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GenerateMac");
            GenerateMacResponse generateMacResponse = (GenerateMacResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GenerateMac").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)generateMacRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GenerateMacRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return generateMacResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$generateMac$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenerateRandomResponse generateRandom(GenerateRandomRequest generateRandomRequest) throws DependencyTimeoutException, KmsInternalException, UnsupportedOperationException, CustomKeyStoreNotFoundException, CustomKeyStoreInvalidStateException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GenerateRandomResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)generateRandomRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, generateRandomRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GenerateRandom");
            GenerateRandomResponse generateRandomResponse = (GenerateRandomResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GenerateRandom").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)generateRandomRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GenerateRandomRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return generateRandomResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$generateRandom$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetKeyPolicyResponse getKeyPolicy(GetKeyPolicyRequest getKeyPolicyRequest) throws NotFoundException, InvalidArnException, DependencyTimeoutException, KmsInternalException, KmsInvalidStateException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetKeyPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getKeyPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, getKeyPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetKeyPolicy");
            GetKeyPolicyResponse getKeyPolicyResponse = (GetKeyPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetKeyPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getKeyPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetKeyPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getKeyPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$getKeyPolicy$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetKeyRotationStatusResponse getKeyRotationStatus(GetKeyRotationStatusRequest getKeyRotationStatusRequest) throws NotFoundException, InvalidArnException, DependencyTimeoutException, KmsInternalException, KmsInvalidStateException, UnsupportedOperationException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetKeyRotationStatusResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getKeyRotationStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, getKeyRotationStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetKeyRotationStatus");
            GetKeyRotationStatusResponse getKeyRotationStatusResponse = (GetKeyRotationStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetKeyRotationStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getKeyRotationStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetKeyRotationStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getKeyRotationStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$getKeyRotationStatus$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetParametersForImportResponse getParametersForImport(GetParametersForImportRequest getParametersForImportRequest) throws InvalidArnException, UnsupportedOperationException, DependencyTimeoutException, NotFoundException, KmsInternalException, KmsInvalidStateException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetParametersForImportResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getParametersForImportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, getParametersForImportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetParametersForImport");
            GetParametersForImportResponse getParametersForImportResponse = (GetParametersForImportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetParametersForImport").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getParametersForImportRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetParametersForImportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getParametersForImportResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$getParametersForImport$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPublicKeyResponse getPublicKey(GetPublicKeyRequest getPublicKeyRequest) throws NotFoundException, DisabledException, KeyUnavailableException, DependencyTimeoutException, UnsupportedOperationException, InvalidArnException, InvalidGrantTokenException, InvalidKeyUsageException, KmsInternalException, KmsInvalidStateException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPublicKeyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getPublicKeyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, getPublicKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPublicKey");
            GetPublicKeyResponse getPublicKeyResponse = (GetPublicKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPublicKey").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getPublicKeyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetPublicKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getPublicKeyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$getPublicKey$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImportKeyMaterialResponse importKeyMaterial(ImportKeyMaterialRequest importKeyMaterialRequest) throws InvalidArnException, UnsupportedOperationException, DependencyTimeoutException, NotFoundException, KmsInternalException, KmsInvalidStateException, InvalidCiphertextException, IncorrectKeyMaterialException, ExpiredImportTokenException, InvalidImportTokenException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ImportKeyMaterialResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)importKeyMaterialRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, importKeyMaterialRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ImportKeyMaterial");
            ImportKeyMaterialResponse importKeyMaterialResponse = (ImportKeyMaterialResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ImportKeyMaterial").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)importKeyMaterialRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ImportKeyMaterialRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return importKeyMaterialResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$importKeyMaterial$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAliasesResponse listAliases(ListAliasesRequest listAliasesRequest) throws DependencyTimeoutException, InvalidMarkerException, KmsInternalException, InvalidArnException, NotFoundException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAliasesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAliasesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, listAliasesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAliases");
            ListAliasesResponse listAliasesResponse = (ListAliasesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAliases").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listAliasesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAliasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAliasesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$listAliases$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListGrantsResponse listGrants(ListGrantsRequest listGrantsRequest) throws NotFoundException, DependencyTimeoutException, InvalidMarkerException, InvalidGrantIdException, InvalidArnException, KmsInternalException, KmsInvalidStateException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListGrantsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listGrantsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, listGrantsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListGrants");
            ListGrantsResponse listGrantsResponse = (ListGrantsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListGrants").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listGrantsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListGrantsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listGrantsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$listGrants$63((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListKeyPoliciesResponse listKeyPolicies(ListKeyPoliciesRequest listKeyPoliciesRequest) throws NotFoundException, InvalidArnException, DependencyTimeoutException, KmsInternalException, KmsInvalidStateException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListKeyPoliciesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listKeyPoliciesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, listKeyPoliciesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListKeyPolicies");
            ListKeyPoliciesResponse listKeyPoliciesResponse = (ListKeyPoliciesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListKeyPolicies").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listKeyPoliciesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListKeyPoliciesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listKeyPoliciesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$listKeyPolicies$65((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListKeyRotationsResponse listKeyRotations(ListKeyRotationsRequest listKeyRotationsRequest) throws NotFoundException, InvalidArnException, InvalidMarkerException, KmsInternalException, KmsInvalidStateException, UnsupportedOperationException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListKeyRotationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listKeyRotationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, listKeyRotationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListKeyRotations");
            ListKeyRotationsResponse listKeyRotationsResponse = (ListKeyRotationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListKeyRotations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listKeyRotationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListKeyRotationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listKeyRotationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$listKeyRotations$67((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListKeysResponse listKeys(ListKeysRequest listKeysRequest) throws DependencyTimeoutException, KmsInternalException, InvalidMarkerException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListKeysResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listKeysRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, listKeysRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListKeys");
            ListKeysResponse listKeysResponse = (ListKeysResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListKeys").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listKeysRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListKeysRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listKeysResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$listKeys$69((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListResourceTagsResponse listResourceTags(ListResourceTagsRequest listResourceTagsRequest) throws KmsInternalException, NotFoundException, InvalidArnException, InvalidMarkerException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListResourceTagsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listResourceTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, listResourceTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListResourceTags");
            ListResourceTagsResponse listResourceTagsResponse = (ListResourceTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListResourceTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listResourceTagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListResourceTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listResourceTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$listResourceTags$71((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRetirableGrantsResponse listRetirableGrants(ListRetirableGrantsRequest listRetirableGrantsRequest) throws DependencyTimeoutException, InvalidMarkerException, InvalidArnException, NotFoundException, KmsInternalException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRetirableGrantsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listRetirableGrantsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, listRetirableGrantsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRetirableGrants");
            ListRetirableGrantsResponse listRetirableGrantsResponse = (ListRetirableGrantsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRetirableGrants").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listRetirableGrantsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListRetirableGrantsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listRetirableGrantsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$listRetirableGrants$73((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutKeyPolicyResponse putKeyPolicy(PutKeyPolicyRequest putKeyPolicyRequest) throws NotFoundException, InvalidArnException, MalformedPolicyDocumentException, DependencyTimeoutException, UnsupportedOperationException, KmsInternalException, LimitExceededException, KmsInvalidStateException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutKeyPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putKeyPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, putKeyPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutKeyPolicy");
            PutKeyPolicyResponse putKeyPolicyResponse = (PutKeyPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutKeyPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putKeyPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutKeyPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putKeyPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$putKeyPolicy$75((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReEncryptResponse reEncrypt(ReEncryptRequest reEncryptRequest) throws NotFoundException, DisabledException, InvalidCiphertextException, KeyUnavailableException, IncorrectKeyException, DependencyTimeoutException, InvalidKeyUsageException, InvalidGrantTokenException, KmsInternalException, KmsInvalidStateException, DryRunOperationException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ReEncryptResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)reEncryptRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, reEncryptRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ReEncrypt");
            ReEncryptResponse reEncryptResponse = (ReEncryptResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ReEncrypt").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)reEncryptRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ReEncryptRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return reEncryptResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$reEncrypt$77((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReplicateKeyResponse replicateKey(ReplicateKeyRequest replicateKeyRequest) throws AlreadyExistsException, DisabledException, InvalidArnException, KmsInvalidStateException, KmsInternalException, LimitExceededException, MalformedPolicyDocumentException, NotFoundException, TagException, UnsupportedOperationException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ReplicateKeyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)replicateKeyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, replicateKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ReplicateKey");
            ReplicateKeyResponse replicateKeyResponse = (ReplicateKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ReplicateKey").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)replicateKeyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ReplicateKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return replicateKeyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$replicateKey$79((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RetireGrantResponse retireGrant(RetireGrantRequest retireGrantRequest) throws InvalidArnException, InvalidGrantTokenException, InvalidGrantIdException, NotFoundException, DependencyTimeoutException, KmsInternalException, KmsInvalidStateException, DryRunOperationException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RetireGrantResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)retireGrantRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, retireGrantRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RetireGrant");
            RetireGrantResponse retireGrantResponse = (RetireGrantResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RetireGrant").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)retireGrantRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RetireGrantRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return retireGrantResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$retireGrant$81((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RevokeGrantResponse revokeGrant(RevokeGrantRequest revokeGrantRequest) throws NotFoundException, DependencyTimeoutException, InvalidArnException, InvalidGrantIdException, KmsInternalException, KmsInvalidStateException, DryRunOperationException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RevokeGrantResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)revokeGrantRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, revokeGrantRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RevokeGrant");
            RevokeGrantResponse revokeGrantResponse = (RevokeGrantResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RevokeGrant").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)revokeGrantRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RevokeGrantRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return revokeGrantResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$revokeGrant$83((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RotateKeyOnDemandResponse rotateKeyOnDemand(RotateKeyOnDemandRequest rotateKeyOnDemandRequest) throws NotFoundException, DisabledException, InvalidArnException, DependencyTimeoutException, KmsInternalException, KmsInvalidStateException, UnsupportedOperationException, LimitExceededException, ConflictException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RotateKeyOnDemandResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)rotateKeyOnDemandRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, rotateKeyOnDemandRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RotateKeyOnDemand");
            RotateKeyOnDemandResponse rotateKeyOnDemandResponse = (RotateKeyOnDemandResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RotateKeyOnDemand").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)rotateKeyOnDemandRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RotateKeyOnDemandRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return rotateKeyOnDemandResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$rotateKeyOnDemand$85((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScheduleKeyDeletionResponse scheduleKeyDeletion(ScheduleKeyDeletionRequest scheduleKeyDeletionRequest) throws NotFoundException, InvalidArnException, DependencyTimeoutException, KmsInternalException, KmsInvalidStateException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ScheduleKeyDeletionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)scheduleKeyDeletionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, scheduleKeyDeletionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ScheduleKeyDeletion");
            ScheduleKeyDeletionResponse scheduleKeyDeletionResponse = (ScheduleKeyDeletionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ScheduleKeyDeletion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)scheduleKeyDeletionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ScheduleKeyDeletionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return scheduleKeyDeletionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$scheduleKeyDeletion$87((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SignResponse sign(SignRequest signRequest) throws NotFoundException, DisabledException, KeyUnavailableException, DependencyTimeoutException, InvalidKeyUsageException, InvalidGrantTokenException, KmsInternalException, KmsInvalidStateException, DryRunOperationException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SignResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)signRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, signRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"Sign");
            SignResponse signResponse = (SignResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("Sign").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)signRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SignRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return signResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$sign$89((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws KmsInternalException, NotFoundException, InvalidArnException, KmsInvalidStateException, LimitExceededException, TagException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$tagResource$91((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws KmsInternalException, NotFoundException, InvalidArnException, KmsInvalidStateException, TagException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$untagResource$93((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAliasResponse updateAlias(UpdateAliasRequest updateAliasRequest) throws DependencyTimeoutException, NotFoundException, KmsInternalException, LimitExceededException, KmsInvalidStateException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAliasResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateAliasRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, updateAliasRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAlias");
            UpdateAliasResponse updateAliasResponse = (UpdateAliasResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAlias").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateAliasRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateAliasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateAliasResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$updateAlias$95((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateCustomKeyStoreResponse updateCustomKeyStore(UpdateCustomKeyStoreRequest updateCustomKeyStoreRequest) throws CustomKeyStoreNotFoundException, CustomKeyStoreNameInUseException, CloudHsmClusterNotFoundException, CloudHsmClusterNotRelatedException, CustomKeyStoreInvalidStateException, KmsInternalException, CloudHsmClusterNotActiveException, CloudHsmClusterInvalidConfigurationException, XksProxyUriInUseException, XksProxyUriEndpointInUseException, XksProxyUriUnreachableException, XksProxyIncorrectAuthenticationCredentialException, XksProxyVpcEndpointServiceInUseException, XksProxyVpcEndpointServiceNotFoundException, XksProxyVpcEndpointServiceInvalidConfigurationException, XksProxyInvalidResponseException, XksProxyInvalidConfigurationException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateCustomKeyStoreResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateCustomKeyStoreRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, updateCustomKeyStoreRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCustomKeyStore");
            UpdateCustomKeyStoreResponse updateCustomKeyStoreResponse = (UpdateCustomKeyStoreResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCustomKeyStore").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateCustomKeyStoreRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateCustomKeyStoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateCustomKeyStoreResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$updateCustomKeyStore$97((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateKeyDescriptionResponse updateKeyDescription(UpdateKeyDescriptionRequest updateKeyDescriptionRequest) throws NotFoundException, InvalidArnException, DependencyTimeoutException, KmsInternalException, KmsInvalidStateException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateKeyDescriptionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateKeyDescriptionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, updateKeyDescriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateKeyDescription");
            UpdateKeyDescriptionResponse updateKeyDescriptionResponse = (UpdateKeyDescriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateKeyDescription").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateKeyDescriptionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateKeyDescriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateKeyDescriptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$updateKeyDescription$99((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdatePrimaryRegionResponse updatePrimaryRegion(UpdatePrimaryRegionRequest updatePrimaryRegionRequest) throws DisabledException, InvalidArnException, KmsInvalidStateException, KmsInternalException, NotFoundException, UnsupportedOperationException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePrimaryRegionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updatePrimaryRegionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, updatePrimaryRegionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdatePrimaryRegion");
            UpdatePrimaryRegionResponse updatePrimaryRegionResponse = (UpdatePrimaryRegionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePrimaryRegion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updatePrimaryRegionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdatePrimaryRegionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updatePrimaryRegionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$updatePrimaryRegion$101((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VerifyResponse verify(VerifyRequest verifyRequest) throws NotFoundException, DisabledException, KeyUnavailableException, DependencyTimeoutException, InvalidKeyUsageException, InvalidGrantTokenException, KmsInternalException, KmsInvalidStateException, KmsInvalidSignatureException, DryRunOperationException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, VerifyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)verifyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, verifyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"Verify");
            VerifyResponse verifyResponse = (VerifyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("Verify").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)verifyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new VerifyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return verifyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$verify$103((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VerifyMacResponse verifyMac(VerifyMacRequest verifyMacRequest) throws NotFoundException, DisabledException, KeyUnavailableException, InvalidKeyUsageException, InvalidGrantTokenException, KmsInternalException, KmsInvalidMacException, KmsInvalidStateException, DryRunOperationException, AwsServiceException, SdkClientException, KmsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, VerifyMacResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "XksProxyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                }
                case "ExpiredImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                }
                case "CustomKeyStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                }
                case "MalformedPolicyDocumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                }
                case "XksProxyUriUnreachableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                }
                case "KMSInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "XksProxyUriInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "CustomKeyStoreInvalidStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                }
                case "IncorrectTrustAnchorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                }
                case "KeyUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                }
                case "KMSInternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "XksProxyInvalidResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                }
                case "XksProxyUriEndpointInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                }
                case "InvalidGrantTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                }
                case "XksKeyInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "XksKeyAlreadyInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                }
                case "CloudHsmClusterInvalidConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                }
                case "InvalidMarkerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                }
                case "InvalidAliasNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                }
                case "XksKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                }
                case "DryRunOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                }
                case "CloudHsmClusterNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                }
                case "XksProxyIncorrectAuthenticationCredentialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                }
                case "IncorrectKeyMaterialException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                }
                case "InvalidImportTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                }
                case "CloudHsmClusterNotRelatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                }
                case "DisabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "KMSInvalidSignatureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                }
                case "CloudHsmClusterInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                }
                case "InvalidCiphertextException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidGrantIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                }
                case "CustomKeyStoreHasCMKsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                }
                case "IncorrectKeyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                }
                case "CustomKeyStoreNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                }
                case "KMSInvalidMacException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                }
                case "TagException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                }
                case "InvalidKeyUsageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                }
                case "XksProxyVpcEndpointServiceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                }
                case "XksProxyVpcEndpointServiceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                }
                case "DependencyTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                }
                case "CloudHsmClusterNotActiveException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)verifyMacRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsClient.resolveMetricPublishers(clientConfiguration, verifyMacRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"VerifyMac");
            VerifyMacResponse verifyMacResponse = (VerifyMacResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("VerifyMac").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)verifyMacRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new VerifyMacRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return verifyMacResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKmsClient.lambda$verifyMac$105((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "kms";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        KmsServiceClientConfigurationBuilder serviceConfigBuilder = new KmsServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(KmsException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    @Override
    public final KmsServiceClientConfiguration serviceClientConfiguration() {
        return new KmsServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$verifyMac$105(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$verify$103(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updatePrimaryRegion$101(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateKeyDescription$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateCustomKeyStore$97(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateAlias$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$93(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$sign$89(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$scheduleKeyDeletion$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$rotateKeyOnDemand$85(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$revokeGrant$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$retireGrant$81(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$replicateKey$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$reEncrypt$77(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putKeyPolicy$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRetirableGrants$73(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listResourceTags$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listKeys$69(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listKeyRotations$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listKeyPolicies$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listGrants$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAliases$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$importKeyMaterial$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPublicKey$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getParametersForImport$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getKeyRotationStatus$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getKeyPolicy$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$generateRandom$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$generateMac$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$generateDataKeyWithoutPlaintext$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$generateDataKeyPairWithoutPlaintext$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$generateDataKeyPair$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$generateDataKey$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$encrypt$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$enableKeyRotation$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$enableKey$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disconnectCustomKeyStore$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disableKeyRotation$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disableKey$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeKey$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCustomKeyStores$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deriveSharedSecret$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteImportedKeyMaterial$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCustomKeyStore$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAlias$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$decrypt$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createKey$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createGrant$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCustomKeyStore$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAlias$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$connectCustomKeyStore$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelKeyDeletion$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

