/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.kms.KmsAsyncClient;
import software.amazon.awssdk.services.kms.KmsServiceClientConfiguration;
import software.amazon.awssdk.services.kms.internal.KmsServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.kms.model.AlreadyExistsException;
import software.amazon.awssdk.services.kms.model.CancelKeyDeletionRequest;
import software.amazon.awssdk.services.kms.model.CancelKeyDeletionResponse;
import software.amazon.awssdk.services.kms.model.CloudHsmClusterInUseException;
import software.amazon.awssdk.services.kms.model.CloudHsmClusterInvalidConfigurationException;
import software.amazon.awssdk.services.kms.model.CloudHsmClusterNotActiveException;
import software.amazon.awssdk.services.kms.model.CloudHsmClusterNotFoundException;
import software.amazon.awssdk.services.kms.model.CloudHsmClusterNotRelatedException;
import software.amazon.awssdk.services.kms.model.ConflictException;
import software.amazon.awssdk.services.kms.model.ConnectCustomKeyStoreRequest;
import software.amazon.awssdk.services.kms.model.ConnectCustomKeyStoreResponse;
import software.amazon.awssdk.services.kms.model.CreateAliasRequest;
import software.amazon.awssdk.services.kms.model.CreateAliasResponse;
import software.amazon.awssdk.services.kms.model.CreateCustomKeyStoreRequest;
import software.amazon.awssdk.services.kms.model.CreateCustomKeyStoreResponse;
import software.amazon.awssdk.services.kms.model.CreateGrantRequest;
import software.amazon.awssdk.services.kms.model.CreateGrantResponse;
import software.amazon.awssdk.services.kms.model.CreateKeyRequest;
import software.amazon.awssdk.services.kms.model.CreateKeyResponse;
import software.amazon.awssdk.services.kms.model.CustomKeyStoreHasCmKsException;
import software.amazon.awssdk.services.kms.model.CustomKeyStoreInvalidStateException;
import software.amazon.awssdk.services.kms.model.CustomKeyStoreNameInUseException;
import software.amazon.awssdk.services.kms.model.CustomKeyStoreNotFoundException;
import software.amazon.awssdk.services.kms.model.DecryptRequest;
import software.amazon.awssdk.services.kms.model.DecryptResponse;
import software.amazon.awssdk.services.kms.model.DeleteAliasRequest;
import software.amazon.awssdk.services.kms.model.DeleteAliasResponse;
import software.amazon.awssdk.services.kms.model.DeleteCustomKeyStoreRequest;
import software.amazon.awssdk.services.kms.model.DeleteCustomKeyStoreResponse;
import software.amazon.awssdk.services.kms.model.DeleteImportedKeyMaterialRequest;
import software.amazon.awssdk.services.kms.model.DeleteImportedKeyMaterialResponse;
import software.amazon.awssdk.services.kms.model.DependencyTimeoutException;
import software.amazon.awssdk.services.kms.model.DeriveSharedSecretRequest;
import software.amazon.awssdk.services.kms.model.DeriveSharedSecretResponse;
import software.amazon.awssdk.services.kms.model.DescribeCustomKeyStoresRequest;
import software.amazon.awssdk.services.kms.model.DescribeCustomKeyStoresResponse;
import software.amazon.awssdk.services.kms.model.DescribeKeyRequest;
import software.amazon.awssdk.services.kms.model.DescribeKeyResponse;
import software.amazon.awssdk.services.kms.model.DisableKeyRequest;
import software.amazon.awssdk.services.kms.model.DisableKeyResponse;
import software.amazon.awssdk.services.kms.model.DisableKeyRotationRequest;
import software.amazon.awssdk.services.kms.model.DisableKeyRotationResponse;
import software.amazon.awssdk.services.kms.model.DisabledException;
import software.amazon.awssdk.services.kms.model.DisconnectCustomKeyStoreRequest;
import software.amazon.awssdk.services.kms.model.DisconnectCustomKeyStoreResponse;
import software.amazon.awssdk.services.kms.model.DryRunOperationException;
import software.amazon.awssdk.services.kms.model.EnableKeyRequest;
import software.amazon.awssdk.services.kms.model.EnableKeyResponse;
import software.amazon.awssdk.services.kms.model.EnableKeyRotationRequest;
import software.amazon.awssdk.services.kms.model.EnableKeyRotationResponse;
import software.amazon.awssdk.services.kms.model.EncryptRequest;
import software.amazon.awssdk.services.kms.model.EncryptResponse;
import software.amazon.awssdk.services.kms.model.ExpiredImportTokenException;
import software.amazon.awssdk.services.kms.model.GenerateDataKeyPairRequest;
import software.amazon.awssdk.services.kms.model.GenerateDataKeyPairResponse;
import software.amazon.awssdk.services.kms.model.GenerateDataKeyPairWithoutPlaintextRequest;
import software.amazon.awssdk.services.kms.model.GenerateDataKeyPairWithoutPlaintextResponse;
import software.amazon.awssdk.services.kms.model.GenerateDataKeyRequest;
import software.amazon.awssdk.services.kms.model.GenerateDataKeyResponse;
import software.amazon.awssdk.services.kms.model.GenerateDataKeyWithoutPlaintextRequest;
import software.amazon.awssdk.services.kms.model.GenerateDataKeyWithoutPlaintextResponse;
import software.amazon.awssdk.services.kms.model.GenerateMacRequest;
import software.amazon.awssdk.services.kms.model.GenerateMacResponse;
import software.amazon.awssdk.services.kms.model.GenerateRandomRequest;
import software.amazon.awssdk.services.kms.model.GenerateRandomResponse;
import software.amazon.awssdk.services.kms.model.GetKeyPolicyRequest;
import software.amazon.awssdk.services.kms.model.GetKeyPolicyResponse;
import software.amazon.awssdk.services.kms.model.GetKeyRotationStatusRequest;
import software.amazon.awssdk.services.kms.model.GetKeyRotationStatusResponse;
import software.amazon.awssdk.services.kms.model.GetParametersForImportRequest;
import software.amazon.awssdk.services.kms.model.GetParametersForImportResponse;
import software.amazon.awssdk.services.kms.model.GetPublicKeyRequest;
import software.amazon.awssdk.services.kms.model.GetPublicKeyResponse;
import software.amazon.awssdk.services.kms.model.ImportKeyMaterialRequest;
import software.amazon.awssdk.services.kms.model.ImportKeyMaterialResponse;
import software.amazon.awssdk.services.kms.model.IncorrectKeyException;
import software.amazon.awssdk.services.kms.model.IncorrectKeyMaterialException;
import software.amazon.awssdk.services.kms.model.IncorrectTrustAnchorException;
import software.amazon.awssdk.services.kms.model.InvalidAliasNameException;
import software.amazon.awssdk.services.kms.model.InvalidArnException;
import software.amazon.awssdk.services.kms.model.InvalidCiphertextException;
import software.amazon.awssdk.services.kms.model.InvalidGrantIdException;
import software.amazon.awssdk.services.kms.model.InvalidGrantTokenException;
import software.amazon.awssdk.services.kms.model.InvalidImportTokenException;
import software.amazon.awssdk.services.kms.model.InvalidKeyUsageException;
import software.amazon.awssdk.services.kms.model.InvalidMarkerException;
import software.amazon.awssdk.services.kms.model.KeyUnavailableException;
import software.amazon.awssdk.services.kms.model.KmsException;
import software.amazon.awssdk.services.kms.model.KmsInternalException;
import software.amazon.awssdk.services.kms.model.KmsInvalidMacException;
import software.amazon.awssdk.services.kms.model.KmsInvalidSignatureException;
import software.amazon.awssdk.services.kms.model.KmsInvalidStateException;
import software.amazon.awssdk.services.kms.model.LimitExceededException;
import software.amazon.awssdk.services.kms.model.ListAliasesRequest;
import software.amazon.awssdk.services.kms.model.ListAliasesResponse;
import software.amazon.awssdk.services.kms.model.ListGrantsRequest;
import software.amazon.awssdk.services.kms.model.ListGrantsResponse;
import software.amazon.awssdk.services.kms.model.ListKeyPoliciesRequest;
import software.amazon.awssdk.services.kms.model.ListKeyPoliciesResponse;
import software.amazon.awssdk.services.kms.model.ListKeyRotationsRequest;
import software.amazon.awssdk.services.kms.model.ListKeyRotationsResponse;
import software.amazon.awssdk.services.kms.model.ListKeysRequest;
import software.amazon.awssdk.services.kms.model.ListKeysResponse;
import software.amazon.awssdk.services.kms.model.ListResourceTagsRequest;
import software.amazon.awssdk.services.kms.model.ListResourceTagsResponse;
import software.amazon.awssdk.services.kms.model.ListRetirableGrantsRequest;
import software.amazon.awssdk.services.kms.model.ListRetirableGrantsResponse;
import software.amazon.awssdk.services.kms.model.MalformedPolicyDocumentException;
import software.amazon.awssdk.services.kms.model.NotFoundException;
import software.amazon.awssdk.services.kms.model.PutKeyPolicyRequest;
import software.amazon.awssdk.services.kms.model.PutKeyPolicyResponse;
import software.amazon.awssdk.services.kms.model.ReEncryptRequest;
import software.amazon.awssdk.services.kms.model.ReEncryptResponse;
import software.amazon.awssdk.services.kms.model.ReplicateKeyRequest;
import software.amazon.awssdk.services.kms.model.ReplicateKeyResponse;
import software.amazon.awssdk.services.kms.model.RetireGrantRequest;
import software.amazon.awssdk.services.kms.model.RetireGrantResponse;
import software.amazon.awssdk.services.kms.model.RevokeGrantRequest;
import software.amazon.awssdk.services.kms.model.RevokeGrantResponse;
import software.amazon.awssdk.services.kms.model.RotateKeyOnDemandRequest;
import software.amazon.awssdk.services.kms.model.RotateKeyOnDemandResponse;
import software.amazon.awssdk.services.kms.model.ScheduleKeyDeletionRequest;
import software.amazon.awssdk.services.kms.model.ScheduleKeyDeletionResponse;
import software.amazon.awssdk.services.kms.model.SignRequest;
import software.amazon.awssdk.services.kms.model.SignResponse;
import software.amazon.awssdk.services.kms.model.TagException;
import software.amazon.awssdk.services.kms.model.TagResourceRequest;
import software.amazon.awssdk.services.kms.model.TagResourceResponse;
import software.amazon.awssdk.services.kms.model.UnsupportedOperationException;
import software.amazon.awssdk.services.kms.model.UntagResourceRequest;
import software.amazon.awssdk.services.kms.model.UntagResourceResponse;
import software.amazon.awssdk.services.kms.model.UpdateAliasRequest;
import software.amazon.awssdk.services.kms.model.UpdateAliasResponse;
import software.amazon.awssdk.services.kms.model.UpdateCustomKeyStoreRequest;
import software.amazon.awssdk.services.kms.model.UpdateCustomKeyStoreResponse;
import software.amazon.awssdk.services.kms.model.UpdateKeyDescriptionRequest;
import software.amazon.awssdk.services.kms.model.UpdateKeyDescriptionResponse;
import software.amazon.awssdk.services.kms.model.UpdatePrimaryRegionRequest;
import software.amazon.awssdk.services.kms.model.UpdatePrimaryRegionResponse;
import software.amazon.awssdk.services.kms.model.VerifyMacRequest;
import software.amazon.awssdk.services.kms.model.VerifyMacResponse;
import software.amazon.awssdk.services.kms.model.VerifyRequest;
import software.amazon.awssdk.services.kms.model.VerifyResponse;
import software.amazon.awssdk.services.kms.model.XksKeyAlreadyInUseException;
import software.amazon.awssdk.services.kms.model.XksKeyInvalidConfigurationException;
import software.amazon.awssdk.services.kms.model.XksKeyNotFoundException;
import software.amazon.awssdk.services.kms.model.XksProxyIncorrectAuthenticationCredentialException;
import software.amazon.awssdk.services.kms.model.XksProxyInvalidConfigurationException;
import software.amazon.awssdk.services.kms.model.XksProxyInvalidResponseException;
import software.amazon.awssdk.services.kms.model.XksProxyUriEndpointInUseException;
import software.amazon.awssdk.services.kms.model.XksProxyUriInUseException;
import software.amazon.awssdk.services.kms.model.XksProxyUriUnreachableException;
import software.amazon.awssdk.services.kms.model.XksProxyVpcEndpointServiceInUseException;
import software.amazon.awssdk.services.kms.model.XksProxyVpcEndpointServiceInvalidConfigurationException;
import software.amazon.awssdk.services.kms.model.XksProxyVpcEndpointServiceNotFoundException;
import software.amazon.awssdk.services.kms.transform.CancelKeyDeletionRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ConnectCustomKeyStoreRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.CreateAliasRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.CreateCustomKeyStoreRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.CreateGrantRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.CreateKeyRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.DecryptRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.DeleteAliasRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.DeleteCustomKeyStoreRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.DeleteImportedKeyMaterialRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.DeriveSharedSecretRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.DescribeCustomKeyStoresRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.DescribeKeyRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.DisableKeyRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.DisableKeyRotationRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.DisconnectCustomKeyStoreRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.EnableKeyRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.EnableKeyRotationRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.EncryptRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.GenerateDataKeyPairRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.GenerateDataKeyPairWithoutPlaintextRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.GenerateDataKeyRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.GenerateDataKeyWithoutPlaintextRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.GenerateMacRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.GenerateRandomRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.GetKeyPolicyRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.GetKeyRotationStatusRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.GetParametersForImportRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.GetPublicKeyRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ImportKeyMaterialRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ListAliasesRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ListGrantsRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ListKeyPoliciesRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ListKeyRotationsRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ListKeysRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ListResourceTagsRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ListRetirableGrantsRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.PutKeyPolicyRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ReEncryptRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ReplicateKeyRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.RetireGrantRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.RevokeGrantRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.RotateKeyOnDemandRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.ScheduleKeyDeletionRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.SignRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.UpdateAliasRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.UpdateCustomKeyStoreRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.UpdateKeyDescriptionRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.UpdatePrimaryRegionRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.VerifyMacRequestMarshaller;
import software.amazon.awssdk.services.kms.transform.VerifyRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultKmsAsyncClient
implements KmsAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultKmsAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultKmsAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"KMS#2.39.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<CancelKeyDeletionResponse> cancelKeyDeletion(CancelKeyDeletionRequest cancelKeyDeletionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)cancelKeyDeletionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, cancelKeyDeletionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelKeyDeletion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelKeyDeletionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelKeyDeletion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CancelKeyDeletionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)cancelKeyDeletionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$cancelKeyDeletion$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$cancelKeyDeletion$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ConnectCustomKeyStoreResponse> connectCustomKeyStore(ConnectCustomKeyStoreRequest connectCustomKeyStoreRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)connectCustomKeyStoreRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, connectCustomKeyStoreRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ConnectCustomKeyStore");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ConnectCustomKeyStoreResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ConnectCustomKeyStore").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ConnectCustomKeyStoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)connectCustomKeyStoreRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$connectCustomKeyStore$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$connectCustomKeyStore$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateAliasResponse> createAlias(CreateAliasRequest createAliasRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createAliasRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, createAliasRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAlias");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAliasResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAlias").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateAliasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createAliasRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$createAlias$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$createAlias$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateCustomKeyStoreResponse> createCustomKeyStore(CreateCustomKeyStoreRequest createCustomKeyStoreRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createCustomKeyStoreRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, createCustomKeyStoreRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCustomKeyStore");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCustomKeyStoreResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCustomKeyStore").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateCustomKeyStoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createCustomKeyStoreRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$createCustomKeyStore$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$createCustomKeyStore$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateGrantResponse> createGrant(CreateGrantRequest createGrantRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createGrantRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, createGrantRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateGrant");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateGrantResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateGrant").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateGrantRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createGrantRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$createGrant$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$createGrant$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateKeyResponse> createKey(CreateKeyRequest createKeyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createKeyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, createKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateKey");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateKeyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateKey").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createKeyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$createKey$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$createKey$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DecryptResponse> decrypt(DecryptRequest decryptRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)decryptRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, decryptRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"Decrypt");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DecryptResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("Decrypt").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DecryptRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)decryptRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$decrypt$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$decrypt$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteAliasResponse> deleteAlias(DeleteAliasRequest deleteAliasRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAliasRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteAliasRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAlias");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAliasResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAlias").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteAliasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteAliasRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$deleteAlias$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$deleteAlias$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteCustomKeyStoreResponse> deleteCustomKeyStore(DeleteCustomKeyStoreRequest deleteCustomKeyStoreRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteCustomKeyStoreRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteCustomKeyStoreRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCustomKeyStore");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCustomKeyStoreResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCustomKeyStore").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteCustomKeyStoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteCustomKeyStoreRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$deleteCustomKeyStore$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$deleteCustomKeyStore$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteImportedKeyMaterialResponse> deleteImportedKeyMaterial(DeleteImportedKeyMaterialRequest deleteImportedKeyMaterialRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteImportedKeyMaterialRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteImportedKeyMaterialRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteImportedKeyMaterial");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteImportedKeyMaterialResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteImportedKeyMaterial").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteImportedKeyMaterialRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteImportedKeyMaterialRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$deleteImportedKeyMaterial$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$deleteImportedKeyMaterial$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeriveSharedSecretResponse> deriveSharedSecret(DeriveSharedSecretRequest deriveSharedSecretRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deriveSharedSecretRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, deriveSharedSecretRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeriveSharedSecret");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeriveSharedSecretResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeriveSharedSecret").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeriveSharedSecretRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deriveSharedSecretRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$deriveSharedSecret$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$deriveSharedSecret$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeCustomKeyStoresResponse> describeCustomKeyStores(DescribeCustomKeyStoresRequest describeCustomKeyStoresRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeCustomKeyStoresRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, describeCustomKeyStoresRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCustomKeyStores");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCustomKeyStoresResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCustomKeyStores").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeCustomKeyStoresRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeCustomKeyStoresRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$describeCustomKeyStores$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$describeCustomKeyStores$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeKeyResponse> describeKey(DescribeKeyRequest describeKeyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeKeyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, describeKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeKey");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeKeyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeKey").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeKeyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$describeKey$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$describeKey$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisableKeyResponse> disableKey(DisableKeyRequest disableKeyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disableKeyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, disableKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableKey");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableKeyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableKey").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DisableKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)disableKeyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$disableKey$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$disableKey$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisableKeyRotationResponse> disableKeyRotation(DisableKeyRotationRequest disableKeyRotationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disableKeyRotationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, disableKeyRotationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableKeyRotation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableKeyRotationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableKeyRotation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DisableKeyRotationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)disableKeyRotationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$disableKeyRotation$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$disableKeyRotation$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisconnectCustomKeyStoreResponse> disconnectCustomKeyStore(DisconnectCustomKeyStoreRequest disconnectCustomKeyStoreRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disconnectCustomKeyStoreRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, disconnectCustomKeyStoreRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisconnectCustomKeyStore");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisconnectCustomKeyStoreResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisconnectCustomKeyStore").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DisconnectCustomKeyStoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)disconnectCustomKeyStoreRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$disconnectCustomKeyStore$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$disconnectCustomKeyStore$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<EnableKeyResponse> enableKey(EnableKeyRequest enableKeyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)enableKeyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, enableKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableKey");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableKeyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableKey").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new EnableKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)enableKeyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$enableKey$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$enableKey$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<EnableKeyRotationResponse> enableKeyRotation(EnableKeyRotationRequest enableKeyRotationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)enableKeyRotationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, enableKeyRotationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableKeyRotation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableKeyRotationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableKeyRotation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new EnableKeyRotationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)enableKeyRotationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$enableKeyRotation$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$enableKeyRotation$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<EncryptResponse> encrypt(EncryptRequest encryptRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)encryptRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, encryptRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"Encrypt");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EncryptResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("Encrypt").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new EncryptRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)encryptRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$encrypt$74(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$encrypt$75((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GenerateDataKeyResponse> generateDataKey(GenerateDataKeyRequest generateDataKeyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)generateDataKeyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, generateDataKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GenerateDataKey");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GenerateDataKeyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GenerateDataKey").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GenerateDataKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)generateDataKeyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$generateDataKey$78(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$generateDataKey$79((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GenerateDataKeyPairResponse> generateDataKeyPair(GenerateDataKeyPairRequest generateDataKeyPairRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)generateDataKeyPairRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, generateDataKeyPairRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GenerateDataKeyPair");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GenerateDataKeyPairResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GenerateDataKeyPair").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GenerateDataKeyPairRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)generateDataKeyPairRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$generateDataKeyPair$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$generateDataKeyPair$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GenerateDataKeyPairWithoutPlaintextResponse> generateDataKeyPairWithoutPlaintext(GenerateDataKeyPairWithoutPlaintextRequest generateDataKeyPairWithoutPlaintextRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)generateDataKeyPairWithoutPlaintextRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, generateDataKeyPairWithoutPlaintextRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GenerateDataKeyPairWithoutPlaintext");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GenerateDataKeyPairWithoutPlaintextResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GenerateDataKeyPairWithoutPlaintext").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GenerateDataKeyPairWithoutPlaintextRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)generateDataKeyPairWithoutPlaintextRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$generateDataKeyPairWithoutPlaintext$86(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$generateDataKeyPairWithoutPlaintext$87((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GenerateDataKeyWithoutPlaintextResponse> generateDataKeyWithoutPlaintext(GenerateDataKeyWithoutPlaintextRequest generateDataKeyWithoutPlaintextRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)generateDataKeyWithoutPlaintextRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, generateDataKeyWithoutPlaintextRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GenerateDataKeyWithoutPlaintext");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GenerateDataKeyWithoutPlaintextResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GenerateDataKeyWithoutPlaintext").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GenerateDataKeyWithoutPlaintextRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)generateDataKeyWithoutPlaintextRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$generateDataKeyWithoutPlaintext$90(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$generateDataKeyWithoutPlaintext$91((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GenerateMacResponse> generateMac(GenerateMacRequest generateMacRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)generateMacRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, generateMacRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GenerateMac");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GenerateMacResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GenerateMac").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GenerateMacRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)generateMacRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$generateMac$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$generateMac$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GenerateRandomResponse> generateRandom(GenerateRandomRequest generateRandomRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)generateRandomRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, generateRandomRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GenerateRandom");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GenerateRandomResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GenerateRandom").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GenerateRandomRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)generateRandomRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$generateRandom$98(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$generateRandom$99((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetKeyPolicyResponse> getKeyPolicy(GetKeyPolicyRequest getKeyPolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getKeyPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, getKeyPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetKeyPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetKeyPolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetKeyPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetKeyPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getKeyPolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$getKeyPolicy$102(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$getKeyPolicy$103((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetKeyRotationStatusResponse> getKeyRotationStatus(GetKeyRotationStatusRequest getKeyRotationStatusRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getKeyRotationStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, getKeyRotationStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetKeyRotationStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetKeyRotationStatusResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetKeyRotationStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetKeyRotationStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getKeyRotationStatusRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$getKeyRotationStatus$106(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$getKeyRotationStatus$107((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetParametersForImportResponse> getParametersForImport(GetParametersForImportRequest getParametersForImportRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getParametersForImportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, getParametersForImportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetParametersForImport");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetParametersForImportResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetParametersForImport").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetParametersForImportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getParametersForImportRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$getParametersForImport$110(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$getParametersForImport$111((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetPublicKeyResponse> getPublicKey(GetPublicKeyRequest getPublicKeyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getPublicKeyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, getPublicKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPublicKey");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPublicKeyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPublicKey").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetPublicKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getPublicKeyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$getPublicKey$114(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$getPublicKey$115((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ImportKeyMaterialResponse> importKeyMaterial(ImportKeyMaterialRequest importKeyMaterialRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)importKeyMaterialRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, importKeyMaterialRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ImportKeyMaterial");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ImportKeyMaterialResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ImportKeyMaterial").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ImportKeyMaterialRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)importKeyMaterialRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$importKeyMaterial$118(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$importKeyMaterial$119((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListAliasesResponse> listAliases(ListAliasesRequest listAliasesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAliasesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, listAliasesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAliases");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAliasesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAliases").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListAliasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listAliasesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$listAliases$122(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$listAliases$123((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListGrantsResponse> listGrants(ListGrantsRequest listGrantsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listGrantsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, listGrantsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListGrants");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListGrantsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListGrants").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListGrantsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listGrantsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$listGrants$126(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$listGrants$127((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListKeyPoliciesResponse> listKeyPolicies(ListKeyPoliciesRequest listKeyPoliciesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listKeyPoliciesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, listKeyPoliciesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListKeyPolicies");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListKeyPoliciesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListKeyPolicies").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListKeyPoliciesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listKeyPoliciesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$listKeyPolicies$130(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$listKeyPolicies$131((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListKeyRotationsResponse> listKeyRotations(ListKeyRotationsRequest listKeyRotationsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listKeyRotationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, listKeyRotationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListKeyRotations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListKeyRotationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListKeyRotations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListKeyRotationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listKeyRotationsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$listKeyRotations$134(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$listKeyRotations$135((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListKeysResponse> listKeys(ListKeysRequest listKeysRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listKeysRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, listKeysRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListKeys");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListKeysResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListKeys").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListKeysRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listKeysRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$listKeys$138(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$listKeys$139((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListResourceTagsResponse> listResourceTags(ListResourceTagsRequest listResourceTagsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listResourceTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, listResourceTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListResourceTags");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListResourceTagsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListResourceTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListResourceTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listResourceTagsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$listResourceTags$142(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$listResourceTags$143((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListRetirableGrantsResponse> listRetirableGrants(ListRetirableGrantsRequest listRetirableGrantsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listRetirableGrantsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, listRetirableGrantsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRetirableGrants");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRetirableGrantsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRetirableGrants").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListRetirableGrantsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listRetirableGrantsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$listRetirableGrants$146(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$listRetirableGrants$147((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutKeyPolicyResponse> putKeyPolicy(PutKeyPolicyRequest putKeyPolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putKeyPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, putKeyPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutKeyPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutKeyPolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutKeyPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutKeyPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putKeyPolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$putKeyPolicy$150(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$putKeyPolicy$151((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ReEncryptResponse> reEncrypt(ReEncryptRequest reEncryptRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)reEncryptRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, reEncryptRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ReEncrypt");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ReEncryptResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ReEncrypt").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ReEncryptRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)reEncryptRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$reEncrypt$154(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$reEncrypt$155((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ReplicateKeyResponse> replicateKey(ReplicateKeyRequest replicateKeyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)replicateKeyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, replicateKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ReplicateKey");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ReplicateKeyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ReplicateKey").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ReplicateKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)replicateKeyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$replicateKey$158(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$replicateKey$159((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RetireGrantResponse> retireGrant(RetireGrantRequest retireGrantRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)retireGrantRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, retireGrantRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RetireGrant");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RetireGrantResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RetireGrant").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RetireGrantRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)retireGrantRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$retireGrant$162(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$retireGrant$163((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RevokeGrantResponse> revokeGrant(RevokeGrantRequest revokeGrantRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)revokeGrantRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, revokeGrantRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RevokeGrant");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RevokeGrantResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RevokeGrant").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RevokeGrantRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)revokeGrantRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$revokeGrant$166(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$revokeGrant$167((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RotateKeyOnDemandResponse> rotateKeyOnDemand(RotateKeyOnDemandRequest rotateKeyOnDemandRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)rotateKeyOnDemandRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, rotateKeyOnDemandRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RotateKeyOnDemand");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RotateKeyOnDemandResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RotateKeyOnDemand").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RotateKeyOnDemandRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)rotateKeyOnDemandRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$rotateKeyOnDemand$170(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$rotateKeyOnDemand$171((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ScheduleKeyDeletionResponse> scheduleKeyDeletion(ScheduleKeyDeletionRequest scheduleKeyDeletionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)scheduleKeyDeletionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, scheduleKeyDeletionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ScheduleKeyDeletion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ScheduleKeyDeletionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ScheduleKeyDeletion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ScheduleKeyDeletionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)scheduleKeyDeletionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$scheduleKeyDeletion$174(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$scheduleKeyDeletion$175((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SignResponse> sign(SignRequest signRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)signRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, signRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"Sign");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SignResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("Sign").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new SignRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)signRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$sign$178(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$sign$179((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$tagResource$182(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$tagResource$183((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$untagResource$186(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$untagResource$187((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateAliasResponse> updateAlias(UpdateAliasRequest updateAliasRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateAliasRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, updateAliasRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAlias");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAliasResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAlias").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateAliasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateAliasRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$updateAlias$190(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$updateAlias$191((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateCustomKeyStoreResponse> updateCustomKeyStore(UpdateCustomKeyStoreRequest updateCustomKeyStoreRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateCustomKeyStoreRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, updateCustomKeyStoreRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCustomKeyStore");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateCustomKeyStoreResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCustomKeyStore").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateCustomKeyStoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateCustomKeyStoreRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$updateCustomKeyStore$194(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$updateCustomKeyStore$195((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateKeyDescriptionResponse> updateKeyDescription(UpdateKeyDescriptionRequest updateKeyDescriptionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateKeyDescriptionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, updateKeyDescriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateKeyDescription");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateKeyDescriptionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateKeyDescription").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateKeyDescriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateKeyDescriptionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$updateKeyDescription$198(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$updateKeyDescription$199((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdatePrimaryRegionResponse> updatePrimaryRegion(UpdatePrimaryRegionRequest updatePrimaryRegionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updatePrimaryRegionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, updatePrimaryRegionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdatePrimaryRegion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePrimaryRegionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePrimaryRegion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdatePrimaryRegionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updatePrimaryRegionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$updatePrimaryRegion$202(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$updatePrimaryRegion$203((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<VerifyResponse> verify(VerifyRequest verifyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)verifyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, verifyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"Verify");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, VerifyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("Verify").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new VerifyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)verifyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$verify$206(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$verify$207((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<VerifyMacResponse> verifyMac(VerifyMacRequest verifyMacRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)verifyMacRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKmsAsyncClient.resolveMetricPublishers(clientConfiguration, verifyMacRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KMS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"VerifyMac");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, VerifyMacResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "XksProxyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidConfigurationException::builder).build());
                    }
                    case "ExpiredImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredImportTokenException::builder).build());
                    }
                    case "CustomKeyStoreNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNotFoundException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInvalidConfigurationException::builder).build());
                    }
                    case "MalformedPolicyDocumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).build());
                    }
                    case "XksProxyUriUnreachableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriUnreachableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriUnreachableException::builder).build());
                    }
                    case "KMSInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                    }
                    case "XksProxyUriInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriInUseException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "CustomKeyStoreInvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreInvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreInvalidStateException::builder).build());
                    }
                    case "IncorrectTrustAnchorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectTrustAnchorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectTrustAnchorException::builder).build());
                    }
                    case "KeyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KeyUnavailableException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KeyUnavailableException::builder).build());
                    }
                    case "KMSInternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(KmsInternalException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "XksProxyInvalidResponseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyInvalidResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyInvalidResponseException::builder).build());
                    }
                    case "XksProxyUriEndpointInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyUriEndpointInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyUriEndpointInUseException::builder).build());
                    }
                    case "InvalidGrantTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantTokenException::builder).build());
                    }
                    case "XksKeyInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyInvalidConfigurationException::builder).build());
                    }
                    case "UnsupportedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "XksKeyAlreadyInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyAlreadyInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyAlreadyInUseException::builder).build());
                    }
                    case "CloudHsmClusterInvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInvalidConfigurationException::builder).build());
                    }
                    case "InvalidMarkerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMarkerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMarkerException::builder).build());
                    }
                    case "InvalidAliasNameException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAliasNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAliasNameException::builder).build());
                    }
                    case "XksKeyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksKeyNotFoundException::builder).build());
                    }
                    case "DryRunOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DryRunOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DryRunOperationException::builder).build());
                    }
                    case "CloudHsmClusterNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotFoundException::builder).build());
                    }
                    case "XksProxyIncorrectAuthenticationCredentialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyIncorrectAuthenticationCredentialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyIncorrectAuthenticationCredentialException::builder).build());
                    }
                    case "IncorrectKeyMaterialException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyMaterialException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyMaterialException::builder).build());
                    }
                    case "InvalidImportTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportTokenException::builder).build());
                    }
                    case "CloudHsmClusterNotRelatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotRelatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotRelatedException::builder).build());
                    }
                    case "DisabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "KMSInvalidSignatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidSignatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidSignatureException::builder).build());
                    }
                    case "CloudHsmClusterInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterInUseException::builder).build());
                    }
                    case "InvalidCiphertextException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCiphertextException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCiphertextException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidGrantIdException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGrantIdException::builder).build());
                    }
                    case "CustomKeyStoreHasCMKsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreHasCMKsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreHasCmKsException::builder).build());
                    }
                    case "IncorrectKeyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncorrectKeyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncorrectKeyException::builder).build());
                    }
                    case "CustomKeyStoreNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomKeyStoreNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomKeyStoreNameInUseException::builder).build());
                    }
                    case "KMSInvalidMacException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidMacException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidMacException::builder).build());
                    }
                    case "TagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagException::builder).build());
                    }
                    case "InvalidKeyUsageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyUsageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKeyUsageException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceInUseException::builder).build());
                    }
                    case "XksProxyVpcEndpointServiceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("XksProxyVpcEndpointServiceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(XksProxyVpcEndpointServiceNotFoundException::builder).build());
                    }
                    case "DependencyTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyTimeoutException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DependencyTimeoutException::builder).build());
                    }
                    case "CloudHsmClusterNotActiveException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CloudHsmClusterNotActiveException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudHsmClusterNotActiveException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("VerifyMac").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new VerifyMacRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)verifyMacRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKmsAsyncClient.lambda$verifyMac$210(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKmsAsyncClient.lambda$verifyMac$211((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final KmsServiceClientConfiguration serviceClientConfiguration() {
        return new KmsServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "kms";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(KmsException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        KmsServiceClientConfigurationBuilder serviceConfigBuilder = new KmsServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$verifyMac$211(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$verifyMac$210(List metricPublishers, MetricCollector apiCallMetricCollector, VerifyMacResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$verify$207(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$verify$206(List metricPublishers, MetricCollector apiCallMetricCollector, VerifyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updatePrimaryRegion$203(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updatePrimaryRegion$202(List metricPublishers, MetricCollector apiCallMetricCollector, UpdatePrimaryRegionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateKeyDescription$199(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateKeyDescription$198(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateKeyDescriptionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateCustomKeyStore$195(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateCustomKeyStore$194(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateCustomKeyStoreResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateAlias$191(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateAlias$190(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateAliasResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagResource$187(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$186(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$183(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$182(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$sign$179(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$sign$178(List metricPublishers, MetricCollector apiCallMetricCollector, SignResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$scheduleKeyDeletion$175(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$scheduleKeyDeletion$174(List metricPublishers, MetricCollector apiCallMetricCollector, ScheduleKeyDeletionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$rotateKeyOnDemand$171(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$rotateKeyOnDemand$170(List metricPublishers, MetricCollector apiCallMetricCollector, RotateKeyOnDemandResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$revokeGrant$167(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$revokeGrant$166(List metricPublishers, MetricCollector apiCallMetricCollector, RevokeGrantResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$retireGrant$163(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$retireGrant$162(List metricPublishers, MetricCollector apiCallMetricCollector, RetireGrantResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$replicateKey$159(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$replicateKey$158(List metricPublishers, MetricCollector apiCallMetricCollector, ReplicateKeyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$reEncrypt$155(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$reEncrypt$154(List metricPublishers, MetricCollector apiCallMetricCollector, ReEncryptResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putKeyPolicy$151(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putKeyPolicy$150(List metricPublishers, MetricCollector apiCallMetricCollector, PutKeyPolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listRetirableGrants$147(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRetirableGrants$146(List metricPublishers, MetricCollector apiCallMetricCollector, ListRetirableGrantsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listResourceTags$143(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listResourceTags$142(List metricPublishers, MetricCollector apiCallMetricCollector, ListResourceTagsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listKeys$139(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listKeys$138(List metricPublishers, MetricCollector apiCallMetricCollector, ListKeysResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listKeyRotations$135(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listKeyRotations$134(List metricPublishers, MetricCollector apiCallMetricCollector, ListKeyRotationsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listKeyPolicies$131(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listKeyPolicies$130(List metricPublishers, MetricCollector apiCallMetricCollector, ListKeyPoliciesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listGrants$127(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listGrants$126(List metricPublishers, MetricCollector apiCallMetricCollector, ListGrantsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listAliases$123(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAliases$122(List metricPublishers, MetricCollector apiCallMetricCollector, ListAliasesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$importKeyMaterial$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$importKeyMaterial$118(List metricPublishers, MetricCollector apiCallMetricCollector, ImportKeyMaterialResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getPublicKey$115(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPublicKey$114(List metricPublishers, MetricCollector apiCallMetricCollector, GetPublicKeyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getParametersForImport$111(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getParametersForImport$110(List metricPublishers, MetricCollector apiCallMetricCollector, GetParametersForImportResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getKeyRotationStatus$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getKeyRotationStatus$106(List metricPublishers, MetricCollector apiCallMetricCollector, GetKeyRotationStatusResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getKeyPolicy$103(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getKeyPolicy$102(List metricPublishers, MetricCollector apiCallMetricCollector, GetKeyPolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$generateRandom$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$generateRandom$98(List metricPublishers, MetricCollector apiCallMetricCollector, GenerateRandomResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$generateMac$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$generateMac$94(List metricPublishers, MetricCollector apiCallMetricCollector, GenerateMacResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$generateDataKeyWithoutPlaintext$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$generateDataKeyWithoutPlaintext$90(List metricPublishers, MetricCollector apiCallMetricCollector, GenerateDataKeyWithoutPlaintextResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$generateDataKeyPairWithoutPlaintext$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$generateDataKeyPairWithoutPlaintext$86(List metricPublishers, MetricCollector apiCallMetricCollector, GenerateDataKeyPairWithoutPlaintextResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$generateDataKeyPair$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$generateDataKeyPair$82(List metricPublishers, MetricCollector apiCallMetricCollector, GenerateDataKeyPairResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$generateDataKey$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$generateDataKey$78(List metricPublishers, MetricCollector apiCallMetricCollector, GenerateDataKeyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$encrypt$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$encrypt$74(List metricPublishers, MetricCollector apiCallMetricCollector, EncryptResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$enableKeyRotation$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$enableKeyRotation$70(List metricPublishers, MetricCollector apiCallMetricCollector, EnableKeyRotationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$enableKey$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$enableKey$66(List metricPublishers, MetricCollector apiCallMetricCollector, EnableKeyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$disconnectCustomKeyStore$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disconnectCustomKeyStore$62(List metricPublishers, MetricCollector apiCallMetricCollector, DisconnectCustomKeyStoreResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$disableKeyRotation$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disableKeyRotation$58(List metricPublishers, MetricCollector apiCallMetricCollector, DisableKeyRotationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$disableKey$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disableKey$54(List metricPublishers, MetricCollector apiCallMetricCollector, DisableKeyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeKey$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeKey$50(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeKeyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeCustomKeyStores$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCustomKeyStores$46(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeCustomKeyStoresResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deriveSharedSecret$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deriveSharedSecret$42(List metricPublishers, MetricCollector apiCallMetricCollector, DeriveSharedSecretResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteImportedKeyMaterial$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteImportedKeyMaterial$38(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteImportedKeyMaterialResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteCustomKeyStore$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCustomKeyStore$34(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteCustomKeyStoreResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteAlias$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAlias$30(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteAliasResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$decrypt$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$decrypt$26(List metricPublishers, MetricCollector apiCallMetricCollector, DecryptResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createKey$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createKey$22(List metricPublishers, MetricCollector apiCallMetricCollector, CreateKeyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createGrant$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createGrant$18(List metricPublishers, MetricCollector apiCallMetricCollector, CreateGrantResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createCustomKeyStore$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCustomKeyStore$14(List metricPublishers, MetricCollector apiCallMetricCollector, CreateCustomKeyStoreResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createAlias$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAlias$10(List metricPublishers, MetricCollector apiCallMetricCollector, CreateAliasResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$connectCustomKeyStore$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$connectCustomKeyStore$6(List metricPublishers, MetricCollector apiCallMetricCollector, ConnectCustomKeyStoreResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$cancelKeyDeletion$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelKeyDeletion$2(List metricPublishers, MetricCollector apiCallMetricCollector, CancelKeyDeletionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

