/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGrantResponse extends KmsResponse implements
        ToCopyableBuilder<CreateGrantResponse.Builder, CreateGrantResponse> {
    private static final SdkField<String> GRANT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateGrantResponse::grantToken)).setter(setter(Builder::grantToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantToken").build()).build();

    private static final SdkField<String> GRANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateGrantResponse::grantId)).setter(setter(Builder::grantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRANT_TOKEN_FIELD,
            GRANT_ID_FIELD));

    private final String grantToken;

    private final String grantId;

    private CreateGrantResponse(BuilderImpl builder) {
        super(builder);
        this.grantToken = builder.grantToken;
        this.grantId = builder.grantId;
    }

    /**
     * <p>
     * The grant token.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token">Grant Tokens</a> in the
     * <i>AWS Key Management Service Developer Guide</i>.
     * </p>
     * 
     * @return The grant token.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token">Grant Tokens</a>
     *         in the <i>AWS Key Management Service Developer Guide</i>.
     */
    public String grantToken() {
        return grantToken;
    }

    /**
     * <p>
     * The unique identifier for the grant.
     * </p>
     * <p>
     * You can use the <code>GrantId</code> in a subsequent <a>RetireGrant</a> or <a>RevokeGrant</a> operation.
     * </p>
     * 
     * @return The unique identifier for the grant.</p>
     *         <p>
     *         You can use the <code>GrantId</code> in a subsequent <a>RetireGrant</a> or <a>RevokeGrant</a> operation.
     */
    public String grantId() {
        return grantId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(grantToken());
        hashCode = 31 * hashCode + Objects.hashCode(grantId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGrantResponse)) {
            return false;
        }
        CreateGrantResponse other = (CreateGrantResponse) obj;
        return Objects.equals(grantToken(), other.grantToken()) && Objects.equals(grantId(), other.grantId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateGrantResponse").add("GrantToken", grantToken()).add("GrantId", grantId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GrantToken":
            return Optional.ofNullable(clazz.cast(grantToken()));
        case "GrantId":
            return Optional.ofNullable(clazz.cast(grantId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateGrantResponse, T> g) {
        return obj -> g.apply((CreateGrantResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KmsResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateGrantResponse> {
        /**
         * <p>
         * The grant token.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token">Grant Tokens</a> in
         * the <i>AWS Key Management Service Developer Guide</i>.
         * </p>
         * 
         * @param grantToken
         *        The grant token.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token">Grant
         *        Tokens</a> in the <i>AWS Key Management Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantToken(String grantToken);

        /**
         * <p>
         * The unique identifier for the grant.
         * </p>
         * <p>
         * You can use the <code>GrantId</code> in a subsequent <a>RetireGrant</a> or <a>RevokeGrant</a> operation.
         * </p>
         * 
         * @param grantId
         *        The unique identifier for the grant.</p>
         *        <p>
         *        You can use the <code>GrantId</code> in a subsequent <a>RetireGrant</a> or <a>RevokeGrant</a>
         *        operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantId(String grantId);
    }

    static final class BuilderImpl extends KmsResponse.BuilderImpl implements Builder {
        private String grantToken;

        private String grantId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGrantResponse model) {
            super(model);
            grantToken(model.grantToken);
            grantId(model.grantId);
        }

        public final String getGrantToken() {
            return grantToken;
        }

        @Override
        public final Builder grantToken(String grantToken) {
            this.grantToken = grantToken;
            return this;
        }

        public final void setGrantToken(String grantToken) {
            this.grantToken = grantToken;
        }

        public final String getGrantId() {
            return grantId;
        }

        @Override
        public final Builder grantId(String grantId) {
            this.grantId = grantId;
            return this;
        }

        public final void setGrantId(String grantId) {
            this.grantId = grantId;
        }

        @Override
        public CreateGrantResponse build() {
            return new CreateGrantResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
