/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetireGrantRequest extends KmsRequest implements
        ToCopyableBuilder<RetireGrantRequest.Builder, RetireGrantRequest> {
    private static final SdkField<String> GRANT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RetireGrantRequest::grantToken)).setter(setter(Builder::grantToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantToken").build()).build();

    private static final SdkField<String> KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RetireGrantRequest::keyId)).setter(setter(Builder::keyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()).build();

    private static final SdkField<String> GRANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RetireGrantRequest::grantId)).setter(setter(Builder::grantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRANT_TOKEN_FIELD,
            KEY_ID_FIELD, GRANT_ID_FIELD));

    private final String grantToken;

    private final String keyId;

    private final String grantId;

    private RetireGrantRequest(BuilderImpl builder) {
        super(builder);
        this.grantToken = builder.grantToken;
        this.keyId = builder.keyId;
        this.grantId = builder.grantId;
    }

    /**
     * <p>
     * Token that identifies the grant to be retired.
     * </p>
     * 
     * @return Token that identifies the grant to be retired.
     */
    public String grantToken() {
        return grantToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the CMK associated with the grant.
     * </p>
     * <p>
     * For example: <code>arn:aws:kms:us-east-2:444455556666:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the CMK associated with the grant. </p>
     *         <p>
     *         For example: <code>arn:aws:kms:us-east-2:444455556666:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
     */
    public String keyId() {
        return keyId;
    }

    /**
     * <p>
     * Unique identifier of the grant to retire. The grant ID is returned in the response to a <code>CreateGrant</code>
     * operation.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Grant ID Example - 0123456789012345678901234567890123456789012345678901234567890123
     * </p>
     * </li>
     * </ul>
     * 
     * @return Unique identifier of the grant to retire. The grant ID is returned in the response to a
     *         <code>CreateGrant</code> operation.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Grant ID Example - 0123456789012345678901234567890123456789012345678901234567890123
     *         </p>
     *         </li>
     */
    public String grantId() {
        return grantId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(grantToken());
        hashCode = 31 * hashCode + Objects.hashCode(keyId());
        hashCode = 31 * hashCode + Objects.hashCode(grantId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetireGrantRequest)) {
            return false;
        }
        RetireGrantRequest other = (RetireGrantRequest) obj;
        return Objects.equals(grantToken(), other.grantToken()) && Objects.equals(keyId(), other.keyId())
                && Objects.equals(grantId(), other.grantId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RetireGrantRequest").add("GrantToken", grantToken()).add("KeyId", keyId())
                .add("GrantId", grantId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GrantToken":
            return Optional.ofNullable(clazz.cast(grantToken()));
        case "KeyId":
            return Optional.ofNullable(clazz.cast(keyId()));
        case "GrantId":
            return Optional.ofNullable(clazz.cast(grantId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RetireGrantRequest, T> g) {
        return obj -> g.apply((RetireGrantRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KmsRequest.Builder, SdkPojo, CopyableBuilder<Builder, RetireGrantRequest> {
        /**
         * <p>
         * Token that identifies the grant to be retired.
         * </p>
         * 
         * @param grantToken
         *        Token that identifies the grant to be retired.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantToken(String grantToken);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the CMK associated with the grant.
         * </p>
         * <p>
         * For example: <code>arn:aws:kms:us-east-2:444455556666:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
         * </p>
         * 
         * @param keyId
         *        The Amazon Resource Name (ARN) of the CMK associated with the grant. </p>
         *        <p>
         *        For example: <code>arn:aws:kms:us-east-2:444455556666:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyId(String keyId);

        /**
         * <p>
         * Unique identifier of the grant to retire. The grant ID is returned in the response to a
         * <code>CreateGrant</code> operation.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Grant ID Example - 0123456789012345678901234567890123456789012345678901234567890123
         * </p>
         * </li>
         * </ul>
         * 
         * @param grantId
         *        Unique identifier of the grant to retire. The grant ID is returned in the response to a
         *        <code>CreateGrant</code> operation.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Grant ID Example - 0123456789012345678901234567890123456789012345678901234567890123
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantId(String grantId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KmsRequest.BuilderImpl implements Builder {
        private String grantToken;

        private String keyId;

        private String grantId;

        private BuilderImpl() {
        }

        private BuilderImpl(RetireGrantRequest model) {
            super(model);
            grantToken(model.grantToken);
            keyId(model.keyId);
            grantId(model.grantId);
        }

        public final String getGrantToken() {
            return grantToken;
        }

        @Override
        public final Builder grantToken(String grantToken) {
            this.grantToken = grantToken;
            return this;
        }

        public final void setGrantToken(String grantToken) {
            this.grantToken = grantToken;
        }

        public final String getKeyId() {
            return keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final String getGrantId() {
            return grantId;
        }

        @Override
        public final Builder grantId(String grantId) {
            this.grantId = grantId;
            return this;
        }

        public final void setGrantId(String grantId) {
            this.grantId = grantId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RetireGrantRequest build() {
            return new RetireGrantRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
