/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.lakeformation.model.AlreadyExistsException;
import software.amazon.awssdk.services.lakeformation.model.BatchGrantPermissionsRequest;
import software.amazon.awssdk.services.lakeformation.model.BatchGrantPermissionsResponse;
import software.amazon.awssdk.services.lakeformation.model.BatchRevokePermissionsRequest;
import software.amazon.awssdk.services.lakeformation.model.BatchRevokePermissionsResponse;
import software.amazon.awssdk.services.lakeformation.model.ConcurrentModificationException;
import software.amazon.awssdk.services.lakeformation.model.DeregisterResourceRequest;
import software.amazon.awssdk.services.lakeformation.model.DeregisterResourceResponse;
import software.amazon.awssdk.services.lakeformation.model.DescribeResourceRequest;
import software.amazon.awssdk.services.lakeformation.model.DescribeResourceResponse;
import software.amazon.awssdk.services.lakeformation.model.EntityNotFoundException;
import software.amazon.awssdk.services.lakeformation.model.GetDataLakeSettingsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetDataLakeSettingsResponse;
import software.amazon.awssdk.services.lakeformation.model.GetEffectivePermissionsForPathRequest;
import software.amazon.awssdk.services.lakeformation.model.GetEffectivePermissionsForPathResponse;
import software.amazon.awssdk.services.lakeformation.model.GrantPermissionsRequest;
import software.amazon.awssdk.services.lakeformation.model.GrantPermissionsResponse;
import software.amazon.awssdk.services.lakeformation.model.InternalServiceException;
import software.amazon.awssdk.services.lakeformation.model.InvalidInputException;
import software.amazon.awssdk.services.lakeformation.model.LakeFormationException;
import software.amazon.awssdk.services.lakeformation.model.ListPermissionsRequest;
import software.amazon.awssdk.services.lakeformation.model.ListPermissionsResponse;
import software.amazon.awssdk.services.lakeformation.model.ListResourcesRequest;
import software.amazon.awssdk.services.lakeformation.model.ListResourcesResponse;
import software.amazon.awssdk.services.lakeformation.model.OperationTimeoutException;
import software.amazon.awssdk.services.lakeformation.model.PutDataLakeSettingsRequest;
import software.amazon.awssdk.services.lakeformation.model.PutDataLakeSettingsResponse;
import software.amazon.awssdk.services.lakeformation.model.RegisterResourceRequest;
import software.amazon.awssdk.services.lakeformation.model.RegisterResourceResponse;
import software.amazon.awssdk.services.lakeformation.model.RevokePermissionsRequest;
import software.amazon.awssdk.services.lakeformation.model.RevokePermissionsResponse;
import software.amazon.awssdk.services.lakeformation.model.UpdateResourceRequest;
import software.amazon.awssdk.services.lakeformation.model.UpdateResourceResponse;
import software.amazon.awssdk.services.lakeformation.paginators.GetEffectivePermissionsForPathIterable;
import software.amazon.awssdk.services.lakeformation.paginators.ListPermissionsIterable;
import software.amazon.awssdk.services.lakeformation.paginators.ListResourcesIterable;

/**
 * Service client for accessing AWS Lake Formation. This can be created using the static {@link #builder()} method.
 *
 * <fullname>AWS Lake Formation</fullname>
 * <p>
 * Defines the public endpoint for the AWS Lake Formation service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface LakeFormationClient extends SdkClient {
    String SERVICE_NAME = "lakeformation";

    /**
     * Create a {@link LakeFormationClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static LakeFormationClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link LakeFormationClient}.
     */
    static LakeFormationClientBuilder builder() {
        return new DefaultLakeFormationClientBuilder();
    }

    /**
     * <p>
     * Batch operation to grant permissions to the principal.
     * </p>
     *
     * @param batchGrantPermissionsRequest
     * @return Result of the BatchGrantPermissions operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.BatchGrantPermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/BatchGrantPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGrantPermissionsResponse batchGrantPermissions(BatchGrantPermissionsRequest batchGrantPermissionsRequest)
            throws InvalidInputException, OperationTimeoutException, AwsServiceException, SdkClientException,
            LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Batch operation to grant permissions to the principal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGrantPermissionsRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGrantPermissionsRequest#builder()}
     * </p>
     *
     * @param batchGrantPermissionsRequest
     *        A {@link Consumer} that will call methods on {@link BatchGrantPermissionsRequest.Builder} to create a
     *        request.
     * @return Result of the BatchGrantPermissions operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.BatchGrantPermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/BatchGrantPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGrantPermissionsResponse batchGrantPermissions(
            Consumer<BatchGrantPermissionsRequest.Builder> batchGrantPermissionsRequest) throws InvalidInputException,
            OperationTimeoutException, AwsServiceException, SdkClientException, LakeFormationException {
        return batchGrantPermissions(BatchGrantPermissionsRequest.builder().applyMutation(batchGrantPermissionsRequest).build());
    }

    /**
     * <p>
     * Batch operation to revoke permissions from the principal.
     * </p>
     *
     * @param batchRevokePermissionsRequest
     * @return Result of the BatchRevokePermissions operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.BatchRevokePermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/BatchRevokePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchRevokePermissionsResponse batchRevokePermissions(BatchRevokePermissionsRequest batchRevokePermissionsRequest)
            throws InvalidInputException, OperationTimeoutException, AwsServiceException, SdkClientException,
            LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Batch operation to revoke permissions from the principal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchRevokePermissionsRequest.Builder} avoiding the
     * need to create one manually via {@link BatchRevokePermissionsRequest#builder()}
     * </p>
     *
     * @param batchRevokePermissionsRequest
     *        A {@link Consumer} that will call methods on {@link BatchRevokePermissionsRequest.Builder} to create a
     *        request.
     * @return Result of the BatchRevokePermissions operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.BatchRevokePermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/BatchRevokePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchRevokePermissionsResponse batchRevokePermissions(
            Consumer<BatchRevokePermissionsRequest.Builder> batchRevokePermissionsRequest) throws InvalidInputException,
            OperationTimeoutException, AwsServiceException, SdkClientException, LakeFormationException {
        return batchRevokePermissions(BatchRevokePermissionsRequest.builder().applyMutation(batchRevokePermissionsRequest)
                .build());
    }

    /**
     * <p>
     * Deregisters the resource as managed by the Data Catalog.
     * </p>
     * <p>
     * When you deregister a path, Lake Formation removes the path from the inline policy attached to your
     * service-linked role.
     * </p>
     *
     * @param deregisterResourceRequest
     * @return Result of the DeregisterResource operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.DeregisterResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/DeregisterResource"
     *      target="_top">AWS API Documentation</a>
     */
    default DeregisterResourceResponse deregisterResource(DeregisterResourceRequest deregisterResourceRequest)
            throws InvalidInputException, InternalServiceException, OperationTimeoutException, EntityNotFoundException,
            AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deregisters the resource as managed by the Data Catalog.
     * </p>
     * <p>
     * When you deregister a path, Lake Formation removes the path from the inline policy attached to your
     * service-linked role.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterResourceRequest.Builder} avoiding the
     * need to create one manually via {@link DeregisterResourceRequest#builder()}
     * </p>
     *
     * @param deregisterResourceRequest
     *        A {@link Consumer} that will call methods on {@link DeregisterResourceRequest.Builder} to create a
     *        request.
     * @return Result of the DeregisterResource operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.DeregisterResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/DeregisterResource"
     *      target="_top">AWS API Documentation</a>
     */
    default DeregisterResourceResponse deregisterResource(Consumer<DeregisterResourceRequest.Builder> deregisterResourceRequest)
            throws InvalidInputException, InternalServiceException, OperationTimeoutException, EntityNotFoundException,
            AwsServiceException, SdkClientException, LakeFormationException {
        return deregisterResource(DeregisterResourceRequest.builder().applyMutation(deregisterResourceRequest).build());
    }

    /**
     * <p>
     * Retrieves the current data access role for the given resource registered in AWS Lake Formation.
     * </p>
     *
     * @param describeResourceRequest
     * @return Result of the DescribeResource operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.DescribeResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/DescribeResource" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeResourceResponse describeResource(DescribeResourceRequest describeResourceRequest)
            throws InvalidInputException, InternalServiceException, OperationTimeoutException, EntityNotFoundException,
            AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the current data access role for the given resource registered in AWS Lake Formation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeResourceRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeResourceRequest#builder()}
     * </p>
     *
     * @param describeResourceRequest
     *        A {@link Consumer} that will call methods on {@link DescribeResourceRequest.Builder} to create a request.
     * @return Result of the DescribeResource operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.DescribeResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/DescribeResource" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeResourceResponse describeResource(Consumer<DescribeResourceRequest.Builder> describeResourceRequest)
            throws InvalidInputException, InternalServiceException, OperationTimeoutException, EntityNotFoundException,
            AwsServiceException, SdkClientException, LakeFormationException {
        return describeResource(DescribeResourceRequest.builder().applyMutation(describeResourceRequest).build());
    }

    /**
     * <p>
     * The AWS Lake Formation principal.
     * </p>
     *
     * @param getDataLakeSettingsRequest
     * @return Result of the GetDataLakeSettings operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.GetDataLakeSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetDataLakeSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDataLakeSettingsResponse getDataLakeSettings(GetDataLakeSettingsRequest getDataLakeSettingsRequest)
            throws InternalServiceException, InvalidInputException, EntityNotFoundException, AwsServiceException,
            SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The AWS Lake Formation principal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataLakeSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link GetDataLakeSettingsRequest#builder()}
     * </p>
     *
     * @param getDataLakeSettingsRequest
     *        A {@link Consumer} that will call methods on {@link GetDataLakeSettingsRequest.Builder} to create a
     *        request.
     * @return Result of the GetDataLakeSettings operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.GetDataLakeSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetDataLakeSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDataLakeSettingsResponse getDataLakeSettings(
            Consumer<GetDataLakeSettingsRequest.Builder> getDataLakeSettingsRequest) throws InternalServiceException,
            InvalidInputException, EntityNotFoundException, AwsServiceException, SdkClientException, LakeFormationException {
        return getDataLakeSettings(GetDataLakeSettingsRequest.builder().applyMutation(getDataLakeSettingsRequest).build());
    }

    /**
     * <p>
     * Returns the permissions for a specified table or database resource located at a path in Amazon S3.
     * </p>
     *
     * @param getEffectivePermissionsForPathRequest
     * @return Result of the GetEffectivePermissionsForPath operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.GetEffectivePermissionsForPath
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetEffectivePermissionsForPath"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEffectivePermissionsForPathResponse getEffectivePermissionsForPath(
            GetEffectivePermissionsForPathRequest getEffectivePermissionsForPathRequest) throws InvalidInputException,
            EntityNotFoundException, OperationTimeoutException, InternalServiceException, AwsServiceException,
            SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the permissions for a specified table or database resource located at a path in Amazon S3.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEffectivePermissionsForPathRequest.Builder}
     * avoiding the need to create one manually via {@link GetEffectivePermissionsForPathRequest#builder()}
     * </p>
     *
     * @param getEffectivePermissionsForPathRequest
     *        A {@link Consumer} that will call methods on {@link GetEffectivePermissionsForPathRequest.Builder} to
     *        create a request.
     * @return Result of the GetEffectivePermissionsForPath operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.GetEffectivePermissionsForPath
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetEffectivePermissionsForPath"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEffectivePermissionsForPathResponse getEffectivePermissionsForPath(
            Consumer<GetEffectivePermissionsForPathRequest.Builder> getEffectivePermissionsForPathRequest)
            throws InvalidInputException, EntityNotFoundException, OperationTimeoutException, InternalServiceException,
            AwsServiceException, SdkClientException, LakeFormationException {
        return getEffectivePermissionsForPath(GetEffectivePermissionsForPathRequest.builder()
                .applyMutation(getEffectivePermissionsForPathRequest).build());
    }

    /**
     * <p>
     * Returns the permissions for a specified table or database resource located at a path in Amazon S3.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getEffectivePermissionsForPath(software.amazon.awssdk.services.lakeformation.model.GetEffectivePermissionsForPathRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.GetEffectivePermissionsForPathIterable responses = client.getEffectivePermissionsForPathPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lakeformation.paginators.GetEffectivePermissionsForPathIterable responses = client
     *             .getEffectivePermissionsForPathPaginator(request);
     *     for (software.amazon.awssdk.services.lakeformation.model.GetEffectivePermissionsForPathResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.GetEffectivePermissionsForPathIterable responses = client.getEffectivePermissionsForPathPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getEffectivePermissionsForPath(software.amazon.awssdk.services.lakeformation.model.GetEffectivePermissionsForPathRequest)}
     * operation.</b>
     * </p>
     *
     * @param getEffectivePermissionsForPathRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.GetEffectivePermissionsForPath
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetEffectivePermissionsForPath"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEffectivePermissionsForPathIterable getEffectivePermissionsForPathPaginator(
            GetEffectivePermissionsForPathRequest getEffectivePermissionsForPathRequest) throws InvalidInputException,
            EntityNotFoundException, OperationTimeoutException, InternalServiceException, AwsServiceException,
            SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the permissions for a specified table or database resource located at a path in Amazon S3.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getEffectivePermissionsForPath(software.amazon.awssdk.services.lakeformation.model.GetEffectivePermissionsForPathRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.GetEffectivePermissionsForPathIterable responses = client.getEffectivePermissionsForPathPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lakeformation.paginators.GetEffectivePermissionsForPathIterable responses = client
     *             .getEffectivePermissionsForPathPaginator(request);
     *     for (software.amazon.awssdk.services.lakeformation.model.GetEffectivePermissionsForPathResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.GetEffectivePermissionsForPathIterable responses = client.getEffectivePermissionsForPathPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getEffectivePermissionsForPath(software.amazon.awssdk.services.lakeformation.model.GetEffectivePermissionsForPathRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEffectivePermissionsForPathRequest.Builder}
     * avoiding the need to create one manually via {@link GetEffectivePermissionsForPathRequest#builder()}
     * </p>
     *
     * @param getEffectivePermissionsForPathRequest
     *        A {@link Consumer} that will call methods on {@link GetEffectivePermissionsForPathRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.GetEffectivePermissionsForPath
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetEffectivePermissionsForPath"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEffectivePermissionsForPathIterable getEffectivePermissionsForPathPaginator(
            Consumer<GetEffectivePermissionsForPathRequest.Builder> getEffectivePermissionsForPathRequest)
            throws InvalidInputException, EntityNotFoundException, OperationTimeoutException, InternalServiceException,
            AwsServiceException, SdkClientException, LakeFormationException {
        return getEffectivePermissionsForPathPaginator(GetEffectivePermissionsForPathRequest.builder()
                .applyMutation(getEffectivePermissionsForPathRequest).build());
    }

    /**
     * <p>
     * Grants permissions to the principal to access metadata in the Data Catalog and data organized in underlying data
     * storage such as Amazon S3.
     * </p>
     * <p>
     * For information about permissions, see <a
     * href="https://docs-aws.amazon.com/michigan/latest/dg/security-data-access.html">Security and Access Control to
     * Metadata and Data</a>.
     * </p>
     *
     * @param grantPermissionsRequest
     * @return Result of the GrantPermissions operation returned by the service.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.GrantPermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GrantPermissions" target="_top">AWS
     *      API Documentation</a>
     */
    default GrantPermissionsResponse grantPermissions(GrantPermissionsRequest grantPermissionsRequest)
            throws ConcurrentModificationException, EntityNotFoundException, InvalidInputException, AwsServiceException,
            SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Grants permissions to the principal to access metadata in the Data Catalog and data organized in underlying data
     * storage such as Amazon S3.
     * </p>
     * <p>
     * For information about permissions, see <a
     * href="https://docs-aws.amazon.com/michigan/latest/dg/security-data-access.html">Security and Access Control to
     * Metadata and Data</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GrantPermissionsRequest.Builder} avoiding the need
     * to create one manually via {@link GrantPermissionsRequest#builder()}
     * </p>
     *
     * @param grantPermissionsRequest
     *        A {@link Consumer} that will call methods on {@link GrantPermissionsRequest.Builder} to create a request.
     * @return Result of the GrantPermissions operation returned by the service.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.GrantPermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GrantPermissions" target="_top">AWS
     *      API Documentation</a>
     */
    default GrantPermissionsResponse grantPermissions(Consumer<GrantPermissionsRequest.Builder> grantPermissionsRequest)
            throws ConcurrentModificationException, EntityNotFoundException, InvalidInputException, AwsServiceException,
            SdkClientException, LakeFormationException {
        return grantPermissions(GrantPermissionsRequest.builder().applyMutation(grantPermissionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the principal permissions on the resource, filtered by the permissions of the caller. For
     * example, if you are granted an ALTER permission, you are able to see only the principal permissions for ALTER.
     * </p>
     * <p>
     * This operation returns only those permissions that have been explicitly granted.
     * </p>
     * <p>
     * For information about permissions, see <a
     * href="https://docs-aws.amazon.com/michigan/latest/dg/security-data-access.html">Security and Access Control to
     * Metadata and Data</a>.
     * </p>
     *
     * @param listPermissionsRequest
     * @return Result of the ListPermissions operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.ListPermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListPermissions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPermissionsResponse listPermissions(ListPermissionsRequest listPermissionsRequest) throws InvalidInputException,
            OperationTimeoutException, InternalServiceException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the principal permissions on the resource, filtered by the permissions of the caller. For
     * example, if you are granted an ALTER permission, you are able to see only the principal permissions for ALTER.
     * </p>
     * <p>
     * This operation returns only those permissions that have been explicitly granted.
     * </p>
     * <p>
     * For information about permissions, see <a
     * href="https://docs-aws.amazon.com/michigan/latest/dg/security-data-access.html">Security and Access Control to
     * Metadata and Data</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPermissionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListPermissionsRequest#builder()}
     * </p>
     *
     * @param listPermissionsRequest
     *        A {@link Consumer} that will call methods on {@link ListPermissionsRequest.Builder} to create a request.
     * @return Result of the ListPermissions operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.ListPermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListPermissions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPermissionsResponse listPermissions(Consumer<ListPermissionsRequest.Builder> listPermissionsRequest)
            throws InvalidInputException, OperationTimeoutException, InternalServiceException, AwsServiceException,
            SdkClientException, LakeFormationException {
        return listPermissions(ListPermissionsRequest.builder().applyMutation(listPermissionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the principal permissions on the resource, filtered by the permissions of the caller. For
     * example, if you are granted an ALTER permission, you are able to see only the principal permissions for ALTER.
     * </p>
     * <p>
     * This operation returns only those permissions that have been explicitly granted.
     * </p>
     * <p>
     * For information about permissions, see <a
     * href="https://docs-aws.amazon.com/michigan/latest/dg/security-data-access.html">Security and Access Control to
     * Metadata and Data</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPermissions(software.amazon.awssdk.services.lakeformation.model.ListPermissionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.ListPermissionsIterable responses = client.listPermissionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lakeformation.paginators.ListPermissionsIterable responses = client
     *             .listPermissionsPaginator(request);
     *     for (software.amazon.awssdk.services.lakeformation.model.ListPermissionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.ListPermissionsIterable responses = client.listPermissionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPermissions(software.amazon.awssdk.services.lakeformation.model.ListPermissionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPermissionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.ListPermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListPermissions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPermissionsIterable listPermissionsPaginator(ListPermissionsRequest listPermissionsRequest)
            throws InvalidInputException, OperationTimeoutException, InternalServiceException, AwsServiceException,
            SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the principal permissions on the resource, filtered by the permissions of the caller. For
     * example, if you are granted an ALTER permission, you are able to see only the principal permissions for ALTER.
     * </p>
     * <p>
     * This operation returns only those permissions that have been explicitly granted.
     * </p>
     * <p>
     * For information about permissions, see <a
     * href="https://docs-aws.amazon.com/michigan/latest/dg/security-data-access.html">Security and Access Control to
     * Metadata and Data</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPermissions(software.amazon.awssdk.services.lakeformation.model.ListPermissionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.ListPermissionsIterable responses = client.listPermissionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lakeformation.paginators.ListPermissionsIterable responses = client
     *             .listPermissionsPaginator(request);
     *     for (software.amazon.awssdk.services.lakeformation.model.ListPermissionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.ListPermissionsIterable responses = client.listPermissionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPermissions(software.amazon.awssdk.services.lakeformation.model.ListPermissionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPermissionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListPermissionsRequest#builder()}
     * </p>
     *
     * @param listPermissionsRequest
     *        A {@link Consumer} that will call methods on {@link ListPermissionsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.ListPermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListPermissions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPermissionsIterable listPermissionsPaginator(Consumer<ListPermissionsRequest.Builder> listPermissionsRequest)
            throws InvalidInputException, OperationTimeoutException, InternalServiceException, AwsServiceException,
            SdkClientException, LakeFormationException {
        return listPermissionsPaginator(ListPermissionsRequest.builder().applyMutation(listPermissionsRequest).build());
    }

    /**
     * <p>
     * Lists the resources registered to be managed by the Data Catalog.
     * </p>
     *
     * @param listResourcesRequest
     * @return Result of the ListResources operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.ListResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListResources" target="_top">AWS
     *      API Documentation</a>
     */
    default ListResourcesResponse listResources(ListResourcesRequest listResourcesRequest) throws InvalidInputException,
            InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the resources registered to be managed by the Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourcesRequest.Builder} avoiding the need to
     * create one manually via {@link ListResourcesRequest#builder()}
     * </p>
     *
     * @param listResourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListResourcesRequest.Builder} to create a request.
     * @return Result of the ListResources operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.ListResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListResources" target="_top">AWS
     *      API Documentation</a>
     */
    default ListResourcesResponse listResources(Consumer<ListResourcesRequest.Builder> listResourcesRequest)
            throws InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException,
            SdkClientException, LakeFormationException {
        return listResources(ListResourcesRequest.builder().applyMutation(listResourcesRequest).build());
    }

    /**
     * <p>
     * Lists the resources registered to be managed by the Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResources(software.amazon.awssdk.services.lakeformation.model.ListResourcesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.ListResourcesIterable responses = client.listResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lakeformation.paginators.ListResourcesIterable responses = client
     *             .listResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.lakeformation.model.ListResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.ListResourcesIterable responses = client.listResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResources(software.amazon.awssdk.services.lakeformation.model.ListResourcesRequest)} operation.</b>
     * </p>
     *
     * @param listResourcesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.ListResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListResources" target="_top">AWS
     *      API Documentation</a>
     */
    default ListResourcesIterable listResourcesPaginator(ListResourcesRequest listResourcesRequest) throws InvalidInputException,
            InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the resources registered to be managed by the Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResources(software.amazon.awssdk.services.lakeformation.model.ListResourcesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.ListResourcesIterable responses = client.listResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lakeformation.paginators.ListResourcesIterable responses = client
     *             .listResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.lakeformation.model.ListResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.ListResourcesIterable responses = client.listResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResources(software.amazon.awssdk.services.lakeformation.model.ListResourcesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourcesRequest.Builder} avoiding the need to
     * create one manually via {@link ListResourcesRequest#builder()}
     * </p>
     *
     * @param listResourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListResourcesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.ListResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListResources" target="_top">AWS
     *      API Documentation</a>
     */
    default ListResourcesIterable listResourcesPaginator(Consumer<ListResourcesRequest.Builder> listResourcesRequest)
            throws InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException,
            SdkClientException, LakeFormationException {
        return listResourcesPaginator(ListResourcesRequest.builder().applyMutation(listResourcesRequest).build());
    }

    /**
     * <p>
     * The AWS Lake Formation principal.
     * </p>
     *
     * @param putDataLakeSettingsRequest
     * @return Result of the PutDataLakeSettings operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.PutDataLakeSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/PutDataLakeSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default PutDataLakeSettingsResponse putDataLakeSettings(PutDataLakeSettingsRequest putDataLakeSettingsRequest)
            throws InternalServiceException, InvalidInputException, AwsServiceException, SdkClientException,
            LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The AWS Lake Formation principal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutDataLakeSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link PutDataLakeSettingsRequest#builder()}
     * </p>
     *
     * @param putDataLakeSettingsRequest
     *        A {@link Consumer} that will call methods on {@link PutDataLakeSettingsRequest.Builder} to create a
     *        request.
     * @return Result of the PutDataLakeSettings operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.PutDataLakeSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/PutDataLakeSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default PutDataLakeSettingsResponse putDataLakeSettings(
            Consumer<PutDataLakeSettingsRequest.Builder> putDataLakeSettingsRequest) throws InternalServiceException,
            InvalidInputException, AwsServiceException, SdkClientException, LakeFormationException {
        return putDataLakeSettings(PutDataLakeSettingsRequest.builder().applyMutation(putDataLakeSettingsRequest).build());
    }

    /**
     * <p>
     * Registers the resource as managed by the Data Catalog.
     * </p>
     * <p>
     * To add or update data, Lake Formation needs read/write access to the chosen Amazon S3 path. Choose a role that
     * you know has permission to do this, or choose the AWSServiceRoleForLakeFormationDataAccess service-linked role.
     * When you register the first Amazon S3 path, the service-linked role and a new inline policy are created on your
     * behalf. Lake Formation adds the first path to the inline policy and attaches it to the service-linked role. When
     * you register subsequent paths, Lake Formation adds the path to the existing policy.
     * </p>
     *
     * @param registerResourceRequest
     * @return Result of the RegisterResource operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.RegisterResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/RegisterResource" target="_top">AWS
     *      API Documentation</a>
     */
    default RegisterResourceResponse registerResource(RegisterResourceRequest registerResourceRequest)
            throws InvalidInputException, InternalServiceException, OperationTimeoutException, AlreadyExistsException,
            AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers the resource as managed by the Data Catalog.
     * </p>
     * <p>
     * To add or update data, Lake Formation needs read/write access to the chosen Amazon S3 path. Choose a role that
     * you know has permission to do this, or choose the AWSServiceRoleForLakeFormationDataAccess service-linked role.
     * When you register the first Amazon S3 path, the service-linked role and a new inline policy are created on your
     * behalf. Lake Formation adds the first path to the inline policy and attaches it to the service-linked role. When
     * you register subsequent paths, Lake Formation adds the path to the existing policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterResourceRequest.Builder} avoiding the need
     * to create one manually via {@link RegisterResourceRequest#builder()}
     * </p>
     *
     * @param registerResourceRequest
     *        A {@link Consumer} that will call methods on {@link RegisterResourceRequest.Builder} to create a request.
     * @return Result of the RegisterResource operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.RegisterResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/RegisterResource" target="_top">AWS
     *      API Documentation</a>
     */
    default RegisterResourceResponse registerResource(Consumer<RegisterResourceRequest.Builder> registerResourceRequest)
            throws InvalidInputException, InternalServiceException, OperationTimeoutException, AlreadyExistsException,
            AwsServiceException, SdkClientException, LakeFormationException {
        return registerResource(RegisterResourceRequest.builder().applyMutation(registerResourceRequest).build());
    }

    /**
     * <p>
     * Revokes permissions to the principal to access metadata in the Data Catalog and data organized in underlying data
     * storage such as Amazon S3.
     * </p>
     *
     * @param revokePermissionsRequest
     * @return Result of the RevokePermissions operation returned by the service.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.RevokePermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/RevokePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default RevokePermissionsResponse revokePermissions(RevokePermissionsRequest revokePermissionsRequest)
            throws ConcurrentModificationException, EntityNotFoundException, InvalidInputException, AwsServiceException,
            SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Revokes permissions to the principal to access metadata in the Data Catalog and data organized in underlying data
     * storage such as Amazon S3.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RevokePermissionsRequest.Builder} avoiding the need
     * to create one manually via {@link RevokePermissionsRequest#builder()}
     * </p>
     *
     * @param revokePermissionsRequest
     *        A {@link Consumer} that will call methods on {@link RevokePermissionsRequest.Builder} to create a request.
     * @return Result of the RevokePermissions operation returned by the service.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.RevokePermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/RevokePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default RevokePermissionsResponse revokePermissions(Consumer<RevokePermissionsRequest.Builder> revokePermissionsRequest)
            throws ConcurrentModificationException, EntityNotFoundException, InvalidInputException, AwsServiceException,
            SdkClientException, LakeFormationException {
        return revokePermissions(RevokePermissionsRequest.builder().applyMutation(revokePermissionsRequest).build());
    }

    /**
     * <p>
     * Updates the data access role used for vending access to the given (registered) resource in AWS Lake Formation.
     * </p>
     *
     * @param updateResourceRequest
     * @return Result of the UpdateResource operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.UpdateResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/UpdateResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateResourceResponse updateResource(UpdateResourceRequest updateResourceRequest) throws InvalidInputException,
            InternalServiceException, OperationTimeoutException, EntityNotFoundException, AwsServiceException,
            SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the data access role used for vending access to the given (registered) resource in AWS Lake Formation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateResourceRequest#builder()}
     * </p>
     *
     * @param updateResourceRequest
     *        A {@link Consumer} that will call methods on {@link UpdateResourceRequest.Builder} to create a request.
     * @return Result of the UpdateResource operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.UpdateResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/UpdateResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateResourceResponse updateResource(Consumer<UpdateResourceRequest.Builder> updateResourceRequest)
            throws InvalidInputException, InternalServiceException, OperationTimeoutException, EntityNotFoundException,
            AwsServiceException, SdkClientException, LakeFormationException {
        return updateResource(UpdateResourceRequest.builder().applyMutation(updateResourceRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("lakeformation");
    }
}
