/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGrantPermissionsResponse extends LakeFormationResponse implements
        ToCopyableBuilder<BatchGrantPermissionsResponse.Builder, BatchGrantPermissionsResponse> {
    private static final SdkField<List<BatchPermissionsFailureEntry>> FAILURES_FIELD = SdkField
            .<List<BatchPermissionsFailureEntry>> builder(MarshallingType.LIST)
            .getter(getter(BatchGrantPermissionsResponse::failures))
            .setter(setter(Builder::failures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Failures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchPermissionsFailureEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchPermissionsFailureEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILURES_FIELD));

    private final List<BatchPermissionsFailureEntry> failures;

    private BatchGrantPermissionsResponse(BuilderImpl builder) {
        super(builder);
        this.failures = builder.failures;
    }

    /**
     * <p>
     * A list of failures to grant permissions to the resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of failures to grant permissions to the resources.
     */
    public List<BatchPermissionsFailureEntry> failures() {
        return failures;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(failures());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGrantPermissionsResponse)) {
            return false;
        }
        BatchGrantPermissionsResponse other = (BatchGrantPermissionsResponse) obj;
        return Objects.equals(failures(), other.failures());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchGrantPermissionsResponse").add("Failures", failures()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Failures":
            return Optional.ofNullable(clazz.cast(failures()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGrantPermissionsResponse, T> g) {
        return obj -> g.apply((BatchGrantPermissionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LakeFormationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGrantPermissionsResponse> {
        /**
         * <p>
         * A list of failures to grant permissions to the resources.
         * </p>
         * 
         * @param failures
         *        A list of failures to grant permissions to the resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failures(Collection<BatchPermissionsFailureEntry> failures);

        /**
         * <p>
         * A list of failures to grant permissions to the resources.
         * </p>
         * 
         * @param failures
         *        A list of failures to grant permissions to the resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failures(BatchPermissionsFailureEntry... failures);

        /**
         * <p>
         * A list of failures to grant permissions to the resources.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BatchPermissionsFailureEntry>.Builder}
         * avoiding the need to create one manually via {@link List<BatchPermissionsFailureEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BatchPermissionsFailureEntry>.Builder#build()} is called
         * immediately and its result is passed to {@link #failures(List<BatchPermissionsFailureEntry>)}.
         * 
         * @param failures
         *        a consumer that will call methods on {@link List<BatchPermissionsFailureEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failures(List<BatchPermissionsFailureEntry>)
         */
        Builder failures(Consumer<BatchPermissionsFailureEntry.Builder>... failures);
    }

    static final class BuilderImpl extends LakeFormationResponse.BuilderImpl implements Builder {
        private List<BatchPermissionsFailureEntry> failures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGrantPermissionsResponse model) {
            super(model);
            failures(model.failures);
        }

        public final Collection<BatchPermissionsFailureEntry.Builder> getFailures() {
            return failures != null ? failures.stream().map(BatchPermissionsFailureEntry::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder failures(Collection<BatchPermissionsFailureEntry> failures) {
            this.failures = BatchPermissionsFailureListCopier.copy(failures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(BatchPermissionsFailureEntry... failures) {
            failures(Arrays.asList(failures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Consumer<BatchPermissionsFailureEntry.Builder>... failures) {
            failures(Stream.of(failures).map(c -> BatchPermissionsFailureEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFailures(Collection<BatchPermissionsFailureEntry.BuilderImpl> failures) {
            this.failures = BatchPermissionsFailureListCopier.copyFromBuilder(failures);
        }

        @Override
        public BatchGrantPermissionsResponse build() {
            return new BatchGrantPermissionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
