/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure representing a list of AWS Lake Formation principals designated as data lake administrators and lists of
 * principal permission entries for default create database and default create table permissions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataLakeSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<DataLakeSettings.Builder, DataLakeSettings> {
    private static final SdkField<List<DataLakePrincipal>> DATA_LAKE_ADMINS_FIELD = SdkField
            .<List<DataLakePrincipal>> builder(MarshallingType.LIST)
            .getter(getter(DataLakeSettings::dataLakeAdmins))
            .setter(setter(Builder::dataLakeAdmins))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataLakeAdmins").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataLakePrincipal> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataLakePrincipal::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<PrincipalPermissions>> CREATE_DATABASE_DEFAULT_PERMISSIONS_FIELD = SdkField
            .<List<PrincipalPermissions>> builder(MarshallingType.LIST)
            .getter(getter(DataLakeSettings::createDatabaseDefaultPermissions))
            .setter(setter(Builder::createDatabaseDefaultPermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDatabaseDefaultPermissions")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PrincipalPermissions> builder(MarshallingType.SDK_POJO)
                                            .constructor(PrincipalPermissions::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<PrincipalPermissions>> CREATE_TABLE_DEFAULT_PERMISSIONS_FIELD = SdkField
            .<List<PrincipalPermissions>> builder(MarshallingType.LIST)
            .getter(getter(DataLakeSettings::createTableDefaultPermissions))
            .setter(setter(Builder::createTableDefaultPermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTableDefaultPermissions")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PrincipalPermissions> builder(MarshallingType.SDK_POJO)
                                            .constructor(PrincipalPermissions::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> TRUSTED_RESOURCE_OWNERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DataLakeSettings::trustedResourceOwners))
            .setter(setter(Builder::trustedResourceOwners))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustedResourceOwners").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_LAKE_ADMINS_FIELD,
            CREATE_DATABASE_DEFAULT_PERMISSIONS_FIELD, CREATE_TABLE_DEFAULT_PERMISSIONS_FIELD, TRUSTED_RESOURCE_OWNERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<DataLakePrincipal> dataLakeAdmins;

    private final List<PrincipalPermissions> createDatabaseDefaultPermissions;

    private final List<PrincipalPermissions> createTableDefaultPermissions;

    private final List<String> trustedResourceOwners;

    private DataLakeSettings(BuilderImpl builder) {
        this.dataLakeAdmins = builder.dataLakeAdmins;
        this.createDatabaseDefaultPermissions = builder.createDatabaseDefaultPermissions;
        this.createTableDefaultPermissions = builder.createTableDefaultPermissions;
        this.trustedResourceOwners = builder.trustedResourceOwners;
    }

    /**
     * Returns true if the DataLakeAdmins property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasDataLakeAdmins() {
        return dataLakeAdmins != null && !(dataLakeAdmins instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of AWS Lake Formation principals. Supported principals are IAM users or IAM roles.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDataLakeAdmins()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of AWS Lake Formation principals. Supported principals are IAM users or IAM roles.
     */
    public List<DataLakePrincipal> dataLakeAdmins() {
        return dataLakeAdmins;
    }

    /**
     * Returns true if the CreateDatabaseDefaultPermissions property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasCreateDatabaseDefaultPermissions() {
        return createDatabaseDefaultPermissions != null && !(createDatabaseDefaultPermissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A structure representing a list of up to three principal permissions entries for default create database
     * permissions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCreateDatabaseDefaultPermissions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A structure representing a list of up to three principal permissions entries for default create database
     *         permissions.
     */
    public List<PrincipalPermissions> createDatabaseDefaultPermissions() {
        return createDatabaseDefaultPermissions;
    }

    /**
     * Returns true if the CreateTableDefaultPermissions property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasCreateTableDefaultPermissions() {
        return createTableDefaultPermissions != null && !(createTableDefaultPermissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A structure representing a list of up to three principal permissions entries for default create table
     * permissions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCreateTableDefaultPermissions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A structure representing a list of up to three principal permissions entries for default create table
     *         permissions.
     */
    public List<PrincipalPermissions> createTableDefaultPermissions() {
        return createTableDefaultPermissions;
    }

    /**
     * Returns true if the TrustedResourceOwners property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasTrustedResourceOwners() {
        return trustedResourceOwners != null && !(trustedResourceOwners instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the resource-owning account IDs that the caller's account can use to share their user access details
     * (user ARNs). The user ARNs can be logged in the resource owner's AWS CloudTrail log.
     * </p>
     * <p>
     * You may want to specify this property when you are in a high-trust boundary, such as the same team or company.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTrustedResourceOwners()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the resource-owning account IDs that the caller's account can use to share their user access
     *         details (user ARNs). The user ARNs can be logged in the resource owner's AWS CloudTrail log.</p>
     *         <p>
     *         You may want to specify this property when you are in a high-trust boundary, such as the same team or
     *         company.
     */
    public List<String> trustedResourceOwners() {
        return trustedResourceOwners;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataLakeAdmins());
        hashCode = 31 * hashCode + Objects.hashCode(createDatabaseDefaultPermissions());
        hashCode = 31 * hashCode + Objects.hashCode(createTableDefaultPermissions());
        hashCode = 31 * hashCode + Objects.hashCode(trustedResourceOwners());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataLakeSettings)) {
            return false;
        }
        DataLakeSettings other = (DataLakeSettings) obj;
        return Objects.equals(dataLakeAdmins(), other.dataLakeAdmins())
                && Objects.equals(createDatabaseDefaultPermissions(), other.createDatabaseDefaultPermissions())
                && Objects.equals(createTableDefaultPermissions(), other.createTableDefaultPermissions())
                && Objects.equals(trustedResourceOwners(), other.trustedResourceOwners());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DataLakeSettings").add("DataLakeAdmins", dataLakeAdmins())
                .add("CreateDatabaseDefaultPermissions", createDatabaseDefaultPermissions())
                .add("CreateTableDefaultPermissions", createTableDefaultPermissions())
                .add("TrustedResourceOwners", trustedResourceOwners()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataLakeAdmins":
            return Optional.ofNullable(clazz.cast(dataLakeAdmins()));
        case "CreateDatabaseDefaultPermissions":
            return Optional.ofNullable(clazz.cast(createDatabaseDefaultPermissions()));
        case "CreateTableDefaultPermissions":
            return Optional.ofNullable(clazz.cast(createTableDefaultPermissions()));
        case "TrustedResourceOwners":
            return Optional.ofNullable(clazz.cast(trustedResourceOwners()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataLakeSettings, T> g) {
        return obj -> g.apply((DataLakeSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataLakeSettings> {
        /**
         * <p>
         * A list of AWS Lake Formation principals. Supported principals are IAM users or IAM roles.
         * </p>
         * 
         * @param dataLakeAdmins
         *        A list of AWS Lake Formation principals. Supported principals are IAM users or IAM roles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataLakeAdmins(Collection<DataLakePrincipal> dataLakeAdmins);

        /**
         * <p>
         * A list of AWS Lake Formation principals. Supported principals are IAM users or IAM roles.
         * </p>
         * 
         * @param dataLakeAdmins
         *        A list of AWS Lake Formation principals. Supported principals are IAM users or IAM roles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataLakeAdmins(DataLakePrincipal... dataLakeAdmins);

        /**
         * <p>
         * A list of AWS Lake Formation principals. Supported principals are IAM users or IAM roles.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DataLakePrincipal>.Builder} avoiding the
         * need to create one manually via {@link List<DataLakePrincipal>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DataLakePrincipal>.Builder#build()} is called immediately
         * and its result is passed to {@link #dataLakeAdmins(List<DataLakePrincipal>)}.
         * 
         * @param dataLakeAdmins
         *        a consumer that will call methods on {@link List<DataLakePrincipal>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataLakeAdmins(List<DataLakePrincipal>)
         */
        Builder dataLakeAdmins(Consumer<DataLakePrincipal.Builder>... dataLakeAdmins);

        /**
         * <p>
         * A structure representing a list of up to three principal permissions entries for default create database
         * permissions.
         * </p>
         * 
         * @param createDatabaseDefaultPermissions
         *        A structure representing a list of up to three principal permissions entries for default create
         *        database permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDatabaseDefaultPermissions(Collection<PrincipalPermissions> createDatabaseDefaultPermissions);

        /**
         * <p>
         * A structure representing a list of up to three principal permissions entries for default create database
         * permissions.
         * </p>
         * 
         * @param createDatabaseDefaultPermissions
         *        A structure representing a list of up to three principal permissions entries for default create
         *        database permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDatabaseDefaultPermissions(PrincipalPermissions... createDatabaseDefaultPermissions);

        /**
         * <p>
         * A structure representing a list of up to three principal permissions entries for default create database
         * permissions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PrincipalPermissions>.Builder} avoiding the
         * need to create one manually via {@link List<PrincipalPermissions>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PrincipalPermissions>.Builder#build()} is called immediately
         * and its result is passed to {@link #createDatabaseDefaultPermissions(List<PrincipalPermissions>)}.
         * 
         * @param createDatabaseDefaultPermissions
         *        a consumer that will call methods on {@link List<PrincipalPermissions>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createDatabaseDefaultPermissions(List<PrincipalPermissions>)
         */
        Builder createDatabaseDefaultPermissions(Consumer<PrincipalPermissions.Builder>... createDatabaseDefaultPermissions);

        /**
         * <p>
         * A structure representing a list of up to three principal permissions entries for default create table
         * permissions.
         * </p>
         * 
         * @param createTableDefaultPermissions
         *        A structure representing a list of up to three principal permissions entries for default create table
         *        permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTableDefaultPermissions(Collection<PrincipalPermissions> createTableDefaultPermissions);

        /**
         * <p>
         * A structure representing a list of up to three principal permissions entries for default create table
         * permissions.
         * </p>
         * 
         * @param createTableDefaultPermissions
         *        A structure representing a list of up to three principal permissions entries for default create table
         *        permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTableDefaultPermissions(PrincipalPermissions... createTableDefaultPermissions);

        /**
         * <p>
         * A structure representing a list of up to three principal permissions entries for default create table
         * permissions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PrincipalPermissions>.Builder} avoiding the
         * need to create one manually via {@link List<PrincipalPermissions>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PrincipalPermissions>.Builder#build()} is called immediately
         * and its result is passed to {@link #createTableDefaultPermissions(List<PrincipalPermissions>)}.
         * 
         * @param createTableDefaultPermissions
         *        a consumer that will call methods on {@link List<PrincipalPermissions>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createTableDefaultPermissions(List<PrincipalPermissions>)
         */
        Builder createTableDefaultPermissions(Consumer<PrincipalPermissions.Builder>... createTableDefaultPermissions);

        /**
         * <p>
         * A list of the resource-owning account IDs that the caller's account can use to share their user access
         * details (user ARNs). The user ARNs can be logged in the resource owner's AWS CloudTrail log.
         * </p>
         * <p>
         * You may want to specify this property when you are in a high-trust boundary, such as the same team or
         * company.
         * </p>
         * 
         * @param trustedResourceOwners
         *        A list of the resource-owning account IDs that the caller's account can use to share their user access
         *        details (user ARNs). The user ARNs can be logged in the resource owner's AWS CloudTrail log.</p>
         *        <p>
         *        You may want to specify this property when you are in a high-trust boundary, such as the same team or
         *        company.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustedResourceOwners(Collection<String> trustedResourceOwners);

        /**
         * <p>
         * A list of the resource-owning account IDs that the caller's account can use to share their user access
         * details (user ARNs). The user ARNs can be logged in the resource owner's AWS CloudTrail log.
         * </p>
         * <p>
         * You may want to specify this property when you are in a high-trust boundary, such as the same team or
         * company.
         * </p>
         * 
         * @param trustedResourceOwners
         *        A list of the resource-owning account IDs that the caller's account can use to share their user access
         *        details (user ARNs). The user ARNs can be logged in the resource owner's AWS CloudTrail log.</p>
         *        <p>
         *        You may want to specify this property when you are in a high-trust boundary, such as the same team or
         *        company.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustedResourceOwners(String... trustedResourceOwners);
    }

    static final class BuilderImpl implements Builder {
        private List<DataLakePrincipal> dataLakeAdmins = DefaultSdkAutoConstructList.getInstance();

        private List<PrincipalPermissions> createDatabaseDefaultPermissions = DefaultSdkAutoConstructList.getInstance();

        private List<PrincipalPermissions> createTableDefaultPermissions = DefaultSdkAutoConstructList.getInstance();

        private List<String> trustedResourceOwners = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DataLakeSettings model) {
            dataLakeAdmins(model.dataLakeAdmins);
            createDatabaseDefaultPermissions(model.createDatabaseDefaultPermissions);
            createTableDefaultPermissions(model.createTableDefaultPermissions);
            trustedResourceOwners(model.trustedResourceOwners);
        }

        public final Collection<DataLakePrincipal.Builder> getDataLakeAdmins() {
            return dataLakeAdmins != null ? dataLakeAdmins.stream().map(DataLakePrincipal::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dataLakeAdmins(Collection<DataLakePrincipal> dataLakeAdmins) {
            this.dataLakeAdmins = DataLakePrincipalListCopier.copy(dataLakeAdmins);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataLakeAdmins(DataLakePrincipal... dataLakeAdmins) {
            dataLakeAdmins(Arrays.asList(dataLakeAdmins));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataLakeAdmins(Consumer<DataLakePrincipal.Builder>... dataLakeAdmins) {
            dataLakeAdmins(Stream.of(dataLakeAdmins).map(c -> DataLakePrincipal.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDataLakeAdmins(Collection<DataLakePrincipal.BuilderImpl> dataLakeAdmins) {
            this.dataLakeAdmins = DataLakePrincipalListCopier.copyFromBuilder(dataLakeAdmins);
        }

        public final Collection<PrincipalPermissions.Builder> getCreateDatabaseDefaultPermissions() {
            return createDatabaseDefaultPermissions != null ? createDatabaseDefaultPermissions.stream()
                    .map(PrincipalPermissions::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder createDatabaseDefaultPermissions(Collection<PrincipalPermissions> createDatabaseDefaultPermissions) {
            this.createDatabaseDefaultPermissions = PrincipalPermissionsListCopier.copy(createDatabaseDefaultPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createDatabaseDefaultPermissions(PrincipalPermissions... createDatabaseDefaultPermissions) {
            createDatabaseDefaultPermissions(Arrays.asList(createDatabaseDefaultPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createDatabaseDefaultPermissions(
                Consumer<PrincipalPermissions.Builder>... createDatabaseDefaultPermissions) {
            createDatabaseDefaultPermissions(Stream.of(createDatabaseDefaultPermissions)
                    .map(c -> PrincipalPermissions.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCreateDatabaseDefaultPermissions(
                Collection<PrincipalPermissions.BuilderImpl> createDatabaseDefaultPermissions) {
            this.createDatabaseDefaultPermissions = PrincipalPermissionsListCopier
                    .copyFromBuilder(createDatabaseDefaultPermissions);
        }

        public final Collection<PrincipalPermissions.Builder> getCreateTableDefaultPermissions() {
            return createTableDefaultPermissions != null ? createTableDefaultPermissions.stream()
                    .map(PrincipalPermissions::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder createTableDefaultPermissions(Collection<PrincipalPermissions> createTableDefaultPermissions) {
            this.createTableDefaultPermissions = PrincipalPermissionsListCopier.copy(createTableDefaultPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createTableDefaultPermissions(PrincipalPermissions... createTableDefaultPermissions) {
            createTableDefaultPermissions(Arrays.asList(createTableDefaultPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createTableDefaultPermissions(
                Consumer<PrincipalPermissions.Builder>... createTableDefaultPermissions) {
            createTableDefaultPermissions(Stream.of(createTableDefaultPermissions)
                    .map(c -> PrincipalPermissions.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCreateTableDefaultPermissions(
                Collection<PrincipalPermissions.BuilderImpl> createTableDefaultPermissions) {
            this.createTableDefaultPermissions = PrincipalPermissionsListCopier.copyFromBuilder(createTableDefaultPermissions);
        }

        public final Collection<String> getTrustedResourceOwners() {
            return trustedResourceOwners;
        }

        @Override
        public final Builder trustedResourceOwners(Collection<String> trustedResourceOwners) {
            this.trustedResourceOwners = TrustedResourceOwnersCopier.copy(trustedResourceOwners);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trustedResourceOwners(String... trustedResourceOwners) {
            trustedResourceOwners(Arrays.asList(trustedResourceOwners));
            return this;
        }

        public final void setTrustedResourceOwners(Collection<String> trustedResourceOwners) {
            this.trustedResourceOwners = TrustedResourceOwnersCopier.copy(trustedResourceOwners);
        }

        @Override
        public DataLakeSettings build() {
            return new DataLakeSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
