/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GrantPermissionsRequest extends LakeFormationRequest implements
        ToCopyableBuilder<GrantPermissionsRequest.Builder, GrantPermissionsRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GrantPermissionsRequest::catalogId)).setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<DataLakePrincipal> PRINCIPAL_FIELD = SdkField
            .<DataLakePrincipal> builder(MarshallingType.SDK_POJO).getter(getter(GrantPermissionsRequest::principal))
            .setter(setter(Builder::principal)).constructor(DataLakePrincipal::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Principal").build()).build();

    private static final SdkField<Resource> RESOURCE_FIELD = SdkField.<Resource> builder(MarshallingType.SDK_POJO)
            .getter(getter(GrantPermissionsRequest::resource)).setter(setter(Builder::resource)).constructor(Resource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resource").build()).build();

    private static final SdkField<List<String>> PERMISSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(GrantPermissionsRequest::permissionsAsStrings))
            .setter(setter(Builder::permissionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PERMISSIONS_WITH_GRANT_OPTION_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(GrantPermissionsRequest::permissionsWithGrantOptionAsStrings))
            .setter(setter(Builder::permissionsWithGrantOptionWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionsWithGrantOption").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD,
            PRINCIPAL_FIELD, RESOURCE_FIELD, PERMISSIONS_FIELD, PERMISSIONS_WITH_GRANT_OPTION_FIELD));

    private final String catalogId;

    private final DataLakePrincipal principal;

    private final Resource resource;

    private final List<String> permissions;

    private final List<String> permissionsWithGrantOption;

    private GrantPermissionsRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.principal = builder.principal;
        this.resource = builder.resource;
        this.permissions = builder.permissions;
        this.permissionsWithGrantOption = builder.permissionsWithGrantOption;
    }

    /**
     * <p>
     * The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata
     * store. It contains database definitions, table definitions, and other control information to manage your AWS Lake
     * Formation environment.
     * </p>
     * 
     * @return The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent
     *         metadata store. It contains database definitions, table definitions, and other control information to
     *         manage your AWS Lake Formation environment.
     */
    public String catalogId() {
        return catalogId;
    }

    /**
     * <p>
     * The principal to be granted the permissions on the resource. Supported principals are IAM users or IAM roles, and
     * they are defined by their principal type and their ARN.
     * </p>
     * <p>
     * Note that if you define a resource with a particular ARN, then later delete, and recreate a resource with that
     * same ARN, the resource maintains the permissions already granted.
     * </p>
     * 
     * @return The principal to be granted the permissions on the resource. Supported principals are IAM users or IAM
     *         roles, and they are defined by their principal type and their ARN.</p>
     *         <p>
     *         Note that if you define a resource with a particular ARN, then later delete, and recreate a resource with
     *         that same ARN, the resource maintains the permissions already granted.
     */
    public DataLakePrincipal principal() {
        return principal;
    }

    /**
     * <p>
     * The resource to which permissions are to be granted. Resources in AWS Lake Formation are the Data Catalog,
     * databases, and tables.
     * </p>
     * 
     * @return The resource to which permissions are to be granted. Resources in AWS Lake Formation are the Data
     *         Catalog, databases, and tables.
     */
    public Resource resource() {
        return resource;
    }

    /**
     * <p>
     * The permissions granted to the principal on the resource. AWS Lake Formation defines privileges to grant and
     * revoke access to metadata in the Data Catalog and data organized in underlying data storage such as Amazon S3.
     * AWS Lake Formation requires that each principal be authorized to perform a specific task on AWS Lake Formation
     * resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPermissions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The permissions granted to the principal on the resource. AWS Lake Formation defines privileges to grant
     *         and revoke access to metadata in the Data Catalog and data organized in underlying data storage such as
     *         Amazon S3. AWS Lake Formation requires that each principal be authorized to perform a specific task on
     *         AWS Lake Formation resources.
     */
    public List<Permission> permissions() {
        return PermissionListCopier.copyStringToEnum(permissions);
    }

    /**
     * Returns true if the Permissions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasPermissions() {
        return permissions != null && !(permissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The permissions granted to the principal on the resource. AWS Lake Formation defines privileges to grant and
     * revoke access to metadata in the Data Catalog and data organized in underlying data storage such as Amazon S3.
     * AWS Lake Formation requires that each principal be authorized to perform a specific task on AWS Lake Formation
     * resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPermissions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The permissions granted to the principal on the resource. AWS Lake Formation defines privileges to grant
     *         and revoke access to metadata in the Data Catalog and data organized in underlying data storage such as
     *         Amazon S3. AWS Lake Formation requires that each principal be authorized to perform a specific task on
     *         AWS Lake Formation resources.
     */
    public List<String> permissionsAsStrings() {
        return permissions;
    }

    /**
     * <p>
     * Indicates a list of the granted permissions that the principal may pass to other users. These permissions may
     * only be a subset of the permissions granted in the <code>Privileges</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPermissionsWithGrantOption()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Indicates a list of the granted permissions that the principal may pass to other users. These permissions
     *         may only be a subset of the permissions granted in the <code>Privileges</code>.
     */
    public List<Permission> permissionsWithGrantOption() {
        return PermissionListCopier.copyStringToEnum(permissionsWithGrantOption);
    }

    /**
     * Returns true if the PermissionsWithGrantOption property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasPermissionsWithGrantOption() {
        return permissionsWithGrantOption != null && !(permissionsWithGrantOption instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates a list of the granted permissions that the principal may pass to other users. These permissions may
     * only be a subset of the permissions granted in the <code>Privileges</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPermissionsWithGrantOption()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Indicates a list of the granted permissions that the principal may pass to other users. These permissions
     *         may only be a subset of the permissions granted in the <code>Privileges</code>.
     */
    public List<String> permissionsWithGrantOptionAsStrings() {
        return permissionsWithGrantOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(principal());
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        hashCode = 31 * hashCode + Objects.hashCode(permissionsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(permissionsWithGrantOptionAsStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GrantPermissionsRequest)) {
            return false;
        }
        GrantPermissionsRequest other = (GrantPermissionsRequest) obj;
        return Objects.equals(catalogId(), other.catalogId()) && Objects.equals(principal(), other.principal())
                && Objects.equals(resource(), other.resource())
                && Objects.equals(permissionsAsStrings(), other.permissionsAsStrings())
                && Objects.equals(permissionsWithGrantOptionAsStrings(), other.permissionsWithGrantOptionAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GrantPermissionsRequest").add("CatalogId", catalogId()).add("Principal", principal())
                .add("Resource", resource()).add("Permissions", permissionsAsStrings())
                .add("PermissionsWithGrantOption", permissionsWithGrantOptionAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "Principal":
            return Optional.ofNullable(clazz.cast(principal()));
        case "Resource":
            return Optional.ofNullable(clazz.cast(resource()));
        case "Permissions":
            return Optional.ofNullable(clazz.cast(permissionsAsStrings()));
        case "PermissionsWithGrantOption":
            return Optional.ofNullable(clazz.cast(permissionsWithGrantOptionAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GrantPermissionsRequest, T> g) {
        return obj -> g.apply((GrantPermissionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LakeFormationRequest.Builder, SdkPojo, CopyableBuilder<Builder, GrantPermissionsRequest> {
        /**
         * <p>
         * The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata
         * store. It contains database definitions, table definitions, and other control information to manage your AWS
         * Lake Formation environment.
         * </p>
         * 
         * @param catalogId
         *        The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent
         *        metadata store. It contains database definitions, table definitions, and other control information to
         *        manage your AWS Lake Formation environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * The principal to be granted the permissions on the resource. Supported principals are IAM users or IAM roles,
         * and they are defined by their principal type and their ARN.
         * </p>
         * <p>
         * Note that if you define a resource with a particular ARN, then later delete, and recreate a resource with
         * that same ARN, the resource maintains the permissions already granted.
         * </p>
         * 
         * @param principal
         *        The principal to be granted the permissions on the resource. Supported principals are IAM users or IAM
         *        roles, and they are defined by their principal type and their ARN.</p>
         *        <p>
         *        Note that if you define a resource with a particular ARN, then later delete, and recreate a resource
         *        with that same ARN, the resource maintains the permissions already granted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principal(DataLakePrincipal principal);

        /**
         * <p>
         * The principal to be granted the permissions on the resource. Supported principals are IAM users or IAM roles,
         * and they are defined by their principal type and their ARN.
         * </p>
         * <p>
         * Note that if you define a resource with a particular ARN, then later delete, and recreate a resource with
         * that same ARN, the resource maintains the permissions already granted.
         * </p>
         * This is a convenience that creates an instance of the {@link DataLakePrincipal.Builder} avoiding the need to
         * create one manually via {@link DataLakePrincipal#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataLakePrincipal.Builder#build()} is called immediately and its
         * result is passed to {@link #principal(DataLakePrincipal)}.
         * 
         * @param principal
         *        a consumer that will call methods on {@link DataLakePrincipal.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #principal(DataLakePrincipal)
         */
        default Builder principal(Consumer<DataLakePrincipal.Builder> principal) {
            return principal(DataLakePrincipal.builder().applyMutation(principal).build());
        }

        /**
         * <p>
         * The resource to which permissions are to be granted. Resources in AWS Lake Formation are the Data Catalog,
         * databases, and tables.
         * </p>
         * 
         * @param resource
         *        The resource to which permissions are to be granted. Resources in AWS Lake Formation are the Data
         *        Catalog, databases, and tables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(Resource resource);

        /**
         * <p>
         * The resource to which permissions are to be granted. Resources in AWS Lake Formation are the Data Catalog,
         * databases, and tables.
         * </p>
         * This is a convenience that creates an instance of the {@link Resource.Builder} avoiding the need to create
         * one manually via {@link Resource#builder()}.
         *
         * When the {@link Consumer} completes, {@link Resource.Builder#build()} is called immediately and its result is
         * passed to {@link #resource(Resource)}.
         * 
         * @param resource
         *        a consumer that will call methods on {@link Resource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resource(Resource)
         */
        default Builder resource(Consumer<Resource.Builder> resource) {
            return resource(Resource.builder().applyMutation(resource).build());
        }

        /**
         * <p>
         * The permissions granted to the principal on the resource. AWS Lake Formation defines privileges to grant and
         * revoke access to metadata in the Data Catalog and data organized in underlying data storage such as Amazon
         * S3. AWS Lake Formation requires that each principal be authorized to perform a specific task on AWS Lake
         * Formation resources.
         * </p>
         * 
         * @param permissions
         *        The permissions granted to the principal on the resource. AWS Lake Formation defines privileges to
         *        grant and revoke access to metadata in the Data Catalog and data organized in underlying data storage
         *        such as Amazon S3. AWS Lake Formation requires that each principal be authorized to perform a specific
         *        task on AWS Lake Formation resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsWithStrings(Collection<String> permissions);

        /**
         * <p>
         * The permissions granted to the principal on the resource. AWS Lake Formation defines privileges to grant and
         * revoke access to metadata in the Data Catalog and data organized in underlying data storage such as Amazon
         * S3. AWS Lake Formation requires that each principal be authorized to perform a specific task on AWS Lake
         * Formation resources.
         * </p>
         * 
         * @param permissions
         *        The permissions granted to the principal on the resource. AWS Lake Formation defines privileges to
         *        grant and revoke access to metadata in the Data Catalog and data organized in underlying data storage
         *        such as Amazon S3. AWS Lake Formation requires that each principal be authorized to perform a specific
         *        task on AWS Lake Formation resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsWithStrings(String... permissions);

        /**
         * <p>
         * The permissions granted to the principal on the resource. AWS Lake Formation defines privileges to grant and
         * revoke access to metadata in the Data Catalog and data organized in underlying data storage such as Amazon
         * S3. AWS Lake Formation requires that each principal be authorized to perform a specific task on AWS Lake
         * Formation resources.
         * </p>
         * 
         * @param permissions
         *        The permissions granted to the principal on the resource. AWS Lake Formation defines privileges to
         *        grant and revoke access to metadata in the Data Catalog and data organized in underlying data storage
         *        such as Amazon S3. AWS Lake Formation requires that each principal be authorized to perform a specific
         *        task on AWS Lake Formation resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Collection<Permission> permissions);

        /**
         * <p>
         * The permissions granted to the principal on the resource. AWS Lake Formation defines privileges to grant and
         * revoke access to metadata in the Data Catalog and data organized in underlying data storage such as Amazon
         * S3. AWS Lake Formation requires that each principal be authorized to perform a specific task on AWS Lake
         * Formation resources.
         * </p>
         * 
         * @param permissions
         *        The permissions granted to the principal on the resource. AWS Lake Formation defines privileges to
         *        grant and revoke access to metadata in the Data Catalog and data organized in underlying data storage
         *        such as Amazon S3. AWS Lake Formation requires that each principal be authorized to perform a specific
         *        task on AWS Lake Formation resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Permission... permissions);

        /**
         * <p>
         * Indicates a list of the granted permissions that the principal may pass to other users. These permissions may
         * only be a subset of the permissions granted in the <code>Privileges</code>.
         * </p>
         * 
         * @param permissionsWithGrantOption
         *        Indicates a list of the granted permissions that the principal may pass to other users. These
         *        permissions may only be a subset of the permissions granted in the <code>Privileges</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsWithGrantOptionWithStrings(Collection<String> permissionsWithGrantOption);

        /**
         * <p>
         * Indicates a list of the granted permissions that the principal may pass to other users. These permissions may
         * only be a subset of the permissions granted in the <code>Privileges</code>.
         * </p>
         * 
         * @param permissionsWithGrantOption
         *        Indicates a list of the granted permissions that the principal may pass to other users. These
         *        permissions may only be a subset of the permissions granted in the <code>Privileges</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsWithGrantOptionWithStrings(String... permissionsWithGrantOption);

        /**
         * <p>
         * Indicates a list of the granted permissions that the principal may pass to other users. These permissions may
         * only be a subset of the permissions granted in the <code>Privileges</code>.
         * </p>
         * 
         * @param permissionsWithGrantOption
         *        Indicates a list of the granted permissions that the principal may pass to other users. These
         *        permissions may only be a subset of the permissions granted in the <code>Privileges</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsWithGrantOption(Collection<Permission> permissionsWithGrantOption);

        /**
         * <p>
         * Indicates a list of the granted permissions that the principal may pass to other users. These permissions may
         * only be a subset of the permissions granted in the <code>Privileges</code>.
         * </p>
         * 
         * @param permissionsWithGrantOption
         *        Indicates a list of the granted permissions that the principal may pass to other users. These
         *        permissions may only be a subset of the permissions granted in the <code>Privileges</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsWithGrantOption(Permission... permissionsWithGrantOption);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LakeFormationRequest.BuilderImpl implements Builder {
        private String catalogId;

        private DataLakePrincipal principal;

        private Resource resource;

        private List<String> permissions = DefaultSdkAutoConstructList.getInstance();

        private List<String> permissionsWithGrantOption = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GrantPermissionsRequest model) {
            super(model);
            catalogId(model.catalogId);
            principal(model.principal);
            resource(model.resource);
            permissionsWithStrings(model.permissions);
            permissionsWithGrantOptionWithStrings(model.permissionsWithGrantOption);
        }

        public final String getCatalogId() {
            return catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        public final DataLakePrincipal.Builder getPrincipal() {
            return principal != null ? principal.toBuilder() : null;
        }

        @Override
        public final Builder principal(DataLakePrincipal principal) {
            this.principal = principal;
            return this;
        }

        public final void setPrincipal(DataLakePrincipal.BuilderImpl principal) {
            this.principal = principal != null ? principal.build() : null;
        }

        public final Resource.Builder getResource() {
            return resource != null ? resource.toBuilder() : null;
        }

        @Override
        public final Builder resource(Resource resource) {
            this.resource = resource;
            return this;
        }

        public final void setResource(Resource.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        public final Collection<String> getPermissions() {
            return permissions;
        }

        @Override
        public final Builder permissionsWithStrings(Collection<String> permissions) {
            this.permissions = PermissionListCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionsWithStrings(String... permissions) {
            permissionsWithStrings(Arrays.asList(permissions));
            return this;
        }

        @Override
        public final Builder permissions(Collection<Permission> permissions) {
            this.permissions = PermissionListCopier.copyEnumToString(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Permission... permissions) {
            permissions(Arrays.asList(permissions));
            return this;
        }

        public final void setPermissions(Collection<String> permissions) {
            this.permissions = PermissionListCopier.copy(permissions);
        }

        public final Collection<String> getPermissionsWithGrantOption() {
            return permissionsWithGrantOption;
        }

        @Override
        public final Builder permissionsWithGrantOptionWithStrings(Collection<String> permissionsWithGrantOption) {
            this.permissionsWithGrantOption = PermissionListCopier.copy(permissionsWithGrantOption);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionsWithGrantOptionWithStrings(String... permissionsWithGrantOption) {
            permissionsWithGrantOptionWithStrings(Arrays.asList(permissionsWithGrantOption));
            return this;
        }

        @Override
        public final Builder permissionsWithGrantOption(Collection<Permission> permissionsWithGrantOption) {
            this.permissionsWithGrantOption = PermissionListCopier.copyEnumToString(permissionsWithGrantOption);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionsWithGrantOption(Permission... permissionsWithGrantOption) {
            permissionsWithGrantOption(Arrays.asList(permissionsWithGrantOption));
            return this;
        }

        public final void setPermissionsWithGrantOption(Collection<String> permissionsWithGrantOption) {
            this.permissionsWithGrantOption = PermissionListCopier.copy(permissionsWithGrantOption);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GrantPermissionsRequest build() {
            return new GrantPermissionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
