/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListResourcesResponse extends LakeFormationResponse implements
        ToCopyableBuilder<ListResourcesResponse.Builder, ListResourcesResponse> {
    private static final SdkField<List<ResourceInfo>> RESOURCE_INFO_LIST_FIELD = SdkField
            .<List<ResourceInfo>> builder(MarshallingType.LIST)
            .getter(getter(ListResourcesResponse::resourceInfoList))
            .setter(setter(Builder::resourceInfoList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceInfoList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListResourcesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_INFO_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ResourceInfo> resourceInfoList;

    private final String nextToken;

    private ListResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.resourceInfoList = builder.resourceInfoList;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ResourceInfoList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasResourceInfoList() {
        return resourceInfoList != null && !(resourceInfoList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A summary of the data lake resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceInfoList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A summary of the data lake resources.
     */
    public List<ResourceInfo> resourceInfoList() {
        return resourceInfoList;
    }

    /**
     * <p>
     * A continuation token, if this is not the first call to retrieve these resources.
     * </p>
     * 
     * @return A continuation token, if this is not the first call to retrieve these resources.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceInfoList());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourcesResponse)) {
            return false;
        }
        ListResourcesResponse other = (ListResourcesResponse) obj;
        return Objects.equals(resourceInfoList(), other.resourceInfoList()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListResourcesResponse").add("ResourceInfoList", resourceInfoList())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceInfoList":
            return Optional.ofNullable(clazz.cast(resourceInfoList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListResourcesResponse, T> g) {
        return obj -> g.apply((ListResourcesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LakeFormationResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListResourcesResponse> {
        /**
         * <p>
         * A summary of the data lake resources.
         * </p>
         * 
         * @param resourceInfoList
         *        A summary of the data lake resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceInfoList(Collection<ResourceInfo> resourceInfoList);

        /**
         * <p>
         * A summary of the data lake resources.
         * </p>
         * 
         * @param resourceInfoList
         *        A summary of the data lake resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceInfoList(ResourceInfo... resourceInfoList);

        /**
         * <p>
         * A summary of the data lake resources.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResourceInfo>.Builder} avoiding the need to
         * create one manually via {@link List<ResourceInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourceInfo>.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceInfoList(List<ResourceInfo>)}.
         * 
         * @param resourceInfoList
         *        a consumer that will call methods on {@link List<ResourceInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceInfoList(List<ResourceInfo>)
         */
        Builder resourceInfoList(Consumer<ResourceInfo.Builder>... resourceInfoList);

        /**
         * <p>
         * A continuation token, if this is not the first call to retrieve these resources.
         * </p>
         * 
         * @param nextToken
         *        A continuation token, if this is not the first call to retrieve these resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LakeFormationResponse.BuilderImpl implements Builder {
        private List<ResourceInfo> resourceInfoList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourcesResponse model) {
            super(model);
            resourceInfoList(model.resourceInfoList);
            nextToken(model.nextToken);
        }

        public final Collection<ResourceInfo.Builder> getResourceInfoList() {
            return resourceInfoList != null ? resourceInfoList.stream().map(ResourceInfo::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder resourceInfoList(Collection<ResourceInfo> resourceInfoList) {
            this.resourceInfoList = ResourceInfoListCopier.copy(resourceInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceInfoList(ResourceInfo... resourceInfoList) {
            resourceInfoList(Arrays.asList(resourceInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceInfoList(Consumer<ResourceInfo.Builder>... resourceInfoList) {
            resourceInfoList(Stream.of(resourceInfoList).map(c -> ResourceInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setResourceInfoList(Collection<ResourceInfo.BuilderImpl> resourceInfoList) {
            this.resourceInfoList = ResourceInfoListCopier.copyFromBuilder(resourceInfoList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListResourcesResponse build() {
            return new ListResourcesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
