/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure for the table object. A table is a metadata definition that represents your data. You can Grant and
 * Revoke table privileges to a principal.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableResource implements SdkPojo, Serializable, ToCopyableBuilder<TableResource.Builder, TableResource> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TableResource::catalogId)).setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TableResource::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TableResource::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<TableWildcard> TABLE_WILDCARD_FIELD = SdkField
            .<TableWildcard> builder(MarshallingType.SDK_POJO).getter(getter(TableResource::tableWildcard))
            .setter(setter(Builder::tableWildcard)).constructor(TableWildcard::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableWildcard").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD,
            DATABASE_NAME_FIELD, NAME_FIELD, TABLE_WILDCARD_FIELD));

    private static final long serialVersionUID = 1L;

    private final String catalogId;

    private final String databaseName;

    private final String name;

    private final TableWildcard tableWildcard;

    private TableResource(BuilderImpl builder) {
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.name = builder.name;
        this.tableWildcard = builder.tableWildcard;
    }

    /**
     * <p>
     * The identifier for the Data Catalog. By default, it is the account ID of the caller.
     * </p>
     * 
     * @return The identifier for the Data Catalog. By default, it is the account ID of the caller.
     */
    public String catalogId() {
        return catalogId;
    }

    /**
     * <p>
     * The name of the database for the table. Unique to a Data Catalog. A database is a set of associated table
     * definitions organized into a logical group. You can Grant and Revoke database privileges to a principal.
     * </p>
     * 
     * @return The name of the database for the table. Unique to a Data Catalog. A database is a set of associated table
     *         definitions organized into a logical group. You can Grant and Revoke database privileges to a principal.
     */
    public String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The name of the table.
     * </p>
     * 
     * @return The name of the table.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A wildcard object representing every table under a database.
     * </p>
     * <p>
     * At least one of <code>TableResource$Name</code> or <code>TableResource$TableWildcard</code> is required.
     * </p>
     * 
     * @return A wildcard object representing every table under a database.</p>
     *         <p>
     *         At least one of <code>TableResource$Name</code> or <code>TableResource$TableWildcard</code> is required.
     */
    public TableWildcard tableWildcard() {
        return tableWildcard;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(tableWildcard());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableResource)) {
            return false;
        }
        TableResource other = (TableResource) obj;
        return Objects.equals(catalogId(), other.catalogId()) && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(name(), other.name()) && Objects.equals(tableWildcard(), other.tableWildcard());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TableResource").add("CatalogId", catalogId()).add("DatabaseName", databaseName())
                .add("Name", name()).add("TableWildcard", tableWildcard()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "TableWildcard":
            return Optional.ofNullable(clazz.cast(tableWildcard()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TableResource, T> g) {
        return obj -> g.apply((TableResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableResource> {
        /**
         * <p>
         * The identifier for the Data Catalog. By default, it is the account ID of the caller.
         * </p>
         * 
         * @param catalogId
         *        The identifier for the Data Catalog. By default, it is the account ID of the caller.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * The name of the database for the table. Unique to a Data Catalog. A database is a set of associated table
         * definitions organized into a logical group. You can Grant and Revoke database privileges to a principal.
         * </p>
         * 
         * @param databaseName
         *        The name of the database for the table. Unique to a Data Catalog. A database is a set of associated
         *        table definitions organized into a logical group. You can Grant and Revoke database privileges to a
         *        principal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The name of the table.
         * </p>
         * 
         * @param name
         *        The name of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A wildcard object representing every table under a database.
         * </p>
         * <p>
         * At least one of <code>TableResource$Name</code> or <code>TableResource$TableWildcard</code> is required.
         * </p>
         * 
         * @param tableWildcard
         *        A wildcard object representing every table under a database.</p>
         *        <p>
         *        At least one of <code>TableResource$Name</code> or <code>TableResource$TableWildcard</code> is
         *        required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableWildcard(TableWildcard tableWildcard);

        /**
         * <p>
         * A wildcard object representing every table under a database.
         * </p>
         * <p>
         * At least one of <code>TableResource$Name</code> or <code>TableResource$TableWildcard</code> is required.
         * </p>
         * This is a convenience that creates an instance of the {@link TableWildcard.Builder} avoiding the need to
         * create one manually via {@link TableWildcard#builder()}.
         *
         * When the {@link Consumer} completes, {@link TableWildcard.Builder#build()} is called immediately and its
         * result is passed to {@link #tableWildcard(TableWildcard)}.
         * 
         * @param tableWildcard
         *        a consumer that will call methods on {@link TableWildcard.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tableWildcard(TableWildcard)
         */
        default Builder tableWildcard(Consumer<TableWildcard.Builder> tableWildcard) {
            return tableWildcard(TableWildcard.builder().applyMutation(tableWildcard).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String catalogId;

        private String databaseName;

        private String name;

        private TableWildcard tableWildcard;

        private BuilderImpl() {
        }

        private BuilderImpl(TableResource model) {
            catalogId(model.catalogId);
            databaseName(model.databaseName);
            name(model.name);
            tableWildcard(model.tableWildcard);
        }

        public final String getCatalogId() {
            return catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final TableWildcard.Builder getTableWildcard() {
            return tableWildcard != null ? tableWildcard.toBuilder() : null;
        }

        @Override
        public final Builder tableWildcard(TableWildcard tableWildcard) {
            this.tableWildcard = tableWildcard;
            return this;
        }

        public final void setTableWildcard(TableWildcard.BuilderImpl tableWildcard) {
            this.tableWildcard = tableWildcard != null ? tableWildcard.build() : null;
        }

        @Override
        public TableResource build() {
            return new TableResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
