/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A wildcard object, consisting of an optional list of excluded column names or indexes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ColumnWildcard implements SdkPojo, Serializable, ToCopyableBuilder<ColumnWildcard.Builder, ColumnWildcard> {
    private static final SdkField<List<String>> EXCLUDED_COLUMN_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ExcludedColumnNames")
            .getter(getter(ColumnWildcard::excludedColumnNames))
            .setter(setter(Builder::excludedColumnNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludedColumnNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXCLUDED_COLUMN_NAMES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> excludedColumnNames;

    private ColumnWildcard(BuilderImpl builder) {
        this.excludedColumnNames = builder.excludedColumnNames;
    }

    /**
     * Returns true if the ExcludedColumnNames property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasExcludedColumnNames() {
        return excludedColumnNames != null && !(excludedColumnNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Excludes column names. Any column with this name will be excluded.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExcludedColumnNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Excludes column names. Any column with this name will be excluded.
     */
    public List<String> excludedColumnNames() {
        return excludedColumnNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasExcludedColumnNames() ? excludedColumnNames() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnWildcard)) {
            return false;
        }
        ColumnWildcard other = (ColumnWildcard) obj;
        return hasExcludedColumnNames() == other.hasExcludedColumnNames()
                && Objects.equals(excludedColumnNames(), other.excludedColumnNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ColumnWildcard")
                .add("ExcludedColumnNames", hasExcludedColumnNames() ? excludedColumnNames() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExcludedColumnNames":
            return Optional.ofNullable(clazz.cast(excludedColumnNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ColumnWildcard, T> g) {
        return obj -> g.apply((ColumnWildcard) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ColumnWildcard> {
        /**
         * <p>
         * Excludes column names. Any column with this name will be excluded.
         * </p>
         * 
         * @param excludedColumnNames
         *        Excludes column names. Any column with this name will be excluded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludedColumnNames(Collection<String> excludedColumnNames);

        /**
         * <p>
         * Excludes column names. Any column with this name will be excluded.
         * </p>
         * 
         * @param excludedColumnNames
         *        Excludes column names. Any column with this name will be excluded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludedColumnNames(String... excludedColumnNames);
    }

    static final class BuilderImpl implements Builder {
        private List<String> excludedColumnNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ColumnWildcard model) {
            excludedColumnNames(model.excludedColumnNames);
        }

        public final Collection<String> getExcludedColumnNames() {
            if (excludedColumnNames instanceof SdkAutoConstructList) {
                return null;
            }
            return excludedColumnNames;
        }

        @Override
        public final Builder excludedColumnNames(Collection<String> excludedColumnNames) {
            this.excludedColumnNames = ColumnNamesCopier.copy(excludedColumnNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedColumnNames(String... excludedColumnNames) {
            excludedColumnNames(Arrays.asList(excludedColumnNames));
            return this;
        }

        public final void setExcludedColumnNames(Collection<String> excludedColumnNames) {
            this.excludedColumnNames = ColumnNamesCopier.copy(excludedColumnNames);
        }

        @Override
        public ColumnWildcard build() {
            return new ColumnWildcard(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
