/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutDataLakeSettingsRequest extends LakeFormationRequest implements
        ToCopyableBuilder<PutDataLakeSettingsRequest.Builder, PutDataLakeSettingsRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogId").getter(getter(PutDataLakeSettingsRequest::catalogId)).setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<DataLakeSettings> DATA_LAKE_SETTINGS_FIELD = SdkField
            .<DataLakeSettings> builder(MarshallingType.SDK_POJO).memberName("DataLakeSettings")
            .getter(getter(PutDataLakeSettingsRequest::dataLakeSettings)).setter(setter(Builder::dataLakeSettings))
            .constructor(DataLakeSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataLakeSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD,
            DATA_LAKE_SETTINGS_FIELD));

    private final String catalogId;

    private final DataLakeSettings dataLakeSettings;

    private PutDataLakeSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.dataLakeSettings = builder.dataLakeSettings;
    }

    /**
     * <p>
     * The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata
     * store. It contains database definitions, table definitions, and other control information to manage your AWS Lake
     * Formation environment.
     * </p>
     * 
     * @return The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent
     *         metadata store. It contains database definitions, table definitions, and other control information to
     *         manage your AWS Lake Formation environment.
     */
    public String catalogId() {
        return catalogId;
    }

    /**
     * <p>
     * A structure representing a list of AWS Lake Formation principals designated as data lake administrators.
     * </p>
     * 
     * @return A structure representing a list of AWS Lake Formation principals designated as data lake administrators.
     */
    public DataLakeSettings dataLakeSettings() {
        return dataLakeSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(dataLakeSettings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDataLakeSettingsRequest)) {
            return false;
        }
        PutDataLakeSettingsRequest other = (PutDataLakeSettingsRequest) obj;
        return Objects.equals(catalogId(), other.catalogId()) && Objects.equals(dataLakeSettings(), other.dataLakeSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutDataLakeSettingsRequest").add("CatalogId", catalogId())
                .add("DataLakeSettings", dataLakeSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "DataLakeSettings":
            return Optional.ofNullable(clazz.cast(dataLakeSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutDataLakeSettingsRequest, T> g) {
        return obj -> g.apply((PutDataLakeSettingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LakeFormationRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutDataLakeSettingsRequest> {
        /**
         * <p>
         * The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata
         * store. It contains database definitions, table definitions, and other control information to manage your AWS
         * Lake Formation environment.
         * </p>
         * 
         * @param catalogId
         *        The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent
         *        metadata store. It contains database definitions, table definitions, and other control information to
         *        manage your AWS Lake Formation environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * A structure representing a list of AWS Lake Formation principals designated as data lake administrators.
         * </p>
         * 
         * @param dataLakeSettings
         *        A structure representing a list of AWS Lake Formation principals designated as data lake
         *        administrators.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataLakeSettings(DataLakeSettings dataLakeSettings);

        /**
         * <p>
         * A structure representing a list of AWS Lake Formation principals designated as data lake administrators.
         * </p>
         * This is a convenience that creates an instance of the {@link DataLakeSettings.Builder} avoiding the need to
         * create one manually via {@link DataLakeSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataLakeSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #dataLakeSettings(DataLakeSettings)}.
         * 
         * @param dataLakeSettings
         *        a consumer that will call methods on {@link DataLakeSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataLakeSettings(DataLakeSettings)
         */
        default Builder dataLakeSettings(Consumer<DataLakeSettings.Builder> dataLakeSettings) {
            return dataLakeSettings(DataLakeSettings.builder().applyMutation(dataLakeSettings).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LakeFormationRequest.BuilderImpl implements Builder {
        private String catalogId;

        private DataLakeSettings dataLakeSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(PutDataLakeSettingsRequest model) {
            super(model);
            catalogId(model.catalogId);
            dataLakeSettings(model.dataLakeSettings);
        }

        public final String getCatalogId() {
            return catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        public final DataLakeSettings.Builder getDataLakeSettings() {
            return dataLakeSettings != null ? dataLakeSettings.toBuilder() : null;
        }

        @Override
        public final Builder dataLakeSettings(DataLakeSettings dataLakeSettings) {
            this.dataLakeSettings = dataLakeSettings;
            return this;
        }

        public final void setDataLakeSettings(DataLakeSettings.BuilderImpl dataLakeSettings) {
            this.dataLakeSettings = dataLakeSettings != null ? dataLakeSettings.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutDataLakeSettingsRequest build() {
            return new PutDataLakeSettingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
