/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A permission to a resource granted by batch operation to the principal.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchPermissionsRequestEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchPermissionsRequestEntry.Builder, BatchPermissionsRequestEntry> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(BatchPermissionsRequestEntry::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<DataLakePrincipal> PRINCIPAL_FIELD = SdkField
            .<DataLakePrincipal> builder(MarshallingType.SDK_POJO).memberName("Principal")
            .getter(getter(BatchPermissionsRequestEntry::principal)).setter(setter(Builder::principal))
            .constructor(DataLakePrincipal::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Principal").build()).build();

    private static final SdkField<Resource> RESOURCE_FIELD = SdkField.<Resource> builder(MarshallingType.SDK_POJO)
            .memberName("Resource").getter(getter(BatchPermissionsRequestEntry::resource)).setter(setter(Builder::resource))
            .constructor(Resource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resource").build()).build();

    private static final SdkField<List<String>> PERMISSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Permissions")
            .getter(getter(BatchPermissionsRequestEntry::permissionsAsStrings))
            .setter(setter(Builder::permissionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PERMISSIONS_WITH_GRANT_OPTION_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PermissionsWithGrantOption")
            .getter(getter(BatchPermissionsRequestEntry::permissionsWithGrantOptionAsStrings))
            .setter(setter(Builder::permissionsWithGrantOptionWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionsWithGrantOption").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, PRINCIPAL_FIELD,
            RESOURCE_FIELD, PERMISSIONS_FIELD, PERMISSIONS_WITH_GRANT_OPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final DataLakePrincipal principal;

    private final Resource resource;

    private final List<String> permissions;

    private final List<String> permissionsWithGrantOption;

    private BatchPermissionsRequestEntry(BuilderImpl builder) {
        this.id = builder.id;
        this.principal = builder.principal;
        this.resource = builder.resource;
        this.permissions = builder.permissions;
        this.permissionsWithGrantOption = builder.permissionsWithGrantOption;
    }

    /**
     * <p>
     * A unique identifier for the batch permissions request entry.
     * </p>
     * 
     * @return A unique identifier for the batch permissions request entry.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The principal to be granted a permission.
     * </p>
     * 
     * @return The principal to be granted a permission.
     */
    public DataLakePrincipal principal() {
        return principal;
    }

    /**
     * <p>
     * The resource to which the principal is to be granted a permission.
     * </p>
     * 
     * @return The resource to which the principal is to be granted a permission.
     */
    public Resource resource() {
        return resource;
    }

    /**
     * <p>
     * The permissions to be granted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPermissions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The permissions to be granted.
     */
    public List<Permission> permissions() {
        return PermissionListCopier.copyStringToEnum(permissions);
    }

    /**
     * Returns true if the Permissions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasPermissions() {
        return permissions != null && !(permissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The permissions to be granted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPermissions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The permissions to be granted.
     */
    public List<String> permissionsAsStrings() {
        return permissions;
    }

    /**
     * <p>
     * Indicates if the option to pass permissions is granted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPermissionsWithGrantOption()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Indicates if the option to pass permissions is granted.
     */
    public List<Permission> permissionsWithGrantOption() {
        return PermissionListCopier.copyStringToEnum(permissionsWithGrantOption);
    }

    /**
     * Returns true if the PermissionsWithGrantOption property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasPermissionsWithGrantOption() {
        return permissionsWithGrantOption != null && !(permissionsWithGrantOption instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates if the option to pass permissions is granted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPermissionsWithGrantOption()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Indicates if the option to pass permissions is granted.
     */
    public List<String> permissionsWithGrantOptionAsStrings() {
        return permissionsWithGrantOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(principal());
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        hashCode = 31 * hashCode + Objects.hashCode(hasPermissions() ? permissionsAsStrings() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasPermissionsWithGrantOption() ? permissionsWithGrantOptionAsStrings() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPermissionsRequestEntry)) {
            return false;
        }
        BatchPermissionsRequestEntry other = (BatchPermissionsRequestEntry) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(principal(), other.principal())
                && Objects.equals(resource(), other.resource()) && hasPermissions() == other.hasPermissions()
                && Objects.equals(permissionsAsStrings(), other.permissionsAsStrings())
                && hasPermissionsWithGrantOption() == other.hasPermissionsWithGrantOption()
                && Objects.equals(permissionsWithGrantOptionAsStrings(), other.permissionsWithGrantOptionAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString
                .builder("BatchPermissionsRequestEntry")
                .add("Id", id())
                .add("Principal", principal())
                .add("Resource", resource())
                .add("Permissions", hasPermissions() ? permissionsAsStrings() : null)
                .add("PermissionsWithGrantOption", hasPermissionsWithGrantOption() ? permissionsWithGrantOptionAsStrings() : null)
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Principal":
            return Optional.ofNullable(clazz.cast(principal()));
        case "Resource":
            return Optional.ofNullable(clazz.cast(resource()));
        case "Permissions":
            return Optional.ofNullable(clazz.cast(permissionsAsStrings()));
        case "PermissionsWithGrantOption":
            return Optional.ofNullable(clazz.cast(permissionsWithGrantOptionAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchPermissionsRequestEntry, T> g) {
        return obj -> g.apply((BatchPermissionsRequestEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchPermissionsRequestEntry> {
        /**
         * <p>
         * A unique identifier for the batch permissions request entry.
         * </p>
         * 
         * @param id
         *        A unique identifier for the batch permissions request entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The principal to be granted a permission.
         * </p>
         * 
         * @param principal
         *        The principal to be granted a permission.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principal(DataLakePrincipal principal);

        /**
         * <p>
         * The principal to be granted a permission.
         * </p>
         * This is a convenience that creates an instance of the {@link DataLakePrincipal.Builder} avoiding the need to
         * create one manually via {@link DataLakePrincipal#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataLakePrincipal.Builder#build()} is called immediately and its
         * result is passed to {@link #principal(DataLakePrincipal)}.
         * 
         * @param principal
         *        a consumer that will call methods on {@link DataLakePrincipal.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #principal(DataLakePrincipal)
         */
        default Builder principal(Consumer<DataLakePrincipal.Builder> principal) {
            return principal(DataLakePrincipal.builder().applyMutation(principal).build());
        }

        /**
         * <p>
         * The resource to which the principal is to be granted a permission.
         * </p>
         * 
         * @param resource
         *        The resource to which the principal is to be granted a permission.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(Resource resource);

        /**
         * <p>
         * The resource to which the principal is to be granted a permission.
         * </p>
         * This is a convenience that creates an instance of the {@link Resource.Builder} avoiding the need to create
         * one manually via {@link Resource#builder()}.
         *
         * When the {@link Consumer} completes, {@link Resource.Builder#build()} is called immediately and its result is
         * passed to {@link #resource(Resource)}.
         * 
         * @param resource
         *        a consumer that will call methods on {@link Resource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resource(Resource)
         */
        default Builder resource(Consumer<Resource.Builder> resource) {
            return resource(Resource.builder().applyMutation(resource).build());
        }

        /**
         * <p>
         * The permissions to be granted.
         * </p>
         * 
         * @param permissions
         *        The permissions to be granted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsWithStrings(Collection<String> permissions);

        /**
         * <p>
         * The permissions to be granted.
         * </p>
         * 
         * @param permissions
         *        The permissions to be granted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsWithStrings(String... permissions);

        /**
         * <p>
         * The permissions to be granted.
         * </p>
         * 
         * @param permissions
         *        The permissions to be granted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Collection<Permission> permissions);

        /**
         * <p>
         * The permissions to be granted.
         * </p>
         * 
         * @param permissions
         *        The permissions to be granted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Permission... permissions);

        /**
         * <p>
         * Indicates if the option to pass permissions is granted.
         * </p>
         * 
         * @param permissionsWithGrantOption
         *        Indicates if the option to pass permissions is granted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsWithGrantOptionWithStrings(Collection<String> permissionsWithGrantOption);

        /**
         * <p>
         * Indicates if the option to pass permissions is granted.
         * </p>
         * 
         * @param permissionsWithGrantOption
         *        Indicates if the option to pass permissions is granted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsWithGrantOptionWithStrings(String... permissionsWithGrantOption);

        /**
         * <p>
         * Indicates if the option to pass permissions is granted.
         * </p>
         * 
         * @param permissionsWithGrantOption
         *        Indicates if the option to pass permissions is granted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsWithGrantOption(Collection<Permission> permissionsWithGrantOption);

        /**
         * <p>
         * Indicates if the option to pass permissions is granted.
         * </p>
         * 
         * @param permissionsWithGrantOption
         *        Indicates if the option to pass permissions is granted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsWithGrantOption(Permission... permissionsWithGrantOption);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private DataLakePrincipal principal;

        private Resource resource;

        private List<String> permissions = DefaultSdkAutoConstructList.getInstance();

        private List<String> permissionsWithGrantOption = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchPermissionsRequestEntry model) {
            id(model.id);
            principal(model.principal);
            resource(model.resource);
            permissionsWithStrings(model.permissions);
            permissionsWithGrantOptionWithStrings(model.permissionsWithGrantOption);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final DataLakePrincipal.Builder getPrincipal() {
            return principal != null ? principal.toBuilder() : null;
        }

        @Override
        public final Builder principal(DataLakePrincipal principal) {
            this.principal = principal;
            return this;
        }

        public final void setPrincipal(DataLakePrincipal.BuilderImpl principal) {
            this.principal = principal != null ? principal.build() : null;
        }

        public final Resource.Builder getResource() {
            return resource != null ? resource.toBuilder() : null;
        }

        @Override
        public final Builder resource(Resource resource) {
            this.resource = resource;
            return this;
        }

        public final void setResource(Resource.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        public final Collection<String> getPermissions() {
            if (permissions instanceof SdkAutoConstructList) {
                return null;
            }
            return permissions;
        }

        @Override
        public final Builder permissionsWithStrings(Collection<String> permissions) {
            this.permissions = PermissionListCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionsWithStrings(String... permissions) {
            permissionsWithStrings(Arrays.asList(permissions));
            return this;
        }

        @Override
        public final Builder permissions(Collection<Permission> permissions) {
            this.permissions = PermissionListCopier.copyEnumToString(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Permission... permissions) {
            permissions(Arrays.asList(permissions));
            return this;
        }

        public final void setPermissions(Collection<String> permissions) {
            this.permissions = PermissionListCopier.copy(permissions);
        }

        public final Collection<String> getPermissionsWithGrantOption() {
            if (permissionsWithGrantOption instanceof SdkAutoConstructList) {
                return null;
            }
            return permissionsWithGrantOption;
        }

        @Override
        public final Builder permissionsWithGrantOptionWithStrings(Collection<String> permissionsWithGrantOption) {
            this.permissionsWithGrantOption = PermissionListCopier.copy(permissionsWithGrantOption);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionsWithGrantOptionWithStrings(String... permissionsWithGrantOption) {
            permissionsWithGrantOptionWithStrings(Arrays.asList(permissionsWithGrantOption));
            return this;
        }

        @Override
        public final Builder permissionsWithGrantOption(Collection<Permission> permissionsWithGrantOption) {
            this.permissionsWithGrantOption = PermissionListCopier.copyEnumToString(permissionsWithGrantOption);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionsWithGrantOption(Permission... permissionsWithGrantOption) {
            permissionsWithGrantOption(Arrays.asList(permissionsWithGrantOption));
            return this;
        }

        public final void setPermissionsWithGrantOption(Collection<String> permissionsWithGrantOption) {
            this.permissionsWithGrantOption = PermissionListCopier.copy(permissionsWithGrantOption);
        }

        @Override
        public BatchPermissionsRequestEntry build() {
            return new BatchPermissionsRequestEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
