/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListResourcesRequest extends LakeFormationRequest implements
        ToCopyableBuilder<ListResourcesRequest.Builder, ListResourcesRequest> {
    private static final SdkField<List<FilterCondition>> FILTER_CONDITION_LIST_FIELD = SdkField
            .<List<FilterCondition>> builder(MarshallingType.LIST)
            .memberName("FilterConditionList")
            .getter(getter(ListResourcesRequest::filterConditionList))
            .setter(setter(Builder::filterConditionList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterConditionList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FilterCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(FilterCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListResourcesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListResourcesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_CONDITION_LIST_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<FilterCondition> filterConditionList;

    private final Integer maxResults;

    private final String nextToken;

    private ListResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.filterConditionList = builder.filterConditionList;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the FilterConditionList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasFilterConditionList() {
        return filterConditionList != null && !(filterConditionList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any applicable row-level and/or column-level filtering conditions for the resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilterConditionList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Any applicable row-level and/or column-level filtering conditions for the resources.
     */
    public final List<FilterCondition> filterConditionList() {
        return filterConditionList;
    }

    /**
     * <p>
     * The maximum number of resource results.
     * </p>
     * 
     * @return The maximum number of resource results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A continuation token, if this is not the first call to retrieve these resources.
     * </p>
     * 
     * @return A continuation token, if this is not the first call to retrieve these resources.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFilterConditionList() ? filterConditionList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourcesRequest)) {
            return false;
        }
        ListResourcesRequest other = (ListResourcesRequest) obj;
        return hasFilterConditionList() == other.hasFilterConditionList()
                && Objects.equals(filterConditionList(), other.filterConditionList())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListResourcesRequest")
                .add("FilterConditionList", hasFilterConditionList() ? filterConditionList() : null)
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FilterConditionList":
            return Optional.ofNullable(clazz.cast(filterConditionList()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListResourcesRequest, T> g) {
        return obj -> g.apply((ListResourcesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LakeFormationRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListResourcesRequest> {
        /**
         * <p>
         * Any applicable row-level and/or column-level filtering conditions for the resources.
         * </p>
         * 
         * @param filterConditionList
         *        Any applicable row-level and/or column-level filtering conditions for the resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterConditionList(Collection<FilterCondition> filterConditionList);

        /**
         * <p>
         * Any applicable row-level and/or column-level filtering conditions for the resources.
         * </p>
         * 
         * @param filterConditionList
         *        Any applicable row-level and/or column-level filtering conditions for the resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterConditionList(FilterCondition... filterConditionList);

        /**
         * <p>
         * Any applicable row-level and/or column-level filtering conditions for the resources.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FilterCondition>.Builder} avoiding the need
         * to create one manually via {@link List<FilterCondition>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FilterCondition>.Builder#build()} is called immediately and
         * its result is passed to {@link #filterConditionList(List<FilterCondition>)}.
         * 
         * @param filterConditionList
         *        a consumer that will call methods on {@link List<FilterCondition>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterConditionList(List<FilterCondition>)
         */
        Builder filterConditionList(Consumer<FilterCondition.Builder>... filterConditionList);

        /**
         * <p>
         * The maximum number of resource results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of resource results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A continuation token, if this is not the first call to retrieve these resources.
         * </p>
         * 
         * @param nextToken
         *        A continuation token, if this is not the first call to retrieve these resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LakeFormationRequest.BuilderImpl implements Builder {
        private List<FilterCondition> filterConditionList = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourcesRequest model) {
            super(model);
            filterConditionList(model.filterConditionList);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<FilterCondition.Builder> getFilterConditionList() {
            if (filterConditionList instanceof SdkAutoConstructList) {
                return null;
            }
            return filterConditionList != null ? filterConditionList.stream().map(FilterCondition::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filterConditionList(Collection<FilterCondition> filterConditionList) {
            this.filterConditionList = FilterConditionListCopier.copy(filterConditionList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterConditionList(FilterCondition... filterConditionList) {
            filterConditionList(Arrays.asList(filterConditionList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterConditionList(Consumer<FilterCondition.Builder>... filterConditionList) {
            filterConditionList(Stream.of(filterConditionList).map(c -> FilterCondition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFilterConditionList(Collection<FilterCondition.BuilderImpl> filterConditionList) {
            this.filterConditionList = FilterConditionListCopier.copyFromBuilder(filterConditionList);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListResourcesRequest build() {
            return new ListResourcesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
