/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeResourceResponse extends LakeFormationResponse implements
        ToCopyableBuilder<DescribeResourceResponse.Builder, DescribeResourceResponse> {
    private static final SdkField<ResourceInfo> RESOURCE_INFO_FIELD = SdkField.<ResourceInfo> builder(MarshallingType.SDK_POJO)
            .memberName("ResourceInfo").getter(getter(DescribeResourceResponse::resourceInfo))
            .setter(setter(Builder::resourceInfo)).constructor(ResourceInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceInfo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_INFO_FIELD));

    private final ResourceInfo resourceInfo;

    private DescribeResourceResponse(BuilderImpl builder) {
        super(builder);
        this.resourceInfo = builder.resourceInfo;
    }

    /**
     * <p>
     * A structure containing information about an AWS Lake Formation resource.
     * </p>
     * 
     * @return A structure containing information about an AWS Lake Formation resource.
     */
    public final ResourceInfo resourceInfo() {
        return resourceInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceInfo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeResourceResponse)) {
            return false;
        }
        DescribeResourceResponse other = (DescribeResourceResponse) obj;
        return Objects.equals(resourceInfo(), other.resourceInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeResourceResponse").add("ResourceInfo", resourceInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceInfo":
            return Optional.ofNullable(clazz.cast(resourceInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeResourceResponse, T> g) {
        return obj -> g.apply((DescribeResourceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LakeFormationResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeResourceResponse> {
        /**
         * <p>
         * A structure containing information about an AWS Lake Formation resource.
         * </p>
         * 
         * @param resourceInfo
         *        A structure containing information about an AWS Lake Formation resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceInfo(ResourceInfo resourceInfo);

        /**
         * <p>
         * A structure containing information about an AWS Lake Formation resource.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceInfo.Builder} avoiding the need to
         * create one manually via {@link ResourceInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceInfo(ResourceInfo)}.
         * 
         * @param resourceInfo
         *        a consumer that will call methods on {@link ResourceInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceInfo(ResourceInfo)
         */
        default Builder resourceInfo(Consumer<ResourceInfo.Builder> resourceInfo) {
            return resourceInfo(ResourceInfo.builder().applyMutation(resourceInfo).build());
        }
    }

    static final class BuilderImpl extends LakeFormationResponse.BuilderImpl implements Builder {
        private ResourceInfo resourceInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeResourceResponse model) {
            super(model);
            resourceInfo(model.resourceInfo);
        }

        public final ResourceInfo.Builder getResourceInfo() {
            return resourceInfo != null ? resourceInfo.toBuilder() : null;
        }

        @Override
        public final Builder resourceInfo(ResourceInfo resourceInfo) {
            this.resourceInfo = resourceInfo;
            return this;
        }

        public final void setResourceInfo(ResourceInfo.BuilderImpl resourceInfo) {
            this.resourceInfo = resourceInfo != null ? resourceInfo.build() : null;
        }

        @Override
        public DescribeResourceResponse build() {
            return new DescribeResourceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
