/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure containing an error related to a <code>TagResource</code> or <code>UnTagResource</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LFTagError implements SdkPojo, Serializable, ToCopyableBuilder<LFTagError.Builder, LFTagError> {
    private static final SdkField<LFTagPair> LF_TAG_FIELD = SdkField.<LFTagPair> builder(MarshallingType.SDK_POJO)
            .memberName("LFTag").getter(getter(LFTagError::lfTag)).setter(setter(Builder::lfTag)).constructor(LFTagPair::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LFTag").build()).build();

    private static final SdkField<ErrorDetail> ERROR_FIELD = SdkField.<ErrorDetail> builder(MarshallingType.SDK_POJO)
            .memberName("Error").getter(getter(LFTagError::error)).setter(setter(Builder::error))
            .constructor(ErrorDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LF_TAG_FIELD, ERROR_FIELD));

    private static final long serialVersionUID = 1L;

    private final LFTagPair lfTag;

    private final ErrorDetail error;

    private LFTagError(BuilderImpl builder) {
        this.lfTag = builder.lfTag;
        this.error = builder.error;
    }

    /**
     * <p>
     * The key-name of the tag.
     * </p>
     * 
     * @return The key-name of the tag.
     */
    public final LFTagPair lfTag() {
        return lfTag;
    }

    /**
     * <p>
     * An error that occurred with the attachment or detachment of the tag.
     * </p>
     * 
     * @return An error that occurred with the attachment or detachment of the tag.
     */
    public final ErrorDetail error() {
        return error;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lfTag());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LFTagError)) {
            return false;
        }
        LFTagError other = (LFTagError) obj;
        return Objects.equals(lfTag(), other.lfTag()) && Objects.equals(error(), other.error());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LFTagError").add("LFTag", lfTag()).add("Error", error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LFTag":
            return Optional.ofNullable(clazz.cast(lfTag()));
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LFTagError, T> g) {
        return obj -> g.apply((LFTagError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LFTagError> {
        /**
         * <p>
         * The key-name of the tag.
         * </p>
         * 
         * @param lfTag
         *        The key-name of the tag.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lfTag(LFTagPair lfTag);

        /**
         * <p>
         * The key-name of the tag.
         * </p>
         * This is a convenience that creates an instance of the {@link LFTagPair.Builder} avoiding the need to create
         * one manually via {@link LFTagPair#builder()}.
         *
         * When the {@link Consumer} completes, {@link LFTagPair.Builder#build()} is called immediately and its result
         * is passed to {@link #lfTag(LFTagPair)}.
         * 
         * @param lfTag
         *        a consumer that will call methods on {@link LFTagPair.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lfTag(LFTagPair)
         */
        default Builder lfTag(Consumer<LFTagPair.Builder> lfTag) {
            return lfTag(LFTagPair.builder().applyMutation(lfTag).build());
        }

        /**
         * <p>
         * An error that occurred with the attachment or detachment of the tag.
         * </p>
         * 
         * @param error
         *        An error that occurred with the attachment or detachment of the tag.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(ErrorDetail error);

        /**
         * <p>
         * An error that occurred with the attachment or detachment of the tag.
         * </p>
         * This is a convenience that creates an instance of the {@link ErrorDetail.Builder} avoiding the need to create
         * one manually via {@link ErrorDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link ErrorDetail.Builder#build()} is called immediately and its result
         * is passed to {@link #error(ErrorDetail)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link ErrorDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(ErrorDetail)
         */
        default Builder error(Consumer<ErrorDetail.Builder> error) {
            return error(ErrorDetail.builder().applyMutation(error).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LFTagPair lfTag;

        private ErrorDetail error;

        private BuilderImpl() {
        }

        private BuilderImpl(LFTagError model) {
            lfTag(model.lfTag);
            error(model.error);
        }

        public final LFTagPair.Builder getLfTag() {
            return lfTag != null ? lfTag.toBuilder() : null;
        }

        @Override
        public final Builder lfTag(LFTagPair lfTag) {
            this.lfTag = lfTag;
            return this;
        }

        public final void setLfTag(LFTagPair.BuilderImpl lfTag) {
            this.lfTag = lfTag != null ? lfTag.build() : null;
        }

        public final ErrorDetail.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        @Override
        public final Builder error(ErrorDetail error) {
            this.error = error;
            return this;
        }

        public final void setError(ErrorDetail.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public LFTagError build() {
            return new LFTagError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
