/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation;

import java.nio.file.Path;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.lakeformation.model.AccessDeniedException;
import software.amazon.awssdk.services.lakeformation.model.AddLfTagsToResourceRequest;
import software.amazon.awssdk.services.lakeformation.model.AddLfTagsToResourceResponse;
import software.amazon.awssdk.services.lakeformation.model.AlreadyExistsException;
import software.amazon.awssdk.services.lakeformation.model.BatchGrantPermissionsRequest;
import software.amazon.awssdk.services.lakeformation.model.BatchGrantPermissionsResponse;
import software.amazon.awssdk.services.lakeformation.model.BatchRevokePermissionsRequest;
import software.amazon.awssdk.services.lakeformation.model.BatchRevokePermissionsResponse;
import software.amazon.awssdk.services.lakeformation.model.CancelTransactionRequest;
import software.amazon.awssdk.services.lakeformation.model.CancelTransactionResponse;
import software.amazon.awssdk.services.lakeformation.model.CommitTransactionRequest;
import software.amazon.awssdk.services.lakeformation.model.CommitTransactionResponse;
import software.amazon.awssdk.services.lakeformation.model.ConcurrentModificationException;
import software.amazon.awssdk.services.lakeformation.model.CreateDataCellsFilterRequest;
import software.amazon.awssdk.services.lakeformation.model.CreateDataCellsFilterResponse;
import software.amazon.awssdk.services.lakeformation.model.CreateLfTagRequest;
import software.amazon.awssdk.services.lakeformation.model.CreateLfTagResponse;
import software.amazon.awssdk.services.lakeformation.model.DeleteDataCellsFilterRequest;
import software.amazon.awssdk.services.lakeformation.model.DeleteDataCellsFilterResponse;
import software.amazon.awssdk.services.lakeformation.model.DeleteLfTagRequest;
import software.amazon.awssdk.services.lakeformation.model.DeleteLfTagResponse;
import software.amazon.awssdk.services.lakeformation.model.DeleteObjectsOnCancelRequest;
import software.amazon.awssdk.services.lakeformation.model.DeleteObjectsOnCancelResponse;
import software.amazon.awssdk.services.lakeformation.model.DeregisterResourceRequest;
import software.amazon.awssdk.services.lakeformation.model.DeregisterResourceResponse;
import software.amazon.awssdk.services.lakeformation.model.DescribeResourceRequest;
import software.amazon.awssdk.services.lakeformation.model.DescribeResourceResponse;
import software.amazon.awssdk.services.lakeformation.model.DescribeTransactionRequest;
import software.amazon.awssdk.services.lakeformation.model.DescribeTransactionResponse;
import software.amazon.awssdk.services.lakeformation.model.EntityNotFoundException;
import software.amazon.awssdk.services.lakeformation.model.ExpiredException;
import software.amazon.awssdk.services.lakeformation.model.ExtendTransactionRequest;
import software.amazon.awssdk.services.lakeformation.model.ExtendTransactionResponse;
import software.amazon.awssdk.services.lakeformation.model.GetDataLakeSettingsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetDataLakeSettingsResponse;
import software.amazon.awssdk.services.lakeformation.model.GetEffectivePermissionsForPathRequest;
import software.amazon.awssdk.services.lakeformation.model.GetEffectivePermissionsForPathResponse;
import software.amazon.awssdk.services.lakeformation.model.GetLfTagRequest;
import software.amazon.awssdk.services.lakeformation.model.GetLfTagResponse;
import software.amazon.awssdk.services.lakeformation.model.GetQueryStateRequest;
import software.amazon.awssdk.services.lakeformation.model.GetQueryStateResponse;
import software.amazon.awssdk.services.lakeformation.model.GetQueryStatisticsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetQueryStatisticsResponse;
import software.amazon.awssdk.services.lakeformation.model.GetResourceLfTagsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetResourceLfTagsResponse;
import software.amazon.awssdk.services.lakeformation.model.GetTableObjectsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetTableObjectsResponse;
import software.amazon.awssdk.services.lakeformation.model.GetWorkUnitResultsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetWorkUnitResultsResponse;
import software.amazon.awssdk.services.lakeformation.model.GetWorkUnitsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetWorkUnitsResponse;
import software.amazon.awssdk.services.lakeformation.model.GlueEncryptionException;
import software.amazon.awssdk.services.lakeformation.model.GrantPermissionsRequest;
import software.amazon.awssdk.services.lakeformation.model.GrantPermissionsResponse;
import software.amazon.awssdk.services.lakeformation.model.InternalServiceException;
import software.amazon.awssdk.services.lakeformation.model.InvalidInputException;
import software.amazon.awssdk.services.lakeformation.model.LakeFormationException;
import software.amazon.awssdk.services.lakeformation.model.ListDataCellsFilterRequest;
import software.amazon.awssdk.services.lakeformation.model.ListDataCellsFilterResponse;
import software.amazon.awssdk.services.lakeformation.model.ListLfTagsRequest;
import software.amazon.awssdk.services.lakeformation.model.ListLfTagsResponse;
import software.amazon.awssdk.services.lakeformation.model.ListPermissionsRequest;
import software.amazon.awssdk.services.lakeformation.model.ListPermissionsResponse;
import software.amazon.awssdk.services.lakeformation.model.ListResourcesRequest;
import software.amazon.awssdk.services.lakeformation.model.ListResourcesResponse;
import software.amazon.awssdk.services.lakeformation.model.ListTableStorageOptimizersRequest;
import software.amazon.awssdk.services.lakeformation.model.ListTableStorageOptimizersResponse;
import software.amazon.awssdk.services.lakeformation.model.ListTransactionsRequest;
import software.amazon.awssdk.services.lakeformation.model.ListTransactionsResponse;
import software.amazon.awssdk.services.lakeformation.model.OperationTimeoutException;
import software.amazon.awssdk.services.lakeformation.model.PutDataLakeSettingsRequest;
import software.amazon.awssdk.services.lakeformation.model.PutDataLakeSettingsResponse;
import software.amazon.awssdk.services.lakeformation.model.RegisterResourceRequest;
import software.amazon.awssdk.services.lakeformation.model.RegisterResourceResponse;
import software.amazon.awssdk.services.lakeformation.model.RemoveLfTagsFromResourceRequest;
import software.amazon.awssdk.services.lakeformation.model.RemoveLfTagsFromResourceResponse;
import software.amazon.awssdk.services.lakeformation.model.ResourceNotReadyException;
import software.amazon.awssdk.services.lakeformation.model.ResourceNumberLimitExceededException;
import software.amazon.awssdk.services.lakeformation.model.RevokePermissionsRequest;
import software.amazon.awssdk.services.lakeformation.model.RevokePermissionsResponse;
import software.amazon.awssdk.services.lakeformation.model.SearchDatabasesByLfTagsRequest;
import software.amazon.awssdk.services.lakeformation.model.SearchDatabasesByLfTagsResponse;
import software.amazon.awssdk.services.lakeformation.model.SearchTablesByLfTagsRequest;
import software.amazon.awssdk.services.lakeformation.model.SearchTablesByLfTagsResponse;
import software.amazon.awssdk.services.lakeformation.model.StartQueryPlanningRequest;
import software.amazon.awssdk.services.lakeformation.model.StartQueryPlanningResponse;
import software.amazon.awssdk.services.lakeformation.model.StartTransactionRequest;
import software.amazon.awssdk.services.lakeformation.model.StartTransactionResponse;
import software.amazon.awssdk.services.lakeformation.model.StatisticsNotReadyYetException;
import software.amazon.awssdk.services.lakeformation.model.ThrottledException;
import software.amazon.awssdk.services.lakeformation.model.TransactionCanceledException;
import software.amazon.awssdk.services.lakeformation.model.TransactionCommitInProgressException;
import software.amazon.awssdk.services.lakeformation.model.TransactionCommittedException;
import software.amazon.awssdk.services.lakeformation.model.UpdateLfTagRequest;
import software.amazon.awssdk.services.lakeformation.model.UpdateLfTagResponse;
import software.amazon.awssdk.services.lakeformation.model.UpdateResourceRequest;
import software.amazon.awssdk.services.lakeformation.model.UpdateResourceResponse;
import software.amazon.awssdk.services.lakeformation.model.UpdateTableObjectsRequest;
import software.amazon.awssdk.services.lakeformation.model.UpdateTableObjectsResponse;
import software.amazon.awssdk.services.lakeformation.model.UpdateTableStorageOptimizerRequest;
import software.amazon.awssdk.services.lakeformation.model.UpdateTableStorageOptimizerResponse;
import software.amazon.awssdk.services.lakeformation.model.WorkUnitsNotReadyYetException;
import software.amazon.awssdk.services.lakeformation.paginators.GetEffectivePermissionsForPathIterable;
import software.amazon.awssdk.services.lakeformation.paginators.GetTableObjectsIterable;
import software.amazon.awssdk.services.lakeformation.paginators.GetWorkUnitsIterable;
import software.amazon.awssdk.services.lakeformation.paginators.ListDataCellsFilterIterable;
import software.amazon.awssdk.services.lakeformation.paginators.ListLFTagsIterable;
import software.amazon.awssdk.services.lakeformation.paginators.ListPermissionsIterable;
import software.amazon.awssdk.services.lakeformation.paginators.ListResourcesIterable;
import software.amazon.awssdk.services.lakeformation.paginators.ListTableStorageOptimizersIterable;
import software.amazon.awssdk.services.lakeformation.paginators.ListTransactionsIterable;
import software.amazon.awssdk.services.lakeformation.paginators.SearchDatabasesByLFTagsIterable;
import software.amazon.awssdk.services.lakeformation.paginators.SearchTablesByLFTagsIterable;

/**
 * Service client for accessing AWS Lake Formation. This can be created using the static {@link #builder()} method.
 *
 * <fullname>Lake Formation</fullname>
 * <p>
 * Defines the public endpoint for the Lake Formation service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface LakeFormationClient extends SdkClient {
    String SERVICE_NAME = "lakeformation";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "lakeformation";

    /**
     * Create a {@link LakeFormationClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static LakeFormationClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link LakeFormationClient}.
     */
    static LakeFormationClientBuilder builder() {
        return new DefaultLakeFormationClientBuilder();
    }

    /**
     * <p>
     * Attaches one or more LF-tags to an existing resource.
     * </p>
     *
     * @param addLfTagsToResourceRequest
     * @return Result of the AddLFTagsToResource operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.AddLFTagsToResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/AddLFTagsToResource"
     *      target="_top">AWS API Documentation</a>
     */
    default AddLfTagsToResourceResponse addLFTagsToResource(AddLfTagsToResourceRequest addLfTagsToResourceRequest)
            throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            AccessDeniedException, ConcurrentModificationException, AwsServiceException, SdkClientException,
            LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches one or more LF-tags to an existing resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddLfTagsToResourceRequest.Builder} avoiding the
     * need to create one manually via {@link AddLfTagsToResourceRequest#builder()}
     * </p>
     *
     * @param addLfTagsToResourceRequest
     *        A {@link Consumer} that will call methods on {@link AddLFTagsToResourceRequest.Builder} to create a
     *        request.
     * @return Result of the AddLFTagsToResource operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.AddLFTagsToResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/AddLFTagsToResource"
     *      target="_top">AWS API Documentation</a>
     */
    default AddLfTagsToResourceResponse addLFTagsToResource(
            Consumer<AddLfTagsToResourceRequest.Builder> addLfTagsToResourceRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, AccessDeniedException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, LakeFormationException {
        return addLFTagsToResource(AddLfTagsToResourceRequest.builder().applyMutation(addLfTagsToResourceRequest).build());
    }

    /**
     * <p>
     * Batch operation to grant permissions to the principal.
     * </p>
     *
     * @param batchGrantPermissionsRequest
     * @return Result of the BatchGrantPermissions operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.BatchGrantPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/BatchGrantPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGrantPermissionsResponse batchGrantPermissions(BatchGrantPermissionsRequest batchGrantPermissionsRequest)
            throws InvalidInputException, OperationTimeoutException, AwsServiceException, SdkClientException,
            LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Batch operation to grant permissions to the principal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGrantPermissionsRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGrantPermissionsRequest#builder()}
     * </p>
     *
     * @param batchGrantPermissionsRequest
     *        A {@link Consumer} that will call methods on {@link BatchGrantPermissionsRequest.Builder} to create a
     *        request.
     * @return Result of the BatchGrantPermissions operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.BatchGrantPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/BatchGrantPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGrantPermissionsResponse batchGrantPermissions(
            Consumer<BatchGrantPermissionsRequest.Builder> batchGrantPermissionsRequest) throws InvalidInputException,
            OperationTimeoutException, AwsServiceException, SdkClientException, LakeFormationException {
        return batchGrantPermissions(BatchGrantPermissionsRequest.builder().applyMutation(batchGrantPermissionsRequest).build());
    }

    /**
     * <p>
     * Batch operation to revoke permissions from the principal.
     * </p>
     *
     * @param batchRevokePermissionsRequest
     * @return Result of the BatchRevokePermissions operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.BatchRevokePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/BatchRevokePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchRevokePermissionsResponse batchRevokePermissions(BatchRevokePermissionsRequest batchRevokePermissionsRequest)
            throws InvalidInputException, OperationTimeoutException, AwsServiceException, SdkClientException,
            LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Batch operation to revoke permissions from the principal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchRevokePermissionsRequest.Builder} avoiding the
     * need to create one manually via {@link BatchRevokePermissionsRequest#builder()}
     * </p>
     *
     * @param batchRevokePermissionsRequest
     *        A {@link Consumer} that will call methods on {@link BatchRevokePermissionsRequest.Builder} to create a
     *        request.
     * @return Result of the BatchRevokePermissions operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.BatchRevokePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/BatchRevokePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchRevokePermissionsResponse batchRevokePermissions(
            Consumer<BatchRevokePermissionsRequest.Builder> batchRevokePermissionsRequest) throws InvalidInputException,
            OperationTimeoutException, AwsServiceException, SdkClientException, LakeFormationException {
        return batchRevokePermissions(BatchRevokePermissionsRequest.builder().applyMutation(batchRevokePermissionsRequest)
                .build());
    }

    /**
     * <p>
     * Attempts to cancel the specified transaction. Returns an exception if the transaction was previously committed.
     * </p>
     *
     * @param cancelTransactionRequest
     * @return Result of the CancelTransaction operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws TransactionCommittedException
     *         Contains details about an error where the specified transaction has already been committed and cannot be
     *         used for <code>UpdateTableObjects</code>.
     * @throws TransactionCommitInProgressException
     *         Contains details about an error related to a transaction commit that was in progress.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.CancelTransaction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/CancelTransaction"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelTransactionResponse cancelTransaction(CancelTransactionRequest cancelTransactionRequest)
            throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException,
            TransactionCommittedException, TransactionCommitInProgressException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attempts to cancel the specified transaction. Returns an exception if the transaction was previously committed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelTransactionRequest.Builder} avoiding the need
     * to create one manually via {@link CancelTransactionRequest#builder()}
     * </p>
     *
     * @param cancelTransactionRequest
     *        A {@link Consumer} that will call methods on {@link CancelTransactionRequest.Builder} to create a request.
     * @return Result of the CancelTransaction operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws TransactionCommittedException
     *         Contains details about an error where the specified transaction has already been committed and cannot be
     *         used for <code>UpdateTableObjects</code>.
     * @throws TransactionCommitInProgressException
     *         Contains details about an error related to a transaction commit that was in progress.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.CancelTransaction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/CancelTransaction"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelTransactionResponse cancelTransaction(Consumer<CancelTransactionRequest.Builder> cancelTransactionRequest)
            throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException,
            TransactionCommittedException, TransactionCommitInProgressException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, LakeFormationException {
        return cancelTransaction(CancelTransactionRequest.builder().applyMutation(cancelTransactionRequest).build());
    }

    /**
     * <p>
     * Attempts to commit the specified transaction. Returns an exception if the transaction was previously aborted.
     * This API action is idempotent if called multiple times for the same transaction.
     * </p>
     *
     * @param commitTransactionRequest
     * @return Result of the CommitTransaction operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws TransactionCanceledException
     *         Contains details about an error related to a transaction that was cancelled.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.CommitTransaction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/CommitTransaction"
     *      target="_top">AWS API Documentation</a>
     */
    default CommitTransactionResponse commitTransaction(CommitTransactionRequest commitTransactionRequest)
            throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException,
            TransactionCanceledException, ConcurrentModificationException, AwsServiceException, SdkClientException,
            LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attempts to commit the specified transaction. Returns an exception if the transaction was previously aborted.
     * This API action is idempotent if called multiple times for the same transaction.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CommitTransactionRequest.Builder} avoiding the need
     * to create one manually via {@link CommitTransactionRequest#builder()}
     * </p>
     *
     * @param commitTransactionRequest
     *        A {@link Consumer} that will call methods on {@link CommitTransactionRequest.Builder} to create a request.
     * @return Result of the CommitTransaction operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws TransactionCanceledException
     *         Contains details about an error related to a transaction that was cancelled.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.CommitTransaction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/CommitTransaction"
     *      target="_top">AWS API Documentation</a>
     */
    default CommitTransactionResponse commitTransaction(Consumer<CommitTransactionRequest.Builder> commitTransactionRequest)
            throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException,
            TransactionCanceledException, ConcurrentModificationException, AwsServiceException, SdkClientException,
            LakeFormationException {
        return commitTransaction(CommitTransactionRequest.builder().applyMutation(commitTransactionRequest).build());
    }

    /**
     * <p>
     * Creates a data cell filter to allow one to grant access to certain columns on certain rows.
     * </p>
     *
     * @param createDataCellsFilterRequest
     * @return Result of the CreateDataCellsFilter operation returned by the service.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.CreateDataCellsFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/CreateDataCellsFilter"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDataCellsFilterResponse createDataCellsFilter(CreateDataCellsFilterRequest createDataCellsFilterRequest)
            throws AlreadyExistsException, InvalidInputException, EntityNotFoundException, ResourceNumberLimitExceededException,
            InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException,
            LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a data cell filter to allow one to grant access to certain columns on certain rows.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataCellsFilterRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDataCellsFilterRequest#builder()}
     * </p>
     *
     * @param createDataCellsFilterRequest
     *        A {@link Consumer} that will call methods on {@link CreateDataCellsFilterRequest.Builder} to create a
     *        request.
     * @return Result of the CreateDataCellsFilter operation returned by the service.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.CreateDataCellsFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/CreateDataCellsFilter"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDataCellsFilterResponse createDataCellsFilter(
            Consumer<CreateDataCellsFilterRequest.Builder> createDataCellsFilterRequest) throws AlreadyExistsException,
            InvalidInputException, EntityNotFoundException, ResourceNumberLimitExceededException, InternalServiceException,
            OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        return createDataCellsFilter(CreateDataCellsFilterRequest.builder().applyMutation(createDataCellsFilterRequest).build());
    }

    /**
     * <p>
     * Creates an LF-tag with the specified name and values.
     * </p>
     *
     * @param createLfTagRequest
     * @return Result of the CreateLFTag operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.CreateLFTag
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/CreateLFTag" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateLfTagResponse createLFTag(CreateLfTagRequest createLfTagRequest) throws EntityNotFoundException,
            InvalidInputException, ResourceNumberLimitExceededException, InternalServiceException, OperationTimeoutException,
            AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an LF-tag with the specified name and values.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLfTagRequest.Builder} avoiding the need to
     * create one manually via {@link CreateLfTagRequest#builder()}
     * </p>
     *
     * @param createLfTagRequest
     *        A {@link Consumer} that will call methods on {@link CreateLFTagRequest.Builder} to create a request.
     * @return Result of the CreateLFTag operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.CreateLFTag
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/CreateLFTag" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateLfTagResponse createLFTag(Consumer<CreateLfTagRequest.Builder> createLfTagRequest)
            throws EntityNotFoundException, InvalidInputException, ResourceNumberLimitExceededException,
            InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException,
            LakeFormationException {
        return createLFTag(CreateLfTagRequest.builder().applyMutation(createLfTagRequest).build());
    }

    /**
     * <p>
     * Deletes a data cell filter.
     * </p>
     *
     * @param deleteDataCellsFilterRequest
     * @return Result of the DeleteDataCellsFilter operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.DeleteDataCellsFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/DeleteDataCellsFilter"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDataCellsFilterResponse deleteDataCellsFilter(DeleteDataCellsFilterRequest deleteDataCellsFilterRequest)
            throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException,
            AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a data cell filter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDataCellsFilterRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDataCellsFilterRequest#builder()}
     * </p>
     *
     * @param deleteDataCellsFilterRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDataCellsFilterRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteDataCellsFilter operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.DeleteDataCellsFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/DeleteDataCellsFilter"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDataCellsFilterResponse deleteDataCellsFilter(
            Consumer<DeleteDataCellsFilterRequest.Builder> deleteDataCellsFilterRequest) throws InvalidInputException,
            EntityNotFoundException, InternalServiceException, OperationTimeoutException, AccessDeniedException,
            AwsServiceException, SdkClientException, LakeFormationException {
        return deleteDataCellsFilter(DeleteDataCellsFilterRequest.builder().applyMutation(deleteDataCellsFilterRequest).build());
    }

    /**
     * <p>
     * Deletes the specified LF-tag key name. If the attribute key does not exist or the LF-tag does not exist, then the
     * operation will not do anything. If the attribute key exists, then the operation checks if any resources are
     * tagged with this attribute key, if yes, the API throws a 400 Exception with the message "Delete not allowed" as
     * the LF-tag key is still attached with resources. You can consider untagging resources with this LF-tag key.
     * </p>
     *
     * @param deleteLfTagRequest
     * @return Result of the DeleteLFTag operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.DeleteLFTag
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/DeleteLFTag" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteLfTagResponse deleteLFTag(DeleteLfTagRequest deleteLfTagRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, AccessDeniedException,
            AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified LF-tag key name. If the attribute key does not exist or the LF-tag does not exist, then the
     * operation will not do anything. If the attribute key exists, then the operation checks if any resources are
     * tagged with this attribute key, if yes, the API throws a 400 Exception with the message "Delete not allowed" as
     * the LF-tag key is still attached with resources. You can consider untagging resources with this LF-tag key.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLfTagRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteLfTagRequest#builder()}
     * </p>
     *
     * @param deleteLfTagRequest
     *        A {@link Consumer} that will call methods on {@link DeleteLFTagRequest.Builder} to create a request.
     * @return Result of the DeleteLFTag operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.DeleteLFTag
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/DeleteLFTag" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteLfTagResponse deleteLFTag(Consumer<DeleteLfTagRequest.Builder> deleteLfTagRequest)
            throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        return deleteLFTag(DeleteLfTagRequest.builder().applyMutation(deleteLfTagRequest).build());
    }

    /**
     * <p>
     * For a specific governed table, provides a list of Amazon S3 objects that will be written during the current
     * transaction and that can be automatically deleted if the transaction is canceled. Without this call, no Amazon S3
     * objects are automatically deleted when a transaction cancels.
     * </p>
     * <p>
     * The Glue ETL library function <code>write_dynamic_frame.from_catalog()</code> includes an option to automatically
     * call <code>DeleteObjectsOnCancel</code> before writes. For more information, see <a href=
     * "https://docs.aws.amazon.com/lake-formation/latest/dg/transactions-data-operations.html#rolling-back-writes"
     * >Rolling Back Amazon S3 Writes</a>.
     * </p>
     *
     * @param deleteObjectsOnCancelRequest
     * @return Result of the DeleteObjectsOnCancel operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws TransactionCommittedException
     *         Contains details about an error where the specified transaction has already been committed and cannot be
     *         used for <code>UpdateTableObjects</code>.
     * @throws TransactionCanceledException
     *         Contains details about an error related to a transaction that was cancelled.
     * @throws ResourceNotReadyException
     *         Contains details about an error related to a resource which is not ready for a transaction.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.DeleteObjectsOnCancel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/DeleteObjectsOnCancel"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteObjectsOnCancelResponse deleteObjectsOnCancel(DeleteObjectsOnCancelRequest deleteObjectsOnCancelRequest)
            throws InternalServiceException, InvalidInputException, OperationTimeoutException, EntityNotFoundException,
            TransactionCommittedException, TransactionCanceledException, ResourceNotReadyException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For a specific governed table, provides a list of Amazon S3 objects that will be written during the current
     * transaction and that can be automatically deleted if the transaction is canceled. Without this call, no Amazon S3
     * objects are automatically deleted when a transaction cancels.
     * </p>
     * <p>
     * The Glue ETL library function <code>write_dynamic_frame.from_catalog()</code> includes an option to automatically
     * call <code>DeleteObjectsOnCancel</code> before writes. For more information, see <a href=
     * "https://docs.aws.amazon.com/lake-formation/latest/dg/transactions-data-operations.html#rolling-back-writes"
     * >Rolling Back Amazon S3 Writes</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteObjectsOnCancelRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteObjectsOnCancelRequest#builder()}
     * </p>
     *
     * @param deleteObjectsOnCancelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteObjectsOnCancelRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteObjectsOnCancel operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws TransactionCommittedException
     *         Contains details about an error where the specified transaction has already been committed and cannot be
     *         used for <code>UpdateTableObjects</code>.
     * @throws TransactionCanceledException
     *         Contains details about an error related to a transaction that was cancelled.
     * @throws ResourceNotReadyException
     *         Contains details about an error related to a resource which is not ready for a transaction.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.DeleteObjectsOnCancel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/DeleteObjectsOnCancel"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteObjectsOnCancelResponse deleteObjectsOnCancel(
            Consumer<DeleteObjectsOnCancelRequest.Builder> deleteObjectsOnCancelRequest) throws InternalServiceException,
            InvalidInputException, OperationTimeoutException, EntityNotFoundException, TransactionCommittedException,
            TransactionCanceledException, ResourceNotReadyException, ConcurrentModificationException, AwsServiceException,
            SdkClientException, LakeFormationException {
        return deleteObjectsOnCancel(DeleteObjectsOnCancelRequest.builder().applyMutation(deleteObjectsOnCancelRequest).build());
    }

    /**
     * <p>
     * Deregisters the resource as managed by the Data Catalog.
     * </p>
     * <p>
     * When you deregister a path, Lake Formation removes the path from the inline policy attached to your
     * service-linked role.
     * </p>
     *
     * @param deregisterResourceRequest
     * @return Result of the DeregisterResource operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.DeregisterResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/DeregisterResource"
     *      target="_top">AWS API Documentation</a>
     */
    default DeregisterResourceResponse deregisterResource(DeregisterResourceRequest deregisterResourceRequest)
            throws InvalidInputException, InternalServiceException, OperationTimeoutException, EntityNotFoundException,
            AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deregisters the resource as managed by the Data Catalog.
     * </p>
     * <p>
     * When you deregister a path, Lake Formation removes the path from the inline policy attached to your
     * service-linked role.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterResourceRequest.Builder} avoiding the
     * need to create one manually via {@link DeregisterResourceRequest#builder()}
     * </p>
     *
     * @param deregisterResourceRequest
     *        A {@link Consumer} that will call methods on {@link DeregisterResourceRequest.Builder} to create a
     *        request.
     * @return Result of the DeregisterResource operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.DeregisterResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/DeregisterResource"
     *      target="_top">AWS API Documentation</a>
     */
    default DeregisterResourceResponse deregisterResource(Consumer<DeregisterResourceRequest.Builder> deregisterResourceRequest)
            throws InvalidInputException, InternalServiceException, OperationTimeoutException, EntityNotFoundException,
            AwsServiceException, SdkClientException, LakeFormationException {
        return deregisterResource(DeregisterResourceRequest.builder().applyMutation(deregisterResourceRequest).build());
    }

    /**
     * <p>
     * Retrieves the current data access role for the given resource registered in Lake Formation.
     * </p>
     *
     * @param describeResourceRequest
     * @return Result of the DescribeResource operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.DescribeResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/DescribeResource"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeResourceResponse describeResource(DescribeResourceRequest describeResourceRequest)
            throws InvalidInputException, InternalServiceException, OperationTimeoutException, EntityNotFoundException,
            AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the current data access role for the given resource registered in Lake Formation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeResourceRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeResourceRequest#builder()}
     * </p>
     *
     * @param describeResourceRequest
     *        A {@link Consumer} that will call methods on {@link DescribeResourceRequest.Builder} to create a request.
     * @return Result of the DescribeResource operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.DescribeResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/DescribeResource"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeResourceResponse describeResource(Consumer<DescribeResourceRequest.Builder> describeResourceRequest)
            throws InvalidInputException, InternalServiceException, OperationTimeoutException, EntityNotFoundException,
            AwsServiceException, SdkClientException, LakeFormationException {
        return describeResource(DescribeResourceRequest.builder().applyMutation(describeResourceRequest).build());
    }

    /**
     * <p>
     * Returns the details of a single transaction.
     * </p>
     *
     * @param describeTransactionRequest
     * @return Result of the DescribeTransaction operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.DescribeTransaction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/DescribeTransaction"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTransactionResponse describeTransaction(DescribeTransactionRequest describeTransactionRequest)
            throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details of a single transaction.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTransactionRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeTransactionRequest#builder()}
     * </p>
     *
     * @param describeTransactionRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTransactionRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeTransaction operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.DescribeTransaction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/DescribeTransaction"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTransactionResponse describeTransaction(
            Consumer<DescribeTransactionRequest.Builder> describeTransactionRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException,
            LakeFormationException {
        return describeTransaction(DescribeTransactionRequest.builder().applyMutation(describeTransactionRequest).build());
    }

    /**
     * <p>
     * Indicates to the service that the specified transaction is still active and should not be treated as idle and
     * aborted.
     * </p>
     * <p>
     * Write transactions that remain idle for a long period are automatically aborted unless explicitly extended.
     * </p>
     *
     * @param extendTransactionRequest
     * @return Result of the ExtendTransaction operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws TransactionCommittedException
     *         Contains details about an error where the specified transaction has already been committed and cannot be
     *         used for <code>UpdateTableObjects</code>.
     * @throws TransactionCanceledException
     *         Contains details about an error related to a transaction that was cancelled.
     * @throws TransactionCommitInProgressException
     *         Contains details about an error related to a transaction commit that was in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.ExtendTransaction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ExtendTransaction"
     *      target="_top">AWS API Documentation</a>
     */
    default ExtendTransactionResponse extendTransaction(ExtendTransactionRequest extendTransactionRequest)
            throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException,
            TransactionCommittedException, TransactionCanceledException, TransactionCommitInProgressException,
            AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Indicates to the service that the specified transaction is still active and should not be treated as idle and
     * aborted.
     * </p>
     * <p>
     * Write transactions that remain idle for a long period are automatically aborted unless explicitly extended.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExtendTransactionRequest.Builder} avoiding the need
     * to create one manually via {@link ExtendTransactionRequest#builder()}
     * </p>
     *
     * @param extendTransactionRequest
     *        A {@link Consumer} that will call methods on {@link ExtendTransactionRequest.Builder} to create a request.
     * @return Result of the ExtendTransaction operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws TransactionCommittedException
     *         Contains details about an error where the specified transaction has already been committed and cannot be
     *         used for <code>UpdateTableObjects</code>.
     * @throws TransactionCanceledException
     *         Contains details about an error related to a transaction that was cancelled.
     * @throws TransactionCommitInProgressException
     *         Contains details about an error related to a transaction commit that was in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.ExtendTransaction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ExtendTransaction"
     *      target="_top">AWS API Documentation</a>
     */
    default ExtendTransactionResponse extendTransaction(Consumer<ExtendTransactionRequest.Builder> extendTransactionRequest)
            throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException,
            TransactionCommittedException, TransactionCanceledException, TransactionCommitInProgressException,
            AwsServiceException, SdkClientException, LakeFormationException {
        return extendTransaction(ExtendTransactionRequest.builder().applyMutation(extendTransactionRequest).build());
    }

    /**
     * <p>
     * Retrieves the list of the data lake administrators of a Lake Formation-managed data lake.
     * </p>
     *
     * @param getDataLakeSettingsRequest
     * @return Result of the GetDataLakeSettings operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.GetDataLakeSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetDataLakeSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDataLakeSettingsResponse getDataLakeSettings(GetDataLakeSettingsRequest getDataLakeSettingsRequest)
            throws InternalServiceException, InvalidInputException, EntityNotFoundException, AwsServiceException,
            SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the list of the data lake administrators of a Lake Formation-managed data lake.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataLakeSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link GetDataLakeSettingsRequest#builder()}
     * </p>
     *
     * @param getDataLakeSettingsRequest
     *        A {@link Consumer} that will call methods on {@link GetDataLakeSettingsRequest.Builder} to create a
     *        request.
     * @return Result of the GetDataLakeSettings operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.GetDataLakeSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetDataLakeSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDataLakeSettingsResponse getDataLakeSettings(
            Consumer<GetDataLakeSettingsRequest.Builder> getDataLakeSettingsRequest) throws InternalServiceException,
            InvalidInputException, EntityNotFoundException, AwsServiceException, SdkClientException, LakeFormationException {
        return getDataLakeSettings(GetDataLakeSettingsRequest.builder().applyMutation(getDataLakeSettingsRequest).build());
    }

    /**
     * <p>
     * Returns the Lake Formation permissions for a specified table or database resource located at a path in Amazon S3.
     * <code>GetEffectivePermissionsForPath</code> will not return databases and tables if the catalog is encrypted.
     * </p>
     *
     * @param getEffectivePermissionsForPathRequest
     * @return Result of the GetEffectivePermissionsForPath operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.GetEffectivePermissionsForPath
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetEffectivePermissionsForPath"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEffectivePermissionsForPathResponse getEffectivePermissionsForPath(
            GetEffectivePermissionsForPathRequest getEffectivePermissionsForPathRequest) throws InvalidInputException,
            EntityNotFoundException, OperationTimeoutException, InternalServiceException, AwsServiceException,
            SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the Lake Formation permissions for a specified table or database resource located at a path in Amazon S3.
     * <code>GetEffectivePermissionsForPath</code> will not return databases and tables if the catalog is encrypted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEffectivePermissionsForPathRequest.Builder}
     * avoiding the need to create one manually via {@link GetEffectivePermissionsForPathRequest#builder()}
     * </p>
     *
     * @param getEffectivePermissionsForPathRequest
     *        A {@link Consumer} that will call methods on {@link GetEffectivePermissionsForPathRequest.Builder} to
     *        create a request.
     * @return Result of the GetEffectivePermissionsForPath operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.GetEffectivePermissionsForPath
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetEffectivePermissionsForPath"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEffectivePermissionsForPathResponse getEffectivePermissionsForPath(
            Consumer<GetEffectivePermissionsForPathRequest.Builder> getEffectivePermissionsForPathRequest)
            throws InvalidInputException, EntityNotFoundException, OperationTimeoutException, InternalServiceException,
            AwsServiceException, SdkClientException, LakeFormationException {
        return getEffectivePermissionsForPath(GetEffectivePermissionsForPathRequest.builder()
                .applyMutation(getEffectivePermissionsForPathRequest).build());
    }

    /**
     * <p>
     * Returns the Lake Formation permissions for a specified table or database resource located at a path in Amazon S3.
     * <code>GetEffectivePermissionsForPath</code> will not return databases and tables if the catalog is encrypted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getEffectivePermissionsForPath(software.amazon.awssdk.services.lakeformation.model.GetEffectivePermissionsForPathRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.GetEffectivePermissionsForPathIterable responses = client.getEffectivePermissionsForPathPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lakeformation.paginators.GetEffectivePermissionsForPathIterable responses = client
     *             .getEffectivePermissionsForPathPaginator(request);
     *     for (software.amazon.awssdk.services.lakeformation.model.GetEffectivePermissionsForPathResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.GetEffectivePermissionsForPathIterable responses = client.getEffectivePermissionsForPathPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getEffectivePermissionsForPath(software.amazon.awssdk.services.lakeformation.model.GetEffectivePermissionsForPathRequest)}
     * operation.</b>
     * </p>
     *
     * @param getEffectivePermissionsForPathRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.GetEffectivePermissionsForPath
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetEffectivePermissionsForPath"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEffectivePermissionsForPathIterable getEffectivePermissionsForPathPaginator(
            GetEffectivePermissionsForPathRequest getEffectivePermissionsForPathRequest) throws InvalidInputException,
            EntityNotFoundException, OperationTimeoutException, InternalServiceException, AwsServiceException,
            SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the Lake Formation permissions for a specified table or database resource located at a path in Amazon S3.
     * <code>GetEffectivePermissionsForPath</code> will not return databases and tables if the catalog is encrypted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getEffectivePermissionsForPath(software.amazon.awssdk.services.lakeformation.model.GetEffectivePermissionsForPathRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.GetEffectivePermissionsForPathIterable responses = client.getEffectivePermissionsForPathPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lakeformation.paginators.GetEffectivePermissionsForPathIterable responses = client
     *             .getEffectivePermissionsForPathPaginator(request);
     *     for (software.amazon.awssdk.services.lakeformation.model.GetEffectivePermissionsForPathResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.GetEffectivePermissionsForPathIterable responses = client.getEffectivePermissionsForPathPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getEffectivePermissionsForPath(software.amazon.awssdk.services.lakeformation.model.GetEffectivePermissionsForPathRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEffectivePermissionsForPathRequest.Builder}
     * avoiding the need to create one manually via {@link GetEffectivePermissionsForPathRequest#builder()}
     * </p>
     *
     * @param getEffectivePermissionsForPathRequest
     *        A {@link Consumer} that will call methods on {@link GetEffectivePermissionsForPathRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.GetEffectivePermissionsForPath
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetEffectivePermissionsForPath"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEffectivePermissionsForPathIterable getEffectivePermissionsForPathPaginator(
            Consumer<GetEffectivePermissionsForPathRequest.Builder> getEffectivePermissionsForPathRequest)
            throws InvalidInputException, EntityNotFoundException, OperationTimeoutException, InternalServiceException,
            AwsServiceException, SdkClientException, LakeFormationException {
        return getEffectivePermissionsForPathPaginator(GetEffectivePermissionsForPathRequest.builder()
                .applyMutation(getEffectivePermissionsForPathRequest).build());
    }

    /**
     * <p>
     * Returns an LF-tag definition.
     * </p>
     *
     * @param getLfTagRequest
     * @return Result of the GetLFTag operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.GetLFTag
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetLFTag" target="_top">AWS API
     *      Documentation</a>
     */
    default GetLfTagResponse getLFTag(GetLfTagRequest getLfTagRequest) throws EntityNotFoundException, InvalidInputException,
            InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException,
            LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an LF-tag definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLfTagRequest.Builder} avoiding the need to
     * create one manually via {@link GetLfTagRequest#builder()}
     * </p>
     *
     * @param getLfTagRequest
     *        A {@link Consumer} that will call methods on {@link GetLFTagRequest.Builder} to create a request.
     * @return Result of the GetLFTag operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.GetLFTag
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetLFTag" target="_top">AWS API
     *      Documentation</a>
     */
    default GetLfTagResponse getLFTag(Consumer<GetLfTagRequest.Builder> getLfTagRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, AccessDeniedException,
            AwsServiceException, SdkClientException, LakeFormationException {
        return getLFTag(GetLfTagRequest.builder().applyMutation(getLfTagRequest).build());
    }

    /**
     * <p>
     * Returns the state of a query previously submitted. Clients are expected to poll <code>GetQueryState</code> to
     * monitor the current state of the planning before retrieving the work units. A query state is only visible to the
     * principal that made the initial call to <code>StartQueryPlanning</code>.
     * </p>
     *
     * @param getQueryStateRequest
     * @return Result of the GetQueryState operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.GetQueryState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetQueryState" target="_top">AWS
     *      API Documentation</a>
     */
    default GetQueryStateResponse getQueryState(GetQueryStateRequest getQueryStateRequest) throws InternalServiceException,
            InvalidInputException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the state of a query previously submitted. Clients are expected to poll <code>GetQueryState</code> to
     * monitor the current state of the planning before retrieving the work units. A query state is only visible to the
     * principal that made the initial call to <code>StartQueryPlanning</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetQueryStateRequest.Builder} avoiding the need to
     * create one manually via {@link GetQueryStateRequest#builder()}
     * </p>
     *
     * @param getQueryStateRequest
     *        A {@link Consumer} that will call methods on {@link GetQueryStateRequest.Builder} to create a request.
     * @return Result of the GetQueryState operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.GetQueryState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetQueryState" target="_top">AWS
     *      API Documentation</a>
     */
    default GetQueryStateResponse getQueryState(Consumer<GetQueryStateRequest.Builder> getQueryStateRequest)
            throws InternalServiceException, InvalidInputException, AccessDeniedException, AwsServiceException,
            SdkClientException, LakeFormationException {
        return getQueryState(GetQueryStateRequest.builder().applyMutation(getQueryStateRequest).build());
    }

    /**
     * <p>
     * Retrieves statistics on the planning and execution of a query.
     * </p>
     *
     * @param getQueryStatisticsRequest
     * @return Result of the GetQueryStatistics operation returned by the service.
     * @throws StatisticsNotReadyYetException
     *         Contains details about an error related to statistics not being ready.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws ExpiredException
     *         Contains details about an error where the query request expired.
     * @throws ThrottledException
     *         Contains details about an error where the query request was throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.GetQueryStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetQueryStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default GetQueryStatisticsResponse getQueryStatistics(GetQueryStatisticsRequest getQueryStatisticsRequest)
            throws StatisticsNotReadyYetException, InternalServiceException, InvalidInputException, AccessDeniedException,
            ExpiredException, ThrottledException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves statistics on the planning and execution of a query.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetQueryStatisticsRequest.Builder} avoiding the
     * need to create one manually via {@link GetQueryStatisticsRequest#builder()}
     * </p>
     *
     * @param getQueryStatisticsRequest
     *        A {@link Consumer} that will call methods on {@link GetQueryStatisticsRequest.Builder} to create a
     *        request.
     * @return Result of the GetQueryStatistics operation returned by the service.
     * @throws StatisticsNotReadyYetException
     *         Contains details about an error related to statistics not being ready.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws ExpiredException
     *         Contains details about an error where the query request expired.
     * @throws ThrottledException
     *         Contains details about an error where the query request was throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.GetQueryStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetQueryStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default GetQueryStatisticsResponse getQueryStatistics(Consumer<GetQueryStatisticsRequest.Builder> getQueryStatisticsRequest)
            throws StatisticsNotReadyYetException, InternalServiceException, InvalidInputException, AccessDeniedException,
            ExpiredException, ThrottledException, AwsServiceException, SdkClientException, LakeFormationException {
        return getQueryStatistics(GetQueryStatisticsRequest.builder().applyMutation(getQueryStatisticsRequest).build());
    }

    /**
     * <p>
     * Returns the LF-tags applied to a resource.
     * </p>
     *
     * @param getResourceLfTagsRequest
     * @return Result of the GetResourceLFTags operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.GetResourceLFTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetResourceLFTags"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceLfTagsResponse getResourceLFTags(GetResourceLfTagsRequest getResourceLfTagsRequest)
            throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            GlueEncryptionException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the LF-tags applied to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceLfTagsRequest.Builder} avoiding the need
     * to create one manually via {@link GetResourceLfTagsRequest#builder()}
     * </p>
     *
     * @param getResourceLfTagsRequest
     *        A {@link Consumer} that will call methods on {@link GetResourceLFTagsRequest.Builder} to create a request.
     * @return Result of the GetResourceLFTags operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.GetResourceLFTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetResourceLFTags"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceLfTagsResponse getResourceLFTags(Consumer<GetResourceLfTagsRequest.Builder> getResourceLfTagsRequest)
            throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            GlueEncryptionException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        return getResourceLFTags(GetResourceLfTagsRequest.builder().applyMutation(getResourceLfTagsRequest).build());
    }

    /**
     * <p>
     * Returns the set of Amazon S3 objects that make up the specified governed table. A transaction ID or timestamp can
     * be specified for time-travel queries.
     * </p>
     *
     * @param getTableObjectsRequest
     * @return Result of the GetTableObjects operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws TransactionCommittedException
     *         Contains details about an error where the specified transaction has already been committed and cannot be
     *         used for <code>UpdateTableObjects</code>.
     * @throws TransactionCanceledException
     *         Contains details about an error related to a transaction that was cancelled.
     * @throws ResourceNotReadyException
     *         Contains details about an error related to a resource which is not ready for a transaction.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.GetTableObjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetTableObjects" target="_top">AWS
     *      API Documentation</a>
     */
    default GetTableObjectsResponse getTableObjects(GetTableObjectsRequest getTableObjectsRequest)
            throws EntityNotFoundException, InternalServiceException, InvalidInputException, OperationTimeoutException,
            TransactionCommittedException, TransactionCanceledException, ResourceNotReadyException, AwsServiceException,
            SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the set of Amazon S3 objects that make up the specified governed table. A transaction ID or timestamp can
     * be specified for time-travel queries.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTableObjectsRequest.Builder} avoiding the need
     * to create one manually via {@link GetTableObjectsRequest#builder()}
     * </p>
     *
     * @param getTableObjectsRequest
     *        A {@link Consumer} that will call methods on {@link GetTableObjectsRequest.Builder} to create a request.
     * @return Result of the GetTableObjects operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws TransactionCommittedException
     *         Contains details about an error where the specified transaction has already been committed and cannot be
     *         used for <code>UpdateTableObjects</code>.
     * @throws TransactionCanceledException
     *         Contains details about an error related to a transaction that was cancelled.
     * @throws ResourceNotReadyException
     *         Contains details about an error related to a resource which is not ready for a transaction.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.GetTableObjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetTableObjects" target="_top">AWS
     *      API Documentation</a>
     */
    default GetTableObjectsResponse getTableObjects(Consumer<GetTableObjectsRequest.Builder> getTableObjectsRequest)
            throws EntityNotFoundException, InternalServiceException, InvalidInputException, OperationTimeoutException,
            TransactionCommittedException, TransactionCanceledException, ResourceNotReadyException, AwsServiceException,
            SdkClientException, LakeFormationException {
        return getTableObjects(GetTableObjectsRequest.builder().applyMutation(getTableObjectsRequest).build());
    }

    /**
     * <p>
     * Returns the set of Amazon S3 objects that make up the specified governed table. A transaction ID or timestamp can
     * be specified for time-travel queries.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getTableObjects(software.amazon.awssdk.services.lakeformation.model.GetTableObjectsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.GetTableObjectsIterable responses = client.getTableObjectsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lakeformation.paginators.GetTableObjectsIterable responses = client
     *             .getTableObjectsPaginator(request);
     *     for (software.amazon.awssdk.services.lakeformation.model.GetTableObjectsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.GetTableObjectsIterable responses = client.getTableObjectsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getTableObjects(software.amazon.awssdk.services.lakeformation.model.GetTableObjectsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getTableObjectsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws TransactionCommittedException
     *         Contains details about an error where the specified transaction has already been committed and cannot be
     *         used for <code>UpdateTableObjects</code>.
     * @throws TransactionCanceledException
     *         Contains details about an error related to a transaction that was cancelled.
     * @throws ResourceNotReadyException
     *         Contains details about an error related to a resource which is not ready for a transaction.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.GetTableObjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetTableObjects" target="_top">AWS
     *      API Documentation</a>
     */
    default GetTableObjectsIterable getTableObjectsPaginator(GetTableObjectsRequest getTableObjectsRequest)
            throws EntityNotFoundException, InternalServiceException, InvalidInputException, OperationTimeoutException,
            TransactionCommittedException, TransactionCanceledException, ResourceNotReadyException, AwsServiceException,
            SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the set of Amazon S3 objects that make up the specified governed table. A transaction ID or timestamp can
     * be specified for time-travel queries.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getTableObjects(software.amazon.awssdk.services.lakeformation.model.GetTableObjectsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.GetTableObjectsIterable responses = client.getTableObjectsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lakeformation.paginators.GetTableObjectsIterable responses = client
     *             .getTableObjectsPaginator(request);
     *     for (software.amazon.awssdk.services.lakeformation.model.GetTableObjectsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.GetTableObjectsIterable responses = client.getTableObjectsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getTableObjects(software.amazon.awssdk.services.lakeformation.model.GetTableObjectsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTableObjectsRequest.Builder} avoiding the need
     * to create one manually via {@link GetTableObjectsRequest#builder()}
     * </p>
     *
     * @param getTableObjectsRequest
     *        A {@link Consumer} that will call methods on {@link GetTableObjectsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws TransactionCommittedException
     *         Contains details about an error where the specified transaction has already been committed and cannot be
     *         used for <code>UpdateTableObjects</code>.
     * @throws TransactionCanceledException
     *         Contains details about an error related to a transaction that was cancelled.
     * @throws ResourceNotReadyException
     *         Contains details about an error related to a resource which is not ready for a transaction.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.GetTableObjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetTableObjects" target="_top">AWS
     *      API Documentation</a>
     */
    default GetTableObjectsIterable getTableObjectsPaginator(Consumer<GetTableObjectsRequest.Builder> getTableObjectsRequest)
            throws EntityNotFoundException, InternalServiceException, InvalidInputException, OperationTimeoutException,
            TransactionCommittedException, TransactionCanceledException, ResourceNotReadyException, AwsServiceException,
            SdkClientException, LakeFormationException {
        return getTableObjectsPaginator(GetTableObjectsRequest.builder().applyMutation(getTableObjectsRequest).build());
    }

    /**
     * <p>
     * Returns the work units resulting from the query. Work units can be executed in any order and in parallel.
     * </p>
     *
     * @param getWorkUnitResultsRequest
     * @param responseTransformer
     *        Functional interface for processing the streamed response content. The unmarshalled
     *        GetWorkUnitResultsResponse and an InputStream to the response content are provided as parameters to the
     *        callback. The callback may return a transformed type which will be the return value of this method. See
     *        {@link software.amazon.awssdk.core.sync.ResponseTransformer} for details on implementing this interface
     *        and for links to pre-canned implementations for common scenarios like downloading to a file. The service
     *        documentation for the response content is as follows '
     *        <p>
     *        Rows returned from the <code>GetWorkUnitResults</code> operation as a stream of Apache Arrow v1.0
     *        messages.
     *        </p>
     *        '.
     * @return The transformed result of the ResponseTransformer.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws ExpiredException
     *         Contains details about an error where the query request expired.
     * @throws ThrottledException
     *         Contains details about an error where the query request was throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.GetWorkUnitResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetWorkUnitResults"
     *      target="_top">AWS API Documentation</a>
     */
    default <ReturnT> ReturnT getWorkUnitResults(GetWorkUnitResultsRequest getWorkUnitResultsRequest,
            ResponseTransformer<GetWorkUnitResultsResponse, ReturnT> responseTransformer) throws InternalServiceException,
            InvalidInputException, AccessDeniedException, ExpiredException, ThrottledException, AwsServiceException,
            SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the work units resulting from the query. Work units can be executed in any order and in parallel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkUnitResultsRequest.Builder} avoiding the
     * need to create one manually via {@link GetWorkUnitResultsRequest#builder()}
     * </p>
     *
     * @param getWorkUnitResultsRequest
     *        A {@link Consumer} that will call methods on {@link GetWorkUnitResultsRequest.Builder} to create a
     *        request.
     * @param responseTransformer
     *        Functional interface for processing the streamed response content. The unmarshalled
     *        GetWorkUnitResultsResponse and an InputStream to the response content are provided as parameters to the
     *        callback. The callback may return a transformed type which will be the return value of this method. See
     *        {@link software.amazon.awssdk.core.sync.ResponseTransformer} for details on implementing this interface
     *        and for links to pre-canned implementations for common scenarios like downloading to a file. The service
     *        documentation for the response content is as follows '
     *        <p>
     *        Rows returned from the <code>GetWorkUnitResults</code> operation as a stream of Apache Arrow v1.0
     *        messages.
     *        </p>
     *        '.
     * @return The transformed result of the ResponseTransformer.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws ExpiredException
     *         Contains details about an error where the query request expired.
     * @throws ThrottledException
     *         Contains details about an error where the query request was throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.GetWorkUnitResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetWorkUnitResults"
     *      target="_top">AWS API Documentation</a>
     */
    default <ReturnT> ReturnT getWorkUnitResults(Consumer<GetWorkUnitResultsRequest.Builder> getWorkUnitResultsRequest,
            ResponseTransformer<GetWorkUnitResultsResponse, ReturnT> responseTransformer) throws InternalServiceException,
            InvalidInputException, AccessDeniedException, ExpiredException, ThrottledException, AwsServiceException,
            SdkClientException, LakeFormationException {
        return getWorkUnitResults(GetWorkUnitResultsRequest.builder().applyMutation(getWorkUnitResultsRequest).build(),
                responseTransformer);
    }

    /**
     * <p>
     * Returns the work units resulting from the query. Work units can be executed in any order and in parallel.
     * </p>
     *
     * @param getWorkUnitResultsRequest
     * @param destinationPath
     *        {@link Path} to file that response contents will be written to. The file must not exist or this method
     *        will throw an exception. If the file is not writable by the current user then an exception will be thrown.
     *        The service documentation for the response content is as follows '
     *        <p>
     *        Rows returned from the <code>GetWorkUnitResults</code> operation as a stream of Apache Arrow v1.0
     *        messages.
     *        </p>
     *        '.
     * @return The transformed result of the ResponseTransformer.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws ExpiredException
     *         Contains details about an error where the query request expired.
     * @throws ThrottledException
     *         Contains details about an error where the query request was throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.GetWorkUnitResults
     * @see #getWorkUnitResults(GetWorkUnitResultsRequest, ResponseTransformer)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetWorkUnitResults"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWorkUnitResultsResponse getWorkUnitResults(GetWorkUnitResultsRequest getWorkUnitResultsRequest,
            Path destinationPath) throws InternalServiceException, InvalidInputException, AccessDeniedException,
            ExpiredException, ThrottledException, AwsServiceException, SdkClientException, LakeFormationException {
        return getWorkUnitResults(getWorkUnitResultsRequest, ResponseTransformer.toFile(destinationPath));
    }

    /**
     * <p>
     * Returns the work units resulting from the query. Work units can be executed in any order and in parallel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkUnitResultsRequest.Builder} avoiding the
     * need to create one manually via {@link GetWorkUnitResultsRequest#builder()}
     * </p>
     *
     * @param getWorkUnitResultsRequest
     *        A {@link Consumer} that will call methods on {@link GetWorkUnitResultsRequest.Builder} to create a
     *        request.
     * @param destinationPath
     *        {@link Path} to file that response contents will be written to. The file must not exist or this method
     *        will throw an exception. If the file is not writable by the current user then an exception will be thrown.
     *        The service documentation for the response content is as follows '
     *        <p>
     *        Rows returned from the <code>GetWorkUnitResults</code> operation as a stream of Apache Arrow v1.0
     *        messages.
     *        </p>
     *        '.
     * @return The transformed result of the ResponseTransformer.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws ExpiredException
     *         Contains details about an error where the query request expired.
     * @throws ThrottledException
     *         Contains details about an error where the query request was throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.GetWorkUnitResults
     * @see #getWorkUnitResults(GetWorkUnitResultsRequest, ResponseTransformer)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetWorkUnitResults"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWorkUnitResultsResponse getWorkUnitResults(Consumer<GetWorkUnitResultsRequest.Builder> getWorkUnitResultsRequest,
            Path destinationPath) throws InternalServiceException, InvalidInputException, AccessDeniedException,
            ExpiredException, ThrottledException, AwsServiceException, SdkClientException, LakeFormationException {
        return getWorkUnitResults(GetWorkUnitResultsRequest.builder().applyMutation(getWorkUnitResultsRequest).build(),
                destinationPath);
    }

    /**
     * <p>
     * Returns the work units resulting from the query. Work units can be executed in any order and in parallel.
     * </p>
     *
     * @param getWorkUnitResultsRequest
     * @return A {@link ResponseInputStream} containing data streamed from service. Note that this is an unmanaged
     *         reference to the underlying HTTP connection so great care must be taken to ensure all data if fully read
     *         from the input stream and that it is properly closed. Failure to do so may result in sub-optimal behavior
     *         and exhausting connections in the connection pool. The unmarshalled response object can be obtained via
     *         {@link ResponseInputStream#response()}. The service documentation for the response content is as follows
     *         '
     *         <p>
     *         Rows returned from the <code>GetWorkUnitResults</code> operation as a stream of Apache Arrow v1.0
     *         messages.
     *         </p>
     *         '.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws ExpiredException
     *         Contains details about an error where the query request expired.
     * @throws ThrottledException
     *         Contains details about an error where the query request was throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.GetWorkUnitResults
     * @see #getObject(getWorkUnitResults, ResponseTransformer)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetWorkUnitResults"
     *      target="_top">AWS API Documentation</a>
     */
    default ResponseInputStream<GetWorkUnitResultsResponse> getWorkUnitResults(GetWorkUnitResultsRequest getWorkUnitResultsRequest)
            throws InternalServiceException, InvalidInputException, AccessDeniedException, ExpiredException, ThrottledException,
            AwsServiceException, SdkClientException, LakeFormationException {
        return getWorkUnitResults(getWorkUnitResultsRequest, ResponseTransformer.toInputStream());
    }

    /**
     * <p>
     * Returns the work units resulting from the query. Work units can be executed in any order and in parallel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkUnitResultsRequest.Builder} avoiding the
     * need to create one manually via {@link GetWorkUnitResultsRequest#builder()}
     * </p>
     *
     * @param getWorkUnitResultsRequest
     *        A {@link Consumer} that will call methods on {@link GetWorkUnitResultsRequest.Builder} to create a
     *        request.
     * @return A {@link ResponseInputStream} containing data streamed from service. Note that this is an unmanaged
     *         reference to the underlying HTTP connection so great care must be taken to ensure all data if fully read
     *         from the input stream and that it is properly closed. Failure to do so may result in sub-optimal behavior
     *         and exhausting connections in the connection pool. The unmarshalled response object can be obtained via
     *         {@link ResponseInputStream#response()}. The service documentation for the response content is as follows
     *         '
     *         <p>
     *         Rows returned from the <code>GetWorkUnitResults</code> operation as a stream of Apache Arrow v1.0
     *         messages.
     *         </p>
     *         '.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws ExpiredException
     *         Contains details about an error where the query request expired.
     * @throws ThrottledException
     *         Contains details about an error where the query request was throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.GetWorkUnitResults
     * @see #getObject(getWorkUnitResults, ResponseTransformer)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetWorkUnitResults"
     *      target="_top">AWS API Documentation</a>
     */
    default ResponseInputStream<GetWorkUnitResultsResponse> getWorkUnitResults(
            Consumer<GetWorkUnitResultsRequest.Builder> getWorkUnitResultsRequest) throws InternalServiceException,
            InvalidInputException, AccessDeniedException, ExpiredException, ThrottledException, AwsServiceException,
            SdkClientException, LakeFormationException {
        return getWorkUnitResults(GetWorkUnitResultsRequest.builder().applyMutation(getWorkUnitResultsRequest).build());
    }

    /**
     * <p>
     * Returns the work units resulting from the query. Work units can be executed in any order and in parallel.
     * </p>
     *
     * @param getWorkUnitResultsRequest
     * @return A {@link ResponseBytes} that loads the data streamed from the service into memory and exposes it in
     *         convenient in-memory representations like a byte buffer or string. The unmarshalled response object can
     *         be obtained via {@link ResponseBytes#response()}. The service documentation for the response content is
     *         as follows '
     *         <p>
     *         Rows returned from the <code>GetWorkUnitResults</code> operation as a stream of Apache Arrow v1.0
     *         messages.
     *         </p>
     *         '.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws ExpiredException
     *         Contains details about an error where the query request expired.
     * @throws ThrottledException
     *         Contains details about an error where the query request was throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.GetWorkUnitResults
     * @see #getObject(getWorkUnitResults, ResponseTransformer)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetWorkUnitResults"
     *      target="_top">AWS API Documentation</a>
     */
    default ResponseBytes<GetWorkUnitResultsResponse> getWorkUnitResultsAsBytes(
            GetWorkUnitResultsRequest getWorkUnitResultsRequest) throws InternalServiceException, InvalidInputException,
            AccessDeniedException, ExpiredException, ThrottledException, AwsServiceException, SdkClientException,
            LakeFormationException {
        return getWorkUnitResults(getWorkUnitResultsRequest, ResponseTransformer.toBytes());
    }

    /**
     * <p>
     * Returns the work units resulting from the query. Work units can be executed in any order and in parallel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkUnitResultsRequest.Builder} avoiding the
     * need to create one manually via {@link GetWorkUnitResultsRequest#builder()}
     * </p>
     *
     * @param getWorkUnitResultsRequest
     *        A {@link Consumer} that will call methods on {@link GetWorkUnitResultsRequest.Builder} to create a
     *        request.
     * @return A {@link ResponseBytes} that loads the data streamed from the service into memory and exposes it in
     *         convenient in-memory representations like a byte buffer or string. The unmarshalled response object can
     *         be obtained via {@link ResponseBytes#response()}. The service documentation for the response content is
     *         as follows '
     *         <p>
     *         Rows returned from the <code>GetWorkUnitResults</code> operation as a stream of Apache Arrow v1.0
     *         messages.
     *         </p>
     *         '.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws ExpiredException
     *         Contains details about an error where the query request expired.
     * @throws ThrottledException
     *         Contains details about an error where the query request was throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.GetWorkUnitResults
     * @see #getObject(getWorkUnitResults, ResponseTransformer)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetWorkUnitResults"
     *      target="_top">AWS API Documentation</a>
     */
    default ResponseBytes<GetWorkUnitResultsResponse> getWorkUnitResultsAsBytes(
            Consumer<GetWorkUnitResultsRequest.Builder> getWorkUnitResultsRequest) throws InternalServiceException,
            InvalidInputException, AccessDeniedException, ExpiredException, ThrottledException, AwsServiceException,
            SdkClientException, LakeFormationException {
        return getWorkUnitResultsAsBytes(GetWorkUnitResultsRequest.builder().applyMutation(getWorkUnitResultsRequest).build());
    }

    /**
     * <p>
     * Retrieves the work units generated by the <code>StartQueryPlanning</code> operation.
     * </p>
     *
     * @param getWorkUnitsRequest
     * @return Result of the GetWorkUnits operation returned by the service.
     * @throws WorkUnitsNotReadyYetException
     *         Contains details about an error related to work units not being ready.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws ExpiredException
     *         Contains details about an error where the query request expired.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.GetWorkUnits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetWorkUnits" target="_top">AWS
     *      API Documentation</a>
     */
    default GetWorkUnitsResponse getWorkUnits(GetWorkUnitsRequest getWorkUnitsRequest) throws WorkUnitsNotReadyYetException,
            InternalServiceException, InvalidInputException, AccessDeniedException, ExpiredException, AwsServiceException,
            SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the work units generated by the <code>StartQueryPlanning</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkUnitsRequest.Builder} avoiding the need to
     * create one manually via {@link GetWorkUnitsRequest#builder()}
     * </p>
     *
     * @param getWorkUnitsRequest
     *        A {@link Consumer} that will call methods on {@link GetWorkUnitsRequest.Builder} to create a request.
     * @return Result of the GetWorkUnits operation returned by the service.
     * @throws WorkUnitsNotReadyYetException
     *         Contains details about an error related to work units not being ready.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws ExpiredException
     *         Contains details about an error where the query request expired.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.GetWorkUnits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetWorkUnits" target="_top">AWS
     *      API Documentation</a>
     */
    default GetWorkUnitsResponse getWorkUnits(Consumer<GetWorkUnitsRequest.Builder> getWorkUnitsRequest)
            throws WorkUnitsNotReadyYetException, InternalServiceException, InvalidInputException, AccessDeniedException,
            ExpiredException, AwsServiceException, SdkClientException, LakeFormationException {
        return getWorkUnits(GetWorkUnitsRequest.builder().applyMutation(getWorkUnitsRequest).build());
    }

    /**
     * <p>
     * Retrieves the work units generated by the <code>StartQueryPlanning</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getWorkUnits(software.amazon.awssdk.services.lakeformation.model.GetWorkUnitsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.GetWorkUnitsIterable responses = client.getWorkUnitsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lakeformation.paginators.GetWorkUnitsIterable responses = client
     *             .getWorkUnitsPaginator(request);
     *     for (software.amazon.awssdk.services.lakeformation.model.GetWorkUnitsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.GetWorkUnitsIterable responses = client.getWorkUnitsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getWorkUnits(software.amazon.awssdk.services.lakeformation.model.GetWorkUnitsRequest)} operation.</b>
     * </p>
     *
     * @param getWorkUnitsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws WorkUnitsNotReadyYetException
     *         Contains details about an error related to work units not being ready.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws ExpiredException
     *         Contains details about an error where the query request expired.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.GetWorkUnits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetWorkUnits" target="_top">AWS
     *      API Documentation</a>
     */
    default GetWorkUnitsIterable getWorkUnitsPaginator(GetWorkUnitsRequest getWorkUnitsRequest)
            throws WorkUnitsNotReadyYetException, InternalServiceException, InvalidInputException, AccessDeniedException,
            ExpiredException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the work units generated by the <code>StartQueryPlanning</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getWorkUnits(software.amazon.awssdk.services.lakeformation.model.GetWorkUnitsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.GetWorkUnitsIterable responses = client.getWorkUnitsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lakeformation.paginators.GetWorkUnitsIterable responses = client
     *             .getWorkUnitsPaginator(request);
     *     for (software.amazon.awssdk.services.lakeformation.model.GetWorkUnitsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.GetWorkUnitsIterable responses = client.getWorkUnitsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getWorkUnits(software.amazon.awssdk.services.lakeformation.model.GetWorkUnitsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkUnitsRequest.Builder} avoiding the need to
     * create one manually via {@link GetWorkUnitsRequest#builder()}
     * </p>
     *
     * @param getWorkUnitsRequest
     *        A {@link Consumer} that will call methods on {@link GetWorkUnitsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws WorkUnitsNotReadyYetException
     *         Contains details about an error related to work units not being ready.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws ExpiredException
     *         Contains details about an error where the query request expired.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.GetWorkUnits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GetWorkUnits" target="_top">AWS
     *      API Documentation</a>
     */
    default GetWorkUnitsIterable getWorkUnitsPaginator(Consumer<GetWorkUnitsRequest.Builder> getWorkUnitsRequest)
            throws WorkUnitsNotReadyYetException, InternalServiceException, InvalidInputException, AccessDeniedException,
            ExpiredException, AwsServiceException, SdkClientException, LakeFormationException {
        return getWorkUnitsPaginator(GetWorkUnitsRequest.builder().applyMutation(getWorkUnitsRequest).build());
    }

    /**
     * <p>
     * Grants permissions to the principal to access metadata in the Data Catalog and data organized in underlying data
     * storage such as Amazon S3.
     * </p>
     * <p>
     * For information about permissions, see <a
     * href="https://docs-aws.amazon.com/lake-formation/latest/dg/security-data-access.html">Security and Access Control
     * to Metadata and Data</a>.
     * </p>
     *
     * @param grantPermissionsRequest
     * @return Result of the GrantPermissions operation returned by the service.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.GrantPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GrantPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default GrantPermissionsResponse grantPermissions(GrantPermissionsRequest grantPermissionsRequest)
            throws ConcurrentModificationException, EntityNotFoundException, InvalidInputException, AwsServiceException,
            SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Grants permissions to the principal to access metadata in the Data Catalog and data organized in underlying data
     * storage such as Amazon S3.
     * </p>
     * <p>
     * For information about permissions, see <a
     * href="https://docs-aws.amazon.com/lake-formation/latest/dg/security-data-access.html">Security and Access Control
     * to Metadata and Data</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GrantPermissionsRequest.Builder} avoiding the need
     * to create one manually via {@link GrantPermissionsRequest#builder()}
     * </p>
     *
     * @param grantPermissionsRequest
     *        A {@link Consumer} that will call methods on {@link GrantPermissionsRequest.Builder} to create a request.
     * @return Result of the GrantPermissions operation returned by the service.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.GrantPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/GrantPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default GrantPermissionsResponse grantPermissions(Consumer<GrantPermissionsRequest.Builder> grantPermissionsRequest)
            throws ConcurrentModificationException, EntityNotFoundException, InvalidInputException, AwsServiceException,
            SdkClientException, LakeFormationException {
        return grantPermissions(GrantPermissionsRequest.builder().applyMutation(grantPermissionsRequest).build());
    }

    /**
     * <p>
     * Lists all the data cell filters on a table.
     * </p>
     *
     * @param listDataCellsFilterRequest
     * @return Result of the ListDataCellsFilter operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.ListDataCellsFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListDataCellsFilter"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataCellsFilterResponse listDataCellsFilter(ListDataCellsFilterRequest listDataCellsFilterRequest)
            throws InvalidInputException, OperationTimeoutException, InternalServiceException, AccessDeniedException,
            AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the data cell filters on a table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataCellsFilterRequest.Builder} avoiding the
     * need to create one manually via {@link ListDataCellsFilterRequest#builder()}
     * </p>
     *
     * @param listDataCellsFilterRequest
     *        A {@link Consumer} that will call methods on {@link ListDataCellsFilterRequest.Builder} to create a
     *        request.
     * @return Result of the ListDataCellsFilter operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.ListDataCellsFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListDataCellsFilter"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataCellsFilterResponse listDataCellsFilter(
            Consumer<ListDataCellsFilterRequest.Builder> listDataCellsFilterRequest) throws InvalidInputException,
            OperationTimeoutException, InternalServiceException, AccessDeniedException, AwsServiceException, SdkClientException,
            LakeFormationException {
        return listDataCellsFilter(ListDataCellsFilterRequest.builder().applyMutation(listDataCellsFilterRequest).build());
    }

    /**
     * <p>
     * Lists all the data cell filters on a table.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDataCellsFilter(software.amazon.awssdk.services.lakeformation.model.ListDataCellsFilterRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.ListDataCellsFilterIterable responses = client.listDataCellsFilterPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lakeformation.paginators.ListDataCellsFilterIterable responses = client
     *             .listDataCellsFilterPaginator(request);
     *     for (software.amazon.awssdk.services.lakeformation.model.ListDataCellsFilterResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.ListDataCellsFilterIterable responses = client.listDataCellsFilterPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataCellsFilter(software.amazon.awssdk.services.lakeformation.model.ListDataCellsFilterRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDataCellsFilterRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.ListDataCellsFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListDataCellsFilter"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataCellsFilterIterable listDataCellsFilterPaginator(ListDataCellsFilterRequest listDataCellsFilterRequest)
            throws InvalidInputException, OperationTimeoutException, InternalServiceException, AccessDeniedException,
            AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the data cell filters on a table.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDataCellsFilter(software.amazon.awssdk.services.lakeformation.model.ListDataCellsFilterRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.ListDataCellsFilterIterable responses = client.listDataCellsFilterPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lakeformation.paginators.ListDataCellsFilterIterable responses = client
     *             .listDataCellsFilterPaginator(request);
     *     for (software.amazon.awssdk.services.lakeformation.model.ListDataCellsFilterResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.ListDataCellsFilterIterable responses = client.listDataCellsFilterPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataCellsFilter(software.amazon.awssdk.services.lakeformation.model.ListDataCellsFilterRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataCellsFilterRequest.Builder} avoiding the
     * need to create one manually via {@link ListDataCellsFilterRequest#builder()}
     * </p>
     *
     * @param listDataCellsFilterRequest
     *        A {@link Consumer} that will call methods on {@link ListDataCellsFilterRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.ListDataCellsFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListDataCellsFilter"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataCellsFilterIterable listDataCellsFilterPaginator(
            Consumer<ListDataCellsFilterRequest.Builder> listDataCellsFilterRequest) throws InvalidInputException,
            OperationTimeoutException, InternalServiceException, AccessDeniedException, AwsServiceException, SdkClientException,
            LakeFormationException {
        return listDataCellsFilterPaginator(ListDataCellsFilterRequest.builder().applyMutation(listDataCellsFilterRequest)
                .build());
    }

    /**
     * <p>
     * Lists LF-tags that the requester has permission to view.
     * </p>
     *
     * @param listLfTagsRequest
     * @return Result of the ListLFTags operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.ListLFTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListLFTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLfTagsResponse listLFTags(ListLfTagsRequest listLfTagsRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, AccessDeniedException,
            AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists LF-tags that the requester has permission to view.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLfTagsRequest.Builder} avoiding the need to
     * create one manually via {@link ListLfTagsRequest#builder()}
     * </p>
     *
     * @param listLfTagsRequest
     *        A {@link Consumer} that will call methods on {@link ListLFTagsRequest.Builder} to create a request.
     * @return Result of the ListLFTags operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.ListLFTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListLFTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLfTagsResponse listLFTags(Consumer<ListLfTagsRequest.Builder> listLfTagsRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, AccessDeniedException,
            AwsServiceException, SdkClientException, LakeFormationException {
        return listLFTags(ListLfTagsRequest.builder().applyMutation(listLfTagsRequest).build());
    }

    /**
     * <p>
     * Lists LF-tags that the requester has permission to view.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listLFTags(software.amazon.awssdk.services.lakeformation.model.ListLfTagsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.ListLFTagsIterable responses = client.listLFTagsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lakeformation.paginators.ListLFTagsIterable responses = client.listLFTagsPaginator(request);
     *     for (software.amazon.awssdk.services.lakeformation.model.ListLfTagsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.ListLFTagsIterable responses = client.listLFTagsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLFTags(software.amazon.awssdk.services.lakeformation.model.ListLfTagsRequest)} operation.</b>
     * </p>
     *
     * @param listLfTagsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.ListLFTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListLFTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLFTagsIterable listLFTagsPaginator(ListLfTagsRequest listLfTagsRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, AccessDeniedException,
            AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists LF-tags that the requester has permission to view.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listLFTags(software.amazon.awssdk.services.lakeformation.model.ListLfTagsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.ListLFTagsIterable responses = client.listLFTagsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lakeformation.paginators.ListLFTagsIterable responses = client.listLFTagsPaginator(request);
     *     for (software.amazon.awssdk.services.lakeformation.model.ListLfTagsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.ListLFTagsIterable responses = client.listLFTagsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLFTags(software.amazon.awssdk.services.lakeformation.model.ListLfTagsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLfTagsRequest.Builder} avoiding the need to
     * create one manually via {@link ListLfTagsRequest#builder()}
     * </p>
     *
     * @param listLfTagsRequest
     *        A {@link Consumer} that will call methods on {@link ListLFTagsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.ListLFTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListLFTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLFTagsIterable listLFTagsPaginator(Consumer<ListLfTagsRequest.Builder> listLfTagsRequest)
            throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        return listLFTagsPaginator(ListLfTagsRequest.builder().applyMutation(listLfTagsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the principal permissions on the resource, filtered by the permissions of the caller. For
     * example, if you are granted an ALTER permission, you are able to see only the principal permissions for ALTER.
     * </p>
     * <p>
     * This operation returns only those permissions that have been explicitly granted.
     * </p>
     * <p>
     * For information about permissions, see <a
     * href="https://docs-aws.amazon.com/lake-formation/latest/dg/security-data-access.html">Security and Access Control
     * to Metadata and Data</a>.
     * </p>
     *
     * @param listPermissionsRequest
     * @return Result of the ListPermissions operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.ListPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListPermissions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPermissionsResponse listPermissions(ListPermissionsRequest listPermissionsRequest) throws InvalidInputException,
            OperationTimeoutException, InternalServiceException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the principal permissions on the resource, filtered by the permissions of the caller. For
     * example, if you are granted an ALTER permission, you are able to see only the principal permissions for ALTER.
     * </p>
     * <p>
     * This operation returns only those permissions that have been explicitly granted.
     * </p>
     * <p>
     * For information about permissions, see <a
     * href="https://docs-aws.amazon.com/lake-formation/latest/dg/security-data-access.html">Security and Access Control
     * to Metadata and Data</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPermissionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListPermissionsRequest#builder()}
     * </p>
     *
     * @param listPermissionsRequest
     *        A {@link Consumer} that will call methods on {@link ListPermissionsRequest.Builder} to create a request.
     * @return Result of the ListPermissions operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.ListPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListPermissions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPermissionsResponse listPermissions(Consumer<ListPermissionsRequest.Builder> listPermissionsRequest)
            throws InvalidInputException, OperationTimeoutException, InternalServiceException, AwsServiceException,
            SdkClientException, LakeFormationException {
        return listPermissions(ListPermissionsRequest.builder().applyMutation(listPermissionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the principal permissions on the resource, filtered by the permissions of the caller. For
     * example, if you are granted an ALTER permission, you are able to see only the principal permissions for ALTER.
     * </p>
     * <p>
     * This operation returns only those permissions that have been explicitly granted.
     * </p>
     * <p>
     * For information about permissions, see <a
     * href="https://docs-aws.amazon.com/lake-formation/latest/dg/security-data-access.html">Security and Access Control
     * to Metadata and Data</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPermissions(software.amazon.awssdk.services.lakeformation.model.ListPermissionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.ListPermissionsIterable responses = client.listPermissionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lakeformation.paginators.ListPermissionsIterable responses = client
     *             .listPermissionsPaginator(request);
     *     for (software.amazon.awssdk.services.lakeformation.model.ListPermissionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.ListPermissionsIterable responses = client.listPermissionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPermissions(software.amazon.awssdk.services.lakeformation.model.ListPermissionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPermissionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.ListPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListPermissions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPermissionsIterable listPermissionsPaginator(ListPermissionsRequest listPermissionsRequest)
            throws InvalidInputException, OperationTimeoutException, InternalServiceException, AwsServiceException,
            SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the principal permissions on the resource, filtered by the permissions of the caller. For
     * example, if you are granted an ALTER permission, you are able to see only the principal permissions for ALTER.
     * </p>
     * <p>
     * This operation returns only those permissions that have been explicitly granted.
     * </p>
     * <p>
     * For information about permissions, see <a
     * href="https://docs-aws.amazon.com/lake-formation/latest/dg/security-data-access.html">Security and Access Control
     * to Metadata and Data</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPermissions(software.amazon.awssdk.services.lakeformation.model.ListPermissionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.ListPermissionsIterable responses = client.listPermissionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lakeformation.paginators.ListPermissionsIterable responses = client
     *             .listPermissionsPaginator(request);
     *     for (software.amazon.awssdk.services.lakeformation.model.ListPermissionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.ListPermissionsIterable responses = client.listPermissionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPermissions(software.amazon.awssdk.services.lakeformation.model.ListPermissionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPermissionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListPermissionsRequest#builder()}
     * </p>
     *
     * @param listPermissionsRequest
     *        A {@link Consumer} that will call methods on {@link ListPermissionsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.ListPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListPermissions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPermissionsIterable listPermissionsPaginator(Consumer<ListPermissionsRequest.Builder> listPermissionsRequest)
            throws InvalidInputException, OperationTimeoutException, InternalServiceException, AwsServiceException,
            SdkClientException, LakeFormationException {
        return listPermissionsPaginator(ListPermissionsRequest.builder().applyMutation(listPermissionsRequest).build());
    }

    /**
     * <p>
     * Lists the resources registered to be managed by the Data Catalog.
     * </p>
     *
     * @param listResourcesRequest
     * @return Result of the ListResources operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.ListResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListResources" target="_top">AWS
     *      API Documentation</a>
     */
    default ListResourcesResponse listResources(ListResourcesRequest listResourcesRequest) throws InvalidInputException,
            InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the resources registered to be managed by the Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourcesRequest.Builder} avoiding the need to
     * create one manually via {@link ListResourcesRequest#builder()}
     * </p>
     *
     * @param listResourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListResourcesRequest.Builder} to create a request.
     * @return Result of the ListResources operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.ListResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListResources" target="_top">AWS
     *      API Documentation</a>
     */
    default ListResourcesResponse listResources(Consumer<ListResourcesRequest.Builder> listResourcesRequest)
            throws InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException,
            SdkClientException, LakeFormationException {
        return listResources(ListResourcesRequest.builder().applyMutation(listResourcesRequest).build());
    }

    /**
     * <p>
     * Lists the resources registered to be managed by the Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResources(software.amazon.awssdk.services.lakeformation.model.ListResourcesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.ListResourcesIterable responses = client.listResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lakeformation.paginators.ListResourcesIterable responses = client
     *             .listResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.lakeformation.model.ListResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.ListResourcesIterable responses = client.listResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResources(software.amazon.awssdk.services.lakeformation.model.ListResourcesRequest)} operation.</b>
     * </p>
     *
     * @param listResourcesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.ListResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListResources" target="_top">AWS
     *      API Documentation</a>
     */
    default ListResourcesIterable listResourcesPaginator(ListResourcesRequest listResourcesRequest) throws InvalidInputException,
            InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the resources registered to be managed by the Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResources(software.amazon.awssdk.services.lakeformation.model.ListResourcesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.ListResourcesIterable responses = client.listResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lakeformation.paginators.ListResourcesIterable responses = client
     *             .listResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.lakeformation.model.ListResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.ListResourcesIterable responses = client.listResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResources(software.amazon.awssdk.services.lakeformation.model.ListResourcesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourcesRequest.Builder} avoiding the need to
     * create one manually via {@link ListResourcesRequest#builder()}
     * </p>
     *
     * @param listResourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListResourcesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.ListResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListResources" target="_top">AWS
     *      API Documentation</a>
     */
    default ListResourcesIterable listResourcesPaginator(Consumer<ListResourcesRequest.Builder> listResourcesRequest)
            throws InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException,
            SdkClientException, LakeFormationException {
        return listResourcesPaginator(ListResourcesRequest.builder().applyMutation(listResourcesRequest).build());
    }

    /**
     * <p>
     * Returns the configuration of all storage optimizers associated with a specified table.
     * </p>
     *
     * @param listTableStorageOptimizersRequest
     * @return Result of the ListTableStorageOptimizers operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.ListTableStorageOptimizers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListTableStorageOptimizers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTableStorageOptimizersResponse listTableStorageOptimizers(
            ListTableStorageOptimizersRequest listTableStorageOptimizersRequest) throws EntityNotFoundException,
            InvalidInputException, AccessDeniedException, InternalServiceException, AwsServiceException, SdkClientException,
            LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the configuration of all storage optimizers associated with a specified table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTableStorageOptimizersRequest.Builder} avoiding
     * the need to create one manually via {@link ListTableStorageOptimizersRequest#builder()}
     * </p>
     *
     * @param listTableStorageOptimizersRequest
     *        A {@link Consumer} that will call methods on {@link ListTableStorageOptimizersRequest.Builder} to create a
     *        request.
     * @return Result of the ListTableStorageOptimizers operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.ListTableStorageOptimizers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListTableStorageOptimizers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTableStorageOptimizersResponse listTableStorageOptimizers(
            Consumer<ListTableStorageOptimizersRequest.Builder> listTableStorageOptimizersRequest)
            throws EntityNotFoundException, InvalidInputException, AccessDeniedException, InternalServiceException,
            AwsServiceException, SdkClientException, LakeFormationException {
        return listTableStorageOptimizers(ListTableStorageOptimizersRequest.builder()
                .applyMutation(listTableStorageOptimizersRequest).build());
    }

    /**
     * <p>
     * Returns the configuration of all storage optimizers associated with a specified table.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTableStorageOptimizers(software.amazon.awssdk.services.lakeformation.model.ListTableStorageOptimizersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.ListTableStorageOptimizersIterable responses = client.listTableStorageOptimizersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lakeformation.paginators.ListTableStorageOptimizersIterable responses = client
     *             .listTableStorageOptimizersPaginator(request);
     *     for (software.amazon.awssdk.services.lakeformation.model.ListTableStorageOptimizersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.ListTableStorageOptimizersIterable responses = client.listTableStorageOptimizersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTableStorageOptimizers(software.amazon.awssdk.services.lakeformation.model.ListTableStorageOptimizersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTableStorageOptimizersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.ListTableStorageOptimizers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListTableStorageOptimizers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTableStorageOptimizersIterable listTableStorageOptimizersPaginator(
            ListTableStorageOptimizersRequest listTableStorageOptimizersRequest) throws EntityNotFoundException,
            InvalidInputException, AccessDeniedException, InternalServiceException, AwsServiceException, SdkClientException,
            LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the configuration of all storage optimizers associated with a specified table.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTableStorageOptimizers(software.amazon.awssdk.services.lakeformation.model.ListTableStorageOptimizersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.ListTableStorageOptimizersIterable responses = client.listTableStorageOptimizersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lakeformation.paginators.ListTableStorageOptimizersIterable responses = client
     *             .listTableStorageOptimizersPaginator(request);
     *     for (software.amazon.awssdk.services.lakeformation.model.ListTableStorageOptimizersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.ListTableStorageOptimizersIterable responses = client.listTableStorageOptimizersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTableStorageOptimizers(software.amazon.awssdk.services.lakeformation.model.ListTableStorageOptimizersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTableStorageOptimizersRequest.Builder} avoiding
     * the need to create one manually via {@link ListTableStorageOptimizersRequest#builder()}
     * </p>
     *
     * @param listTableStorageOptimizersRequest
     *        A {@link Consumer} that will call methods on {@link ListTableStorageOptimizersRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.ListTableStorageOptimizers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListTableStorageOptimizers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTableStorageOptimizersIterable listTableStorageOptimizersPaginator(
            Consumer<ListTableStorageOptimizersRequest.Builder> listTableStorageOptimizersRequest)
            throws EntityNotFoundException, InvalidInputException, AccessDeniedException, InternalServiceException,
            AwsServiceException, SdkClientException, LakeFormationException {
        return listTableStorageOptimizersPaginator(ListTableStorageOptimizersRequest.builder()
                .applyMutation(listTableStorageOptimizersRequest).build());
    }

    /**
     * <p>
     * Returns metadata about transactions and their status. To prevent the response from growing indefinitely, only
     * uncommitted transactions and those available for time-travel queries are returned.
     * </p>
     * <p>
     * This operation can help you identify uncommitted transactions or to get information about transactions.
     * </p>
     *
     * @param listTransactionsRequest
     * @return Result of the ListTransactions operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.ListTransactions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListTransactions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTransactionsResponse listTransactions(ListTransactionsRequest listTransactionsRequest)
            throws InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException,
            SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns metadata about transactions and their status. To prevent the response from growing indefinitely, only
     * uncommitted transactions and those available for time-travel queries are returned.
     * </p>
     * <p>
     * This operation can help you identify uncommitted transactions or to get information about transactions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTransactionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListTransactionsRequest#builder()}
     * </p>
     *
     * @param listTransactionsRequest
     *        A {@link Consumer} that will call methods on {@link ListTransactionsRequest.Builder} to create a request.
     * @return Result of the ListTransactions operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.ListTransactions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListTransactions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTransactionsResponse listTransactions(Consumer<ListTransactionsRequest.Builder> listTransactionsRequest)
            throws InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException,
            SdkClientException, LakeFormationException {
        return listTransactions(ListTransactionsRequest.builder().applyMutation(listTransactionsRequest).build());
    }

    /**
     * <p>
     * Returns metadata about transactions and their status. To prevent the response from growing indefinitely, only
     * uncommitted transactions and those available for time-travel queries are returned.
     * </p>
     * <p>
     * This operation can help you identify uncommitted transactions or to get information about transactions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTransactions(software.amazon.awssdk.services.lakeformation.model.ListTransactionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.ListTransactionsIterable responses = client.listTransactionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lakeformation.paginators.ListTransactionsIterable responses = client
     *             .listTransactionsPaginator(request);
     *     for (software.amazon.awssdk.services.lakeformation.model.ListTransactionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.ListTransactionsIterable responses = client.listTransactionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTransactions(software.amazon.awssdk.services.lakeformation.model.ListTransactionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTransactionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.ListTransactions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListTransactions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTransactionsIterable listTransactionsPaginator(ListTransactionsRequest listTransactionsRequest)
            throws InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException,
            SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns metadata about transactions and their status. To prevent the response from growing indefinitely, only
     * uncommitted transactions and those available for time-travel queries are returned.
     * </p>
     * <p>
     * This operation can help you identify uncommitted transactions or to get information about transactions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTransactions(software.amazon.awssdk.services.lakeformation.model.ListTransactionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.ListTransactionsIterable responses = client.listTransactionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lakeformation.paginators.ListTransactionsIterable responses = client
     *             .listTransactionsPaginator(request);
     *     for (software.amazon.awssdk.services.lakeformation.model.ListTransactionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.ListTransactionsIterable responses = client.listTransactionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTransactions(software.amazon.awssdk.services.lakeformation.model.ListTransactionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTransactionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListTransactionsRequest#builder()}
     * </p>
     *
     * @param listTransactionsRequest
     *        A {@link Consumer} that will call methods on {@link ListTransactionsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.ListTransactions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListTransactions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTransactionsIterable listTransactionsPaginator(Consumer<ListTransactionsRequest.Builder> listTransactionsRequest)
            throws InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException,
            SdkClientException, LakeFormationException {
        return listTransactionsPaginator(ListTransactionsRequest.builder().applyMutation(listTransactionsRequest).build());
    }

    /**
     * <p>
     * Sets the list of data lake administrators who have admin privileges on all resources managed by Lake Formation.
     * For more information on admin privileges, see <a
     * href="https://docs.aws.amazon.com/lake-formation/latest/dg/lake-formation-permissions.html">Granting Lake
     * Formation Permissions</a>.
     * </p>
     * <p>
     * This API replaces the current list of data lake admins with the new list being passed. To add an admin, fetch the
     * current list and add the new admin to that list and pass that list in this API.
     * </p>
     *
     * @param putDataLakeSettingsRequest
     * @return Result of the PutDataLakeSettings operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.PutDataLakeSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/PutDataLakeSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default PutDataLakeSettingsResponse putDataLakeSettings(PutDataLakeSettingsRequest putDataLakeSettingsRequest)
            throws InternalServiceException, InvalidInputException, AwsServiceException, SdkClientException,
            LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the list of data lake administrators who have admin privileges on all resources managed by Lake Formation.
     * For more information on admin privileges, see <a
     * href="https://docs.aws.amazon.com/lake-formation/latest/dg/lake-formation-permissions.html">Granting Lake
     * Formation Permissions</a>.
     * </p>
     * <p>
     * This API replaces the current list of data lake admins with the new list being passed. To add an admin, fetch the
     * current list and add the new admin to that list and pass that list in this API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutDataLakeSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link PutDataLakeSettingsRequest#builder()}
     * </p>
     *
     * @param putDataLakeSettingsRequest
     *        A {@link Consumer} that will call methods on {@link PutDataLakeSettingsRequest.Builder} to create a
     *        request.
     * @return Result of the PutDataLakeSettings operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.PutDataLakeSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/PutDataLakeSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default PutDataLakeSettingsResponse putDataLakeSettings(
            Consumer<PutDataLakeSettingsRequest.Builder> putDataLakeSettingsRequest) throws InternalServiceException,
            InvalidInputException, AwsServiceException, SdkClientException, LakeFormationException {
        return putDataLakeSettings(PutDataLakeSettingsRequest.builder().applyMutation(putDataLakeSettingsRequest).build());
    }

    /**
     * <p>
     * Registers the resource as managed by the Data Catalog.
     * </p>
     * <p>
     * To add or update data, Lake Formation needs read/write access to the chosen Amazon S3 path. Choose a role that
     * you know has permission to do this, or choose the AWSServiceRoleForLakeFormationDataAccess service-linked role.
     * When you register the first Amazon S3 path, the service-linked role and a new inline policy are created on your
     * behalf. Lake Formation adds the first path to the inline policy and attaches it to the service-linked role. When
     * you register subsequent paths, Lake Formation adds the path to the existing policy.
     * </p>
     * <p>
     * The following request registers a new location and gives Lake Formation permission to use the service-linked role
     * to access that location.
     * </p>
     * <p>
     * <code>ResourceArn = arn:aws:s3:::my-bucket UseServiceLinkedRole = true</code>
     * </p>
     * <p>
     * If <code>UseServiceLinkedRole</code> is not set to true, you must provide or set the <code>RoleArn</code>:
     * </p>
     * <p>
     * <code>arn:aws:iam::12345:role/my-data-access-role</code>
     * </p>
     *
     * @param registerResourceRequest
     * @return Result of the RegisterResource operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.RegisterResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/RegisterResource"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterResourceResponse registerResource(RegisterResourceRequest registerResourceRequest)
            throws InvalidInputException, InternalServiceException, OperationTimeoutException, AlreadyExistsException,
            EntityNotFoundException, ResourceNumberLimitExceededException, AccessDeniedException, AwsServiceException,
            SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers the resource as managed by the Data Catalog.
     * </p>
     * <p>
     * To add or update data, Lake Formation needs read/write access to the chosen Amazon S3 path. Choose a role that
     * you know has permission to do this, or choose the AWSServiceRoleForLakeFormationDataAccess service-linked role.
     * When you register the first Amazon S3 path, the service-linked role and a new inline policy are created on your
     * behalf. Lake Formation adds the first path to the inline policy and attaches it to the service-linked role. When
     * you register subsequent paths, Lake Formation adds the path to the existing policy.
     * </p>
     * <p>
     * The following request registers a new location and gives Lake Formation permission to use the service-linked role
     * to access that location.
     * </p>
     * <p>
     * <code>ResourceArn = arn:aws:s3:::my-bucket UseServiceLinkedRole = true</code>
     * </p>
     * <p>
     * If <code>UseServiceLinkedRole</code> is not set to true, you must provide or set the <code>RoleArn</code>:
     * </p>
     * <p>
     * <code>arn:aws:iam::12345:role/my-data-access-role</code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterResourceRequest.Builder} avoiding the need
     * to create one manually via {@link RegisterResourceRequest#builder()}
     * </p>
     *
     * @param registerResourceRequest
     *        A {@link Consumer} that will call methods on {@link RegisterResourceRequest.Builder} to create a request.
     * @return Result of the RegisterResource operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws AlreadyExistsException
     *         A resource to be created or added already exists.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws ResourceNumberLimitExceededException
     *         A resource numerical limit was exceeded.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.RegisterResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/RegisterResource"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterResourceResponse registerResource(Consumer<RegisterResourceRequest.Builder> registerResourceRequest)
            throws InvalidInputException, InternalServiceException, OperationTimeoutException, AlreadyExistsException,
            EntityNotFoundException, ResourceNumberLimitExceededException, AccessDeniedException, AwsServiceException,
            SdkClientException, LakeFormationException {
        return registerResource(RegisterResourceRequest.builder().applyMutation(registerResourceRequest).build());
    }

    /**
     * <p>
     * Removes an LF-tag from the resource. Only database, table, or tableWithColumns resource are allowed. To tag
     * columns, use the column inclusion list in <code>tableWithColumns</code> to specify column input.
     * </p>
     *
     * @param removeLfTagsFromResourceRequest
     * @return Result of the RemoveLFTagsFromResource operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.RemoveLFTagsFromResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/RemoveLFTagsFromResource"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveLfTagsFromResourceResponse removeLFTagsFromResource(
            RemoveLfTagsFromResourceRequest removeLfTagsFromResourceRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, GlueEncryptionException,
            AccessDeniedException, ConcurrentModificationException, AwsServiceException, SdkClientException,
            LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes an LF-tag from the resource. Only database, table, or tableWithColumns resource are allowed. To tag
     * columns, use the column inclusion list in <code>tableWithColumns</code> to specify column input.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveLfTagsFromResourceRequest.Builder} avoiding
     * the need to create one manually via {@link RemoveLfTagsFromResourceRequest#builder()}
     * </p>
     *
     * @param removeLfTagsFromResourceRequest
     *        A {@link Consumer} that will call methods on {@link RemoveLFTagsFromResourceRequest.Builder} to create a
     *        request.
     * @return Result of the RemoveLFTagsFromResource operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.RemoveLFTagsFromResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/RemoveLFTagsFromResource"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveLfTagsFromResourceResponse removeLFTagsFromResource(
            Consumer<RemoveLfTagsFromResourceRequest.Builder> removeLfTagsFromResourceRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, GlueEncryptionException,
            AccessDeniedException, ConcurrentModificationException, AwsServiceException, SdkClientException,
            LakeFormationException {
        return removeLFTagsFromResource(RemoveLfTagsFromResourceRequest.builder().applyMutation(removeLfTagsFromResourceRequest)
                .build());
    }

    /**
     * <p>
     * Revokes permissions to the principal to access metadata in the Data Catalog and data organized in underlying data
     * storage such as Amazon S3.
     * </p>
     *
     * @param revokePermissionsRequest
     * @return Result of the RevokePermissions operation returned by the service.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.RevokePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/RevokePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default RevokePermissionsResponse revokePermissions(RevokePermissionsRequest revokePermissionsRequest)
            throws ConcurrentModificationException, EntityNotFoundException, InvalidInputException, AwsServiceException,
            SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Revokes permissions to the principal to access metadata in the Data Catalog and data organized in underlying data
     * storage such as Amazon S3.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RevokePermissionsRequest.Builder} avoiding the need
     * to create one manually via {@link RevokePermissionsRequest#builder()}
     * </p>
     *
     * @param revokePermissionsRequest
     *        A {@link Consumer} that will call methods on {@link RevokePermissionsRequest.Builder} to create a request.
     * @return Result of the RevokePermissions operation returned by the service.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.RevokePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/RevokePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default RevokePermissionsResponse revokePermissions(Consumer<RevokePermissionsRequest.Builder> revokePermissionsRequest)
            throws ConcurrentModificationException, EntityNotFoundException, InvalidInputException, AwsServiceException,
            SdkClientException, LakeFormationException {
        return revokePermissions(RevokePermissionsRequest.builder().applyMutation(revokePermissionsRequest).build());
    }

    /**
     * <p>
     * This operation allows a search on <code>DATABASE</code> resources by <code>TagCondition</code>. This operation is
     * used by admins who want to grant user permissions on certain <code>TagConditions</code>. Before making a grant,
     * the admin can use <code>SearchDatabasesByTags</code> to find all resources where the given
     * <code>TagConditions</code> are valid to verify whether the returned resources can be shared.
     * </p>
     *
     * @param searchDatabasesByLfTagsRequest
     * @return Result of the SearchDatabasesByLFTags operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.SearchDatabasesByLFTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/SearchDatabasesByLFTags"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchDatabasesByLfTagsResponse searchDatabasesByLFTags(SearchDatabasesByLfTagsRequest searchDatabasesByLfTagsRequest)
            throws EntityNotFoundException, InternalServiceException, InvalidInputException, OperationTimeoutException,
            GlueEncryptionException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation allows a search on <code>DATABASE</code> resources by <code>TagCondition</code>. This operation is
     * used by admins who want to grant user permissions on certain <code>TagConditions</code>. Before making a grant,
     * the admin can use <code>SearchDatabasesByTags</code> to find all resources where the given
     * <code>TagConditions</code> are valid to verify whether the returned resources can be shared.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchDatabasesByLfTagsRequest.Builder} avoiding
     * the need to create one manually via {@link SearchDatabasesByLfTagsRequest#builder()}
     * </p>
     *
     * @param searchDatabasesByLfTagsRequest
     *        A {@link Consumer} that will call methods on {@link SearchDatabasesByLFTagsRequest.Builder} to create a
     *        request.
     * @return Result of the SearchDatabasesByLFTags operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.SearchDatabasesByLFTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/SearchDatabasesByLFTags"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchDatabasesByLfTagsResponse searchDatabasesByLFTags(
            Consumer<SearchDatabasesByLfTagsRequest.Builder> searchDatabasesByLfTagsRequest) throws EntityNotFoundException,
            InternalServiceException, InvalidInputException, OperationTimeoutException, GlueEncryptionException,
            AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        return searchDatabasesByLFTags(SearchDatabasesByLfTagsRequest.builder().applyMutation(searchDatabasesByLfTagsRequest)
                .build());
    }

    /**
     * <p>
     * This operation allows a search on <code>DATABASE</code> resources by <code>TagCondition</code>. This operation is
     * used by admins who want to grant user permissions on certain <code>TagConditions</code>. Before making a grant,
     * the admin can use <code>SearchDatabasesByTags</code> to find all resources where the given
     * <code>TagConditions</code> are valid to verify whether the returned resources can be shared.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchDatabasesByLFTags(software.amazon.awssdk.services.lakeformation.model.SearchDatabasesByLfTagsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.SearchDatabasesByLFTagsIterable responses = client.searchDatabasesByLFTagsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lakeformation.paginators.SearchDatabasesByLFTagsIterable responses = client
     *             .searchDatabasesByLFTagsPaginator(request);
     *     for (software.amazon.awssdk.services.lakeformation.model.SearchDatabasesByLfTagsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.SearchDatabasesByLFTagsIterable responses = client.searchDatabasesByLFTagsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchDatabasesByLFTags(software.amazon.awssdk.services.lakeformation.model.SearchDatabasesByLfTagsRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchDatabasesByLfTagsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.SearchDatabasesByLFTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/SearchDatabasesByLFTags"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchDatabasesByLFTagsIterable searchDatabasesByLFTagsPaginator(
            SearchDatabasesByLfTagsRequest searchDatabasesByLfTagsRequest) throws EntityNotFoundException,
            InternalServiceException, InvalidInputException, OperationTimeoutException, GlueEncryptionException,
            AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation allows a search on <code>DATABASE</code> resources by <code>TagCondition</code>. This operation is
     * used by admins who want to grant user permissions on certain <code>TagConditions</code>. Before making a grant,
     * the admin can use <code>SearchDatabasesByTags</code> to find all resources where the given
     * <code>TagConditions</code> are valid to verify whether the returned resources can be shared.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchDatabasesByLFTags(software.amazon.awssdk.services.lakeformation.model.SearchDatabasesByLfTagsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.SearchDatabasesByLFTagsIterable responses = client.searchDatabasesByLFTagsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lakeformation.paginators.SearchDatabasesByLFTagsIterable responses = client
     *             .searchDatabasesByLFTagsPaginator(request);
     *     for (software.amazon.awssdk.services.lakeformation.model.SearchDatabasesByLfTagsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.SearchDatabasesByLFTagsIterable responses = client.searchDatabasesByLFTagsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchDatabasesByLFTags(software.amazon.awssdk.services.lakeformation.model.SearchDatabasesByLfTagsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchDatabasesByLfTagsRequest.Builder} avoiding
     * the need to create one manually via {@link SearchDatabasesByLfTagsRequest#builder()}
     * </p>
     *
     * @param searchDatabasesByLfTagsRequest
     *        A {@link Consumer} that will call methods on {@link SearchDatabasesByLFTagsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.SearchDatabasesByLFTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/SearchDatabasesByLFTags"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchDatabasesByLFTagsIterable searchDatabasesByLFTagsPaginator(
            Consumer<SearchDatabasesByLfTagsRequest.Builder> searchDatabasesByLfTagsRequest) throws EntityNotFoundException,
            InternalServiceException, InvalidInputException, OperationTimeoutException, GlueEncryptionException,
            AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        return searchDatabasesByLFTagsPaginator(SearchDatabasesByLfTagsRequest.builder()
                .applyMutation(searchDatabasesByLfTagsRequest).build());
    }

    /**
     * <p>
     * This operation allows a search on <code>TABLE</code> resources by <code>LFTag</code>s. This will be used by
     * admins who want to grant user permissions on certain LF-tags. Before making a grant, the admin can use
     * <code>SearchTablesByLFTags</code> to find all resources where the given <code>LFTag</code>s are valid to verify
     * whether the returned resources can be shared.
     * </p>
     *
     * @param searchTablesByLfTagsRequest
     * @return Result of the SearchTablesByLFTags operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.SearchTablesByLFTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/SearchTablesByLFTags"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchTablesByLfTagsResponse searchTablesByLFTags(SearchTablesByLfTagsRequest searchTablesByLfTagsRequest)
            throws EntityNotFoundException, InternalServiceException, InvalidInputException, OperationTimeoutException,
            GlueEncryptionException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation allows a search on <code>TABLE</code> resources by <code>LFTag</code>s. This will be used by
     * admins who want to grant user permissions on certain LF-tags. Before making a grant, the admin can use
     * <code>SearchTablesByLFTags</code> to find all resources where the given <code>LFTag</code>s are valid to verify
     * whether the returned resources can be shared.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchTablesByLfTagsRequest.Builder} avoiding the
     * need to create one manually via {@link SearchTablesByLfTagsRequest#builder()}
     * </p>
     *
     * @param searchTablesByLfTagsRequest
     *        A {@link Consumer} that will call methods on {@link SearchTablesByLFTagsRequest.Builder} to create a
     *        request.
     * @return Result of the SearchTablesByLFTags operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.SearchTablesByLFTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/SearchTablesByLFTags"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchTablesByLfTagsResponse searchTablesByLFTags(
            Consumer<SearchTablesByLfTagsRequest.Builder> searchTablesByLfTagsRequest) throws EntityNotFoundException,
            InternalServiceException, InvalidInputException, OperationTimeoutException, GlueEncryptionException,
            AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        return searchTablesByLFTags(SearchTablesByLfTagsRequest.builder().applyMutation(searchTablesByLfTagsRequest).build());
    }

    /**
     * <p>
     * This operation allows a search on <code>TABLE</code> resources by <code>LFTag</code>s. This will be used by
     * admins who want to grant user permissions on certain LF-tags. Before making a grant, the admin can use
     * <code>SearchTablesByLFTags</code> to find all resources where the given <code>LFTag</code>s are valid to verify
     * whether the returned resources can be shared.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchTablesByLFTags(software.amazon.awssdk.services.lakeformation.model.SearchTablesByLfTagsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.SearchTablesByLFTagsIterable responses = client.searchTablesByLFTagsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lakeformation.paginators.SearchTablesByLFTagsIterable responses = client
     *             .searchTablesByLFTagsPaginator(request);
     *     for (software.amazon.awssdk.services.lakeformation.model.SearchTablesByLfTagsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.SearchTablesByLFTagsIterable responses = client.searchTablesByLFTagsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchTablesByLFTags(software.amazon.awssdk.services.lakeformation.model.SearchTablesByLfTagsRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchTablesByLfTagsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.SearchTablesByLFTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/SearchTablesByLFTags"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchTablesByLFTagsIterable searchTablesByLFTagsPaginator(SearchTablesByLfTagsRequest searchTablesByLfTagsRequest)
            throws EntityNotFoundException, InternalServiceException, InvalidInputException, OperationTimeoutException,
            GlueEncryptionException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation allows a search on <code>TABLE</code> resources by <code>LFTag</code>s. This will be used by
     * admins who want to grant user permissions on certain LF-tags. Before making a grant, the admin can use
     * <code>SearchTablesByLFTags</code> to find all resources where the given <code>LFTag</code>s are valid to verify
     * whether the returned resources can be shared.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchTablesByLFTags(software.amazon.awssdk.services.lakeformation.model.SearchTablesByLfTagsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.SearchTablesByLFTagsIterable responses = client.searchTablesByLFTagsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lakeformation.paginators.SearchTablesByLFTagsIterable responses = client
     *             .searchTablesByLFTagsPaginator(request);
     *     for (software.amazon.awssdk.services.lakeformation.model.SearchTablesByLfTagsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lakeformation.paginators.SearchTablesByLFTagsIterable responses = client.searchTablesByLFTagsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchTablesByLFTags(software.amazon.awssdk.services.lakeformation.model.SearchTablesByLfTagsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchTablesByLfTagsRequest.Builder} avoiding the
     * need to create one manually via {@link SearchTablesByLfTagsRequest#builder()}
     * </p>
     *
     * @param searchTablesByLfTagsRequest
     *        A {@link Consumer} that will call methods on {@link SearchTablesByLFTagsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws GlueEncryptionException
     *         An encryption operation failed.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.SearchTablesByLFTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/SearchTablesByLFTags"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchTablesByLFTagsIterable searchTablesByLFTagsPaginator(
            Consumer<SearchTablesByLfTagsRequest.Builder> searchTablesByLfTagsRequest) throws EntityNotFoundException,
            InternalServiceException, InvalidInputException, OperationTimeoutException, GlueEncryptionException,
            AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        return searchTablesByLFTagsPaginator(SearchTablesByLfTagsRequest.builder().applyMutation(searchTablesByLfTagsRequest)
                .build());
    }

    /**
     * <p>
     * Submits a request to process a query statement.
     * </p>
     * <p>
     * This operation generates work units that can be retrieved with the <code>GetWorkUnits</code> operation as soon as
     * the query state is WORKUNITS_AVAILABLE or FINISHED.
     * </p>
     *
     * @param startQueryPlanningRequest
     * @return Result of the StartQueryPlanning operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws ThrottledException
     *         Contains details about an error where the query request was throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.StartQueryPlanning
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/StartQueryPlanning"
     *      target="_top">AWS API Documentation</a>
     */
    default StartQueryPlanningResponse startQueryPlanning(StartQueryPlanningRequest startQueryPlanningRequest)
            throws InternalServiceException, InvalidInputException, AccessDeniedException, ThrottledException,
            AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Submits a request to process a query statement.
     * </p>
     * <p>
     * This operation generates work units that can be retrieved with the <code>GetWorkUnits</code> operation as soon as
     * the query state is WORKUNITS_AVAILABLE or FINISHED.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartQueryPlanningRequest.Builder} avoiding the
     * need to create one manually via {@link StartQueryPlanningRequest#builder()}
     * </p>
     *
     * @param startQueryPlanningRequest
     *        A {@link Consumer} that will call methods on {@link StartQueryPlanningRequest.Builder} to create a
     *        request.
     * @return Result of the StartQueryPlanning operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws ThrottledException
     *         Contains details about an error where the query request was throttled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.StartQueryPlanning
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/StartQueryPlanning"
     *      target="_top">AWS API Documentation</a>
     */
    default StartQueryPlanningResponse startQueryPlanning(Consumer<StartQueryPlanningRequest.Builder> startQueryPlanningRequest)
            throws InternalServiceException, InvalidInputException, AccessDeniedException, ThrottledException,
            AwsServiceException, SdkClientException, LakeFormationException {
        return startQueryPlanning(StartQueryPlanningRequest.builder().applyMutation(startQueryPlanningRequest).build());
    }

    /**
     * <p>
     * Starts a new transaction and returns its transaction ID. Transaction IDs are opaque objects that you can use to
     * identify a transaction.
     * </p>
     *
     * @param startTransactionRequest
     * @return Result of the StartTransaction operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.StartTransaction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/StartTransaction"
     *      target="_top">AWS API Documentation</a>
     */
    default StartTransactionResponse startTransaction(StartTransactionRequest startTransactionRequest)
            throws InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException,
            LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a new transaction and returns its transaction ID. Transaction IDs are opaque objects that you can use to
     * identify a transaction.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartTransactionRequest.Builder} avoiding the need
     * to create one manually via {@link StartTransactionRequest#builder()}
     * </p>
     *
     * @param startTransactionRequest
     *        A {@link Consumer} that will call methods on {@link StartTransactionRequest.Builder} to create a request.
     * @return Result of the StartTransaction operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.StartTransaction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/StartTransaction"
     *      target="_top">AWS API Documentation</a>
     */
    default StartTransactionResponse startTransaction(Consumer<StartTransactionRequest.Builder> startTransactionRequest)
            throws InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException,
            LakeFormationException {
        return startTransaction(StartTransactionRequest.builder().applyMutation(startTransactionRequest).build());
    }

    /**
     * <p>
     * Updates the list of possible values for the specified LF-tag key. If the LF-tag does not exist, the operation
     * throws an EntityNotFoundException. The values in the delete key values will be deleted from list of possible
     * values. If any value in the delete key values is attached to a resource, then API errors out with a 400 Exception
     * - "Update not allowed". Untag the attribute before deleting the LF-tag key's value.
     * </p>
     *
     * @param updateLfTagRequest
     * @return Result of the UpdateLFTag operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.UpdateLFTag
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/UpdateLFTag" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateLfTagResponse updateLFTag(UpdateLfTagRequest updateLfTagRequest) throws EntityNotFoundException,
            InvalidInputException, InternalServiceException, OperationTimeoutException, ConcurrentModificationException,
            AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the list of possible values for the specified LF-tag key. If the LF-tag does not exist, the operation
     * throws an EntityNotFoundException. The values in the delete key values will be deleted from list of possible
     * values. If any value in the delete key values is attached to a resource, then API errors out with a 400 Exception
     * - "Update not allowed". Untag the attribute before deleting the LF-tag key's value.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLfTagRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateLfTagRequest#builder()}
     * </p>
     *
     * @param updateLfTagRequest
     *        A {@link Consumer} that will call methods on {@link UpdateLFTagRequest.Builder} to create a request.
     * @return Result of the UpdateLFTag operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.UpdateLFTag
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/UpdateLFTag" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateLfTagResponse updateLFTag(Consumer<UpdateLfTagRequest.Builder> updateLfTagRequest)
            throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException,
            ConcurrentModificationException, AccessDeniedException, AwsServiceException, SdkClientException,
            LakeFormationException {
        return updateLFTag(UpdateLfTagRequest.builder().applyMutation(updateLfTagRequest).build());
    }

    /**
     * <p>
     * Updates the data access role used for vending access to the given (registered) resource in Lake Formation.
     * </p>
     *
     * @param updateResourceRequest
     * @return Result of the UpdateResource operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.UpdateResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/UpdateResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateResourceResponse updateResource(UpdateResourceRequest updateResourceRequest) throws InvalidInputException,
            InternalServiceException, OperationTimeoutException, EntityNotFoundException, AwsServiceException,
            SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the data access role used for vending access to the given (registered) resource in Lake Formation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateResourceRequest#builder()}
     * </p>
     *
     * @param updateResourceRequest
     *        A {@link Consumer} that will call methods on {@link UpdateResourceRequest.Builder} to create a request.
     * @return Result of the UpdateResource operation returned by the service.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.UpdateResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/UpdateResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateResourceResponse updateResource(Consumer<UpdateResourceRequest.Builder> updateResourceRequest)
            throws InvalidInputException, InternalServiceException, OperationTimeoutException, EntityNotFoundException,
            AwsServiceException, SdkClientException, LakeFormationException {
        return updateResource(UpdateResourceRequest.builder().applyMutation(updateResourceRequest).build());
    }

    /**
     * <p>
     * Updates the manifest of Amazon S3 objects that make up the specified governed table.
     * </p>
     *
     * @param updateTableObjectsRequest
     * @return Result of the UpdateTableObjects operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws TransactionCommittedException
     *         Contains details about an error where the specified transaction has already been committed and cannot be
     *         used for <code>UpdateTableObjects</code>.
     * @throws TransactionCanceledException
     *         Contains details about an error related to a transaction that was cancelled.
     * @throws TransactionCommitInProgressException
     *         Contains details about an error related to a transaction commit that was in progress.
     * @throws ResourceNotReadyException
     *         Contains details about an error related to a resource which is not ready for a transaction.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.UpdateTableObjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/UpdateTableObjects"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateTableObjectsResponse updateTableObjects(UpdateTableObjectsRequest updateTableObjectsRequest)
            throws InternalServiceException, InvalidInputException, OperationTimeoutException, EntityNotFoundException,
            TransactionCommittedException, TransactionCanceledException, TransactionCommitInProgressException,
            ResourceNotReadyException, ConcurrentModificationException, AwsServiceException, SdkClientException,
            LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the manifest of Amazon S3 objects that make up the specified governed table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTableObjectsRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateTableObjectsRequest#builder()}
     * </p>
     *
     * @param updateTableObjectsRequest
     *        A {@link Consumer} that will call methods on {@link UpdateTableObjectsRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateTableObjects operation returned by the service.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws OperationTimeoutException
     *         The operation timed out.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws TransactionCommittedException
     *         Contains details about an error where the specified transaction has already been committed and cannot be
     *         used for <code>UpdateTableObjects</code>.
     * @throws TransactionCanceledException
     *         Contains details about an error related to a transaction that was cancelled.
     * @throws TransactionCommitInProgressException
     *         Contains details about an error related to a transaction commit that was in progress.
     * @throws ResourceNotReadyException
     *         Contains details about an error related to a resource which is not ready for a transaction.
     * @throws ConcurrentModificationException
     *         Two processes are trying to modify a resource simultaneously.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.UpdateTableObjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/UpdateTableObjects"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateTableObjectsResponse updateTableObjects(Consumer<UpdateTableObjectsRequest.Builder> updateTableObjectsRequest)
            throws InternalServiceException, InvalidInputException, OperationTimeoutException, EntityNotFoundException,
            TransactionCommittedException, TransactionCanceledException, TransactionCommitInProgressException,
            ResourceNotReadyException, ConcurrentModificationException, AwsServiceException, SdkClientException,
            LakeFormationException {
        return updateTableObjects(UpdateTableObjectsRequest.builder().applyMutation(updateTableObjectsRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of the storage optimizers for a table.
     * </p>
     *
     * @param updateTableStorageOptimizerRequest
     * @return Result of the UpdateTableStorageOptimizer operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.UpdateTableStorageOptimizer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/UpdateTableStorageOptimizer"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateTableStorageOptimizerResponse updateTableStorageOptimizer(
            UpdateTableStorageOptimizerRequest updateTableStorageOptimizerRequest) throws EntityNotFoundException,
            InvalidInputException, AccessDeniedException, InternalServiceException, AwsServiceException, SdkClientException,
            LakeFormationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of the storage optimizers for a table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTableStorageOptimizerRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateTableStorageOptimizerRequest#builder()}
     * </p>
     *
     * @param updateTableStorageOptimizerRequest
     *        A {@link Consumer} that will call methods on {@link UpdateTableStorageOptimizerRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateTableStorageOptimizer operation returned by the service.
     * @throws EntityNotFoundException
     *         A specified entity does not exist
     * @throws InvalidInputException
     *         The input provided was not valid.
     * @throws AccessDeniedException
     *         Access to a resource was denied.
     * @throws InternalServiceException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LakeFormationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LakeFormationClient.UpdateTableStorageOptimizer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/UpdateTableStorageOptimizer"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateTableStorageOptimizerResponse updateTableStorageOptimizer(
            Consumer<UpdateTableStorageOptimizerRequest.Builder> updateTableStorageOptimizerRequest)
            throws EntityNotFoundException, InvalidInputException, AccessDeniedException, InternalServiceException,
            AwsServiceException, SdkClientException, LakeFormationException {
        return updateTableStorageOptimizer(UpdateTableStorageOptimizerRequest.builder()
                .applyMutation(updateTableStorageOptimizerRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }
}
