/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure containing the name of a column resource and the LF-tags attached to it.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ColumnLFTag implements SdkPojo, Serializable, ToCopyableBuilder<ColumnLFTag.Builder, ColumnLFTag> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ColumnLFTag::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<LFTagPair>> LF_TAGS_FIELD = SdkField
            .<List<LFTagPair>> builder(MarshallingType.LIST)
            .memberName("LFTags")
            .getter(getter(ColumnLFTag::lfTags))
            .setter(setter(Builder::lfTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LFTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LFTagPair> builder(MarshallingType.SDK_POJO)
                                            .constructor(LFTagPair::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, LF_TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<LFTagPair> lfTags;

    private ColumnLFTag(BuilderImpl builder) {
        this.name = builder.name;
        this.lfTags = builder.lfTags;
    }

    /**
     * <p>
     * The name of a column resource.
     * </p>
     * 
     * @return The name of a column resource.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the LFTags property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLfTags() {
        return lfTags != null && !(lfTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The LF-tags attached to a column resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLfTags} method.
     * </p>
     * 
     * @return The LF-tags attached to a column resource.
     */
    public final List<LFTagPair> lfTags() {
        return lfTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasLfTags() ? lfTags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnLFTag)) {
            return false;
        }
        ColumnLFTag other = (ColumnLFTag) obj;
        return Objects.equals(name(), other.name()) && hasLfTags() == other.hasLfTags()
                && Objects.equals(lfTags(), other.lfTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ColumnLFTag").add("Name", name()).add("LFTags", hasLfTags() ? lfTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "LFTags":
            return Optional.ofNullable(clazz.cast(lfTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ColumnLFTag, T> g) {
        return obj -> g.apply((ColumnLFTag) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ColumnLFTag> {
        /**
         * <p>
         * The name of a column resource.
         * </p>
         * 
         * @param name
         *        The name of a column resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The LF-tags attached to a column resource.
         * </p>
         * 
         * @param lfTags
         *        The LF-tags attached to a column resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lfTags(Collection<LFTagPair> lfTags);

        /**
         * <p>
         * The LF-tags attached to a column resource.
         * </p>
         * 
         * @param lfTags
         *        The LF-tags attached to a column resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lfTags(LFTagPair... lfTags);

        /**
         * <p>
         * The LF-tags attached to a column resource.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LFTagPair>.Builder} avoiding the need to
         * create one manually via {@link List<LFTagPair>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LFTagPair>.Builder#build()} is called immediately and its
         * result is passed to {@link #lfTags(List<LFTagPair>)}.
         * 
         * @param lfTags
         *        a consumer that will call methods on {@link List<LFTagPair>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lfTags(List<LFTagPair>)
         */
        Builder lfTags(Consumer<LFTagPair.Builder>... lfTags);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<LFTagPair> lfTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ColumnLFTag model) {
            name(model.name);
            lfTags(model.lfTags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<LFTagPair.Builder> getLfTags() {
            List<LFTagPair.Builder> result = LFTagsListCopier.copyToBuilder(this.lfTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLfTags(Collection<LFTagPair.BuilderImpl> lfTags) {
            this.lfTags = LFTagsListCopier.copyFromBuilder(lfTags);
        }

        @Override
        @Transient
        public final Builder lfTags(Collection<LFTagPair> lfTags) {
            this.lfTags = LFTagsListCopier.copy(lfTags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder lfTags(LFTagPair... lfTags) {
            lfTags(Arrays.asList(lfTags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder lfTags(Consumer<LFTagPair.Builder>... lfTags) {
            lfTags(Stream.of(lfTags).map(c -> LFTagPair.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ColumnLFTag build() {
            return new ColumnLFTag(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
