/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CommitTransactionResponse extends LakeFormationResponse implements
        ToCopyableBuilder<CommitTransactionResponse.Builder, CommitTransactionResponse> {
    private static final SdkField<String> TRANSACTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransactionStatus").getter(getter(CommitTransactionResponse::transactionStatusAsString))
            .setter(setter(Builder::transactionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransactionStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSACTION_STATUS_FIELD));

    private final String transactionStatus;

    private CommitTransactionResponse(BuilderImpl builder) {
        super(builder);
        this.transactionStatus = builder.transactionStatus;
    }

    /**
     * <p>
     * The status of the transaction.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #transactionStatus}
     * will return {@link TransactionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #transactionStatusAsString}.
     * </p>
     * 
     * @return The status of the transaction.
     * @see TransactionStatus
     */
    public final TransactionStatus transactionStatus() {
        return TransactionStatus.fromValue(transactionStatus);
    }

    /**
     * <p>
     * The status of the transaction.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #transactionStatus}
     * will return {@link TransactionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #transactionStatusAsString}.
     * </p>
     * 
     * @return The status of the transaction.
     * @see TransactionStatus
     */
    public final String transactionStatusAsString() {
        return transactionStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(transactionStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommitTransactionResponse)) {
            return false;
        }
        CommitTransactionResponse other = (CommitTransactionResponse) obj;
        return Objects.equals(transactionStatusAsString(), other.transactionStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CommitTransactionResponse").add("TransactionStatus", transactionStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransactionStatus":
            return Optional.ofNullable(clazz.cast(transactionStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CommitTransactionResponse, T> g) {
        return obj -> g.apply((CommitTransactionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LakeFormationResponse.Builder, SdkPojo, CopyableBuilder<Builder, CommitTransactionResponse> {
        /**
         * <p>
         * The status of the transaction.
         * </p>
         * 
         * @param transactionStatus
         *        The status of the transaction.
         * @see TransactionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransactionStatus
         */
        Builder transactionStatus(String transactionStatus);

        /**
         * <p>
         * The status of the transaction.
         * </p>
         * 
         * @param transactionStatus
         *        The status of the transaction.
         * @see TransactionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransactionStatus
         */
        Builder transactionStatus(TransactionStatus transactionStatus);
    }

    static final class BuilderImpl extends LakeFormationResponse.BuilderImpl implements Builder {
        private String transactionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(CommitTransactionResponse model) {
            super(model);
            transactionStatus(model.transactionStatus);
        }

        public final String getTransactionStatus() {
            return transactionStatus;
        }

        public final void setTransactionStatus(String transactionStatus) {
            this.transactionStatus = transactionStatus;
        }

        @Override
        @Transient
        public final Builder transactionStatus(String transactionStatus) {
            this.transactionStatus = transactionStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder transactionStatus(TransactionStatus transactionStatus) {
            this.transactionStatus(transactionStatus == null ? null : transactionStatus.toString());
            return this;
        }

        @Override
        public CommitTransactionResponse build() {
            return new CommitTransactionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
