/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTransactionsRequest extends LakeFormationRequest implements
        ToCopyableBuilder<ListTransactionsRequest.Builder, ListTransactionsRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogId").getter(getter(ListTransactionsRequest::catalogId)).setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<String> STATUS_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusFilter").getter(getter(ListTransactionsRequest::statusFilterAsString))
            .setter(setter(Builder::statusFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusFilter").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListTransactionsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListTransactionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD,
            STATUS_FILTER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String catalogId;

    private final String statusFilter;

    private final Integer maxResults;

    private final String nextToken;

    private ListTransactionsRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.statusFilter = builder.statusFilter;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The catalog for which to list transactions. Defaults to the account ID of the caller.
     * </p>
     * 
     * @return The catalog for which to list transactions. Defaults to the account ID of the caller.
     */
    public final String catalogId() {
        return catalogId;
    }

    /**
     * <p>
     * A filter indicating the status of transactions to return. Options are ALL | COMPLETED | COMMITTED | ABORTED |
     * ACTIVE. The default is <code>ALL</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusFilter} will
     * return {@link TransactionStatusFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusFilterAsString}.
     * </p>
     * 
     * @return A filter indicating the status of transactions to return. Options are ALL | COMPLETED | COMMITTED |
     *         ABORTED | ACTIVE. The default is <code>ALL</code>.
     * @see TransactionStatusFilter
     */
    public final TransactionStatusFilter statusFilter() {
        return TransactionStatusFilter.fromValue(statusFilter);
    }

    /**
     * <p>
     * A filter indicating the status of transactions to return. Options are ALL | COMPLETED | COMMITTED | ABORTED |
     * ACTIVE. The default is <code>ALL</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusFilter} will
     * return {@link TransactionStatusFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusFilterAsString}.
     * </p>
     * 
     * @return A filter indicating the status of transactions to return. Options are ALL | COMPLETED | COMMITTED |
     *         ABORTED | ACTIVE. The default is <code>ALL</code>.
     * @see TransactionStatusFilter
     */
    public final String statusFilterAsString() {
        return statusFilter;
    }

    /**
     * <p>
     * The maximum number of transactions to return in a single call.
     * </p>
     * 
     * @return The maximum number of transactions to return in a single call.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A continuation token if this is not the first call to retrieve transactions.
     * </p>
     * 
     * @return A continuation token if this is not the first call to retrieve transactions.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(statusFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTransactionsRequest)) {
            return false;
        }
        ListTransactionsRequest other = (ListTransactionsRequest) obj;
        return Objects.equals(catalogId(), other.catalogId())
                && Objects.equals(statusFilterAsString(), other.statusFilterAsString())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTransactionsRequest").add("CatalogId", catalogId())
                .add("StatusFilter", statusFilterAsString()).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "StatusFilter":
            return Optional.ofNullable(clazz.cast(statusFilterAsString()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTransactionsRequest, T> g) {
        return obj -> g.apply((ListTransactionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LakeFormationRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListTransactionsRequest> {
        /**
         * <p>
         * The catalog for which to list transactions. Defaults to the account ID of the caller.
         * </p>
         * 
         * @param catalogId
         *        The catalog for which to list transactions. Defaults to the account ID of the caller.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * A filter indicating the status of transactions to return. Options are ALL | COMPLETED | COMMITTED | ABORTED |
         * ACTIVE. The default is <code>ALL</code>.
         * </p>
         * 
         * @param statusFilter
         *        A filter indicating the status of transactions to return. Options are ALL | COMPLETED | COMMITTED |
         *        ABORTED | ACTIVE. The default is <code>ALL</code>.
         * @see TransactionStatusFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransactionStatusFilter
         */
        Builder statusFilter(String statusFilter);

        /**
         * <p>
         * A filter indicating the status of transactions to return. Options are ALL | COMPLETED | COMMITTED | ABORTED |
         * ACTIVE. The default is <code>ALL</code>.
         * </p>
         * 
         * @param statusFilter
         *        A filter indicating the status of transactions to return. Options are ALL | COMPLETED | COMMITTED |
         *        ABORTED | ACTIVE. The default is <code>ALL</code>.
         * @see TransactionStatusFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransactionStatusFilter
         */
        Builder statusFilter(TransactionStatusFilter statusFilter);

        /**
         * <p>
         * The maximum number of transactions to return in a single call.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of transactions to return in a single call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A continuation token if this is not the first call to retrieve transactions.
         * </p>
         * 
         * @param nextToken
         *        A continuation token if this is not the first call to retrieve transactions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LakeFormationRequest.BuilderImpl implements Builder {
        private String catalogId;

        private String statusFilter;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTransactionsRequest model) {
            super(model);
            catalogId(model.catalogId);
            statusFilter(model.statusFilter);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getCatalogId() {
            return catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        @Transient
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getStatusFilter() {
            return statusFilter;
        }

        public final void setStatusFilter(String statusFilter) {
            this.statusFilter = statusFilter;
        }

        @Override
        @Transient
        public final Builder statusFilter(String statusFilter) {
            this.statusFilter = statusFilter;
            return this;
        }

        @Override
        @Transient
        public final Builder statusFilter(TransactionStatusFilter statusFilter) {
            this.statusFilter(statusFilter == null ? null : statusFilter.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTransactionsRequest build() {
            return new ListTransactionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
