/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure for the output.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetWorkUnitsResponse extends LakeFormationResponse implements
        ToCopyableBuilder<GetWorkUnitsResponse.Builder, GetWorkUnitsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetWorkUnitsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> QUERY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryId").getter(getter(GetWorkUnitsResponse::queryId)).setter(setter(Builder::queryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryId").build()).build();

    private static final SdkField<List<WorkUnitRange>> WORK_UNIT_RANGES_FIELD = SdkField
            .<List<WorkUnitRange>> builder(MarshallingType.LIST)
            .memberName("WorkUnitRanges")
            .getter(getter(GetWorkUnitsResponse::workUnitRanges))
            .setter(setter(Builder::workUnitRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkUnitRanges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WorkUnitRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkUnitRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            QUERY_ID_FIELD, WORK_UNIT_RANGES_FIELD));

    private final String nextToken;

    private final String queryId;

    private final List<WorkUnitRange> workUnitRanges;

    private GetWorkUnitsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.queryId = builder.queryId;
        this.workUnitRanges = builder.workUnitRanges;
    }

    /**
     * <p>
     * A continuation token for paginating the returned list of tokens, returned if the current segment of the list is
     * not the last.
     * </p>
     * 
     * @return A continuation token for paginating the returned list of tokens, returned if the current segment of the
     *         list is not the last.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The ID of the plan query operation.
     * </p>
     * 
     * @return The ID of the plan query operation.
     */
    public final String queryId() {
        return queryId;
    }

    /**
     * For responses, this returns true if the service returned a value for the WorkUnitRanges property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasWorkUnitRanges() {
        return workUnitRanges != null && !(workUnitRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A <code>WorkUnitRangeList</code> object that specifies the valid range of work unit IDs for querying the
     * execution service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorkUnitRanges} method.
     * </p>
     * 
     * @return A <code>WorkUnitRangeList</code> object that specifies the valid range of work unit IDs for querying the
     *         execution service.
     */
    public final List<WorkUnitRange> workUnitRanges() {
        return workUnitRanges;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(queryId());
        hashCode = 31 * hashCode + Objects.hashCode(hasWorkUnitRanges() ? workUnitRanges() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkUnitsResponse)) {
            return false;
        }
        GetWorkUnitsResponse other = (GetWorkUnitsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(queryId(), other.queryId())
                && hasWorkUnitRanges() == other.hasWorkUnitRanges() && Objects.equals(workUnitRanges(), other.workUnitRanges());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetWorkUnitsResponse").add("NextToken", nextToken()).add("QueryId", queryId())
                .add("WorkUnitRanges", hasWorkUnitRanges() ? workUnitRanges() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "QueryId":
            return Optional.ofNullable(clazz.cast(queryId()));
        case "WorkUnitRanges":
            return Optional.ofNullable(clazz.cast(workUnitRanges()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetWorkUnitsResponse, T> g) {
        return obj -> g.apply((GetWorkUnitsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LakeFormationResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetWorkUnitsResponse> {
        /**
         * <p>
         * A continuation token for paginating the returned list of tokens, returned if the current segment of the list
         * is not the last.
         * </p>
         * 
         * @param nextToken
         *        A continuation token for paginating the returned list of tokens, returned if the current segment of
         *        the list is not the last.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The ID of the plan query operation.
         * </p>
         * 
         * @param queryId
         *        The ID of the plan query operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryId(String queryId);

        /**
         * <p>
         * A <code>WorkUnitRangeList</code> object that specifies the valid range of work unit IDs for querying the
         * execution service.
         * </p>
         * 
         * @param workUnitRanges
         *        A <code>WorkUnitRangeList</code> object that specifies the valid range of work unit IDs for querying
         *        the execution service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workUnitRanges(Collection<WorkUnitRange> workUnitRanges);

        /**
         * <p>
         * A <code>WorkUnitRangeList</code> object that specifies the valid range of work unit IDs for querying the
         * execution service.
         * </p>
         * 
         * @param workUnitRanges
         *        A <code>WorkUnitRangeList</code> object that specifies the valid range of work unit IDs for querying
         *        the execution service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workUnitRanges(WorkUnitRange... workUnitRanges);

        /**
         * <p>
         * A <code>WorkUnitRangeList</code> object that specifies the valid range of work unit IDs for querying the
         * execution service.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<WorkUnitRange>.Builder} avoiding the
         * need to create one manually via {@link List<WorkUnitRange>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<WorkUnitRange>.Builder#build()} is called immediately and
         * its result is passed to {@link #workUnitRanges(List<WorkUnitRange>)}.
         * 
         * @param workUnitRanges
         *        a consumer that will call methods on {@link List<WorkUnitRange>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workUnitRanges(List<WorkUnitRange>)
         */
        Builder workUnitRanges(Consumer<WorkUnitRange.Builder>... workUnitRanges);
    }

    static final class BuilderImpl extends LakeFormationResponse.BuilderImpl implements Builder {
        private String nextToken;

        private String queryId;

        private List<WorkUnitRange> workUnitRanges = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkUnitsResponse model) {
            super(model);
            nextToken(model.nextToken);
            queryId(model.queryId);
            workUnitRanges(model.workUnitRanges);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getQueryId() {
            return queryId;
        }

        public final void setQueryId(String queryId) {
            this.queryId = queryId;
        }

        @Override
        public final Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public final List<WorkUnitRange.Builder> getWorkUnitRanges() {
            List<WorkUnitRange.Builder> result = WorkUnitRangeListCopier.copyToBuilder(this.workUnitRanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkUnitRanges(Collection<WorkUnitRange.BuilderImpl> workUnitRanges) {
            this.workUnitRanges = WorkUnitRangeListCopier.copyFromBuilder(workUnitRanges);
        }

        @Override
        public final Builder workUnitRanges(Collection<WorkUnitRange> workUnitRanges) {
            this.workUnitRanges = WorkUnitRangeListCopier.copy(workUnitRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workUnitRanges(WorkUnitRange... workUnitRanges) {
            workUnitRanges(Arrays.asList(workUnitRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workUnitRanges(Consumer<WorkUnitRange.Builder>... workUnitRanges) {
            workUnitRanges(Stream.of(workUnitRanges).map(c -> WorkUnitRange.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetWorkUnitsResponse build() {
            return new GetWorkUnitsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
