/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPermissionsResponse extends LakeFormationResponse implements
        ToCopyableBuilder<ListPermissionsResponse.Builder, ListPermissionsResponse> {
    private static final SdkField<List<PrincipalResourcePermissions>> PRINCIPAL_RESOURCE_PERMISSIONS_FIELD = SdkField
            .<List<PrincipalResourcePermissions>> builder(MarshallingType.LIST)
            .memberName("PrincipalResourcePermissions")
            .getter(getter(ListPermissionsResponse::principalResourcePermissions))
            .setter(setter(Builder::principalResourcePermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalResourcePermissions")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PrincipalResourcePermissions> builder(MarshallingType.SDK_POJO)
                                            .constructor(PrincipalResourcePermissions::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPermissionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PRINCIPAL_RESOURCE_PERMISSIONS_FIELD, NEXT_TOKEN_FIELD));

    private final List<PrincipalResourcePermissions> principalResourcePermissions;

    private final String nextToken;

    private ListPermissionsResponse(BuilderImpl builder) {
        super(builder);
        this.principalResourcePermissions = builder.principalResourcePermissions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the PrincipalResourcePermissions property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPrincipalResourcePermissions() {
        return principalResourcePermissions != null && !(principalResourcePermissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of principals and their permissions on the resource for the specified principal and resource types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrincipalResourcePermissions} method.
     * </p>
     * 
     * @return A list of principals and their permissions on the resource for the specified principal and resource
     *         types.
     */
    public final List<PrincipalResourcePermissions> principalResourcePermissions() {
        return principalResourcePermissions;
    }

    /**
     * <p>
     * A continuation token, if this is not the first call to retrieve this list.
     * </p>
     * 
     * @return A continuation token, if this is not the first call to retrieve this list.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPrincipalResourcePermissions() ? principalResourcePermissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPermissionsResponse)) {
            return false;
        }
        ListPermissionsResponse other = (ListPermissionsResponse) obj;
        return hasPrincipalResourcePermissions() == other.hasPrincipalResourcePermissions()
                && Objects.equals(principalResourcePermissions(), other.principalResourcePermissions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPermissionsResponse")
                .add("PrincipalResourcePermissions", hasPrincipalResourcePermissions() ? principalResourcePermissions() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PrincipalResourcePermissions":
            return Optional.ofNullable(clazz.cast(principalResourcePermissions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPermissionsResponse, T> g) {
        return obj -> g.apply((ListPermissionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LakeFormationResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListPermissionsResponse> {
        /**
         * <p>
         * A list of principals and their permissions on the resource for the specified principal and resource types.
         * </p>
         * 
         * @param principalResourcePermissions
         *        A list of principals and their permissions on the resource for the specified principal and resource
         *        types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalResourcePermissions(Collection<PrincipalResourcePermissions> principalResourcePermissions);

        /**
         * <p>
         * A list of principals and their permissions on the resource for the specified principal and resource types.
         * </p>
         * 
         * @param principalResourcePermissions
         *        A list of principals and their permissions on the resource for the specified principal and resource
         *        types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalResourcePermissions(PrincipalResourcePermissions... principalResourcePermissions);

        /**
         * <p>
         * A list of principals and their permissions on the resource for the specified principal and resource types.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <PrincipalResourcePermissions>.Builder} avoiding the need to create one manually via {@link List
         * <PrincipalResourcePermissions>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PrincipalResourcePermissions>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #principalResourcePermissions(List<PrincipalResourcePermissions>)}.
         * 
         * @param principalResourcePermissions
         *        a consumer that will call methods on {@link List<PrincipalResourcePermissions>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #principalResourcePermissions(List<PrincipalResourcePermissions>)
         */
        Builder principalResourcePermissions(Consumer<PrincipalResourcePermissions.Builder>... principalResourcePermissions);

        /**
         * <p>
         * A continuation token, if this is not the first call to retrieve this list.
         * </p>
         * 
         * @param nextToken
         *        A continuation token, if this is not the first call to retrieve this list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LakeFormationResponse.BuilderImpl implements Builder {
        private List<PrincipalResourcePermissions> principalResourcePermissions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPermissionsResponse model) {
            super(model);
            principalResourcePermissions(model.principalResourcePermissions);
            nextToken(model.nextToken);
        }

        public final List<PrincipalResourcePermissions.Builder> getPrincipalResourcePermissions() {
            List<PrincipalResourcePermissions.Builder> result = PrincipalResourcePermissionsListCopier
                    .copyToBuilder(this.principalResourcePermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrincipalResourcePermissions(
                Collection<PrincipalResourcePermissions.BuilderImpl> principalResourcePermissions) {
            this.principalResourcePermissions = PrincipalResourcePermissionsListCopier
                    .copyFromBuilder(principalResourcePermissions);
        }

        @Override
        public final Builder principalResourcePermissions(Collection<PrincipalResourcePermissions> principalResourcePermissions) {
            this.principalResourcePermissions = PrincipalResourcePermissionsListCopier.copy(principalResourcePermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principalResourcePermissions(PrincipalResourcePermissions... principalResourcePermissions) {
            principalResourcePermissions(Arrays.asList(principalResourcePermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principalResourcePermissions(
                Consumer<PrincipalResourcePermissions.Builder>... principalResourcePermissions) {
            principalResourcePermissions(Stream.of(principalResourcePermissions)
                    .map(c -> PrincipalResourcePermissions.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPermissionsResponse build() {
            return new ListPermissionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
