/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDataCellsFilterRequest extends LakeFormationRequest implements
        ToCopyableBuilder<CreateDataCellsFilterRequest.Builder, CreateDataCellsFilterRequest> {
    private static final SdkField<DataCellsFilter> TABLE_DATA_FIELD = SdkField
            .<DataCellsFilter> builder(MarshallingType.SDK_POJO).memberName("TableData")
            .getter(getter(CreateDataCellsFilterRequest::tableData)).setter(setter(Builder::tableData))
            .constructor(DataCellsFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_DATA_FIELD));

    private final DataCellsFilter tableData;

    private CreateDataCellsFilterRequest(BuilderImpl builder) {
        super(builder);
        this.tableData = builder.tableData;
    }

    /**
     * <p>
     * A <code>DataCellsFilter</code> structure containing information about the data cells filter.
     * </p>
     * 
     * @return A <code>DataCellsFilter</code> structure containing information about the data cells filter.
     */
    public final DataCellsFilter tableData() {
        return tableData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tableData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataCellsFilterRequest)) {
            return false;
        }
        CreateDataCellsFilterRequest other = (CreateDataCellsFilterRequest) obj;
        return Objects.equals(tableData(), other.tableData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDataCellsFilterRequest").add("TableData", tableData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableData":
            return Optional.ofNullable(clazz.cast(tableData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDataCellsFilterRequest, T> g) {
        return obj -> g.apply((CreateDataCellsFilterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LakeFormationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateDataCellsFilterRequest> {
        /**
         * <p>
         * A <code>DataCellsFilter</code> structure containing information about the data cells filter.
         * </p>
         * 
         * @param tableData
         *        A <code>DataCellsFilter</code> structure containing information about the data cells filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableData(DataCellsFilter tableData);

        /**
         * <p>
         * A <code>DataCellsFilter</code> structure containing information about the data cells filter.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataCellsFilter.Builder} avoiding the
         * need to create one manually via {@link DataCellsFilter#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataCellsFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #tableData(DataCellsFilter)}.
         * 
         * @param tableData
         *        a consumer that will call methods on {@link DataCellsFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tableData(DataCellsFilter)
         */
        default Builder tableData(Consumer<DataCellsFilter.Builder> tableData) {
            return tableData(DataCellsFilter.builder().applyMutation(tableData).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LakeFormationRequest.BuilderImpl implements Builder {
        private DataCellsFilter tableData;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataCellsFilterRequest model) {
            super(model);
            tableData(model.tableData);
        }

        public final DataCellsFilter.Builder getTableData() {
            return tableData != null ? tableData.toBuilder() : null;
        }

        public final void setTableData(DataCellsFilter.BuilderImpl tableData) {
            this.tableData = tableData != null ? tableData.build() : null;
        }

        @Override
        public final Builder tableData(DataCellsFilter tableData) {
            this.tableData = tableData;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataCellsFilterRequest build() {
            return new CreateDataCellsFilterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
