/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTableObjectsResponse extends LakeFormationResponse implements
        ToCopyableBuilder<GetTableObjectsResponse.Builder, GetTableObjectsResponse> {
    private static final SdkField<List<PartitionObjects>> OBJECTS_FIELD = SdkField
            .<List<PartitionObjects>> builder(MarshallingType.LIST)
            .memberName("Objects")
            .getter(getter(GetTableObjectsResponse::objects))
            .setter(setter(Builder::objects))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Objects").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PartitionObjects> builder(MarshallingType.SDK_POJO)
                                            .constructor(PartitionObjects::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetTableObjectsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<PartitionObjects> objects;

    private final String nextToken;

    private GetTableObjectsResponse(BuilderImpl builder) {
        super(builder);
        this.objects = builder.objects;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Objects property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasObjects() {
        return objects != null && !(objects instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects organized by partition keys.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasObjects} method.
     * </p>
     * 
     * @return A list of objects organized by partition keys.
     */
    public final List<PartitionObjects> objects() {
        return objects;
    }

    /**
     * <p>
     * A continuation token indicating whether additional data is available.
     * </p>
     * 
     * @return A continuation token indicating whether additional data is available.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasObjects() ? objects() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTableObjectsResponse)) {
            return false;
        }
        GetTableObjectsResponse other = (GetTableObjectsResponse) obj;
        return hasObjects() == other.hasObjects() && Objects.equals(objects(), other.objects())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTableObjectsResponse").add("Objects", hasObjects() ? objects() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Objects":
            return Optional.ofNullable(clazz.cast(objects()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTableObjectsResponse, T> g) {
        return obj -> g.apply((GetTableObjectsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LakeFormationResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetTableObjectsResponse> {
        /**
         * <p>
         * A list of objects organized by partition keys.
         * </p>
         * 
         * @param objects
         *        A list of objects organized by partition keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objects(Collection<PartitionObjects> objects);

        /**
         * <p>
         * A list of objects organized by partition keys.
         * </p>
         * 
         * @param objects
         *        A list of objects organized by partition keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objects(PartitionObjects... objects);

        /**
         * <p>
         * A list of objects organized by partition keys.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<PartitionObjects>.Builder} avoiding
         * the need to create one manually via {@link List<PartitionObjects>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PartitionObjects>.Builder#build()} is called immediately and
         * its result is passed to {@link #objects(List<PartitionObjects>)}.
         * 
         * @param objects
         *        a consumer that will call methods on {@link List<PartitionObjects>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #objects(List<PartitionObjects>)
         */
        Builder objects(Consumer<PartitionObjects.Builder>... objects);

        /**
         * <p>
         * A continuation token indicating whether additional data is available.
         * </p>
         * 
         * @param nextToken
         *        A continuation token indicating whether additional data is available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LakeFormationResponse.BuilderImpl implements Builder {
        private List<PartitionObjects> objects = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTableObjectsResponse model) {
            super(model);
            objects(model.objects);
            nextToken(model.nextToken);
        }

        public final List<PartitionObjects.Builder> getObjects() {
            List<PartitionObjects.Builder> result = PartitionedTableObjectsListCopier.copyToBuilder(this.objects);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setObjects(Collection<PartitionObjects.BuilderImpl> objects) {
            this.objects = PartitionedTableObjectsListCopier.copyFromBuilder(objects);
        }

        @Override
        public final Builder objects(Collection<PartitionObjects> objects) {
            this.objects = PartitionedTableObjectsListCopier.copy(objects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objects(PartitionObjects... objects) {
            objects(Arrays.asList(objects));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objects(Consumer<PartitionObjects.Builder>... objects) {
            objects(Stream.of(objects).map(c -> PartitionObjects.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetTableObjectsResponse build() {
            return new GetTableObjectsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
