/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure representing a list of AWS Lake Formation principals designated as data lake administrators and lists of
 * principal permission entries for default create database and default create table permissions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataLakeSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<DataLakeSettings.Builder, DataLakeSettings> {
    private static final SdkField<List<DataLakePrincipal>> DATA_LAKE_ADMINS_FIELD = SdkField
            .<List<DataLakePrincipal>> builder(MarshallingType.LIST)
            .memberName("DataLakeAdmins")
            .getter(getter(DataLakeSettings::dataLakeAdmins))
            .setter(setter(Builder::dataLakeAdmins))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataLakeAdmins").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataLakePrincipal> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataLakePrincipal::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<PrincipalPermissions>> CREATE_DATABASE_DEFAULT_PERMISSIONS_FIELD = SdkField
            .<List<PrincipalPermissions>> builder(MarshallingType.LIST)
            .memberName("CreateDatabaseDefaultPermissions")
            .getter(getter(DataLakeSettings::createDatabaseDefaultPermissions))
            .setter(setter(Builder::createDatabaseDefaultPermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDatabaseDefaultPermissions")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PrincipalPermissions> builder(MarshallingType.SDK_POJO)
                                            .constructor(PrincipalPermissions::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<PrincipalPermissions>> CREATE_TABLE_DEFAULT_PERMISSIONS_FIELD = SdkField
            .<List<PrincipalPermissions>> builder(MarshallingType.LIST)
            .memberName("CreateTableDefaultPermissions")
            .getter(getter(DataLakeSettings::createTableDefaultPermissions))
            .setter(setter(Builder::createTableDefaultPermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTableDefaultPermissions")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PrincipalPermissions> builder(MarshallingType.SDK_POJO)
                                            .constructor(PrincipalPermissions::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> TRUSTED_RESOURCE_OWNERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TrustedResourceOwners")
            .getter(getter(DataLakeSettings::trustedResourceOwners))
            .setter(setter(Builder::trustedResourceOwners))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustedResourceOwners").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_LAKE_ADMINS_FIELD,
            CREATE_DATABASE_DEFAULT_PERMISSIONS_FIELD, CREATE_TABLE_DEFAULT_PERMISSIONS_FIELD, TRUSTED_RESOURCE_OWNERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<DataLakePrincipal> dataLakeAdmins;

    private final List<PrincipalPermissions> createDatabaseDefaultPermissions;

    private final List<PrincipalPermissions> createTableDefaultPermissions;

    private final List<String> trustedResourceOwners;

    private DataLakeSettings(BuilderImpl builder) {
        this.dataLakeAdmins = builder.dataLakeAdmins;
        this.createDatabaseDefaultPermissions = builder.createDatabaseDefaultPermissions;
        this.createTableDefaultPermissions = builder.createTableDefaultPermissions;
        this.trustedResourceOwners = builder.trustedResourceOwners;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataLakeAdmins property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDataLakeAdmins() {
        return dataLakeAdmins != null && !(dataLakeAdmins instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of AWS Lake Formation principals. Supported principals are IAM users or IAM roles.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataLakeAdmins} method.
     * </p>
     * 
     * @return A list of AWS Lake Formation principals. Supported principals are IAM users or IAM roles.
     */
    public final List<DataLakePrincipal> dataLakeAdmins() {
        return dataLakeAdmins;
    }

    /**
     * For responses, this returns true if the service returned a value for the CreateDatabaseDefaultPermissions
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasCreateDatabaseDefaultPermissions() {
        return createDatabaseDefaultPermissions != null && !(createDatabaseDefaultPermissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A structure representing a list of up to three principal permissions entries for default create database
     * permissions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCreateDatabaseDefaultPermissions}
     * method.
     * </p>
     * 
     * @return A structure representing a list of up to three principal permissions entries for default create database
     *         permissions.
     */
    public final List<PrincipalPermissions> createDatabaseDefaultPermissions() {
        return createDatabaseDefaultPermissions;
    }

    /**
     * For responses, this returns true if the service returned a value for the CreateTableDefaultPermissions property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCreateTableDefaultPermissions() {
        return createTableDefaultPermissions != null && !(createTableDefaultPermissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A structure representing a list of up to three principal permissions entries for default create table
     * permissions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCreateTableDefaultPermissions} method.
     * </p>
     * 
     * @return A structure representing a list of up to three principal permissions entries for default create table
     *         permissions.
     */
    public final List<PrincipalPermissions> createTableDefaultPermissions() {
        return createTableDefaultPermissions;
    }

    /**
     * For responses, this returns true if the service returned a value for the TrustedResourceOwners property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTrustedResourceOwners() {
        return trustedResourceOwners != null && !(trustedResourceOwners instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the resource-owning account IDs that the caller's account can use to share their user access details
     * (user ARNs). The user ARNs can be logged in the resource owner's AWS CloudTrail log.
     * </p>
     * <p>
     * You may want to specify this property when you are in a high-trust boundary, such as the same team or company.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTrustedResourceOwners} method.
     * </p>
     * 
     * @return A list of the resource-owning account IDs that the caller's account can use to share their user access
     *         details (user ARNs). The user ARNs can be logged in the resource owner's AWS CloudTrail log.</p>
     *         <p>
     *         You may want to specify this property when you are in a high-trust boundary, such as the same team or
     *         company.
     */
    public final List<String> trustedResourceOwners() {
        return trustedResourceOwners;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDataLakeAdmins() ? dataLakeAdmins() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasCreateDatabaseDefaultPermissions() ? createDatabaseDefaultPermissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCreateTableDefaultPermissions() ? createTableDefaultPermissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTrustedResourceOwners() ? trustedResourceOwners() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataLakeSettings)) {
            return false;
        }
        DataLakeSettings other = (DataLakeSettings) obj;
        return hasDataLakeAdmins() == other.hasDataLakeAdmins() && Objects.equals(dataLakeAdmins(), other.dataLakeAdmins())
                && hasCreateDatabaseDefaultPermissions() == other.hasCreateDatabaseDefaultPermissions()
                && Objects.equals(createDatabaseDefaultPermissions(), other.createDatabaseDefaultPermissions())
                && hasCreateTableDefaultPermissions() == other.hasCreateTableDefaultPermissions()
                && Objects.equals(createTableDefaultPermissions(), other.createTableDefaultPermissions())
                && hasTrustedResourceOwners() == other.hasTrustedResourceOwners()
                && Objects.equals(trustedResourceOwners(), other.trustedResourceOwners());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DataLakeSettings")
                .add("DataLakeAdmins", hasDataLakeAdmins() ? dataLakeAdmins() : null)
                .add("CreateDatabaseDefaultPermissions",
                        hasCreateDatabaseDefaultPermissions() ? createDatabaseDefaultPermissions() : null)
                .add("CreateTableDefaultPermissions", hasCreateTableDefaultPermissions() ? createTableDefaultPermissions() : null)
                .add("TrustedResourceOwners", hasTrustedResourceOwners() ? trustedResourceOwners() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataLakeAdmins":
            return Optional.ofNullable(clazz.cast(dataLakeAdmins()));
        case "CreateDatabaseDefaultPermissions":
            return Optional.ofNullable(clazz.cast(createDatabaseDefaultPermissions()));
        case "CreateTableDefaultPermissions":
            return Optional.ofNullable(clazz.cast(createTableDefaultPermissions()));
        case "TrustedResourceOwners":
            return Optional.ofNullable(clazz.cast(trustedResourceOwners()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataLakeSettings, T> g) {
        return obj -> g.apply((DataLakeSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataLakeSettings> {
        /**
         * <p>
         * A list of AWS Lake Formation principals. Supported principals are IAM users or IAM roles.
         * </p>
         * 
         * @param dataLakeAdmins
         *        A list of AWS Lake Formation principals. Supported principals are IAM users or IAM roles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataLakeAdmins(Collection<DataLakePrincipal> dataLakeAdmins);

        /**
         * <p>
         * A list of AWS Lake Formation principals. Supported principals are IAM users or IAM roles.
         * </p>
         * 
         * @param dataLakeAdmins
         *        A list of AWS Lake Formation principals. Supported principals are IAM users or IAM roles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataLakeAdmins(DataLakePrincipal... dataLakeAdmins);

        /**
         * <p>
         * A list of AWS Lake Formation principals. Supported principals are IAM users or IAM roles.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DataLakePrincipal>.Builder} avoiding the
         * need to create one manually via {@link List<DataLakePrincipal>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DataLakePrincipal>.Builder#build()} is called immediately
         * and its result is passed to {@link #dataLakeAdmins(List<DataLakePrincipal>)}.
         * 
         * @param dataLakeAdmins
         *        a consumer that will call methods on {@link List<DataLakePrincipal>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataLakeAdmins(List<DataLakePrincipal>)
         */
        Builder dataLakeAdmins(Consumer<DataLakePrincipal.Builder>... dataLakeAdmins);

        /**
         * <p>
         * A structure representing a list of up to three principal permissions entries for default create database
         * permissions.
         * </p>
         * 
         * @param createDatabaseDefaultPermissions
         *        A structure representing a list of up to three principal permissions entries for default create
         *        database permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDatabaseDefaultPermissions(Collection<PrincipalPermissions> createDatabaseDefaultPermissions);

        /**
         * <p>
         * A structure representing a list of up to three principal permissions entries for default create database
         * permissions.
         * </p>
         * 
         * @param createDatabaseDefaultPermissions
         *        A structure representing a list of up to three principal permissions entries for default create
         *        database permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDatabaseDefaultPermissions(PrincipalPermissions... createDatabaseDefaultPermissions);

        /**
         * <p>
         * A structure representing a list of up to three principal permissions entries for default create database
         * permissions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PrincipalPermissions>.Builder} avoiding the
         * need to create one manually via {@link List<PrincipalPermissions>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PrincipalPermissions>.Builder#build()} is called immediately
         * and its result is passed to {@link #createDatabaseDefaultPermissions(List<PrincipalPermissions>)}.
         * 
         * @param createDatabaseDefaultPermissions
         *        a consumer that will call methods on {@link List<PrincipalPermissions>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createDatabaseDefaultPermissions(List<PrincipalPermissions>)
         */
        Builder createDatabaseDefaultPermissions(Consumer<PrincipalPermissions.Builder>... createDatabaseDefaultPermissions);

        /**
         * <p>
         * A structure representing a list of up to three principal permissions entries for default create table
         * permissions.
         * </p>
         * 
         * @param createTableDefaultPermissions
         *        A structure representing a list of up to three principal permissions entries for default create table
         *        permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTableDefaultPermissions(Collection<PrincipalPermissions> createTableDefaultPermissions);

        /**
         * <p>
         * A structure representing a list of up to three principal permissions entries for default create table
         * permissions.
         * </p>
         * 
         * @param createTableDefaultPermissions
         *        A structure representing a list of up to three principal permissions entries for default create table
         *        permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTableDefaultPermissions(PrincipalPermissions... createTableDefaultPermissions);

        /**
         * <p>
         * A structure representing a list of up to three principal permissions entries for default create table
         * permissions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PrincipalPermissions>.Builder} avoiding the
         * need to create one manually via {@link List<PrincipalPermissions>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PrincipalPermissions>.Builder#build()} is called immediately
         * and its result is passed to {@link #createTableDefaultPermissions(List<PrincipalPermissions>)}.
         * 
         * @param createTableDefaultPermissions
         *        a consumer that will call methods on {@link List<PrincipalPermissions>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createTableDefaultPermissions(List<PrincipalPermissions>)
         */
        Builder createTableDefaultPermissions(Consumer<PrincipalPermissions.Builder>... createTableDefaultPermissions);

        /**
         * <p>
         * A list of the resource-owning account IDs that the caller's account can use to share their user access
         * details (user ARNs). The user ARNs can be logged in the resource owner's AWS CloudTrail log.
         * </p>
         * <p>
         * You may want to specify this property when you are in a high-trust boundary, such as the same team or
         * company.
         * </p>
         * 
         * @param trustedResourceOwners
         *        A list of the resource-owning account IDs that the caller's account can use to share their user access
         *        details (user ARNs). The user ARNs can be logged in the resource owner's AWS CloudTrail log.</p>
         *        <p>
         *        You may want to specify this property when you are in a high-trust boundary, such as the same team or
         *        company.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustedResourceOwners(Collection<String> trustedResourceOwners);

        /**
         * <p>
         * A list of the resource-owning account IDs that the caller's account can use to share their user access
         * details (user ARNs). The user ARNs can be logged in the resource owner's AWS CloudTrail log.
         * </p>
         * <p>
         * You may want to specify this property when you are in a high-trust boundary, such as the same team or
         * company.
         * </p>
         * 
         * @param trustedResourceOwners
         *        A list of the resource-owning account IDs that the caller's account can use to share their user access
         *        details (user ARNs). The user ARNs can be logged in the resource owner's AWS CloudTrail log.</p>
         *        <p>
         *        You may want to specify this property when you are in a high-trust boundary, such as the same team or
         *        company.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustedResourceOwners(String... trustedResourceOwners);
    }

    static final class BuilderImpl implements Builder {
        private List<DataLakePrincipal> dataLakeAdmins = DefaultSdkAutoConstructList.getInstance();

        private List<PrincipalPermissions> createDatabaseDefaultPermissions = DefaultSdkAutoConstructList.getInstance();

        private List<PrincipalPermissions> createTableDefaultPermissions = DefaultSdkAutoConstructList.getInstance();

        private List<String> trustedResourceOwners = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DataLakeSettings model) {
            dataLakeAdmins(model.dataLakeAdmins);
            createDatabaseDefaultPermissions(model.createDatabaseDefaultPermissions);
            createTableDefaultPermissions(model.createTableDefaultPermissions);
            trustedResourceOwners(model.trustedResourceOwners);
        }

        public final List<DataLakePrincipal.Builder> getDataLakeAdmins() {
            List<DataLakePrincipal.Builder> result = DataLakePrincipalListCopier.copyToBuilder(this.dataLakeAdmins);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataLakeAdmins(Collection<DataLakePrincipal.BuilderImpl> dataLakeAdmins) {
            this.dataLakeAdmins = DataLakePrincipalListCopier.copyFromBuilder(dataLakeAdmins);
        }

        @Override
        @Transient
        public final Builder dataLakeAdmins(Collection<DataLakePrincipal> dataLakeAdmins) {
            this.dataLakeAdmins = DataLakePrincipalListCopier.copy(dataLakeAdmins);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dataLakeAdmins(DataLakePrincipal... dataLakeAdmins) {
            dataLakeAdmins(Arrays.asList(dataLakeAdmins));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dataLakeAdmins(Consumer<DataLakePrincipal.Builder>... dataLakeAdmins) {
            dataLakeAdmins(Stream.of(dataLakeAdmins).map(c -> DataLakePrincipal.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<PrincipalPermissions.Builder> getCreateDatabaseDefaultPermissions() {
            List<PrincipalPermissions.Builder> result = PrincipalPermissionsListCopier
                    .copyToBuilder(this.createDatabaseDefaultPermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCreateDatabaseDefaultPermissions(
                Collection<PrincipalPermissions.BuilderImpl> createDatabaseDefaultPermissions) {
            this.createDatabaseDefaultPermissions = PrincipalPermissionsListCopier
                    .copyFromBuilder(createDatabaseDefaultPermissions);
        }

        @Override
        @Transient
        public final Builder createDatabaseDefaultPermissions(Collection<PrincipalPermissions> createDatabaseDefaultPermissions) {
            this.createDatabaseDefaultPermissions = PrincipalPermissionsListCopier.copy(createDatabaseDefaultPermissions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder createDatabaseDefaultPermissions(PrincipalPermissions... createDatabaseDefaultPermissions) {
            createDatabaseDefaultPermissions(Arrays.asList(createDatabaseDefaultPermissions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder createDatabaseDefaultPermissions(
                Consumer<PrincipalPermissions.Builder>... createDatabaseDefaultPermissions) {
            createDatabaseDefaultPermissions(Stream.of(createDatabaseDefaultPermissions)
                    .map(c -> PrincipalPermissions.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<PrincipalPermissions.Builder> getCreateTableDefaultPermissions() {
            List<PrincipalPermissions.Builder> result = PrincipalPermissionsListCopier
                    .copyToBuilder(this.createTableDefaultPermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCreateTableDefaultPermissions(
                Collection<PrincipalPermissions.BuilderImpl> createTableDefaultPermissions) {
            this.createTableDefaultPermissions = PrincipalPermissionsListCopier.copyFromBuilder(createTableDefaultPermissions);
        }

        @Override
        @Transient
        public final Builder createTableDefaultPermissions(Collection<PrincipalPermissions> createTableDefaultPermissions) {
            this.createTableDefaultPermissions = PrincipalPermissionsListCopier.copy(createTableDefaultPermissions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder createTableDefaultPermissions(PrincipalPermissions... createTableDefaultPermissions) {
            createTableDefaultPermissions(Arrays.asList(createTableDefaultPermissions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder createTableDefaultPermissions(
                Consumer<PrincipalPermissions.Builder>... createTableDefaultPermissions) {
            createTableDefaultPermissions(Stream.of(createTableDefaultPermissions)
                    .map(c -> PrincipalPermissions.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getTrustedResourceOwners() {
            if (trustedResourceOwners instanceof SdkAutoConstructList) {
                return null;
            }
            return trustedResourceOwners;
        }

        public final void setTrustedResourceOwners(Collection<String> trustedResourceOwners) {
            this.trustedResourceOwners = TrustedResourceOwnersCopier.copy(trustedResourceOwners);
        }

        @Override
        @Transient
        public final Builder trustedResourceOwners(Collection<String> trustedResourceOwners) {
            this.trustedResourceOwners = TrustedResourceOwnersCopier.copy(trustedResourceOwners);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder trustedResourceOwners(String... trustedResourceOwners) {
            trustedResourceOwners(Arrays.asList(trustedResourceOwners));
            return this;
        }

        @Override
        public DataLakeSettings build() {
            return new DataLakeSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
