/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResourceLfTagsResponse extends LakeFormationResponse implements
        ToCopyableBuilder<GetResourceLfTagsResponse.Builder, GetResourceLfTagsResponse> {
    private static final SdkField<List<LFTagPair>> LF_TAG_ON_DATABASE_FIELD = SdkField
            .<List<LFTagPair>> builder(MarshallingType.LIST)
            .memberName("LFTagOnDatabase")
            .getter(getter(GetResourceLfTagsResponse::lfTagOnDatabase))
            .setter(setter(Builder::lfTagOnDatabase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LFTagOnDatabase").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LFTagPair> builder(MarshallingType.SDK_POJO)
                                            .constructor(LFTagPair::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<LFTagPair>> LF_TAGS_ON_TABLE_FIELD = SdkField
            .<List<LFTagPair>> builder(MarshallingType.LIST)
            .memberName("LFTagsOnTable")
            .getter(getter(GetResourceLfTagsResponse::lfTagsOnTable))
            .setter(setter(Builder::lfTagsOnTable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LFTagsOnTable").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LFTagPair> builder(MarshallingType.SDK_POJO)
                                            .constructor(LFTagPair::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ColumnLFTag>> LF_TAGS_ON_COLUMNS_FIELD = SdkField
            .<List<ColumnLFTag>> builder(MarshallingType.LIST)
            .memberName("LFTagsOnColumns")
            .getter(getter(GetResourceLfTagsResponse::lfTagsOnColumns))
            .setter(setter(Builder::lfTagsOnColumns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LFTagsOnColumns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ColumnLFTag> builder(MarshallingType.SDK_POJO)
                                            .constructor(ColumnLFTag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LF_TAG_ON_DATABASE_FIELD,
            LF_TAGS_ON_TABLE_FIELD, LF_TAGS_ON_COLUMNS_FIELD));

    private final List<LFTagPair> lfTagOnDatabase;

    private final List<LFTagPair> lfTagsOnTable;

    private final List<ColumnLFTag> lfTagsOnColumns;

    private GetResourceLfTagsResponse(BuilderImpl builder) {
        super(builder);
        this.lfTagOnDatabase = builder.lfTagOnDatabase;
        this.lfTagsOnTable = builder.lfTagsOnTable;
        this.lfTagsOnColumns = builder.lfTagsOnColumns;
    }

    /**
     * For responses, this returns true if the service returned a value for the LFTagOnDatabase property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLfTagOnDatabase() {
        return lfTagOnDatabase != null && !(lfTagOnDatabase instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags applied to a database resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLfTagOnDatabase} method.
     * </p>
     * 
     * @return A list of tags applied to a database resource.
     */
    public final List<LFTagPair> lfTagOnDatabase() {
        return lfTagOnDatabase;
    }

    /**
     * For responses, this returns true if the service returned a value for the LFTagsOnTable property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLfTagsOnTable() {
        return lfTagsOnTable != null && !(lfTagsOnTable instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags applied to a table resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLfTagsOnTable} method.
     * </p>
     * 
     * @return A list of tags applied to a table resource.
     */
    public final List<LFTagPair> lfTagsOnTable() {
        return lfTagsOnTable;
    }

    /**
     * For responses, this returns true if the service returned a value for the LFTagsOnColumns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLfTagsOnColumns() {
        return lfTagsOnColumns != null && !(lfTagsOnColumns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags applied to a column resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLfTagsOnColumns} method.
     * </p>
     * 
     * @return A list of tags applied to a column resource.
     */
    public final List<ColumnLFTag> lfTagsOnColumns() {
        return lfTagsOnColumns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLfTagOnDatabase() ? lfTagOnDatabase() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLfTagsOnTable() ? lfTagsOnTable() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLfTagsOnColumns() ? lfTagsOnColumns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceLfTagsResponse)) {
            return false;
        }
        GetResourceLfTagsResponse other = (GetResourceLfTagsResponse) obj;
        return hasLfTagOnDatabase() == other.hasLfTagOnDatabase() && Objects.equals(lfTagOnDatabase(), other.lfTagOnDatabase())
                && hasLfTagsOnTable() == other.hasLfTagsOnTable() && Objects.equals(lfTagsOnTable(), other.lfTagsOnTable())
                && hasLfTagsOnColumns() == other.hasLfTagsOnColumns()
                && Objects.equals(lfTagsOnColumns(), other.lfTagsOnColumns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetResourceLfTagsResponse")
                .add("LFTagOnDatabase", hasLfTagOnDatabase() ? lfTagOnDatabase() : null)
                .add("LFTagsOnTable", hasLfTagsOnTable() ? lfTagsOnTable() : null)
                .add("LFTagsOnColumns", hasLfTagsOnColumns() ? lfTagsOnColumns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LFTagOnDatabase":
            return Optional.ofNullable(clazz.cast(lfTagOnDatabase()));
        case "LFTagsOnTable":
            return Optional.ofNullable(clazz.cast(lfTagsOnTable()));
        case "LFTagsOnColumns":
            return Optional.ofNullable(clazz.cast(lfTagsOnColumns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResourceLfTagsResponse, T> g) {
        return obj -> g.apply((GetResourceLfTagsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LakeFormationResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetResourceLfTagsResponse> {
        /**
         * <p>
         * A list of tags applied to a database resource.
         * </p>
         * 
         * @param lfTagOnDatabase
         *        A list of tags applied to a database resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lfTagOnDatabase(Collection<LFTagPair> lfTagOnDatabase);

        /**
         * <p>
         * A list of tags applied to a database resource.
         * </p>
         * 
         * @param lfTagOnDatabase
         *        A list of tags applied to a database resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lfTagOnDatabase(LFTagPair... lfTagOnDatabase);

        /**
         * <p>
         * A list of tags applied to a database resource.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LFTagPair>.Builder} avoiding the need to
         * create one manually via {@link List<LFTagPair>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LFTagPair>.Builder#build()} is called immediately and its
         * result is passed to {@link #lfTagOnDatabase(List<LFTagPair>)}.
         * 
         * @param lfTagOnDatabase
         *        a consumer that will call methods on {@link List<LFTagPair>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lfTagOnDatabase(List<LFTagPair>)
         */
        Builder lfTagOnDatabase(Consumer<LFTagPair.Builder>... lfTagOnDatabase);

        /**
         * <p>
         * A list of tags applied to a table resource.
         * </p>
         * 
         * @param lfTagsOnTable
         *        A list of tags applied to a table resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lfTagsOnTable(Collection<LFTagPair> lfTagsOnTable);

        /**
         * <p>
         * A list of tags applied to a table resource.
         * </p>
         * 
         * @param lfTagsOnTable
         *        A list of tags applied to a table resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lfTagsOnTable(LFTagPair... lfTagsOnTable);

        /**
         * <p>
         * A list of tags applied to a table resource.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LFTagPair>.Builder} avoiding the need to
         * create one manually via {@link List<LFTagPair>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LFTagPair>.Builder#build()} is called immediately and its
         * result is passed to {@link #lfTagsOnTable(List<LFTagPair>)}.
         * 
         * @param lfTagsOnTable
         *        a consumer that will call methods on {@link List<LFTagPair>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lfTagsOnTable(List<LFTagPair>)
         */
        Builder lfTagsOnTable(Consumer<LFTagPair.Builder>... lfTagsOnTable);

        /**
         * <p>
         * A list of tags applied to a column resource.
         * </p>
         * 
         * @param lfTagsOnColumns
         *        A list of tags applied to a column resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lfTagsOnColumns(Collection<ColumnLFTag> lfTagsOnColumns);

        /**
         * <p>
         * A list of tags applied to a column resource.
         * </p>
         * 
         * @param lfTagsOnColumns
         *        A list of tags applied to a column resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lfTagsOnColumns(ColumnLFTag... lfTagsOnColumns);

        /**
         * <p>
         * A list of tags applied to a column resource.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ColumnLFTag>.Builder} avoiding the need to
         * create one manually via {@link List<ColumnLFTag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ColumnLFTag>.Builder#build()} is called immediately and its
         * result is passed to {@link #lfTagsOnColumns(List<ColumnLFTag>)}.
         * 
         * @param lfTagsOnColumns
         *        a consumer that will call methods on {@link List<ColumnLFTag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lfTagsOnColumns(List<ColumnLFTag>)
         */
        Builder lfTagsOnColumns(Consumer<ColumnLFTag.Builder>... lfTagsOnColumns);
    }

    static final class BuilderImpl extends LakeFormationResponse.BuilderImpl implements Builder {
        private List<LFTagPair> lfTagOnDatabase = DefaultSdkAutoConstructList.getInstance();

        private List<LFTagPair> lfTagsOnTable = DefaultSdkAutoConstructList.getInstance();

        private List<ColumnLFTag> lfTagsOnColumns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceLfTagsResponse model) {
            super(model);
            lfTagOnDatabase(model.lfTagOnDatabase);
            lfTagsOnTable(model.lfTagsOnTable);
            lfTagsOnColumns(model.lfTagsOnColumns);
        }

        public final List<LFTagPair.Builder> getLfTagOnDatabase() {
            List<LFTagPair.Builder> result = LFTagsListCopier.copyToBuilder(this.lfTagOnDatabase);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLfTagOnDatabase(Collection<LFTagPair.BuilderImpl> lfTagOnDatabase) {
            this.lfTagOnDatabase = LFTagsListCopier.copyFromBuilder(lfTagOnDatabase);
        }

        @Override
        @Transient
        public final Builder lfTagOnDatabase(Collection<LFTagPair> lfTagOnDatabase) {
            this.lfTagOnDatabase = LFTagsListCopier.copy(lfTagOnDatabase);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder lfTagOnDatabase(LFTagPair... lfTagOnDatabase) {
            lfTagOnDatabase(Arrays.asList(lfTagOnDatabase));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder lfTagOnDatabase(Consumer<LFTagPair.Builder>... lfTagOnDatabase) {
            lfTagOnDatabase(Stream.of(lfTagOnDatabase).map(c -> LFTagPair.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<LFTagPair.Builder> getLfTagsOnTable() {
            List<LFTagPair.Builder> result = LFTagsListCopier.copyToBuilder(this.lfTagsOnTable);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLfTagsOnTable(Collection<LFTagPair.BuilderImpl> lfTagsOnTable) {
            this.lfTagsOnTable = LFTagsListCopier.copyFromBuilder(lfTagsOnTable);
        }

        @Override
        @Transient
        public final Builder lfTagsOnTable(Collection<LFTagPair> lfTagsOnTable) {
            this.lfTagsOnTable = LFTagsListCopier.copy(lfTagsOnTable);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder lfTagsOnTable(LFTagPair... lfTagsOnTable) {
            lfTagsOnTable(Arrays.asList(lfTagsOnTable));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder lfTagsOnTable(Consumer<LFTagPair.Builder>... lfTagsOnTable) {
            lfTagsOnTable(Stream.of(lfTagsOnTable).map(c -> LFTagPair.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ColumnLFTag.Builder> getLfTagsOnColumns() {
            List<ColumnLFTag.Builder> result = ColumnLFTagsListCopier.copyToBuilder(this.lfTagsOnColumns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLfTagsOnColumns(Collection<ColumnLFTag.BuilderImpl> lfTagsOnColumns) {
            this.lfTagsOnColumns = ColumnLFTagsListCopier.copyFromBuilder(lfTagsOnColumns);
        }

        @Override
        @Transient
        public final Builder lfTagsOnColumns(Collection<ColumnLFTag> lfTagsOnColumns) {
            this.lfTagsOnColumns = ColumnLFTagsListCopier.copy(lfTagsOnColumns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder lfTagsOnColumns(ColumnLFTag... lfTagsOnColumns) {
            lfTagsOnColumns(Arrays.asList(lfTagsOnColumns));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder lfTagsOnColumns(Consumer<ColumnLFTag.Builder>... lfTagsOnColumns) {
            lfTagsOnColumns(Stream.of(lfTagsOnColumns).map(c -> ColumnLFTag.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetResourceLfTagsResponse build() {
            return new GetResourceLfTagsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
