/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure for the resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Resource implements SdkPojo, Serializable, ToCopyableBuilder<Resource.Builder, Resource> {
    private static final SdkField<CatalogResource> CATALOG_FIELD = SdkField.<CatalogResource> builder(MarshallingType.SDK_POJO)
            .memberName("Catalog").getter(getter(Resource::catalog)).setter(setter(Builder::catalog))
            .constructor(CatalogResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()).build();

    private static final SdkField<DatabaseResource> DATABASE_FIELD = SdkField
            .<DatabaseResource> builder(MarshallingType.SDK_POJO).memberName("Database").getter(getter(Resource::database))
            .setter(setter(Builder::database)).constructor(DatabaseResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()).build();

    private static final SdkField<TableResource> TABLE_FIELD = SdkField.<TableResource> builder(MarshallingType.SDK_POJO)
            .memberName("Table").getter(getter(Resource::table)).setter(setter(Builder::table))
            .constructor(TableResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Table").build()).build();

    private static final SdkField<TableWithColumnsResource> TABLE_WITH_COLUMNS_FIELD = SdkField
            .<TableWithColumnsResource> builder(MarshallingType.SDK_POJO).memberName("TableWithColumns")
            .getter(getter(Resource::tableWithColumns)).setter(setter(Builder::tableWithColumns))
            .constructor(TableWithColumnsResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableWithColumns").build()).build();

    private static final SdkField<DataLocationResource> DATA_LOCATION_FIELD = SdkField
            .<DataLocationResource> builder(MarshallingType.SDK_POJO).memberName("DataLocation")
            .getter(getter(Resource::dataLocation)).setter(setter(Builder::dataLocation))
            .constructor(DataLocationResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataLocation").build()).build();

    private static final SdkField<LFTagKeyResource> LF_TAG_FIELD = SdkField.<LFTagKeyResource> builder(MarshallingType.SDK_POJO)
            .memberName("LFTag").getter(getter(Resource::lfTag)).setter(setter(Builder::lfTag))
            .constructor(LFTagKeyResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LFTag").build()).build();

    private static final SdkField<LFTagPolicyResource> LF_TAG_POLICY_FIELD = SdkField
            .<LFTagPolicyResource> builder(MarshallingType.SDK_POJO).memberName("LFTagPolicy")
            .getter(getter(Resource::lfTagPolicy)).setter(setter(Builder::lfTagPolicy)).constructor(LFTagPolicyResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LFTagPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, DATABASE_FIELD,
            TABLE_FIELD, TABLE_WITH_COLUMNS_FIELD, DATA_LOCATION_FIELD, LF_TAG_FIELD, LF_TAG_POLICY_FIELD));

    private static final long serialVersionUID = 1L;

    private final CatalogResource catalog;

    private final DatabaseResource database;

    private final TableResource table;

    private final TableWithColumnsResource tableWithColumns;

    private final DataLocationResource dataLocation;

    private final LFTagKeyResource lfTag;

    private final LFTagPolicyResource lfTagPolicy;

    private Resource(BuilderImpl builder) {
        this.catalog = builder.catalog;
        this.database = builder.database;
        this.table = builder.table;
        this.tableWithColumns = builder.tableWithColumns;
        this.dataLocation = builder.dataLocation;
        this.lfTag = builder.lfTag;
        this.lfTagPolicy = builder.lfTagPolicy;
    }

    /**
     * <p>
     * The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata
     * store. It contains database definitions, table definitions, and other control information to manage your AWS Lake
     * Formation environment.
     * </p>
     * 
     * @return The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent
     *         metadata store. It contains database definitions, table definitions, and other control information to
     *         manage your AWS Lake Formation environment.
     */
    public final CatalogResource catalog() {
        return catalog;
    }

    /**
     * <p>
     * The database for the resource. Unique to the Data Catalog. A database is a set of associated table definitions
     * organized into a logical group. You can Grant and Revoke database permissions to a principal.
     * </p>
     * 
     * @return The database for the resource. Unique to the Data Catalog. A database is a set of associated table
     *         definitions organized into a logical group. You can Grant and Revoke database permissions to a principal.
     */
    public final DatabaseResource database() {
        return database;
    }

    /**
     * <p>
     * The table for the resource. A table is a metadata definition that represents your data. You can Grant and Revoke
     * table privileges to a principal.
     * </p>
     * 
     * @return The table for the resource. A table is a metadata definition that represents your data. You can Grant and
     *         Revoke table privileges to a principal.
     */
    public final TableResource table() {
        return table;
    }

    /**
     * <p>
     * The table with columns for the resource. A principal with permissions to this resource can select metadata from
     * the columns of a table in the Data Catalog and the underlying data in Amazon S3.
     * </p>
     * 
     * @return The table with columns for the resource. A principal with permissions to this resource can select
     *         metadata from the columns of a table in the Data Catalog and the underlying data in Amazon S3.
     */
    public final TableWithColumnsResource tableWithColumns() {
        return tableWithColumns;
    }

    /**
     * <p>
     * The location of an Amazon S3 path where permissions are granted or revoked.
     * </p>
     * 
     * @return The location of an Amazon S3 path where permissions are granted or revoked.
     */
    public final DataLocationResource dataLocation() {
        return dataLocation;
    }

    /**
     * <p>
     * The tag key and values attached to a resource.
     * </p>
     * 
     * @return The tag key and values attached to a resource.
     */
    public final LFTagKeyResource lfTag() {
        return lfTag;
    }

    /**
     * <p>
     * A list of tag conditions that define a resource's tag policy.
     * </p>
     * 
     * @return A list of tag conditions that define a resource's tag policy.
     */
    public final LFTagPolicyResource lfTagPolicy() {
        return lfTagPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(database());
        hashCode = 31 * hashCode + Objects.hashCode(table());
        hashCode = 31 * hashCode + Objects.hashCode(tableWithColumns());
        hashCode = 31 * hashCode + Objects.hashCode(dataLocation());
        hashCode = 31 * hashCode + Objects.hashCode(lfTag());
        hashCode = 31 * hashCode + Objects.hashCode(lfTagPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource other = (Resource) obj;
        return Objects.equals(catalog(), other.catalog()) && Objects.equals(database(), other.database())
                && Objects.equals(table(), other.table()) && Objects.equals(tableWithColumns(), other.tableWithColumns())
                && Objects.equals(dataLocation(), other.dataLocation()) && Objects.equals(lfTag(), other.lfTag())
                && Objects.equals(lfTagPolicy(), other.lfTagPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Resource").add("Catalog", catalog()).add("Database", database()).add("Table", table())
                .add("TableWithColumns", tableWithColumns()).add("DataLocation", dataLocation()).add("LFTag", lfTag())
                .add("LFTagPolicy", lfTagPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "Database":
            return Optional.ofNullable(clazz.cast(database()));
        case "Table":
            return Optional.ofNullable(clazz.cast(table()));
        case "TableWithColumns":
            return Optional.ofNullable(clazz.cast(tableWithColumns()));
        case "DataLocation":
            return Optional.ofNullable(clazz.cast(dataLocation()));
        case "LFTag":
            return Optional.ofNullable(clazz.cast(lfTag()));
        case "LFTagPolicy":
            return Optional.ofNullable(clazz.cast(lfTagPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Resource, T> g) {
        return obj -> g.apply((Resource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Resource> {
        /**
         * <p>
         * The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata
         * store. It contains database definitions, table definitions, and other control information to manage your AWS
         * Lake Formation environment.
         * </p>
         * 
         * @param catalog
         *        The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent
         *        metadata store. It contains database definitions, table definitions, and other control information to
         *        manage your AWS Lake Formation environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(CatalogResource catalog);

        /**
         * <p>
         * The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata
         * store. It contains database definitions, table definitions, and other control information to manage your AWS
         * Lake Formation environment.
         * </p>
         * This is a convenience that creates an instance of the {@link CatalogResource.Builder} avoiding the need to
         * create one manually via {@link CatalogResource#builder()}.
         *
         * When the {@link Consumer} completes, {@link CatalogResource.Builder#build()} is called immediately and its
         * result is passed to {@link #catalog(CatalogResource)}.
         * 
         * @param catalog
         *        a consumer that will call methods on {@link CatalogResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #catalog(CatalogResource)
         */
        default Builder catalog(Consumer<CatalogResource.Builder> catalog) {
            return catalog(CatalogResource.builder().applyMutation(catalog).build());
        }

        /**
         * <p>
         * The database for the resource. Unique to the Data Catalog. A database is a set of associated table
         * definitions organized into a logical group. You can Grant and Revoke database permissions to a principal.
         * </p>
         * 
         * @param database
         *        The database for the resource. Unique to the Data Catalog. A database is a set of associated table
         *        definitions organized into a logical group. You can Grant and Revoke database permissions to a
         *        principal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder database(DatabaseResource database);

        /**
         * <p>
         * The database for the resource. Unique to the Data Catalog. A database is a set of associated table
         * definitions organized into a logical group. You can Grant and Revoke database permissions to a principal.
         * </p>
         * This is a convenience that creates an instance of the {@link DatabaseResource.Builder} avoiding the need to
         * create one manually via {@link DatabaseResource#builder()}.
         *
         * When the {@link Consumer} completes, {@link DatabaseResource.Builder#build()} is called immediately and its
         * result is passed to {@link #database(DatabaseResource)}.
         * 
         * @param database
         *        a consumer that will call methods on {@link DatabaseResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #database(DatabaseResource)
         */
        default Builder database(Consumer<DatabaseResource.Builder> database) {
            return database(DatabaseResource.builder().applyMutation(database).build());
        }

        /**
         * <p>
         * The table for the resource. A table is a metadata definition that represents your data. You can Grant and
         * Revoke table privileges to a principal.
         * </p>
         * 
         * @param table
         *        The table for the resource. A table is a metadata definition that represents your data. You can Grant
         *        and Revoke table privileges to a principal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder table(TableResource table);

        /**
         * <p>
         * The table for the resource. A table is a metadata definition that represents your data. You can Grant and
         * Revoke table privileges to a principal.
         * </p>
         * This is a convenience that creates an instance of the {@link TableResource.Builder} avoiding the need to
         * create one manually via {@link TableResource#builder()}.
         *
         * When the {@link Consumer} completes, {@link TableResource.Builder#build()} is called immediately and its
         * result is passed to {@link #table(TableResource)}.
         * 
         * @param table
         *        a consumer that will call methods on {@link TableResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #table(TableResource)
         */
        default Builder table(Consumer<TableResource.Builder> table) {
            return table(TableResource.builder().applyMutation(table).build());
        }

        /**
         * <p>
         * The table with columns for the resource. A principal with permissions to this resource can select metadata
         * from the columns of a table in the Data Catalog and the underlying data in Amazon S3.
         * </p>
         * 
         * @param tableWithColumns
         *        The table with columns for the resource. A principal with permissions to this resource can select
         *        metadata from the columns of a table in the Data Catalog and the underlying data in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableWithColumns(TableWithColumnsResource tableWithColumns);

        /**
         * <p>
         * The table with columns for the resource. A principal with permissions to this resource can select metadata
         * from the columns of a table in the Data Catalog and the underlying data in Amazon S3.
         * </p>
         * This is a convenience that creates an instance of the {@link TableWithColumnsResource.Builder} avoiding the
         * need to create one manually via {@link TableWithColumnsResource#builder()}.
         *
         * When the {@link Consumer} completes, {@link TableWithColumnsResource.Builder#build()} is called immediately
         * and its result is passed to {@link #tableWithColumns(TableWithColumnsResource)}.
         * 
         * @param tableWithColumns
         *        a consumer that will call methods on {@link TableWithColumnsResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tableWithColumns(TableWithColumnsResource)
         */
        default Builder tableWithColumns(Consumer<TableWithColumnsResource.Builder> tableWithColumns) {
            return tableWithColumns(TableWithColumnsResource.builder().applyMutation(tableWithColumns).build());
        }

        /**
         * <p>
         * The location of an Amazon S3 path where permissions are granted or revoked.
         * </p>
         * 
         * @param dataLocation
         *        The location of an Amazon S3 path where permissions are granted or revoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataLocation(DataLocationResource dataLocation);

        /**
         * <p>
         * The location of an Amazon S3 path where permissions are granted or revoked.
         * </p>
         * This is a convenience that creates an instance of the {@link DataLocationResource.Builder} avoiding the need
         * to create one manually via {@link DataLocationResource#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataLocationResource.Builder#build()} is called immediately and
         * its result is passed to {@link #dataLocation(DataLocationResource)}.
         * 
         * @param dataLocation
         *        a consumer that will call methods on {@link DataLocationResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataLocation(DataLocationResource)
         */
        default Builder dataLocation(Consumer<DataLocationResource.Builder> dataLocation) {
            return dataLocation(DataLocationResource.builder().applyMutation(dataLocation).build());
        }

        /**
         * <p>
         * The tag key and values attached to a resource.
         * </p>
         * 
         * @param lfTag
         *        The tag key and values attached to a resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lfTag(LFTagKeyResource lfTag);

        /**
         * <p>
         * The tag key and values attached to a resource.
         * </p>
         * This is a convenience that creates an instance of the {@link LFTagKeyResource.Builder} avoiding the need to
         * create one manually via {@link LFTagKeyResource#builder()}.
         *
         * When the {@link Consumer} completes, {@link LFTagKeyResource.Builder#build()} is called immediately and its
         * result is passed to {@link #lfTag(LFTagKeyResource)}.
         * 
         * @param lfTag
         *        a consumer that will call methods on {@link LFTagKeyResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lfTag(LFTagKeyResource)
         */
        default Builder lfTag(Consumer<LFTagKeyResource.Builder> lfTag) {
            return lfTag(LFTagKeyResource.builder().applyMutation(lfTag).build());
        }

        /**
         * <p>
         * A list of tag conditions that define a resource's tag policy.
         * </p>
         * 
         * @param lfTagPolicy
         *        A list of tag conditions that define a resource's tag policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lfTagPolicy(LFTagPolicyResource lfTagPolicy);

        /**
         * <p>
         * A list of tag conditions that define a resource's tag policy.
         * </p>
         * This is a convenience that creates an instance of the {@link LFTagPolicyResource.Builder} avoiding the need
         * to create one manually via {@link LFTagPolicyResource#builder()}.
         *
         * When the {@link Consumer} completes, {@link LFTagPolicyResource.Builder#build()} is called immediately and
         * its result is passed to {@link #lfTagPolicy(LFTagPolicyResource)}.
         * 
         * @param lfTagPolicy
         *        a consumer that will call methods on {@link LFTagPolicyResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lfTagPolicy(LFTagPolicyResource)
         */
        default Builder lfTagPolicy(Consumer<LFTagPolicyResource.Builder> lfTagPolicy) {
            return lfTagPolicy(LFTagPolicyResource.builder().applyMutation(lfTagPolicy).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CatalogResource catalog;

        private DatabaseResource database;

        private TableResource table;

        private TableWithColumnsResource tableWithColumns;

        private DataLocationResource dataLocation;

        private LFTagKeyResource lfTag;

        private LFTagPolicyResource lfTagPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(Resource model) {
            catalog(model.catalog);
            database(model.database);
            table(model.table);
            tableWithColumns(model.tableWithColumns);
            dataLocation(model.dataLocation);
            lfTag(model.lfTag);
            lfTagPolicy(model.lfTagPolicy);
        }

        public final CatalogResource.Builder getCatalog() {
            return catalog != null ? catalog.toBuilder() : null;
        }

        public final void setCatalog(CatalogResource.BuilderImpl catalog) {
            this.catalog = catalog != null ? catalog.build() : null;
        }

        @Override
        @Transient
        public final Builder catalog(CatalogResource catalog) {
            this.catalog = catalog;
            return this;
        }

        public final DatabaseResource.Builder getDatabase() {
            return database != null ? database.toBuilder() : null;
        }

        public final void setDatabase(DatabaseResource.BuilderImpl database) {
            this.database = database != null ? database.build() : null;
        }

        @Override
        @Transient
        public final Builder database(DatabaseResource database) {
            this.database = database;
            return this;
        }

        public final TableResource.Builder getTable() {
            return table != null ? table.toBuilder() : null;
        }

        public final void setTable(TableResource.BuilderImpl table) {
            this.table = table != null ? table.build() : null;
        }

        @Override
        @Transient
        public final Builder table(TableResource table) {
            this.table = table;
            return this;
        }

        public final TableWithColumnsResource.Builder getTableWithColumns() {
            return tableWithColumns != null ? tableWithColumns.toBuilder() : null;
        }

        public final void setTableWithColumns(TableWithColumnsResource.BuilderImpl tableWithColumns) {
            this.tableWithColumns = tableWithColumns != null ? tableWithColumns.build() : null;
        }

        @Override
        @Transient
        public final Builder tableWithColumns(TableWithColumnsResource tableWithColumns) {
            this.tableWithColumns = tableWithColumns;
            return this;
        }

        public final DataLocationResource.Builder getDataLocation() {
            return dataLocation != null ? dataLocation.toBuilder() : null;
        }

        public final void setDataLocation(DataLocationResource.BuilderImpl dataLocation) {
            this.dataLocation = dataLocation != null ? dataLocation.build() : null;
        }

        @Override
        @Transient
        public final Builder dataLocation(DataLocationResource dataLocation) {
            this.dataLocation = dataLocation;
            return this;
        }

        public final LFTagKeyResource.Builder getLfTag() {
            return lfTag != null ? lfTag.toBuilder() : null;
        }

        public final void setLfTag(LFTagKeyResource.BuilderImpl lfTag) {
            this.lfTag = lfTag != null ? lfTag.build() : null;
        }

        @Override
        @Transient
        public final Builder lfTag(LFTagKeyResource lfTag) {
            this.lfTag = lfTag;
            return this;
        }

        public final LFTagPolicyResource.Builder getLfTagPolicy() {
            return lfTagPolicy != null ? lfTagPolicy.toBuilder() : null;
        }

        public final void setLfTagPolicy(LFTagPolicyResource.BuilderImpl lfTagPolicy) {
            this.lfTagPolicy = lfTagPolicy != null ? lfTagPolicy.build() : null;
        }

        @Override
        @Transient
        public final Builder lfTagPolicy(LFTagPolicyResource lfTagPolicy) {
            this.lfTagPolicy = lfTagPolicy;
            return this;
        }

        @Override
        public Resource build() {
            return new Resource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
