/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lakeformation.model.LakeFormationResponse;
import software.amazon.awssdk.services.lakeformation.model.TransactionDescription;
import software.amazon.awssdk.services.lakeformation.model.TransactionDescriptionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTransactionsResponse
extends LakeFormationResponse
implements ToCopyableBuilder<Builder, ListTransactionsResponse> {
    private static final SdkField<List<TransactionDescription>> TRANSACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Transactions").getter(ListTransactionsResponse.getter(ListTransactionsResponse::transactions)).setter(ListTransactionsResponse.setter(Builder::transactions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Transactions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TransactionDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListTransactionsResponse.getter(ListTransactionsResponse::nextToken)).setter(ListTransactionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSACTIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<TransactionDescription> transactions;
    private final String nextToken;

    private ListTransactionsResponse(BuilderImpl builder) {
        super(builder);
        this.transactions = builder.transactions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTransactions() {
        return this.transactions != null && !(this.transactions instanceof SdkAutoConstructList);
    }

    public final List<TransactionDescription> transactions() {
        return this.transactions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTransactions() ? this.transactions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTransactionsResponse)) {
            return false;
        }
        ListTransactionsResponse other = (ListTransactionsResponse)((Object)obj);
        return this.hasTransactions() == other.hasTransactions() && Objects.equals(this.transactions(), other.transactions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTransactionsResponse").add("Transactions", this.hasTransactions() ? this.transactions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Transactions": {
                return Optional.ofNullable(clazz.cast(this.transactions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTransactionsResponse, T> g) {
        return obj -> g.apply((ListTransactionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LakeFormationResponse.BuilderImpl
    implements Builder {
        private List<TransactionDescription> transactions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTransactionsResponse model) {
            super(model);
            this.transactions(model.transactions);
            this.nextToken(model.nextToken);
        }

        public final List<TransactionDescription.Builder> getTransactions() {
            List<TransactionDescription.Builder> result = TransactionDescriptionListCopier.copyToBuilder(this.transactions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTransactions(Collection<TransactionDescription.BuilderImpl> transactions) {
            this.transactions = TransactionDescriptionListCopier.copyFromBuilder(transactions);
        }

        @Override
        public final Builder transactions(Collection<TransactionDescription> transactions) {
            this.transactions = TransactionDescriptionListCopier.copy(transactions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transactions(TransactionDescription ... transactions) {
            this.transactions(Arrays.asList(transactions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transactions(Consumer<TransactionDescription.Builder> ... transactions) {
            this.transactions(Stream.of(transactions).map(c -> (TransactionDescription)((TransactionDescription.Builder)TransactionDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTransactionsResponse build() {
            return new ListTransactionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LakeFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTransactionsResponse> {
        public Builder transactions(Collection<TransactionDescription> var1);

        public Builder transactions(TransactionDescription ... var1);

        public Builder transactions(Consumer<TransactionDescription.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

