/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure representing a list of Lake Formation principals designated as data lake administrators and lists of
 * principal permission entries for default create database and default create table permissions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataLakeSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<DataLakeSettings.Builder, DataLakeSettings> {
    private static final SdkField<List<DataLakePrincipal>> DATA_LAKE_ADMINS_FIELD = SdkField
            .<List<DataLakePrincipal>> builder(MarshallingType.LIST)
            .memberName("DataLakeAdmins")
            .getter(getter(DataLakeSettings::dataLakeAdmins))
            .setter(setter(Builder::dataLakeAdmins))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataLakeAdmins").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataLakePrincipal> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataLakePrincipal::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<PrincipalPermissions>> CREATE_DATABASE_DEFAULT_PERMISSIONS_FIELD = SdkField
            .<List<PrincipalPermissions>> builder(MarshallingType.LIST)
            .memberName("CreateDatabaseDefaultPermissions")
            .getter(getter(DataLakeSettings::createDatabaseDefaultPermissions))
            .setter(setter(Builder::createDatabaseDefaultPermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDatabaseDefaultPermissions")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PrincipalPermissions> builder(MarshallingType.SDK_POJO)
                                            .constructor(PrincipalPermissions::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<PrincipalPermissions>> CREATE_TABLE_DEFAULT_PERMISSIONS_FIELD = SdkField
            .<List<PrincipalPermissions>> builder(MarshallingType.LIST)
            .memberName("CreateTableDefaultPermissions")
            .getter(getter(DataLakeSettings::createTableDefaultPermissions))
            .setter(setter(Builder::createTableDefaultPermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTableDefaultPermissions")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PrincipalPermissions> builder(MarshallingType.SDK_POJO)
                                            .constructor(PrincipalPermissions::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Parameters")
            .getter(getter(DataLakeSettings::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> TRUSTED_RESOURCE_OWNERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TrustedResourceOwners")
            .getter(getter(DataLakeSettings::trustedResourceOwners))
            .setter(setter(Builder::trustedResourceOwners))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustedResourceOwners").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ALLOW_EXTERNAL_DATA_FILTERING_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllowExternalDataFiltering")
            .getter(getter(DataLakeSettings::allowExternalDataFiltering))
            .setter(setter(Builder::allowExternalDataFiltering))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowExternalDataFiltering").build())
            .build();

    private static final SdkField<List<DataLakePrincipal>> EXTERNAL_DATA_FILTERING_ALLOW_LIST_FIELD = SdkField
            .<List<DataLakePrincipal>> builder(MarshallingType.LIST)
            .memberName("ExternalDataFilteringAllowList")
            .getter(getter(DataLakeSettings::externalDataFilteringAllowList))
            .setter(setter(Builder::externalDataFilteringAllowList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalDataFilteringAllowList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataLakePrincipal> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataLakePrincipal::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> AUTHORIZED_SESSION_TAG_VALUE_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AuthorizedSessionTagValueList")
            .getter(getter(DataLakeSettings::authorizedSessionTagValueList))
            .setter(setter(Builder::authorizedSessionTagValueList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizedSessionTagValueList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_LAKE_ADMINS_FIELD,
            CREATE_DATABASE_DEFAULT_PERMISSIONS_FIELD, CREATE_TABLE_DEFAULT_PERMISSIONS_FIELD, PARAMETERS_FIELD,
            TRUSTED_RESOURCE_OWNERS_FIELD, ALLOW_EXTERNAL_DATA_FILTERING_FIELD, EXTERNAL_DATA_FILTERING_ALLOW_LIST_FIELD,
            AUTHORIZED_SESSION_TAG_VALUE_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<DataLakePrincipal> dataLakeAdmins;

    private final List<PrincipalPermissions> createDatabaseDefaultPermissions;

    private final List<PrincipalPermissions> createTableDefaultPermissions;

    private final Map<String, String> parameters;

    private final List<String> trustedResourceOwners;

    private final Boolean allowExternalDataFiltering;

    private final List<DataLakePrincipal> externalDataFilteringAllowList;

    private final List<String> authorizedSessionTagValueList;

    private DataLakeSettings(BuilderImpl builder) {
        this.dataLakeAdmins = builder.dataLakeAdmins;
        this.createDatabaseDefaultPermissions = builder.createDatabaseDefaultPermissions;
        this.createTableDefaultPermissions = builder.createTableDefaultPermissions;
        this.parameters = builder.parameters;
        this.trustedResourceOwners = builder.trustedResourceOwners;
        this.allowExternalDataFiltering = builder.allowExternalDataFiltering;
        this.externalDataFilteringAllowList = builder.externalDataFilteringAllowList;
        this.authorizedSessionTagValueList = builder.authorizedSessionTagValueList;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataLakeAdmins property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDataLakeAdmins() {
        return dataLakeAdmins != null && !(dataLakeAdmins instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Lake Formation principals. Supported principals are IAM users or IAM roles.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataLakeAdmins} method.
     * </p>
     * 
     * @return A list of Lake Formation principals. Supported principals are IAM users or IAM roles.
     */
    public final List<DataLakePrincipal> dataLakeAdmins() {
        return dataLakeAdmins;
    }

    /**
     * For responses, this returns true if the service returned a value for the CreateDatabaseDefaultPermissions
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasCreateDatabaseDefaultPermissions() {
        return createDatabaseDefaultPermissions != null && !(createDatabaseDefaultPermissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies whether access control on newly created database is managed by Lake Formation permissions or
     * exclusively by IAM permissions.
     * </p>
     * <p>
     * A null value indicates access control by Lake Formation permissions. A value that assigns ALL to
     * IAM_ALLOWED_PRINCIPALS indicates access control by IAM permissions. This is referred to as the setting
     * "Use only IAM access control," and is for backward compatibility with the Glue permission model implemented by
     * IAM permissions.
     * </p>
     * <p>
     * The only permitted values are an empty array or an array that contains a single JSON object that grants ALL to
     * IAM_ALLOWED_PRINCIPALS.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/lake-formation/latest/dg/change-settings.html">Changing the Default Security
     * Settings for Your Data Lake</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCreateDatabaseDefaultPermissions}
     * method.
     * </p>
     * 
     * @return Specifies whether access control on newly created database is managed by Lake Formation permissions or
     *         exclusively by IAM permissions.</p>
     *         <p>
     *         A null value indicates access control by Lake Formation permissions. A value that assigns ALL to
     *         IAM_ALLOWED_PRINCIPALS indicates access control by IAM permissions. This is referred to as the setting
     *         "Use only IAM access control," and is for backward compatibility with the Glue permission model
     *         implemented by IAM permissions.
     *         </p>
     *         <p>
     *         The only permitted values are an empty array or an array that contains a single JSON object that grants
     *         ALL to IAM_ALLOWED_PRINCIPALS.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/lake-formation/latest/dg/change-settings.html">Changing the Default
     *         Security Settings for Your Data Lake</a>.
     */
    public final List<PrincipalPermissions> createDatabaseDefaultPermissions() {
        return createDatabaseDefaultPermissions;
    }

    /**
     * For responses, this returns true if the service returned a value for the CreateTableDefaultPermissions property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCreateTableDefaultPermissions() {
        return createTableDefaultPermissions != null && !(createTableDefaultPermissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies whether access control on newly created table is managed by Lake Formation permissions or exclusively
     * by IAM permissions.
     * </p>
     * <p>
     * A null value indicates access control by Lake Formation permissions. A value that assigns ALL to
     * IAM_ALLOWED_PRINCIPALS indicates access control by IAM permissions. This is referred to as the setting
     * "Use only IAM access control," and is for backward compatibility with the Glue permission model implemented by
     * IAM permissions.
     * </p>
     * <p>
     * The only permitted values are an empty array or an array that contains a single JSON object that grants ALL to
     * IAM_ALLOWED_PRINCIPALS.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/lake-formation/latest/dg/change-settings.html">Changing the Default Security
     * Settings for Your Data Lake</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCreateTableDefaultPermissions} method.
     * </p>
     * 
     * @return Specifies whether access control on newly created table is managed by Lake Formation permissions or
     *         exclusively by IAM permissions.</p>
     *         <p>
     *         A null value indicates access control by Lake Formation permissions. A value that assigns ALL to
     *         IAM_ALLOWED_PRINCIPALS indicates access control by IAM permissions. This is referred to as the setting
     *         "Use only IAM access control," and is for backward compatibility with the Glue permission model
     *         implemented by IAM permissions.
     *         </p>
     *         <p>
     *         The only permitted values are an empty array or an array that contains a single JSON object that grants
     *         ALL to IAM_ALLOWED_PRINCIPALS.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/lake-formation/latest/dg/change-settings.html">Changing the Default
     *         Security Settings for Your Data Lake</a>.
     */
    public final List<PrincipalPermissions> createTableDefaultPermissions() {
        return createTableDefaultPermissions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A key-value map that provides an additional configuration on your data lake. CrossAccountVersion is the key you
     * can configure in the Parameters field. Accepted values for the CrossAccountVersion key are 1, 2, and 3.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return A key-value map that provides an additional configuration on your data lake. CrossAccountVersion is the
     *         key you can configure in the Parameters field. Accepted values for the CrossAccountVersion key are 1, 2,
     *         and 3.
     */
    public final Map<String, String> parameters() {
        return parameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the TrustedResourceOwners property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTrustedResourceOwners() {
        return trustedResourceOwners != null && !(trustedResourceOwners instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the resource-owning account IDs that the caller's account can use to share their user access details
     * (user ARNs). The user ARNs can be logged in the resource owner's CloudTrail log.
     * </p>
     * <p>
     * You may want to specify this property when you are in a high-trust boundary, such as the same team or company.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTrustedResourceOwners} method.
     * </p>
     * 
     * @return A list of the resource-owning account IDs that the caller's account can use to share their user access
     *         details (user ARNs). The user ARNs can be logged in the resource owner's CloudTrail log.</p>
     *         <p>
     *         You may want to specify this property when you are in a high-trust boundary, such as the same team or
     *         company.
     */
    public final List<String> trustedResourceOwners() {
        return trustedResourceOwners;
    }

    /**
     * <p>
     * Whether to allow Amazon EMR clusters to access data managed by Lake Formation.
     * </p>
     * <p>
     * If true, you allow Amazon EMR clusters to access data in Amazon S3 locations that are registered with Lake
     * Formation.
     * </p>
     * <p>
     * If false or null, no Amazon EMR clusters will be able to access data in Amazon S3 locations that are registered
     * with Lake Formation.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs-aws.amazon.com/lake-formation/latest/dg/getting-started-setup.html#emr-switch">(Optional)
     * Allow Data Filtering on Amazon EMR</a>.
     * </p>
     * 
     * @return Whether to allow Amazon EMR clusters to access data managed by Lake Formation. </p>
     *         <p>
     *         If true, you allow Amazon EMR clusters to access data in Amazon S3 locations that are registered with
     *         Lake Formation.
     *         </p>
     *         <p>
     *         If false or null, no Amazon EMR clusters will be able to access data in Amazon S3 locations that are
     *         registered with Lake Formation.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs-aws.amazon.com/lake-formation/latest/dg/getting-started-setup.html#emr-switch"
     *         >(Optional) Allow Data Filtering on Amazon EMR</a>.
     */
    public final Boolean allowExternalDataFiltering() {
        return allowExternalDataFiltering;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExternalDataFilteringAllowList property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasExternalDataFilteringAllowList() {
        return externalDataFilteringAllowList != null && !(externalDataFilteringAllowList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the account IDs of Amazon Web Services accounts with Amazon EMR clusters that are to perform data
     * filtering.&gt;
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExternalDataFilteringAllowList} method.
     * </p>
     * 
     * @return A list of the account IDs of Amazon Web Services accounts with Amazon EMR clusters that are to perform
     *         data filtering.&gt;
     */
    public final List<DataLakePrincipal> externalDataFilteringAllowList() {
        return externalDataFilteringAllowList;
    }

    /**
     * For responses, this returns true if the service returned a value for the AuthorizedSessionTagValueList property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAuthorizedSessionTagValueList() {
        return authorizedSessionTagValueList != null && !(authorizedSessionTagValueList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lake Formation relies on a privileged process secured by Amazon EMR or the third party integrator to tag the
     * user's role while assuming it. Lake Formation will publish the acceptable key-value pair, for example key =
     * "LakeFormationTrustedCaller" and value = "TRUE" and the third party integrator must properly tag the temporary
     * security credentials that will be used to call Lake Formation's administrative APIs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuthorizedSessionTagValueList} method.
     * </p>
     * 
     * @return Lake Formation relies on a privileged process secured by Amazon EMR or the third party integrator to tag
     *         the user's role while assuming it. Lake Formation will publish the acceptable key-value pair, for example
     *         key = "LakeFormationTrustedCaller" and value = "TRUE" and the third party integrator must properly tag
     *         the temporary security credentials that will be used to call Lake Formation's administrative APIs.
     */
    public final List<String> authorizedSessionTagValueList() {
        return authorizedSessionTagValueList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDataLakeAdmins() ? dataLakeAdmins() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasCreateDatabaseDefaultPermissions() ? createDatabaseDefaultPermissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCreateTableDefaultPermissions() ? createTableDefaultPermissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTrustedResourceOwners() ? trustedResourceOwners() : null);
        hashCode = 31 * hashCode + Objects.hashCode(allowExternalDataFiltering());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasExternalDataFilteringAllowList() ? externalDataFilteringAllowList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAuthorizedSessionTagValueList() ? authorizedSessionTagValueList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataLakeSettings)) {
            return false;
        }
        DataLakeSettings other = (DataLakeSettings) obj;
        return hasDataLakeAdmins() == other.hasDataLakeAdmins() && Objects.equals(dataLakeAdmins(), other.dataLakeAdmins())
                && hasCreateDatabaseDefaultPermissions() == other.hasCreateDatabaseDefaultPermissions()
                && Objects.equals(createDatabaseDefaultPermissions(), other.createDatabaseDefaultPermissions())
                && hasCreateTableDefaultPermissions() == other.hasCreateTableDefaultPermissions()
                && Objects.equals(createTableDefaultPermissions(), other.createTableDefaultPermissions())
                && hasParameters() == other.hasParameters() && Objects.equals(parameters(), other.parameters())
                && hasTrustedResourceOwners() == other.hasTrustedResourceOwners()
                && Objects.equals(trustedResourceOwners(), other.trustedResourceOwners())
                && Objects.equals(allowExternalDataFiltering(), other.allowExternalDataFiltering())
                && hasExternalDataFilteringAllowList() == other.hasExternalDataFilteringAllowList()
                && Objects.equals(externalDataFilteringAllowList(), other.externalDataFilteringAllowList())
                && hasAuthorizedSessionTagValueList() == other.hasAuthorizedSessionTagValueList()
                && Objects.equals(authorizedSessionTagValueList(), other.authorizedSessionTagValueList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DataLakeSettings")
                .add("DataLakeAdmins", hasDataLakeAdmins() ? dataLakeAdmins() : null)
                .add("CreateDatabaseDefaultPermissions",
                        hasCreateDatabaseDefaultPermissions() ? createDatabaseDefaultPermissions() : null)
                .add("CreateTableDefaultPermissions", hasCreateTableDefaultPermissions() ? createTableDefaultPermissions() : null)
                .add("Parameters", hasParameters() ? parameters() : null)
                .add("TrustedResourceOwners", hasTrustedResourceOwners() ? trustedResourceOwners() : null)
                .add("AllowExternalDataFiltering", allowExternalDataFiltering())
                .add("ExternalDataFilteringAllowList",
                        hasExternalDataFilteringAllowList() ? externalDataFilteringAllowList() : null)
                .add("AuthorizedSessionTagValueList", hasAuthorizedSessionTagValueList() ? authorizedSessionTagValueList() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataLakeAdmins":
            return Optional.ofNullable(clazz.cast(dataLakeAdmins()));
        case "CreateDatabaseDefaultPermissions":
            return Optional.ofNullable(clazz.cast(createDatabaseDefaultPermissions()));
        case "CreateTableDefaultPermissions":
            return Optional.ofNullable(clazz.cast(createTableDefaultPermissions()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "TrustedResourceOwners":
            return Optional.ofNullable(clazz.cast(trustedResourceOwners()));
        case "AllowExternalDataFiltering":
            return Optional.ofNullable(clazz.cast(allowExternalDataFiltering()));
        case "ExternalDataFilteringAllowList":
            return Optional.ofNullable(clazz.cast(externalDataFilteringAllowList()));
        case "AuthorizedSessionTagValueList":
            return Optional.ofNullable(clazz.cast(authorizedSessionTagValueList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataLakeSettings, T> g) {
        return obj -> g.apply((DataLakeSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataLakeSettings> {
        /**
         * <p>
         * A list of Lake Formation principals. Supported principals are IAM users or IAM roles.
         * </p>
         * 
         * @param dataLakeAdmins
         *        A list of Lake Formation principals. Supported principals are IAM users or IAM roles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataLakeAdmins(Collection<DataLakePrincipal> dataLakeAdmins);

        /**
         * <p>
         * A list of Lake Formation principals. Supported principals are IAM users or IAM roles.
         * </p>
         * 
         * @param dataLakeAdmins
         *        A list of Lake Formation principals. Supported principals are IAM users or IAM roles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataLakeAdmins(DataLakePrincipal... dataLakeAdmins);

        /**
         * <p>
         * A list of Lake Formation principals. Supported principals are IAM users or IAM roles.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lakeformation.model.DataLakePrincipal.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.lakeformation.model.DataLakePrincipal#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lakeformation.model.DataLakePrincipal.Builder#build()} is called
         * immediately and its result is passed to {@link #dataLakeAdmins(List<DataLakePrincipal>)}.
         * 
         * @param dataLakeAdmins
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lakeformation.model.DataLakePrincipal.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataLakeAdmins(java.util.Collection<DataLakePrincipal>)
         */
        Builder dataLakeAdmins(Consumer<DataLakePrincipal.Builder>... dataLakeAdmins);

        /**
         * <p>
         * Specifies whether access control on newly created database is managed by Lake Formation permissions or
         * exclusively by IAM permissions.
         * </p>
         * <p>
         * A null value indicates access control by Lake Formation permissions. A value that assigns ALL to
         * IAM_ALLOWED_PRINCIPALS indicates access control by IAM permissions. This is referred to as the setting
         * "Use only IAM access control," and is for backward compatibility with the Glue permission model implemented
         * by IAM permissions.
         * </p>
         * <p>
         * The only permitted values are an empty array or an array that contains a single JSON object that grants ALL
         * to IAM_ALLOWED_PRINCIPALS.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/lake-formation/latest/dg/change-settings.html">Changing the Default
         * Security Settings for Your Data Lake</a>.
         * </p>
         * 
         * @param createDatabaseDefaultPermissions
         *        Specifies whether access control on newly created database is managed by Lake Formation permissions or
         *        exclusively by IAM permissions.</p>
         *        <p>
         *        A null value indicates access control by Lake Formation permissions. A value that assigns ALL to
         *        IAM_ALLOWED_PRINCIPALS indicates access control by IAM permissions. This is referred to as the setting
         *        "Use only IAM access control," and is for backward compatibility with the Glue permission model
         *        implemented by IAM permissions.
         *        </p>
         *        <p>
         *        The only permitted values are an empty array or an array that contains a single JSON object that
         *        grants ALL to IAM_ALLOWED_PRINCIPALS.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/lake-formation/latest/dg/change-settings.html">Changing the Default
         *        Security Settings for Your Data Lake</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDatabaseDefaultPermissions(Collection<PrincipalPermissions> createDatabaseDefaultPermissions);

        /**
         * <p>
         * Specifies whether access control on newly created database is managed by Lake Formation permissions or
         * exclusively by IAM permissions.
         * </p>
         * <p>
         * A null value indicates access control by Lake Formation permissions. A value that assigns ALL to
         * IAM_ALLOWED_PRINCIPALS indicates access control by IAM permissions. This is referred to as the setting
         * "Use only IAM access control," and is for backward compatibility with the Glue permission model implemented
         * by IAM permissions.
         * </p>
         * <p>
         * The only permitted values are an empty array or an array that contains a single JSON object that grants ALL
         * to IAM_ALLOWED_PRINCIPALS.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/lake-formation/latest/dg/change-settings.html">Changing the Default
         * Security Settings for Your Data Lake</a>.
         * </p>
         * 
         * @param createDatabaseDefaultPermissions
         *        Specifies whether access control on newly created database is managed by Lake Formation permissions or
         *        exclusively by IAM permissions.</p>
         *        <p>
         *        A null value indicates access control by Lake Formation permissions. A value that assigns ALL to
         *        IAM_ALLOWED_PRINCIPALS indicates access control by IAM permissions. This is referred to as the setting
         *        "Use only IAM access control," and is for backward compatibility with the Glue permission model
         *        implemented by IAM permissions.
         *        </p>
         *        <p>
         *        The only permitted values are an empty array or an array that contains a single JSON object that
         *        grants ALL to IAM_ALLOWED_PRINCIPALS.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/lake-formation/latest/dg/change-settings.html">Changing the Default
         *        Security Settings for Your Data Lake</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDatabaseDefaultPermissions(PrincipalPermissions... createDatabaseDefaultPermissions);

        /**
         * <p>
         * Specifies whether access control on newly created database is managed by Lake Formation permissions or
         * exclusively by IAM permissions.
         * </p>
         * <p>
         * A null value indicates access control by Lake Formation permissions. A value that assigns ALL to
         * IAM_ALLOWED_PRINCIPALS indicates access control by IAM permissions. This is referred to as the setting
         * "Use only IAM access control," and is for backward compatibility with the Glue permission model implemented
         * by IAM permissions.
         * </p>
         * <p>
         * The only permitted values are an empty array or an array that contains a single JSON object that grants ALL
         * to IAM_ALLOWED_PRINCIPALS.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/lake-formation/latest/dg/change-settings.html">Changing the Default
         * Security Settings for Your Data Lake</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lakeformation.model.PrincipalPermissions.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.lakeformation.model.PrincipalPermissions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lakeformation.model.PrincipalPermissions.Builder#build()} is called
         * immediately and its result is passed to {@link #createDatabaseDefaultPermissions(List<PrincipalPermissions>)}.
         * 
         * @param createDatabaseDefaultPermissions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lakeformation.model.PrincipalPermissions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createDatabaseDefaultPermissions(java.util.Collection<PrincipalPermissions>)
         */
        Builder createDatabaseDefaultPermissions(Consumer<PrincipalPermissions.Builder>... createDatabaseDefaultPermissions);

        /**
         * <p>
         * Specifies whether access control on newly created table is managed by Lake Formation permissions or
         * exclusively by IAM permissions.
         * </p>
         * <p>
         * A null value indicates access control by Lake Formation permissions. A value that assigns ALL to
         * IAM_ALLOWED_PRINCIPALS indicates access control by IAM permissions. This is referred to as the setting
         * "Use only IAM access control," and is for backward compatibility with the Glue permission model implemented
         * by IAM permissions.
         * </p>
         * <p>
         * The only permitted values are an empty array or an array that contains a single JSON object that grants ALL
         * to IAM_ALLOWED_PRINCIPALS.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/lake-formation/latest/dg/change-settings.html">Changing the Default
         * Security Settings for Your Data Lake</a>.
         * </p>
         * 
         * @param createTableDefaultPermissions
         *        Specifies whether access control on newly created table is managed by Lake Formation permissions or
         *        exclusively by IAM permissions.</p>
         *        <p>
         *        A null value indicates access control by Lake Formation permissions. A value that assigns ALL to
         *        IAM_ALLOWED_PRINCIPALS indicates access control by IAM permissions. This is referred to as the setting
         *        "Use only IAM access control," and is for backward compatibility with the Glue permission model
         *        implemented by IAM permissions.
         *        </p>
         *        <p>
         *        The only permitted values are an empty array or an array that contains a single JSON object that
         *        grants ALL to IAM_ALLOWED_PRINCIPALS.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/lake-formation/latest/dg/change-settings.html">Changing the Default
         *        Security Settings for Your Data Lake</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTableDefaultPermissions(Collection<PrincipalPermissions> createTableDefaultPermissions);

        /**
         * <p>
         * Specifies whether access control on newly created table is managed by Lake Formation permissions or
         * exclusively by IAM permissions.
         * </p>
         * <p>
         * A null value indicates access control by Lake Formation permissions. A value that assigns ALL to
         * IAM_ALLOWED_PRINCIPALS indicates access control by IAM permissions. This is referred to as the setting
         * "Use only IAM access control," and is for backward compatibility with the Glue permission model implemented
         * by IAM permissions.
         * </p>
         * <p>
         * The only permitted values are an empty array or an array that contains a single JSON object that grants ALL
         * to IAM_ALLOWED_PRINCIPALS.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/lake-formation/latest/dg/change-settings.html">Changing the Default
         * Security Settings for Your Data Lake</a>.
         * </p>
         * 
         * @param createTableDefaultPermissions
         *        Specifies whether access control on newly created table is managed by Lake Formation permissions or
         *        exclusively by IAM permissions.</p>
         *        <p>
         *        A null value indicates access control by Lake Formation permissions. A value that assigns ALL to
         *        IAM_ALLOWED_PRINCIPALS indicates access control by IAM permissions. This is referred to as the setting
         *        "Use only IAM access control," and is for backward compatibility with the Glue permission model
         *        implemented by IAM permissions.
         *        </p>
         *        <p>
         *        The only permitted values are an empty array or an array that contains a single JSON object that
         *        grants ALL to IAM_ALLOWED_PRINCIPALS.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/lake-formation/latest/dg/change-settings.html">Changing the Default
         *        Security Settings for Your Data Lake</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTableDefaultPermissions(PrincipalPermissions... createTableDefaultPermissions);

        /**
         * <p>
         * Specifies whether access control on newly created table is managed by Lake Formation permissions or
         * exclusively by IAM permissions.
         * </p>
         * <p>
         * A null value indicates access control by Lake Formation permissions. A value that assigns ALL to
         * IAM_ALLOWED_PRINCIPALS indicates access control by IAM permissions. This is referred to as the setting
         * "Use only IAM access control," and is for backward compatibility with the Glue permission model implemented
         * by IAM permissions.
         * </p>
         * <p>
         * The only permitted values are an empty array or an array that contains a single JSON object that grants ALL
         * to IAM_ALLOWED_PRINCIPALS.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/lake-formation/latest/dg/change-settings.html">Changing the Default
         * Security Settings for Your Data Lake</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lakeformation.model.PrincipalPermissions.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.lakeformation.model.PrincipalPermissions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lakeformation.model.PrincipalPermissions.Builder#build()} is called
         * immediately and its result is passed to {@link #createTableDefaultPermissions(List<PrincipalPermissions>)}.
         * 
         * @param createTableDefaultPermissions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lakeformation.model.PrincipalPermissions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createTableDefaultPermissions(java.util.Collection<PrincipalPermissions>)
         */
        Builder createTableDefaultPermissions(Consumer<PrincipalPermissions.Builder>... createTableDefaultPermissions);

        /**
         * <p>
         * A key-value map that provides an additional configuration on your data lake. CrossAccountVersion is the key
         * you can configure in the Parameters field. Accepted values for the CrossAccountVersion key are 1, 2, and 3.
         * </p>
         * 
         * @param parameters
         *        A key-value map that provides an additional configuration on your data lake. CrossAccountVersion is
         *        the key you can configure in the Parameters field. Accepted values for the CrossAccountVersion key are
         *        1, 2, and 3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, String> parameters);

        /**
         * <p>
         * A list of the resource-owning account IDs that the caller's account can use to share their user access
         * details (user ARNs). The user ARNs can be logged in the resource owner's CloudTrail log.
         * </p>
         * <p>
         * You may want to specify this property when you are in a high-trust boundary, such as the same team or
         * company.
         * </p>
         * 
         * @param trustedResourceOwners
         *        A list of the resource-owning account IDs that the caller's account can use to share their user access
         *        details (user ARNs). The user ARNs can be logged in the resource owner's CloudTrail log.</p>
         *        <p>
         *        You may want to specify this property when you are in a high-trust boundary, such as the same team or
         *        company.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustedResourceOwners(Collection<String> trustedResourceOwners);

        /**
         * <p>
         * A list of the resource-owning account IDs that the caller's account can use to share their user access
         * details (user ARNs). The user ARNs can be logged in the resource owner's CloudTrail log.
         * </p>
         * <p>
         * You may want to specify this property when you are in a high-trust boundary, such as the same team or
         * company.
         * </p>
         * 
         * @param trustedResourceOwners
         *        A list of the resource-owning account IDs that the caller's account can use to share their user access
         *        details (user ARNs). The user ARNs can be logged in the resource owner's CloudTrail log.</p>
         *        <p>
         *        You may want to specify this property when you are in a high-trust boundary, such as the same team or
         *        company.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustedResourceOwners(String... trustedResourceOwners);

        /**
         * <p>
         * Whether to allow Amazon EMR clusters to access data managed by Lake Formation.
         * </p>
         * <p>
         * If true, you allow Amazon EMR clusters to access data in Amazon S3 locations that are registered with Lake
         * Formation.
         * </p>
         * <p>
         * If false or null, no Amazon EMR clusters will be able to access data in Amazon S3 locations that are
         * registered with Lake Formation.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs-aws.amazon.com/lake-formation/latest/dg/getting-started-setup.html#emr-switch">(Optional)
         * Allow Data Filtering on Amazon EMR</a>.
         * </p>
         * 
         * @param allowExternalDataFiltering
         *        Whether to allow Amazon EMR clusters to access data managed by Lake Formation. </p>
         *        <p>
         *        If true, you allow Amazon EMR clusters to access data in Amazon S3 locations that are registered with
         *        Lake Formation.
         *        </p>
         *        <p>
         *        If false or null, no Amazon EMR clusters will be able to access data in Amazon S3 locations that are
         *        registered with Lake Formation.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs-aws.amazon.com/lake-formation/latest/dg/getting-started-setup.html#emr-switch"
         *        >(Optional) Allow Data Filtering on Amazon EMR</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowExternalDataFiltering(Boolean allowExternalDataFiltering);

        /**
         * <p>
         * A list of the account IDs of Amazon Web Services accounts with Amazon EMR clusters that are to perform data
         * filtering.&gt;
         * </p>
         * 
         * @param externalDataFilteringAllowList
         *        A list of the account IDs of Amazon Web Services accounts with Amazon EMR clusters that are to perform
         *        data filtering.&gt;
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalDataFilteringAllowList(Collection<DataLakePrincipal> externalDataFilteringAllowList);

        /**
         * <p>
         * A list of the account IDs of Amazon Web Services accounts with Amazon EMR clusters that are to perform data
         * filtering.&gt;
         * </p>
         * 
         * @param externalDataFilteringAllowList
         *        A list of the account IDs of Amazon Web Services accounts with Amazon EMR clusters that are to perform
         *        data filtering.&gt;
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalDataFilteringAllowList(DataLakePrincipal... externalDataFilteringAllowList);

        /**
         * <p>
         * A list of the account IDs of Amazon Web Services accounts with Amazon EMR clusters that are to perform data
         * filtering.&gt;
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lakeformation.model.DataLakePrincipal.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.lakeformation.model.DataLakePrincipal#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lakeformation.model.DataLakePrincipal.Builder#build()} is called
         * immediately and its result is passed to {@link #externalDataFilteringAllowList(List<DataLakePrincipal>)}.
         * 
         * @param externalDataFilteringAllowList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lakeformation.model.DataLakePrincipal.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #externalDataFilteringAllowList(java.util.Collection<DataLakePrincipal>)
         */
        Builder externalDataFilteringAllowList(Consumer<DataLakePrincipal.Builder>... externalDataFilteringAllowList);

        /**
         * <p>
         * Lake Formation relies on a privileged process secured by Amazon EMR or the third party integrator to tag the
         * user's role while assuming it. Lake Formation will publish the acceptable key-value pair, for example key =
         * "LakeFormationTrustedCaller" and value = "TRUE" and the third party integrator must properly tag the
         * temporary security credentials that will be used to call Lake Formation's administrative APIs.
         * </p>
         * 
         * @param authorizedSessionTagValueList
         *        Lake Formation relies on a privileged process secured by Amazon EMR or the third party integrator to
         *        tag the user's role while assuming it. Lake Formation will publish the acceptable key-value pair, for
         *        example key = "LakeFormationTrustedCaller" and value = "TRUE" and the third party integrator must
         *        properly tag the temporary security credentials that will be used to call Lake Formation's
         *        administrative APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizedSessionTagValueList(Collection<String> authorizedSessionTagValueList);

        /**
         * <p>
         * Lake Formation relies on a privileged process secured by Amazon EMR or the third party integrator to tag the
         * user's role while assuming it. Lake Formation will publish the acceptable key-value pair, for example key =
         * "LakeFormationTrustedCaller" and value = "TRUE" and the third party integrator must properly tag the
         * temporary security credentials that will be used to call Lake Formation's administrative APIs.
         * </p>
         * 
         * @param authorizedSessionTagValueList
         *        Lake Formation relies on a privileged process secured by Amazon EMR or the third party integrator to
         *        tag the user's role while assuming it. Lake Formation will publish the acceptable key-value pair, for
         *        example key = "LakeFormationTrustedCaller" and value = "TRUE" and the third party integrator must
         *        properly tag the temporary security credentials that will be used to call Lake Formation's
         *        administrative APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizedSessionTagValueList(String... authorizedSessionTagValueList);
    }

    static final class BuilderImpl implements Builder {
        private List<DataLakePrincipal> dataLakeAdmins = DefaultSdkAutoConstructList.getInstance();

        private List<PrincipalPermissions> createDatabaseDefaultPermissions = DefaultSdkAutoConstructList.getInstance();

        private List<PrincipalPermissions> createTableDefaultPermissions = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();

        private List<String> trustedResourceOwners = DefaultSdkAutoConstructList.getInstance();

        private Boolean allowExternalDataFiltering;

        private List<DataLakePrincipal> externalDataFilteringAllowList = DefaultSdkAutoConstructList.getInstance();

        private List<String> authorizedSessionTagValueList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DataLakeSettings model) {
            dataLakeAdmins(model.dataLakeAdmins);
            createDatabaseDefaultPermissions(model.createDatabaseDefaultPermissions);
            createTableDefaultPermissions(model.createTableDefaultPermissions);
            parameters(model.parameters);
            trustedResourceOwners(model.trustedResourceOwners);
            allowExternalDataFiltering(model.allowExternalDataFiltering);
            externalDataFilteringAllowList(model.externalDataFilteringAllowList);
            authorizedSessionTagValueList(model.authorizedSessionTagValueList);
        }

        public final List<DataLakePrincipal.Builder> getDataLakeAdmins() {
            List<DataLakePrincipal.Builder> result = DataLakePrincipalListCopier.copyToBuilder(this.dataLakeAdmins);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataLakeAdmins(Collection<DataLakePrincipal.BuilderImpl> dataLakeAdmins) {
            this.dataLakeAdmins = DataLakePrincipalListCopier.copyFromBuilder(dataLakeAdmins);
        }

        @Override
        public final Builder dataLakeAdmins(Collection<DataLakePrincipal> dataLakeAdmins) {
            this.dataLakeAdmins = DataLakePrincipalListCopier.copy(dataLakeAdmins);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataLakeAdmins(DataLakePrincipal... dataLakeAdmins) {
            dataLakeAdmins(Arrays.asList(dataLakeAdmins));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataLakeAdmins(Consumer<DataLakePrincipal.Builder>... dataLakeAdmins) {
            dataLakeAdmins(Stream.of(dataLakeAdmins).map(c -> DataLakePrincipal.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<PrincipalPermissions.Builder> getCreateDatabaseDefaultPermissions() {
            List<PrincipalPermissions.Builder> result = PrincipalPermissionsListCopier
                    .copyToBuilder(this.createDatabaseDefaultPermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCreateDatabaseDefaultPermissions(
                Collection<PrincipalPermissions.BuilderImpl> createDatabaseDefaultPermissions) {
            this.createDatabaseDefaultPermissions = PrincipalPermissionsListCopier
                    .copyFromBuilder(createDatabaseDefaultPermissions);
        }

        @Override
        public final Builder createDatabaseDefaultPermissions(Collection<PrincipalPermissions> createDatabaseDefaultPermissions) {
            this.createDatabaseDefaultPermissions = PrincipalPermissionsListCopier.copy(createDatabaseDefaultPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createDatabaseDefaultPermissions(PrincipalPermissions... createDatabaseDefaultPermissions) {
            createDatabaseDefaultPermissions(Arrays.asList(createDatabaseDefaultPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createDatabaseDefaultPermissions(
                Consumer<PrincipalPermissions.Builder>... createDatabaseDefaultPermissions) {
            createDatabaseDefaultPermissions(Stream.of(createDatabaseDefaultPermissions)
                    .map(c -> PrincipalPermissions.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<PrincipalPermissions.Builder> getCreateTableDefaultPermissions() {
            List<PrincipalPermissions.Builder> result = PrincipalPermissionsListCopier
                    .copyToBuilder(this.createTableDefaultPermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCreateTableDefaultPermissions(
                Collection<PrincipalPermissions.BuilderImpl> createTableDefaultPermissions) {
            this.createTableDefaultPermissions = PrincipalPermissionsListCopier.copyFromBuilder(createTableDefaultPermissions);
        }

        @Override
        public final Builder createTableDefaultPermissions(Collection<PrincipalPermissions> createTableDefaultPermissions) {
            this.createTableDefaultPermissions = PrincipalPermissionsListCopier.copy(createTableDefaultPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createTableDefaultPermissions(PrincipalPermissions... createTableDefaultPermissions) {
            createTableDefaultPermissions(Arrays.asList(createTableDefaultPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createTableDefaultPermissions(
                Consumer<PrincipalPermissions.Builder>... createTableDefaultPermissions) {
            createTableDefaultPermissions(Stream.of(createTableDefaultPermissions)
                    .map(c -> PrincipalPermissions.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getParameters() {
            if (parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return parameters;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
            return this;
        }

        public final Collection<String> getTrustedResourceOwners() {
            if (trustedResourceOwners instanceof SdkAutoConstructList) {
                return null;
            }
            return trustedResourceOwners;
        }

        public final void setTrustedResourceOwners(Collection<String> trustedResourceOwners) {
            this.trustedResourceOwners = TrustedResourceOwnersCopier.copy(trustedResourceOwners);
        }

        @Override
        public final Builder trustedResourceOwners(Collection<String> trustedResourceOwners) {
            this.trustedResourceOwners = TrustedResourceOwnersCopier.copy(trustedResourceOwners);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trustedResourceOwners(String... trustedResourceOwners) {
            trustedResourceOwners(Arrays.asList(trustedResourceOwners));
            return this;
        }

        public final Boolean getAllowExternalDataFiltering() {
            return allowExternalDataFiltering;
        }

        public final void setAllowExternalDataFiltering(Boolean allowExternalDataFiltering) {
            this.allowExternalDataFiltering = allowExternalDataFiltering;
        }

        @Override
        public final Builder allowExternalDataFiltering(Boolean allowExternalDataFiltering) {
            this.allowExternalDataFiltering = allowExternalDataFiltering;
            return this;
        }

        public final List<DataLakePrincipal.Builder> getExternalDataFilteringAllowList() {
            List<DataLakePrincipal.Builder> result = DataLakePrincipalListCopier
                    .copyToBuilder(this.externalDataFilteringAllowList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExternalDataFilteringAllowList(
                Collection<DataLakePrincipal.BuilderImpl> externalDataFilteringAllowList) {
            this.externalDataFilteringAllowList = DataLakePrincipalListCopier.copyFromBuilder(externalDataFilteringAllowList);
        }

        @Override
        public final Builder externalDataFilteringAllowList(Collection<DataLakePrincipal> externalDataFilteringAllowList) {
            this.externalDataFilteringAllowList = DataLakePrincipalListCopier.copy(externalDataFilteringAllowList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder externalDataFilteringAllowList(DataLakePrincipal... externalDataFilteringAllowList) {
            externalDataFilteringAllowList(Arrays.asList(externalDataFilteringAllowList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder externalDataFilteringAllowList(Consumer<DataLakePrincipal.Builder>... externalDataFilteringAllowList) {
            externalDataFilteringAllowList(Stream.of(externalDataFilteringAllowList)
                    .map(c -> DataLakePrincipal.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAuthorizedSessionTagValueList() {
            if (authorizedSessionTagValueList instanceof SdkAutoConstructList) {
                return null;
            }
            return authorizedSessionTagValueList;
        }

        public final void setAuthorizedSessionTagValueList(Collection<String> authorizedSessionTagValueList) {
            this.authorizedSessionTagValueList = AuthorizedSessionTagValueListCopier.copy(authorizedSessionTagValueList);
        }

        @Override
        public final Builder authorizedSessionTagValueList(Collection<String> authorizedSessionTagValueList) {
            this.authorizedSessionTagValueList = AuthorizedSessionTagValueListCopier.copy(authorizedSessionTagValueList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizedSessionTagValueList(String... authorizedSessionTagValueList) {
            authorizedSessionTagValueList(Arrays.asList(authorizedSessionTagValueList));
            return this;
        }

        @Override
        public DataLakeSettings build() {
            return new DataLakeSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
