/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RevokePermissionsRequest extends LakeFormationRequest implements
        ToCopyableBuilder<RevokePermissionsRequest.Builder, RevokePermissionsRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogId").getter(getter(RevokePermissionsRequest::catalogId)).setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<DataLakePrincipal> PRINCIPAL_FIELD = SdkField
            .<DataLakePrincipal> builder(MarshallingType.SDK_POJO).memberName("Principal")
            .getter(getter(RevokePermissionsRequest::principal)).setter(setter(Builder::principal))
            .constructor(DataLakePrincipal::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Principal").build()).build();

    private static final SdkField<Resource> RESOURCE_FIELD = SdkField.<Resource> builder(MarshallingType.SDK_POJO)
            .memberName("Resource").getter(getter(RevokePermissionsRequest::resource)).setter(setter(Builder::resource))
            .constructor(Resource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resource").build()).build();

    private static final SdkField<List<String>> PERMISSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Permissions")
            .getter(getter(RevokePermissionsRequest::permissionsAsStrings))
            .setter(setter(Builder::permissionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PERMISSIONS_WITH_GRANT_OPTION_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PermissionsWithGrantOption")
            .getter(getter(RevokePermissionsRequest::permissionsWithGrantOptionAsStrings))
            .setter(setter(Builder::permissionsWithGrantOptionWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionsWithGrantOption").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD,
            PRINCIPAL_FIELD, RESOURCE_FIELD, PERMISSIONS_FIELD, PERMISSIONS_WITH_GRANT_OPTION_FIELD));

    private final String catalogId;

    private final DataLakePrincipal principal;

    private final Resource resource;

    private final List<String> permissions;

    private final List<String> permissionsWithGrantOption;

    private RevokePermissionsRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.principal = builder.principal;
        this.resource = builder.resource;
        this.permissions = builder.permissions;
        this.permissionsWithGrantOption = builder.permissionsWithGrantOption;
    }

    /**
     * <p>
     * The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata
     * store. It contains database definitions, table definitions, and other control information to manage your Lake
     * Formation environment.
     * </p>
     * 
     * @return The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent
     *         metadata store. It contains database definitions, table definitions, and other control information to
     *         manage your Lake Formation environment.
     */
    public final String catalogId() {
        return catalogId;
    }

    /**
     * <p>
     * The principal to be revoked permissions on the resource.
     * </p>
     * 
     * @return The principal to be revoked permissions on the resource.
     */
    public final DataLakePrincipal principal() {
        return principal;
    }

    /**
     * <p>
     * The resource to which permissions are to be revoked.
     * </p>
     * 
     * @return The resource to which permissions are to be revoked.
     */
    public final Resource resource() {
        return resource;
    }

    /**
     * <p>
     * The permissions revoked to the principal on the resource. For information about permissions, see <a
     * href="https://docs-aws.amazon.com/lake-formation/latest/dg/security-data-access.html">Security and Access Control
     * to Metadata and Data</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPermissions} method.
     * </p>
     * 
     * @return The permissions revoked to the principal on the resource. For information about permissions, see <a
     *         href="https://docs-aws.amazon.com/lake-formation/latest/dg/security-data-access.html">Security and Access
     *         Control to Metadata and Data</a>.
     */
    public final List<Permission> permissions() {
        return PermissionListCopier.copyStringToEnum(permissions);
    }

    /**
     * For responses, this returns true if the service returned a value for the Permissions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPermissions() {
        return permissions != null && !(permissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The permissions revoked to the principal on the resource. For information about permissions, see <a
     * href="https://docs-aws.amazon.com/lake-formation/latest/dg/security-data-access.html">Security and Access Control
     * to Metadata and Data</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPermissions} method.
     * </p>
     * 
     * @return The permissions revoked to the principal on the resource. For information about permissions, see <a
     *         href="https://docs-aws.amazon.com/lake-formation/latest/dg/security-data-access.html">Security and Access
     *         Control to Metadata and Data</a>.
     */
    public final List<String> permissionsAsStrings() {
        return permissions;
    }

    /**
     * <p>
     * Indicates a list of permissions for which to revoke the grant option allowing the principal to pass permissions
     * to other principals.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPermissionsWithGrantOption} method.
     * </p>
     * 
     * @return Indicates a list of permissions for which to revoke the grant option allowing the principal to pass
     *         permissions to other principals.
     */
    public final List<Permission> permissionsWithGrantOption() {
        return PermissionListCopier.copyStringToEnum(permissionsWithGrantOption);
    }

    /**
     * For responses, this returns true if the service returned a value for the PermissionsWithGrantOption property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPermissionsWithGrantOption() {
        return permissionsWithGrantOption != null && !(permissionsWithGrantOption instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates a list of permissions for which to revoke the grant option allowing the principal to pass permissions
     * to other principals.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPermissionsWithGrantOption} method.
     * </p>
     * 
     * @return Indicates a list of permissions for which to revoke the grant option allowing the principal to pass
     *         permissions to other principals.
     */
    public final List<String> permissionsWithGrantOptionAsStrings() {
        return permissionsWithGrantOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(principal());
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        hashCode = 31 * hashCode + Objects.hashCode(hasPermissions() ? permissionsAsStrings() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasPermissionsWithGrantOption() ? permissionsWithGrantOptionAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevokePermissionsRequest)) {
            return false;
        }
        RevokePermissionsRequest other = (RevokePermissionsRequest) obj;
        return Objects.equals(catalogId(), other.catalogId()) && Objects.equals(principal(), other.principal())
                && Objects.equals(resource(), other.resource()) && hasPermissions() == other.hasPermissions()
                && Objects.equals(permissionsAsStrings(), other.permissionsAsStrings())
                && hasPermissionsWithGrantOption() == other.hasPermissionsWithGrantOption()
                && Objects.equals(permissionsWithGrantOptionAsStrings(), other.permissionsWithGrantOptionAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("RevokePermissionsRequest")
                .add("CatalogId", catalogId())
                .add("Principal", principal())
                .add("Resource", resource())
                .add("Permissions", hasPermissions() ? permissionsAsStrings() : null)
                .add("PermissionsWithGrantOption", hasPermissionsWithGrantOption() ? permissionsWithGrantOptionAsStrings() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "Principal":
            return Optional.ofNullable(clazz.cast(principal()));
        case "Resource":
            return Optional.ofNullable(clazz.cast(resource()));
        case "Permissions":
            return Optional.ofNullable(clazz.cast(permissionsAsStrings()));
        case "PermissionsWithGrantOption":
            return Optional.ofNullable(clazz.cast(permissionsWithGrantOptionAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RevokePermissionsRequest, T> g) {
        return obj -> g.apply((RevokePermissionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LakeFormationRequest.Builder, SdkPojo, CopyableBuilder<Builder, RevokePermissionsRequest> {
        /**
         * <p>
         * The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata
         * store. It contains database definitions, table definitions, and other control information to manage your Lake
         * Formation environment.
         * </p>
         * 
         * @param catalogId
         *        The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent
         *        metadata store. It contains database definitions, table definitions, and other control information to
         *        manage your Lake Formation environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * The principal to be revoked permissions on the resource.
         * </p>
         * 
         * @param principal
         *        The principal to be revoked permissions on the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principal(DataLakePrincipal principal);

        /**
         * <p>
         * The principal to be revoked permissions on the resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataLakePrincipal.Builder} avoiding the
         * need to create one manually via {@link DataLakePrincipal#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataLakePrincipal.Builder#build()} is called immediately and its
         * result is passed to {@link #principal(DataLakePrincipal)}.
         * 
         * @param principal
         *        a consumer that will call methods on {@link DataLakePrincipal.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #principal(DataLakePrincipal)
         */
        default Builder principal(Consumer<DataLakePrincipal.Builder> principal) {
            return principal(DataLakePrincipal.builder().applyMutation(principal).build());
        }

        /**
         * <p>
         * The resource to which permissions are to be revoked.
         * </p>
         * 
         * @param resource
         *        The resource to which permissions are to be revoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(Resource resource);

        /**
         * <p>
         * The resource to which permissions are to be revoked.
         * </p>
         * This is a convenience method that creates an instance of the {@link Resource.Builder} avoiding the need to
         * create one manually via {@link Resource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Resource.Builder#build()} is called immediately and its result is
         * passed to {@link #resource(Resource)}.
         * 
         * @param resource
         *        a consumer that will call methods on {@link Resource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resource(Resource)
         */
        default Builder resource(Consumer<Resource.Builder> resource) {
            return resource(Resource.builder().applyMutation(resource).build());
        }

        /**
         * <p>
         * The permissions revoked to the principal on the resource. For information about permissions, see <a
         * href="https://docs-aws.amazon.com/lake-formation/latest/dg/security-data-access.html">Security and Access
         * Control to Metadata and Data</a>.
         * </p>
         * 
         * @param permissions
         *        The permissions revoked to the principal on the resource. For information about permissions, see <a
         *        href="https://docs-aws.amazon.com/lake-formation/latest/dg/security-data-access.html">Security and
         *        Access Control to Metadata and Data</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsWithStrings(Collection<String> permissions);

        /**
         * <p>
         * The permissions revoked to the principal on the resource. For information about permissions, see <a
         * href="https://docs-aws.amazon.com/lake-formation/latest/dg/security-data-access.html">Security and Access
         * Control to Metadata and Data</a>.
         * </p>
         * 
         * @param permissions
         *        The permissions revoked to the principal on the resource. For information about permissions, see <a
         *        href="https://docs-aws.amazon.com/lake-formation/latest/dg/security-data-access.html">Security and
         *        Access Control to Metadata and Data</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsWithStrings(String... permissions);

        /**
         * <p>
         * The permissions revoked to the principal on the resource. For information about permissions, see <a
         * href="https://docs-aws.amazon.com/lake-formation/latest/dg/security-data-access.html">Security and Access
         * Control to Metadata and Data</a>.
         * </p>
         * 
         * @param permissions
         *        The permissions revoked to the principal on the resource. For information about permissions, see <a
         *        href="https://docs-aws.amazon.com/lake-formation/latest/dg/security-data-access.html">Security and
         *        Access Control to Metadata and Data</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Collection<Permission> permissions);

        /**
         * <p>
         * The permissions revoked to the principal on the resource. For information about permissions, see <a
         * href="https://docs-aws.amazon.com/lake-formation/latest/dg/security-data-access.html">Security and Access
         * Control to Metadata and Data</a>.
         * </p>
         * 
         * @param permissions
         *        The permissions revoked to the principal on the resource. For information about permissions, see <a
         *        href="https://docs-aws.amazon.com/lake-formation/latest/dg/security-data-access.html">Security and
         *        Access Control to Metadata and Data</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Permission... permissions);

        /**
         * <p>
         * Indicates a list of permissions for which to revoke the grant option allowing the principal to pass
         * permissions to other principals.
         * </p>
         * 
         * @param permissionsWithGrantOption
         *        Indicates a list of permissions for which to revoke the grant option allowing the principal to pass
         *        permissions to other principals.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsWithGrantOptionWithStrings(Collection<String> permissionsWithGrantOption);

        /**
         * <p>
         * Indicates a list of permissions for which to revoke the grant option allowing the principal to pass
         * permissions to other principals.
         * </p>
         * 
         * @param permissionsWithGrantOption
         *        Indicates a list of permissions for which to revoke the grant option allowing the principal to pass
         *        permissions to other principals.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsWithGrantOptionWithStrings(String... permissionsWithGrantOption);

        /**
         * <p>
         * Indicates a list of permissions for which to revoke the grant option allowing the principal to pass
         * permissions to other principals.
         * </p>
         * 
         * @param permissionsWithGrantOption
         *        Indicates a list of permissions for which to revoke the grant option allowing the principal to pass
         *        permissions to other principals.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsWithGrantOption(Collection<Permission> permissionsWithGrantOption);

        /**
         * <p>
         * Indicates a list of permissions for which to revoke the grant option allowing the principal to pass
         * permissions to other principals.
         * </p>
         * 
         * @param permissionsWithGrantOption
         *        Indicates a list of permissions for which to revoke the grant option allowing the principal to pass
         *        permissions to other principals.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsWithGrantOption(Permission... permissionsWithGrantOption);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LakeFormationRequest.BuilderImpl implements Builder {
        private String catalogId;

        private DataLakePrincipal principal;

        private Resource resource;

        private List<String> permissions = DefaultSdkAutoConstructList.getInstance();

        private List<String> permissionsWithGrantOption = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RevokePermissionsRequest model) {
            super(model);
            catalogId(model.catalogId);
            principal(model.principal);
            resource(model.resource);
            permissionsWithStrings(model.permissions);
            permissionsWithGrantOptionWithStrings(model.permissionsWithGrantOption);
        }

        public final String getCatalogId() {
            return catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final DataLakePrincipal.Builder getPrincipal() {
            return principal != null ? principal.toBuilder() : null;
        }

        public final void setPrincipal(DataLakePrincipal.BuilderImpl principal) {
            this.principal = principal != null ? principal.build() : null;
        }

        @Override
        public final Builder principal(DataLakePrincipal principal) {
            this.principal = principal;
            return this;
        }

        public final Resource.Builder getResource() {
            return resource != null ? resource.toBuilder() : null;
        }

        public final void setResource(Resource.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        @Override
        public final Builder resource(Resource resource) {
            this.resource = resource;
            return this;
        }

        public final Collection<String> getPermissions() {
            if (permissions instanceof SdkAutoConstructList) {
                return null;
            }
            return permissions;
        }

        public final void setPermissions(Collection<String> permissions) {
            this.permissions = PermissionListCopier.copy(permissions);
        }

        @Override
        public final Builder permissionsWithStrings(Collection<String> permissions) {
            this.permissions = PermissionListCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionsWithStrings(String... permissions) {
            permissionsWithStrings(Arrays.asList(permissions));
            return this;
        }

        @Override
        public final Builder permissions(Collection<Permission> permissions) {
            this.permissions = PermissionListCopier.copyEnumToString(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Permission... permissions) {
            permissions(Arrays.asList(permissions));
            return this;
        }

        public final Collection<String> getPermissionsWithGrantOption() {
            if (permissionsWithGrantOption instanceof SdkAutoConstructList) {
                return null;
            }
            return permissionsWithGrantOption;
        }

        public final void setPermissionsWithGrantOption(Collection<String> permissionsWithGrantOption) {
            this.permissionsWithGrantOption = PermissionListCopier.copy(permissionsWithGrantOption);
        }

        @Override
        public final Builder permissionsWithGrantOptionWithStrings(Collection<String> permissionsWithGrantOption) {
            this.permissionsWithGrantOption = PermissionListCopier.copy(permissionsWithGrantOption);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionsWithGrantOptionWithStrings(String... permissionsWithGrantOption) {
            permissionsWithGrantOptionWithStrings(Arrays.asList(permissionsWithGrantOption));
            return this;
        }

        @Override
        public final Builder permissionsWithGrantOption(Collection<Permission> permissionsWithGrantOption) {
            this.permissionsWithGrantOption = PermissionListCopier.copyEnumToString(permissionsWithGrantOption);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionsWithGrantOption(Permission... permissionsWithGrantOption) {
            permissionsWithGrantOption(Arrays.asList(permissionsWithGrantOption));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RevokePermissionsRequest build() {
            return new RevokePermissionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
