/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lakeformation.LakeFormationClient;
import software.amazon.awssdk.services.lakeformation.internal.UserAgentUtils;
import software.amazon.awssdk.services.lakeformation.model.ListResourcesRequest;
import software.amazon.awssdk.services.lakeformation.model.ListResourcesResponse;

public class ListResourcesIterable
implements SdkIterable<ListResourcesResponse> {
    private final LakeFormationClient client;
    private final ListResourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListResourcesIterable(LakeFormationClient client, ListResourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListResourcesResponseFetcher();
    }

    public Iterator<ListResourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListResourcesResponseFetcher
    implements SyncPageFetcher<ListResourcesResponse> {
        private ListResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListResourcesResponse nextPage(ListResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListResourcesIterable.this.client.listResources(ListResourcesIterable.this.firstRequest);
            }
            return ListResourcesIterable.this.client.listResources((ListResourcesRequest)((Object)ListResourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

