/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lakeformation.LakeFormationClient;
import software.amazon.awssdk.services.lakeformation.model.GetTableObjectsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetTableObjectsResponse;

public class GetTableObjectsIterable
implements SdkIterable<GetTableObjectsResponse> {
    private final LakeFormationClient client;
    private final GetTableObjectsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetTableObjectsIterable(LakeFormationClient client, GetTableObjectsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetTableObjectsResponseFetcher();
    }

    public Iterator<GetTableObjectsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetTableObjectsResponseFetcher
    implements SyncPageFetcher<GetTableObjectsResponse> {
        private GetTableObjectsResponseFetcher() {
        }

        public boolean hasNextPage(GetTableObjectsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetTableObjectsResponse nextPage(GetTableObjectsResponse previousPage) {
            if (previousPage == null) {
                return GetTableObjectsIterable.this.client.getTableObjects(GetTableObjectsIterable.this.firstRequest);
            }
            return GetTableObjectsIterable.this.client.getTableObjects((GetTableObjectsRequest)((Object)GetTableObjectsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

