/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.lakeformation.DefaultLakeFormationBaseClientBuilder;
import software.amazon.awssdk.services.lakeformation.DefaultLakeFormationClient;
import software.amazon.awssdk.services.lakeformation.LakeFormationClient;
import software.amazon.awssdk.services.lakeformation.LakeFormationClientBuilder;
import software.amazon.awssdk.services.lakeformation.LakeFormationServiceClientConfiguration;
import software.amazon.awssdk.services.lakeformation.endpoints.LakeFormationEndpointProvider;

@SdkInternalApi
final class DefaultLakeFormationClientBuilder
extends DefaultLakeFormationBaseClientBuilder<LakeFormationClientBuilder, LakeFormationClient>
implements LakeFormationClientBuilder {
    DefaultLakeFormationClientBuilder() {
    }

    @Override
    public DefaultLakeFormationClientBuilder endpointProvider(LakeFormationEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final LakeFormationClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultLakeFormationClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        LakeFormationServiceClientConfiguration serviceClientConfiguration = LakeFormationServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultLakeFormationClient(serviceClientConfiguration, clientConfiguration);
    }
}

