/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLakeFormationIdentityCenterConfigurationResponse extends LakeFormationResponse
        implements
        ToCopyableBuilder<CreateLakeFormationIdentityCenterConfigurationResponse.Builder, CreateLakeFormationIdentityCenterConfigurationResponse> {
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationArn").getter(getter(CreateLakeFormationIdentityCenterConfigurationResponse::applicationArn))
            .setter(setter(Builder::applicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARN_FIELD));

    private final String applicationArn;

    private CreateLakeFormationIdentityCenterConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.applicationArn = builder.applicationArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the integrated application.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the integrated application.
     */
    public final String applicationArn() {
        return applicationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLakeFormationIdentityCenterConfigurationResponse)) {
            return false;
        }
        CreateLakeFormationIdentityCenterConfigurationResponse other = (CreateLakeFormationIdentityCenterConfigurationResponse) obj;
        return Objects.equals(applicationArn(), other.applicationArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLakeFormationIdentityCenterConfigurationResponse").add("ApplicationArn", applicationArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationArn":
            return Optional.ofNullable(clazz.cast(applicationArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLakeFormationIdentityCenterConfigurationResponse, T> g) {
        return obj -> g.apply((CreateLakeFormationIdentityCenterConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LakeFormationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateLakeFormationIdentityCenterConfigurationResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the integrated application.
         * </p>
         * 
         * @param applicationArn
         *        The Amazon Resource Name (ARN) of the integrated application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationArn(String applicationArn);
    }

    static final class BuilderImpl extends LakeFormationResponse.BuilderImpl implements Builder {
        private String applicationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLakeFormationIdentityCenterConfigurationResponse model) {
            super(model);
            applicationArn(model.applicationArn);
        }

        public final String getApplicationArn() {
            return applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        @Override
        public CreateLakeFormationIdentityCenterConfigurationResponse build() {
            return new CreateLakeFormationIdentityCenterConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
