/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLakeFormationIdentityCenterConfigurationResponse extends LakeFormationResponse
        implements
        ToCopyableBuilder<DescribeLakeFormationIdentityCenterConfigurationResponse.Builder, DescribeLakeFormationIdentityCenterConfigurationResponse> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogId").getter(getter(DescribeLakeFormationIdentityCenterConfigurationResponse::catalogId))
            .setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceArn").getter(getter(DescribeLakeFormationIdentityCenterConfigurationResponse::instanceArn))
            .setter(setter(Builder::instanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceArn").build()).build();

    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationArn")
            .getter(getter(DescribeLakeFormationIdentityCenterConfigurationResponse::applicationArn))
            .setter(setter(Builder::applicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationArn").build()).build();

    private static final SdkField<ExternalFilteringConfiguration> EXTERNAL_FILTERING_FIELD = SdkField
            .<ExternalFilteringConfiguration> builder(MarshallingType.SDK_POJO).memberName("ExternalFiltering")
            .getter(getter(DescribeLakeFormationIdentityCenterConfigurationResponse::externalFiltering))
            .setter(setter(Builder::externalFiltering)).constructor(ExternalFilteringConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalFiltering").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD,
            INSTANCE_ARN_FIELD, APPLICATION_ARN_FIELD, EXTERNAL_FILTERING_FIELD));

    private final String catalogId;

    private final String instanceArn;

    private final String applicationArn;

    private final ExternalFilteringConfiguration externalFiltering;

    private DescribeLakeFormationIdentityCenterConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.instanceArn = builder.instanceArn;
        this.applicationArn = builder.applicationArn;
        this.externalFiltering = builder.externalFiltering;
    }

    /**
     * <p>
     * The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata
     * store. It contains database definitions, table definitions, and other control information to manage your Lake
     * Formation environment.
     * </p>
     * 
     * @return The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent
     *         metadata store. It contains database definitions, table definitions, and other control information to
     *         manage your Lake Formation environment.
     */
    public final String catalogId() {
        return catalogId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the connection.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the connection.
     */
    public final String instanceArn() {
        return instanceArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the integrated application.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the integrated application.
     */
    public final String applicationArn() {
        return applicationArn;
    }

    /**
     * <p>
     * Indicates if external filtering is enabled.
     * </p>
     * 
     * @return Indicates if external filtering is enabled.
     */
    public final ExternalFilteringConfiguration externalFiltering() {
        return externalFiltering;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(externalFiltering());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLakeFormationIdentityCenterConfigurationResponse)) {
            return false;
        }
        DescribeLakeFormationIdentityCenterConfigurationResponse other = (DescribeLakeFormationIdentityCenterConfigurationResponse) obj;
        return Objects.equals(catalogId(), other.catalogId()) && Objects.equals(instanceArn(), other.instanceArn())
                && Objects.equals(applicationArn(), other.applicationArn())
                && Objects.equals(externalFiltering(), other.externalFiltering());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeLakeFormationIdentityCenterConfigurationResponse").add("CatalogId", catalogId())
                .add("InstanceArn", instanceArn()).add("ApplicationArn", applicationArn())
                .add("ExternalFiltering", externalFiltering()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "InstanceArn":
            return Optional.ofNullable(clazz.cast(instanceArn()));
        case "ApplicationArn":
            return Optional.ofNullable(clazz.cast(applicationArn()));
        case "ExternalFiltering":
            return Optional.ofNullable(clazz.cast(externalFiltering()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLakeFormationIdentityCenterConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeLakeFormationIdentityCenterConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LakeFormationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeLakeFormationIdentityCenterConfigurationResponse> {
        /**
         * <p>
         * The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata
         * store. It contains database definitions, table definitions, and other control information to manage your Lake
         * Formation environment.
         * </p>
         * 
         * @param catalogId
         *        The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent
         *        metadata store. It contains database definitions, table definitions, and other control information to
         *        manage your Lake Formation environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the connection.
         * </p>
         * 
         * @param instanceArn
         *        The Amazon Resource Name (ARN) of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceArn(String instanceArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the integrated application.
         * </p>
         * 
         * @param applicationArn
         *        The Amazon Resource Name (ARN) of the integrated application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationArn(String applicationArn);

        /**
         * <p>
         * Indicates if external filtering is enabled.
         * </p>
         * 
         * @param externalFiltering
         *        Indicates if external filtering is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalFiltering(ExternalFilteringConfiguration externalFiltering);

        /**
         * <p>
         * Indicates if external filtering is enabled.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExternalFilteringConfiguration.Builder}
         * avoiding the need to create one manually via {@link ExternalFilteringConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExternalFilteringConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #externalFiltering(ExternalFilteringConfiguration)}.
         * 
         * @param externalFiltering
         *        a consumer that will call methods on {@link ExternalFilteringConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #externalFiltering(ExternalFilteringConfiguration)
         */
        default Builder externalFiltering(Consumer<ExternalFilteringConfiguration.Builder> externalFiltering) {
            return externalFiltering(ExternalFilteringConfiguration.builder().applyMutation(externalFiltering).build());
        }
    }

    static final class BuilderImpl extends LakeFormationResponse.BuilderImpl implements Builder {
        private String catalogId;

        private String instanceArn;

        private String applicationArn;

        private ExternalFilteringConfiguration externalFiltering;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLakeFormationIdentityCenterConfigurationResponse model) {
            super(model);
            catalogId(model.catalogId);
            instanceArn(model.instanceArn);
            applicationArn(model.applicationArn);
            externalFiltering(model.externalFiltering);
        }

        public final String getCatalogId() {
            return catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getInstanceArn() {
            return instanceArn;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final String getApplicationArn() {
            return applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final ExternalFilteringConfiguration.Builder getExternalFiltering() {
            return externalFiltering != null ? externalFiltering.toBuilder() : null;
        }

        public final void setExternalFiltering(ExternalFilteringConfiguration.BuilderImpl externalFiltering) {
            this.externalFiltering = externalFiltering != null ? externalFiltering.build() : null;
        }

        @Override
        public final Builder externalFiltering(ExternalFilteringConfiguration externalFiltering) {
            this.externalFiltering = externalFiltering;
            return this;
        }

        @Override
        public DescribeLakeFormationIdentityCenterConfigurationResponse build() {
            return new DescribeLakeFormationIdentityCenterConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
