/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateLakeFormationIdentityCenterConfigurationRequest extends LakeFormationRequest
        implements
        ToCopyableBuilder<UpdateLakeFormationIdentityCenterConfigurationRequest.Builder, UpdateLakeFormationIdentityCenterConfigurationRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogId").getter(getter(UpdateLakeFormationIdentityCenterConfigurationRequest::catalogId))
            .setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<String> APPLICATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationStatus")
            .getter(getter(UpdateLakeFormationIdentityCenterConfigurationRequest::applicationStatusAsString))
            .setter(setter(Builder::applicationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationStatus").build()).build();

    private static final SdkField<ExternalFilteringConfiguration> EXTERNAL_FILTERING_FIELD = SdkField
            .<ExternalFilteringConfiguration> builder(MarshallingType.SDK_POJO).memberName("ExternalFiltering")
            .getter(getter(UpdateLakeFormationIdentityCenterConfigurationRequest::externalFiltering))
            .setter(setter(Builder::externalFiltering)).constructor(ExternalFilteringConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalFiltering").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD,
            APPLICATION_STATUS_FIELD, EXTERNAL_FILTERING_FIELD));

    private final String catalogId;

    private final String applicationStatus;

    private final ExternalFilteringConfiguration externalFiltering;

    private UpdateLakeFormationIdentityCenterConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.applicationStatus = builder.applicationStatus;
        this.externalFiltering = builder.externalFiltering;
    }

    /**
     * <p>
     * The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata
     * store. It contains database definitions, table definitions, view definitions, and other control information to
     * manage your Lake Formation environment.
     * </p>
     * 
     * @return The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent
     *         metadata store. It contains database definitions, table definitions, view definitions, and other control
     *         information to manage your Lake Formation environment.
     */
    public final String catalogId() {
        return catalogId;
    }

    /**
     * <p>
     * Allows to enable or disable the IAM Identity Center connection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #applicationStatus}
     * will return {@link ApplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #applicationStatusAsString}.
     * </p>
     * 
     * @return Allows to enable or disable the IAM Identity Center connection.
     * @see ApplicationStatus
     */
    public final ApplicationStatus applicationStatus() {
        return ApplicationStatus.fromValue(applicationStatus);
    }

    /**
     * <p>
     * Allows to enable or disable the IAM Identity Center connection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #applicationStatus}
     * will return {@link ApplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #applicationStatusAsString}.
     * </p>
     * 
     * @return Allows to enable or disable the IAM Identity Center connection.
     * @see ApplicationStatus
     */
    public final String applicationStatusAsString() {
        return applicationStatus;
    }

    /**
     * <p>
     * A list of the account IDs of Amazon Web Services accounts of third-party applications that are allowed to access
     * data managed by Lake Formation.
     * </p>
     * 
     * @return A list of the account IDs of Amazon Web Services accounts of third-party applications that are allowed to
     *         access data managed by Lake Formation.
     */
    public final ExternalFilteringConfiguration externalFiltering() {
        return externalFiltering;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(applicationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(externalFiltering());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLakeFormationIdentityCenterConfigurationRequest)) {
            return false;
        }
        UpdateLakeFormationIdentityCenterConfigurationRequest other = (UpdateLakeFormationIdentityCenterConfigurationRequest) obj;
        return Objects.equals(catalogId(), other.catalogId())
                && Objects.equals(applicationStatusAsString(), other.applicationStatusAsString())
                && Objects.equals(externalFiltering(), other.externalFiltering());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateLakeFormationIdentityCenterConfigurationRequest").add("CatalogId", catalogId())
                .add("ApplicationStatus", applicationStatusAsString()).add("ExternalFiltering", externalFiltering()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "ApplicationStatus":
            return Optional.ofNullable(clazz.cast(applicationStatusAsString()));
        case "ExternalFiltering":
            return Optional.ofNullable(clazz.cast(externalFiltering()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLakeFormationIdentityCenterConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateLakeFormationIdentityCenterConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LakeFormationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateLakeFormationIdentityCenterConfigurationRequest> {
        /**
         * <p>
         * The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata
         * store. It contains database definitions, table definitions, view definitions, and other control information
         * to manage your Lake Formation environment.
         * </p>
         * 
         * @param catalogId
         *        The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent
         *        metadata store. It contains database definitions, table definitions, view definitions, and other
         *        control information to manage your Lake Formation environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * Allows to enable or disable the IAM Identity Center connection.
         * </p>
         * 
         * @param applicationStatus
         *        Allows to enable or disable the IAM Identity Center connection.
         * @see ApplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationStatus
         */
        Builder applicationStatus(String applicationStatus);

        /**
         * <p>
         * Allows to enable or disable the IAM Identity Center connection.
         * </p>
         * 
         * @param applicationStatus
         *        Allows to enable or disable the IAM Identity Center connection.
         * @see ApplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationStatus
         */
        Builder applicationStatus(ApplicationStatus applicationStatus);

        /**
         * <p>
         * A list of the account IDs of Amazon Web Services accounts of third-party applications that are allowed to
         * access data managed by Lake Formation.
         * </p>
         * 
         * @param externalFiltering
         *        A list of the account IDs of Amazon Web Services accounts of third-party applications that are allowed
         *        to access data managed by Lake Formation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalFiltering(ExternalFilteringConfiguration externalFiltering);

        /**
         * <p>
         * A list of the account IDs of Amazon Web Services accounts of third-party applications that are allowed to
         * access data managed by Lake Formation.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExternalFilteringConfiguration.Builder}
         * avoiding the need to create one manually via {@link ExternalFilteringConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExternalFilteringConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #externalFiltering(ExternalFilteringConfiguration)}.
         * 
         * @param externalFiltering
         *        a consumer that will call methods on {@link ExternalFilteringConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #externalFiltering(ExternalFilteringConfiguration)
         */
        default Builder externalFiltering(Consumer<ExternalFilteringConfiguration.Builder> externalFiltering) {
            return externalFiltering(ExternalFilteringConfiguration.builder().applyMutation(externalFiltering).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LakeFormationRequest.BuilderImpl implements Builder {
        private String catalogId;

        private String applicationStatus;

        private ExternalFilteringConfiguration externalFiltering;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLakeFormationIdentityCenterConfigurationRequest model) {
            super(model);
            catalogId(model.catalogId);
            applicationStatus(model.applicationStatus);
            externalFiltering(model.externalFiltering);
        }

        public final String getCatalogId() {
            return catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getApplicationStatus() {
            return applicationStatus;
        }

        public final void setApplicationStatus(String applicationStatus) {
            this.applicationStatus = applicationStatus;
        }

        @Override
        public final Builder applicationStatus(String applicationStatus) {
            this.applicationStatus = applicationStatus;
            return this;
        }

        @Override
        public final Builder applicationStatus(ApplicationStatus applicationStatus) {
            this.applicationStatus(applicationStatus == null ? null : applicationStatus.toString());
            return this;
        }

        public final ExternalFilteringConfiguration.Builder getExternalFiltering() {
            return externalFiltering != null ? externalFiltering.toBuilder() : null;
        }

        public final void setExternalFiltering(ExternalFilteringConfiguration.BuilderImpl externalFiltering) {
            this.externalFiltering = externalFiltering != null ? externalFiltering.build() : null;
        }

        @Override
        public final Builder externalFiltering(ExternalFilteringConfiguration externalFiltering) {
            this.externalFiltering = externalFiltering;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLakeFormationIdentityCenterConfigurationRequest build() {
            return new UpdateLakeFormationIdentityCenterConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
